/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.gui;

import fr.proline.studio.gui.HourglassPanel;
import fr.proline.studio.gui.InfoDialog;
import fr.proline.studio.utils.IconManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openide.windows.WindowManager;

public class DefaultFloatingPanel
extends HourglassPanel {
    protected JButton[] m_actionButtonArray = null;

    public DefaultFloatingPanel() {
    }

    public DefaultFloatingPanel(String infoText, String[] actionName, ActionListener[] a, Icon[] icon) {
        this(infoText, actionName, a, icon, true);
    }

    public DefaultFloatingPanel(String infoText, String[] actionName, ActionListener[] a, Icon[] icon, boolean closable) {
        this.setBorder(BorderFactory.createLineBorder(Color.darkGray, 1, true));
        this.setOpaque(true);
        this.setLayout(new FlowLayout());
        if (closable) {
            JButton closeButton = new JButton(IconManager.getIcon(IconManager.IconType.CROSS_SMALL7));
            closeButton.setMargin(new Insets(0, 0, 0, 0));
            closeButton.setFocusPainted(false);
            closeButton.setContentAreaFilled(false);
            closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DefaultFloatingPanel.this.setVisible(false);
                }
            });
            this.add(closeButton);
        }
        JLabel infoLabel = null;
        if (infoText != null) {
            infoLabel = new JLabel(infoText);
        }
        if (infoLabel != null) {
            this.add(infoLabel);
        }
        int preferredButtonWidth = 0;
        int preferredButtonHeight = 0;
        int nbActions = actionName.length;
        this.m_actionButtonArray = new JButton[nbActions];
        for (int i = 0; i < nbActions; ++i) {
            this.m_actionButtonArray[i] = new JButton(actionName[i], icon[i]);
            this.m_actionButtonArray[i].setMargin(new Insets(1, 1, 1, 1));
            this.m_actionButtonArray[i].setFocusPainted(false);
            this.m_actionButtonArray[i].addActionListener(a[i]);
            this.add(this.m_actionButtonArray[i]);
            preferredButtonWidth = Math.max(preferredButtonWidth, this.m_actionButtonArray[i].getPreferredSize().width);
            preferredButtonHeight = Math.max(preferredButtonHeight, this.m_actionButtonArray[i].getPreferredSize().height);
        }
        Dimension buttonDimension = new Dimension(preferredButtonWidth, preferredButtonHeight);
        for (int i = 0; i < nbActions; ++i) {
            this.m_actionButtonArray[i].setPreferredSize(buttonDimension);
        }
        Dimension d = this.getPreferredSize();
        this.setBounds(0, 0, (int)d.getWidth(), (int)d.getHeight());
        DragGestureAdapter dragGestureAdapter = new DragGestureAdapter();
        this.addMouseMotionListener(dragGestureAdapter);
        this.addMouseListener(dragGestureAdapter);
        this.setVisible(false);
    }

    public void enableButton(int index, boolean value) {
        this.m_actionButtonArray[index].setEnabled(value);
    }

    public void enableAllButtons(boolean value) {
        for (int i = 0; i < this.m_actionButtonArray.length; ++i) {
            this.m_actionButtonArray[i].setEnabled(value);
        }
    }

    public void actionStarted() {
        int nbActions = this.m_actionButtonArray.length;
        for (int i = 0; i < nbActions; ++i) {
            this.m_actionButtonArray[i].setEnabled(false);
        }
        this.setLoading(1, true);
    }

    public void actionFinished(boolean success, String errorMessage) {
        int nbActions = this.m_actionButtonArray.length;
        for (int i = 0; i < nbActions; ++i) {
            this.m_actionButtonArray[i].setEnabled(true);
        }
        this.setLoaded(1);
        this.setVisible(false);
        if (!success) {
            InfoDialog errorDialog = new InfoDialog((Window)WindowManager.getDefault().getMainWindow(), InfoDialog.InfoType.WARNING, "Error", errorMessage);
            errorDialog.setButtonVisible(1, false);
            errorDialog.centerToWindow(WindowManager.getDefault().getMainWindow());
            errorDialog.setVisible(true);
        }
    }

    public class DragGestureAdapter
    extends MouseAdapter {
        int dX;
        int dY;

        @Override
        public void mouseDragged(MouseEvent e) {
            int parentY;
            Component panel = e.getComponent();
            int newX = e.getLocationOnScreen().x - this.dX;
            int newY = e.getLocationOnScreen().y - this.dY;
            Container parentComponent = panel.getParent();
            int parentX = parentComponent.getX();
            if (newX < parentX) {
                newX = parentX;
            }
            if (newY < (parentY = parentComponent.getY())) {
                newY = parentY;
            }
            int parentWidth = parentComponent.getWidth();
            if (newX + panel.getWidth() > parentWidth - parentX) {
                newX = parentWidth - parentX - panel.getWidth();
            }
            int parentHeight = parentComponent.getHeight();
            if (newY + panel.getHeight() > parentHeight - parentY) {
                newY = parentHeight - parentY - panel.getHeight();
            }
            panel.setLocation(newX, newY);
            this.dX = e.getLocationOnScreen().x - panel.getX();
            this.dY = e.getLocationOnScreen().y - panel.getY();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            JPanel panel = (JPanel)e.getComponent();
            panel.setCursor(Cursor.getPredefinedCursor(13));
            this.dX = e.getLocationOnScreen().x - panel.getX();
            this.dY = e.getLocationOnScreen().y - panel.getY();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            JPanel panel = (JPanel)e.getComponent();
            panel.setCursor(null);
        }
    }
}

