/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.table;

import com.thierry.filtering.TableSelection;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.graphics.CrossSelectionInterface;
import fr.proline.studio.gui.AdvancedSelectionPanel;
import fr.proline.studio.parameter.AbstractLinkedParameters;
import fr.proline.studio.parameter.AbstractParameter;
import fr.proline.studio.parameter.IntegerParameter;
import fr.proline.studio.parameter.MultiObjectParameter;
import fr.proline.studio.parameter.ObjectParameter;
import fr.proline.studio.parameter.ParameterList;
import fr.proline.studio.parameter.SettingsInterface;
import fr.proline.studio.table.DecoratedTableModelInterface;
import fr.proline.studio.table.TablePopupMenu;
import fr.proline.studio.table.TablePopupMouseAdapter;
import fr.proline.studio.utils.RelativePainterHighlighter;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultRowSorter;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.JXTableHeader;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.jdesktop.swingx.table.TableColumnExt;
import org.openide.util.NbPreferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DecoratedTable
extends JXTable
implements CrossSelectionInterface,
SettingsInterface {
    protected static final Logger m_loggerProline = LoggerFactory.getLogger((String)"ProlineStudio");
    private RelativePainterHighlighter.NumberRelativizer m_relativizer = null;
    private TablePopupMenu m_popupMenu;
    private Highlighter m_stripingHighlighter = null;
    private ObjectParameter m_columnArrangementParameter = null;
    private IntegerParameter m_columnWidthParameter = null;
    private MultiObjectParameter m_columnsVisibilityParameter = null;
    private ArrayList<ParameterList> m_parameterListArray = null;
    private ObjectParameter m_sortCol1Parameter = null;
    private ObjectParameter m_sortOrderCol1Parameter = null;
    private ObjectParameter m_sortCol2Parameter = null;
    private ObjectParameter m_sortOrderCol2Parameter = null;
    private static final String COLUMNS_VISIBILITY_KEY = "COLUMNS_VISIBILITY_KEY";
    public static final String DEFAULT_COLUMNS_ARRANGEMENT_KEY = "Columns_Arrangement";
    public static final String DEFAULT_COLUMNS_ARRANGEMENT_NAME = "Columns Arrangement";
    public static final int DEFAULT_COLUMNS_ARRANGEMENT_INDEX = 2;
    public static final String DEFAULT_WIDTH_KEY = "Column_Width";
    public static final String DEFAULT_WIDTH_NAME = "Column Width";
    public static final int COLUMN_DEFAULT_WIDTH = 120;
    public static final int COLUMN_MIN_WIDTH = 20;
    public static final int COLUMN_MAX_WIDTH = 300;
    public static final int AUTOMATIC_COLUMNS_SIZE = 0;
    public static final int FIXED_COLUMNS_SIZE = 1;
    public static final int SMART_COLUMNS_SIZE = 2;
    public static final String TABLE_PARAMETER_LIST_KEY = "Tables";
    private boolean m_firstPaint = true;
    private boolean m_alreadyLoaded = false;
    private int m_width = -1;
    private int m_selection = -1;
    private int m_meanWidth = -1;
    private int m_totalWidth = 0;
    private int m_nbVisible = 0;
    private JComboBox m_arrangementComboBox;
    private JTextField m_widthTextField;

    public DecoratedTable() {
        this.setColumnControlVisible(true);
        this.m_stripingHighlighter = HighlighterFactory.createSimpleStriping();
        this.addHighlighter(this.m_stripingHighlighter);
        this.setGridColor(Color.lightGray);
        this.setRowHeight(16);
        this.setSortOrderCycle(new SortOrder[]{SortOrder.ASCENDING, SortOrder.DESCENDING, SortOrder.UNSORTED});
        TableSelection.installCopyAction((JTable)((Object)this));
        TablePopupMenu popup = this.initPopupMenu();
        if (popup != null) {
            this.setTablePopup(popup);
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        int width = this.getParent().getWidth();
        if (Math.abs(this.m_totalWidth - width) > 50) {
            this.m_firstPaint = true;
            this.m_totalWidth = width;
        }
        if (this.m_firstPaint) {
            this.m_firstPaint = false;
            this.panelResized();
        }
    }

    public void reinitParameters() {
        this.m_firstPaint = true;
        this.m_parameterListArray = null;
    }

    public void columnAdded(TableColumnModelEvent e) {
        super.columnAdded(e);
        this.reinitParameters();
    }

    private void initParameters() {
        this.m_alreadyLoaded = false;
        this.m_width = -1;
        this.m_selection = -1;
        final ParameterList parameterTableList = new ParameterList(TABLE_PARAMETER_LIST_KEY);
        Object[] associatedTable = new Object[]{"Automatic Column Size", "Fixed Column Size", "Smart Column Size"};
        this.m_arrangementComboBox = new JComboBox<Object>(associatedTable);
        Object[] objectTable = new Object[]{0, 1, 2};
        this.m_columnArrangementParameter = new ObjectParameter<Object>(DEFAULT_COLUMNS_ARRANGEMENT_KEY, DEFAULT_COLUMNS_ARRANGEMENT_NAME, this.m_arrangementComboBox, associatedTable, objectTable, 2, null);
        List columns = this.getColumns(true);
        int colCount = columns.size();
        Object[] columnNamesArray = new Object[colCount];
        Object[] columnsArray = new Object[colCount];
        boolean[] selection = new boolean[colCount];
        this.m_nbVisible = 0;
        for (int i = 0; i < colCount; ++i) {
            boolean visible;
            TableColumnExt column = (TableColumnExt)columns.get(i);
            columnNamesArray[i] = column.getHeaderValue().toString().replaceAll("<br/>", " ");
            columnsArray[i] = column;
            selection[i] = visible = column.isVisible();
            if (!visible) continue;
            ++this.m_nbVisible;
        }
        this.calculateMeanWidth();
        this.m_widthTextField = new JTextField();
        this.m_columnWidthParameter = new IntegerParameter(DEFAULT_WIDTH_KEY, DEFAULT_WIDTH_NAME, this.m_widthTextField, (Integer)120, (Integer)10, (Integer)300);
        this.m_columnsVisibilityParameter = new MultiObjectParameter<Object>(COLUMNS_VISIBILITY_KEY, "Columns Visibility", "Visible Columns", "Hidden Columns", AdvancedSelectionPanel.class, columnNamesArray, columnsArray, selection, null);
        parameterTableList.add(this.m_columnArrangementParameter);
        parameterTableList.add(this.m_columnWidthParameter);
        parameterTableList.loadParameters(NbPreferences.root());
        AbstractLinkedParameters linkedParameters = new AbstractLinkedParameters(parameterTableList){

            @Override
            public void valueChanged(String value, Object associatedValue) {
                if (!DecoratedTable.this.m_alreadyLoaded) {
                    parameterTableList.loadParameters(NbPreferences.root());
                    DecoratedTable.this.m_alreadyLoaded = true;
                    DecoratedTable.this.m_width = Integer.parseInt(DecoratedTable.this.m_columnWidthParameter.getStringValue());
                    DecoratedTable.this.m_selection = Integer.parseInt(DecoratedTable.this.m_columnArrangementParameter.getStringValue());
                }
                DecoratedTable.this.m_selection = Integer.parseInt(DecoratedTable.this.m_columnArrangementParameter.getStringValue());
                this.showParameter(DecoratedTable.this.m_columnWidthParameter, DecoratedTable.this.m_selection == 1 || DecoratedTable.this.m_selection == 2, DecoratedTable.this.m_width);
                this.updateParameterListPanel();
            }
        };
        parameterTableList.add(this.m_columnsVisibilityParameter);
        this.m_parameterListArray = new ArrayList();
        this.m_parameterListArray.add(parameterTableList);
        parameterTableList.getPanel();
        this.m_columnArrangementParameter.addLinkedParameters(linkedParameters);
        linkedParameters.valueChanged("true", Boolean.TRUE);
        this.addSortingParameters();
    }

    private void calculateMeanWidth() {
        int totalWidth = this.m_totalWidth;
        int n = this.m_meanWidth = this.m_nbVisible != 0 ? totalWidth / this.m_nbVisible : 30;
        if (this.m_meanWidth < 30) {
            this.m_meanWidth = 30;
        } else if (this.m_meanWidth > 300) {
            this.m_meanWidth = 300;
        }
    }

    private void addSortingParameters() {
        int i;
        TableModel model = this.getModel();
        List colums = this.getColumns(true);
        int nbCols = colums.size();
        String[] colNames = new String[nbCols + 1];
        Object[] indexes = new Integer[nbCols + 1];
        colNames[0] = "< No Sorting >";
        indexes[0] = -1;
        for (int i2 = 0; i2 < nbCols; ++i2) {
            indexes[i2 + 1] = ((TableColumn)colums.get(i2)).getModelIndex();
            colNames[i2 + 1] = model.getColumnName(indexes[i2 + 1]);
        }
        RowSorter sorter = this.getRowSorter();
        List<RowSorter.SortKey> sortKeys = sorter.getSortKeys();
        int numberOfSortingKeys = Math.min(sortKeys.size(), 2);
        int[] colIndex = new int[2];
        SortOrder[] sorterOrder = new SortOrder[2];
        for (i = 0; i < numberOfSortingKeys; ++i) {
            RowSorter.SortKey key = sortKeys.get(i);
            colIndex[i] = key.getColumn() + 1;
            sorterOrder[i] = key.getSortOrder();
        }
        for (i = numberOfSortingKeys; i < 2; ++i) {
            colIndex[i] = 0;
            sorterOrder[i] = SortOrder.ASCENDING;
        }
        String[] orderString = new String[]{"Ascending", "Descending"};
        SortOrder[] orderEnum = new SortOrder[]{SortOrder.ASCENDING, SortOrder.DESCENDING};
        this.m_sortCol1Parameter = new ObjectParameter<String>("COL_1_SORT", "First Sorting Column", null, colNames, indexes, colIndex[0], null);
        this.m_sortOrderCol1Parameter = new ObjectParameter<String>("COL_1_ORDER", "", null, orderString, (Object[])orderEnum, sorterOrder[0] != SortOrder.DESCENDING ? 0 : 1, null);
        this.m_sortOrderCol1Parameter.forceShowLabel(AbstractParameter.LabelVisibility.NO_VISIBLE);
        this.m_sortCol2Parameter = new ObjectParameter<String>("COL_2_SORT", "Second Sorting Column", null, colNames, indexes, colIndex[1], null);
        this.m_sortOrderCol2Parameter = new ObjectParameter<String>("COL_2_ORDER", "", null, orderString, (Object[])orderEnum, sorterOrder[1] != SortOrder.DESCENDING ? 0 : 1, null);
        this.m_sortOrderCol2Parameter.forceShowLabel(AbstractParameter.LabelVisibility.NO_VISIBLE);
        ParameterList parameterTableList = new ParameterList("Sorting Parameters");
        parameterTableList.add(this.m_sortCol1Parameter);
        parameterTableList.add(this.m_sortOrderCol1Parameter);
        parameterTableList.add(this.m_sortCol2Parameter);
        parameterTableList.add(this.m_sortOrderCol2Parameter);
        parameterTableList.getPanel();
        AbstractLinkedParameters linkedParameters = new AbstractLinkedParameters(parameterTableList){

            @Override
            public void valueChanged(String value, Object associatedValue) {
                boolean show = (Integer)associatedValue != -1;
                this.showParameter(DecoratedTable.this.m_sortOrderCol1Parameter, show);
                if (!show) {
                    this.showParameter(DecoratedTable.this.m_sortCol2Parameter, false);
                    this.showParameter(DecoratedTable.this.m_sortOrderCol2Parameter, false);
                } else {
                    this.showParameter(DecoratedTable.this.m_sortCol2Parameter, true);
                    this.showParameter(DecoratedTable.this.m_sortOrderCol2Parameter, (Integer)DecoratedTable.this.m_sortCol2Parameter.getAssociatedObjectValue() != -1);
                }
                this.updateParameterListPanel();
            }
        };
        this.m_sortCol1Parameter.addLinkedParameters(linkedParameters);
        AbstractLinkedParameters linkedParameters2 = new AbstractLinkedParameters(parameterTableList){

            @Override
            public void valueChanged(String value, Object associatedValue) {
                this.showParameter(DecoratedTable.this.m_sortOrderCol2Parameter, (Integer)associatedValue != -1);
                this.updateParameterListPanel();
            }
        };
        this.m_sortCol2Parameter.addLinkedParameters(linkedParameters2);
        linkedParameters.valueChanged(colNames[colIndex[0]], indexes[colIndex[0]]);
        linkedParameters2.valueChanged(colNames[colIndex[1]], indexes[colIndex[1]]);
        this.m_parameterListArray.add(parameterTableList);
    }

    private void fixResize() {
        this.setAutoResizeMode(0);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int width = (Integer)DecoratedTable.this.m_columnWidthParameter.getObjectValue();
                int colCount = DecoratedTable.this.getColumnCount();
                TableColumnModel columnModel = DecoratedTable.this.getColumnModel();
                for (int i = 0; i < colCount; ++i) {
                    TableColumn col = columnModel.getColumn(i);
                    col.setWidth(width);
                    col.setPreferredWidth(width);
                }
            }
        });
    }

    public void removeStriping() {
        this.removeHighlighter(this.m_stripingHighlighter);
    }

    public String getToolTipForHeader(int modelColumn) {
        return ((DecoratedTableModelInterface)((Object)this.getModel())).getToolTipForHeader(modelColumn);
    }

    protected JTableHeader createDefaultTableHeader() {
        return new CustomTooltipTableHeader(this);
    }

    @Override
    public void select(ArrayList<Long> uniqueIds) {
        int minRow;
        ListSelectionModel selModel = this.getSelectionModel();
        selModel.clearSelection();
        TableModel model = this.getModel();
        if (model instanceof ExtendedTableModelInterface) {
            ExtendedTableModelInterface compareDataInterface = (ExtendedTableModelInterface)((Object)model);
            for (Long id : uniqueIds) {
                int row = compareDataInterface.uniqueId2Row(id);
                if (row == -1) continue;
                row = this.convertRowIndexToView(row);
                selModel.addSelectionInterval(row, row);
            }
        } else {
            for (Long id : uniqueIds) {
                int row = this.convertRowIndexToView(id.intValue());
                selModel.addSelectionInterval(row, row);
            }
        }
        if ((minRow = selModel.getMinSelectionIndex()) != -1) {
            this.scrollRowToVisible(minRow);
        }
    }

    @Override
    public ArrayList<Long> getSelection() {
        ArrayList<Long> selectionList = new ArrayList<Long>();
        ListSelectionModel selModel = this.getSelectionModel();
        AbstractTableModel model = (AbstractTableModel)this.getModel();
        if (model instanceof ExtendedTableModelInterface) {
            ExtendedTableModelInterface compareDataInterface = (ExtendedTableModelInterface)((Object)model);
            for (int i = 0; i < model.getRowCount(); ++i) {
                int row = this.convertRowIndexToView(i);
                if (!selModel.isSelectedIndex(row)) continue;
                selectionList.add(compareDataInterface.row2UniqueId(i));
            }
        } else {
            for (int i = 0; i < model.getRowCount(); ++i) {
                int row = this.convertRowIndexToView(i);
                if (!selModel.isSelectedIndex(row)) continue;
                selectionList.add(Long.valueOf(i));
            }
        }
        return selectionList;
    }

    private void setTablePopup(TablePopupMenu popupMenu) {
        if (this.m_popupMenu == null) {
            this.addMouseListener(new TablePopupMouseAdapter(this));
        }
        this.m_popupMenu = popupMenu;
    }

    public TablePopupMenu getTablePopup() {
        this.m_popupMenu.preparePopup();
        return this.m_popupMenu;
    }

    public abstract TablePopupMenu initPopupMenu();

    public abstract void prepostPopupMenu();

    public TableCellRenderer getCellRenderer(int row, int column) {
        int columnInModel;
        TableCellRenderer renderer;
        TableModel model = this.getModel();
        if (model instanceof GlobalTableModelInterface && (renderer = ((GlobalTableModelInterface)model).getRenderer(row, columnInModel = this.convertColumnIndexToModel(column))) != null) {
            return renderer;
        }
        return super.getCellRenderer(row, column);
    }

    @Override
    public ArrayList<ParameterList> getParameters() {
        if (this.m_parameterListArray == null) {
            this.initParameters();
        }
        return this.m_parameterListArray;
    }

    private void panelResized() {
        if (this.m_parameterListArray == null) {
            this.initParameters();
        }
        int arrangement = Integer.parseInt(this.m_columnArrangementParameter.getStringValue());
        switch (arrangement) {
            case 0: {
                this.setAutoResizeMode(4);
                break;
            }
            case 1: {
                this.fixResize();
                break;
            }
            case 2: {
                this.calculateMeanWidth();
                if (this.m_meanWidth == -1) {
                    this.setAutoResizeMode(4);
                    break;
                }
                float meanWidth = this.m_meanWidth;
                float width = ((Integer)this.m_columnWidthParameter.getObjectValue()).floatValue();
                if ((double)(meanWidth / width) < 0.9) {
                    this.fixResize();
                    break;
                }
                this.setAutoResizeMode(4);
            }
        }
    }

    @Override
    public void parametersChanged() {
        this.panelResized();
        List selectedColumns = (List)this.m_columnsVisibilityParameter.getAssociatedValues(true);
        List nonSelectedColumns = (List)this.m_columnsVisibilityParameter.getAssociatedValues(false);
        for (Object column : selectedColumns) {
            ((TableColumnExt)column).setVisible(true);
        }
        for (Object column : nonSelectedColumns) {
            ((TableColumnExt)column).setVisible(false);
        }
        ArrayList<RowSorter.SortKey> sortKeys = new ArrayList<RowSorter.SortKey>();
        Integer modelColIndex1 = (Integer)this.m_sortCol1Parameter.getAssociatedObjectValue();
        SortOrder sortOrder1 = (SortOrder)((Object)this.m_sortOrderCol1Parameter.getAssociatedObjectValue());
        Integer modelColIndex2 = (Integer)this.m_sortCol2Parameter.getAssociatedObjectValue();
        SortOrder sortOrder2 = (SortOrder)((Object)this.m_sortOrderCol2Parameter.getAssociatedObjectValue());
        if (modelColIndex1 > -1) {
            sortKeys.add(new RowSorter.SortKey(modelColIndex1, sortOrder1));
            if (modelColIndex2 > -1) {
                sortKeys.add(new RowSorter.SortKey(modelColIndex2, sortOrder2));
            }
        }
        DefaultRowSorter sorter = (DefaultRowSorter)this.getRowSorter();
        sorter.setSortKeys(sortKeys);
        sorter.sort();
    }

    @Override
    public boolean parametersCanceled() {
        return false;
    }

    private class CustomTooltipTableHeader
    extends JXTableHeader {
        private DecoratedTable m_table;

        public CustomTooltipTableHeader(DecoratedTable table) {
            super(table.getColumnModel());
            this.m_table = table;
        }

        public String getToolTipText(MouseEvent e) {
            String tooltip;
            Point p = e.getPoint();
            int column = this.columnAtPoint(p);
            if (column != -1 && (tooltip = DecoratedTable.this.getToolTipForHeader(column = this.m_table.convertColumnIndexToModel(column))) != null) {
                return tooltip;
            }
            return super.getToolTipText(e);
        }
    }
}

