/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.action.internal;

import java.io.Serializable;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.action.internal.EntityAction;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.access.EntityRegionAccessStrategy;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.cache.spi.entry.CacheEntry;
import org.hibernate.engine.internal.Versioning;
import org.hibernate.engine.spi.CachedNaturalIdValueSource;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.SessionEventListenerManager;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.event.service.spi.EventListenerGroup;
import org.hibernate.event.spi.EventType;
import org.hibernate.event.spi.PostCommitUpdateEventListener;
import org.hibernate.event.spi.PostUpdateEvent;
import org.hibernate.event.spi.PostUpdateEventListener;
import org.hibernate.event.spi.PreUpdateEvent;
import org.hibernate.event.spi.PreUpdateEventListener;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.TypeHelper;

public final class EntityUpdateAction
extends EntityAction {
    private final Object[] state;
    private final Object[] previousState;
    private final Object previousVersion;
    private final int[] dirtyFields;
    private final boolean hasDirtyCollection;
    private final Object rowId;
    private final Object[] previousNaturalIdValues;
    private Object nextVersion;
    private Object cacheEntry;
    private SoftLock lock;

    public EntityUpdateAction(Serializable id, Object[] state, int[] dirtyProperties, boolean hasDirtyCollection, Object[] previousState, Object previousVersion, Object nextVersion, Object instance, Object rowId, EntityPersister persister, SharedSessionContractImplementor session) {
        super(session, id, instance, persister);
        this.state = state;
        this.previousState = previousState;
        this.previousVersion = previousVersion;
        this.nextVersion = nextVersion;
        this.dirtyFields = dirtyProperties;
        this.hasDirtyCollection = hasDirtyCollection;
        this.rowId = rowId;
        this.previousNaturalIdValues = this.determinePreviousNaturalIdValues(persister, previousState, session, id);
        session.getPersistenceContext().getNaturalIdHelper().manageLocalNaturalIdCrossReference(persister, id, state, this.previousNaturalIdValues, CachedNaturalIdValueSource.UPDATE);
    }

    private Object[] determinePreviousNaturalIdValues(EntityPersister persister, Object[] previousState, SharedSessionContractImplementor session, Serializable id) {
        if (!persister.hasNaturalIdentifier()) {
            return null;
        }
        if (previousState != null) {
            return session.getPersistenceContext().getNaturalIdHelper().extractNaturalIdValues(previousState, persister);
        }
        return session.getPersistenceContext().getNaturalIdSnapshot(id, persister);
    }

    @Override
    public void execute() throws HibernateException {
        EntityEntry entry;
        Object ck;
        Serializable id = this.getId();
        EntityPersister persister = this.getPersister();
        SharedSessionContractImplementor session = this.getSession();
        Object instance = this.getInstance();
        boolean veto = this.preUpdate();
        SessionFactoryImplementor factory = session.getFactory();
        Object previousVersion = this.previousVersion;
        if (persister.isVersionPropertyGenerated()) {
            previousVersion = persister.getVersion(instance);
        }
        if (persister.hasCache()) {
            EntityRegionAccessStrategy cache = persister.getCacheAccessStrategy();
            ck = cache.generateCacheKey(id, persister, factory, session.getTenantIdentifier());
            this.lock = cache.lockItem(session, ck, previousVersion);
        } else {
            ck = null;
        }
        if (!veto) {
            persister.update(id, this.state, this.dirtyFields, this.hasDirtyCollection, this.previousState, previousVersion, instance, this.rowId, session);
        }
        if ((entry = session.getPersistenceContext().getEntry(instance)) == null) {
            throw new AssertionFailure("possible nonthreadsafe access to session");
        }
        if (entry.getStatus() == Status.MANAGED || persister.isVersionPropertyGenerated()) {
            TypeHelper.deepCopy(this.state, persister.getPropertyTypes(), persister.getPropertyCheckability(), this.state, session);
            if (persister.hasUpdateGeneratedProperties()) {
                persister.processUpdateGeneratedProperties(id, instance, this.state, session);
                if (persister.isVersionPropertyGenerated()) {
                    this.nextVersion = Versioning.getVersion(this.state, persister);
                }
            }
            entry.postUpdate(instance, this.state, this.nextVersion);
        }
        if (persister.hasCache()) {
            if (persister.isCacheInvalidationRequired() || entry.getStatus() != Status.MANAGED) {
                persister.getCacheAccessStrategy().remove(session, ck);
            } else if (session.getCacheMode().isPutEnabled()) {
                CacheEntry ce = persister.buildCacheEntry(instance, this.state, this.nextVersion, this.getSession());
                this.cacheEntry = persister.getCacheEntryStructure().structure(ce);
                boolean put = this.cacheUpdate(persister, previousVersion, ck);
                if (put && factory.getStatistics().isStatisticsEnabled()) {
                    factory.getStatistics().secondLevelCachePut(this.getPersister().getCacheAccessStrategy().getRegion().getName());
                }
            }
        }
        session.getPersistenceContext().getNaturalIdHelper().manageSharedNaturalIdCrossReference(persister, id, this.state, this.previousNaturalIdValues, CachedNaturalIdValueSource.UPDATE);
        this.postUpdate();
        if (factory.getStatistics().isStatisticsEnabled() && !veto) {
            factory.getStatistics().updateEntity(this.getPersister().getEntityName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean cacheUpdate(EntityPersister persister, Object previousVersion, Object ck) {
        SharedSessionContractImplementor session = this.getSession();
        try {
            session.getEventListenerManager().cachePutStart();
            boolean bl = persister.getCacheAccessStrategy().update(session, ck, this.cacheEntry, this.nextVersion, previousVersion);
            return bl;
        }
        finally {
            session.getEventListenerManager().cachePutEnd();
        }
    }

    private boolean preUpdate() {
        boolean veto = false;
        EventListenerGroup<PreUpdateEventListener> listenerGroup = this.listenerGroup(EventType.PRE_UPDATE);
        if (listenerGroup.isEmpty()) {
            return veto;
        }
        PreUpdateEvent event = new PreUpdateEvent(this.getInstance(), this.getId(), this.state, this.previousState, this.getPersister(), this.eventSource());
        for (PreUpdateEventListener listener : listenerGroup.listeners()) {
            veto |= listener.onPreUpdate(event);
        }
        return veto;
    }

    private void postUpdate() {
        EventListenerGroup<PostUpdateEventListener> listenerGroup = this.listenerGroup(EventType.POST_UPDATE);
        if (listenerGroup.isEmpty()) {
            return;
        }
        PostUpdateEvent event = new PostUpdateEvent(this.getInstance(), this.getId(), this.state, this.previousState, this.dirtyFields, this.getPersister(), this.eventSource());
        for (PostUpdateEventListener listener : listenerGroup.listeners()) {
            listener.onPostUpdate(event);
        }
    }

    private void postCommitUpdate(boolean success) {
        EventListenerGroup<PostUpdateEventListener> listenerGroup = this.listenerGroup(EventType.POST_COMMIT_UPDATE);
        if (listenerGroup.isEmpty()) {
            return;
        }
        PostUpdateEvent event = new PostUpdateEvent(this.getInstance(), this.getId(), this.state, this.previousState, this.dirtyFields, this.getPersister(), this.eventSource());
        for (PostUpdateEventListener listener : listenerGroup.listeners()) {
            if (PostCommitUpdateEventListener.class.isInstance(listener)) {
                if (success) {
                    listener.onPostUpdate(event);
                    continue;
                }
                ((PostCommitUpdateEventListener)listener).onPostUpdateCommitFailed(event);
                continue;
            }
            listener.onPostUpdate(event);
        }
    }

    @Override
    protected boolean hasPostCommitEventListeners() {
        EventListenerGroup<PostUpdateEventListener> group = this.listenerGroup(EventType.POST_COMMIT_UPDATE);
        for (PostUpdateEventListener listener : group.listeners()) {
            if (!listener.requiresPostCommitHanding(this.getPersister())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void doAfterTransactionCompletion(boolean success, SharedSessionContractImplementor session) throws CacheException {
        EntityPersister persister = this.getPersister();
        if (persister.hasCache()) {
            EntityRegionAccessStrategy cache = persister.getCacheAccessStrategy();
            Object ck = cache.generateCacheKey(this.getId(), persister, session.getFactory(), session.getTenantIdentifier());
            if (success && this.cacheEntry != null && !persister.isCacheInvalidationRequired() && session.getCacheMode().isPutEnabled()) {
                boolean put = this.cacheAfterUpdate(cache, ck);
                if (put && this.getSession().getFactory().getStatistics().isStatisticsEnabled()) {
                    this.getSession().getFactory().getStatistics().secondLevelCachePut(cache.getRegion().getName());
                }
            } else {
                cache.unlockItem(session, ck, this.lock);
            }
        }
        this.postCommitUpdate(success);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean cacheAfterUpdate(EntityRegionAccessStrategy cache, Object ck) {
        SharedSessionContractImplementor session = this.getSession();
        SessionEventListenerManager eventListenerManager = session.getEventListenerManager();
        try {
            eventListenerManager.cachePutStart();
            boolean bl = cache.afterUpdate(session, ck, this.cacheEntry, this.nextVersion, this.previousVersion, this.lock);
            return bl;
        }
        finally {
            eventListenerManager.cachePutEnd();
        }
    }
}

