/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.JChannel;
import org.jgroups.MergeView;
import org.jgroups.Message;
import org.jgroups.PhysicalAddress;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.ViewId;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.stack.AddressGenerator;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.Protocol;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.PayloadUUID;
import org.jgroups.util.Streamable;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.TopologyUUID;
import org.jgroups.util.UUID;
import org.jgroups.util.Util;

@MBean(description="RELAY protocol")
public class RELAY
extends Protocol {
    @Property(description="Description of the local cluster, e.g. \"nyc\". This is added to every address, so itshould be short. This is a mandatory property and must be set", writable=false)
    protected String site;
    @Property(description="Properties of the bridge cluster (e.g. tcp.xml)")
    protected String bridge_props = null;
    @Property(description="Name of the bridge cluster")
    protected String bridge_name = "bridge-cluster";
    @Property(description="If set to false, don't perform relaying. Used e.g. for backup clusters; unidirectional replication from one cluster to another, but not back. Can be changed at runtime")
    protected boolean relay = true;
    @Property(description="Drops views received from below and instead generates global views and passes them up. A global view consists of the local view and the remote view, ordered by view ID. If true, no protocolwhich requires (local) views can sit on top of RELAY")
    protected boolean present_global_views = true;
    protected Address local_addr;
    @ManagedAttribute
    protected volatile boolean is_coord = false;
    protected volatile Address coord = null;
    protected JChannel bridge;
    protected View local_view;
    protected View bridge_view;
    protected View remote_view;
    protected View global_view;
    protected long global_view_id = 0L;
    protected TimeScheduler timer;
    protected Future<?> remote_view_fetcher_future;

    @ManagedOperation
    public void setRelay(boolean relay) {
        this.relay = relay;
    }

    @ManagedAttribute
    public String getLocalView() {
        return this.local_view != null ? this.local_view.toString() : "n/a";
    }

    @ManagedAttribute
    public String getBridgeView() {
        return this.bridge_view != null ? this.bridge_view.toString() : "n/a";
    }

    @ManagedAttribute
    public String getRemoteView() {
        return this.remote_view != null ? this.remote_view.toString() : "n/a";
    }

    @ManagedAttribute
    public String getGlobalView() {
        return this.global_view != null ? this.global_view.toString() : "n/a";
    }

    @Override
    public void init() throws Exception {
        super.init();
        if (this.site == null || this.site.isEmpty()) {
            throw new IllegalArgumentException("\"site\" must be set");
        }
        this.timer = this.getTransport().getTimer();
        JChannel channel = this.getProtocolStack().getChannel();
        if (channel == null) {
            throw new IllegalStateException("channel must be set");
        }
        channel.setAddressGenerator(new AddressGenerator(){

            @Override
            public Address generateAddress() {
                return PayloadUUID.randomUUID(RELAY.this.site);
            }
        });
    }

    @Override
    public void stop() {
        this.stopRemoteViewFetcher();
        Util.close((Channel)this.bridge);
    }

    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                Address dest = msg.getDest();
                if (dest == null || this.isLocal(dest)) break;
                this.forwardToCoord(msg);
                return null;
            }
            case 6: {
                this.handleView((View)evt.getArg());
                break;
            }
            case 4: {
                Util.close((Channel)this.bridge);
                break;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 87: {
                PhysicalAddress addr = (PhysicalAddress)this.down_prot.down(evt);
                if (addr == null) {
                    addr = new IpAddress(6666);
                }
                return addr;
            }
        }
        return this.down_prot.down(evt);
    }

    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                Address dest = msg.getDest();
                RelayHeader hdr = (RelayHeader)msg.getHeader(this.getId());
                if (hdr != null) {
                    return this.handleUpEvent(msg, hdr);
                }
                if (!this.is_coord || !this.relay || dest != null || msg.isFlagSet(Message.NO_RELAY)) break;
                Message tmp = msg.copy(true, (short)200);
                try {
                    byte[] buf = Util.streamableToByteBuffer(tmp);
                    this.forward(buf, 0, buf.length);
                }
                catch (Exception e) {
                    this.log.warn("failed relaying message", e);
                }
                break;
            }
            case 6: {
                this.handleView((View)evt.getArg());
                if (!this.present_global_views) break;
                return null;
            }
        }
        return this.up_prot.up(evt);
    }

    protected Object handleUpEvent(Message msg, RelayHeader hdr) {
        switch (hdr.type) {
            case DISSEMINATE: {
                Message copy = msg.copy();
                if (hdr.original_sender != null) {
                    copy.setSrc(hdr.original_sender);
                }
                return this.up_prot.up(new Event(1, copy));
            }
            case FORWARD: {
                if (!this.is_coord) break;
                this.forward(msg.getRawBuffer(), msg.getOffset(), msg.getLength());
                break;
            }
            case VIEW: {
                return this.installView(msg.getRawBuffer(), msg.getOffset(), msg.getLength());
            }
            case BROADCAST_VIEW: {
                break;
            }
            default: {
                throw new IllegalArgumentException((Object)((Object)hdr.type) + " is not a valid type");
            }
        }
        return null;
    }

    @Override
    public void up(MessageBatch batch) {
        for (Message msg : batch) {
            RelayHeader hdr = (RelayHeader)msg.getHeader(this.getId());
            if (hdr != null) {
                batch.remove(msg);
                try {
                    this.handleUpEvent(msg, hdr);
                }
                catch (Throwable t) {
                    this.log.error("failed processing message", t);
                }
            }
            if (!this.is_coord || !this.relay || msg.dest() != null || msg.isFlagSet(Message.NO_RELAY)) continue;
            Message tmp = msg.copy(true, (short)200);
            try {
                byte[] buf = Util.streamableToByteBuffer(tmp);
                this.forward(buf, 0, buf.length);
            }
            catch (Exception e) {
                this.log.warn("failed relaying message", e);
            }
        }
        if (!batch.isEmpty()) {
            this.up_prot.up(batch);
        }
    }

    protected void handleView(View view) {
        List<Address> new_mbrs = null;
        if (this.local_view != null) {
            new_mbrs = Util.newMembers(this.local_view.getMembers(), view.getMembers());
        }
        this.local_view = view;
        this.coord = view.getMembers().iterator().next();
        boolean create_bridge = false;
        boolean is_new_coord = Util.isCoordinator(view, this.local_addr);
        if (this.is_coord) {
            if (!is_new_coord) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("I'm not coordinator anymore, closing the channel");
                }
                Util.close((Channel)this.bridge);
                this.is_coord = false;
                this.bridge = null;
            }
        } else if (is_new_coord) {
            create_bridge = true;
            this.is_coord = true;
        }
        if (this.is_coord) {
            this.sendViewOnLocalCluster(this.remote_view, this.generateGlobalView(view, this.remote_view, view instanceof MergeView), true, new_mbrs);
            if (create_bridge) {
                this.createBridge();
            }
            this.sendViewToRemote(ViewData.create(view, null), false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object installView(byte[] buf, int offset, int length) {
        block8: {
            try {
                ViewData data = (ViewData)Util.streamableFromByteBuffer(ViewData.class, buf, offset, length);
                if (data.uuids != null) {
                    UUID.add(data.uuids);
                }
                this.remote_view = data.remote_view;
                if (this.global_view != null && (data.global_view == null || this.global_view.equals(data.global_view))) break block8;
                this.global_view = data.global_view;
                RELAY rELAY = this;
                synchronized (rELAY) {
                    if (data.global_view.getVid().getId() > this.global_view_id) {
                        this.global_view_id = data.global_view.getViewId().getId();
                    }
                }
                if (this.present_global_views) {
                    return this.up_prot.up(new Event(6, this.global_view));
                }
            }
            catch (Exception e) {
                this.log.error("failed installing view", e);
            }
        }
        return null;
    }

    protected void forward(byte[] buffer, int offset, int length) {
        Message msg = new Message(null, null, buffer, offset, length).putHeader(this.id, new RelayHeader(RelayHeader.Type.FORWARD));
        if (this.bridge != null) {
            try {
                this.bridge.send(msg);
            }
            catch (Throwable t) {
                this.log.error("failed forwarding message over bridge", t);
            }
        }
    }

    protected void forwardToCoord(Message msg) {
        Message tmp = msg.copy(true, (short)200);
        if (tmp.getSrc() == null) {
            tmp.setSrc(this.local_addr);
        }
        try {
            byte[] buf = Util.streamableToByteBuffer(tmp);
            if (this.coord != null) {
                if (this.coord.equals(this.local_addr)) {
                    this.forward(buf, 0, buf.length);
                    return;
                }
                tmp = new Message(this.coord, null, buf, 0, buf.length);
                tmp.putHeader(this.id, new RelayHeader(RelayHeader.Type.FORWARD));
                this.down_prot.down(new Event(1, tmp));
            }
        }
        catch (Exception e) {
            this.log.error("failed forwarding unicast message to coord", e);
        }
    }

    protected void sendViewToRemote(ViewData view_data, boolean use_seperate_thread) {
        try {
            if (this.bridge != null && this.bridge.isConnected()) {
                byte[] buf = Util.streamableToByteBuffer(view_data);
                final Message msg = new Message(null, buf).putHeader(this.id, RelayHeader.create(RelayHeader.Type.VIEW));
                if (use_seperate_thread) {
                    this.timer.execute(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                RELAY.this.bridge.send(msg);
                            }
                            catch (Exception e) {
                                RELAY.this.log.error("failed sending view to remote", e);
                            }
                        }
                    });
                } else {
                    this.bridge.send(msg);
                }
            }
        }
        catch (Exception e) {
            this.log.error("failed sending view to remote", e);
        }
    }

    protected View generateGlobalView(View local_view, View remote_view) {
        return this.generateGlobalView(local_view, remote_view, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected View generateGlobalView(View local_view, View remote_view, boolean merge) {
        Address view_creator;
        long new_view_id;
        ArrayList<View> views = new ArrayList<View>(2);
        if (local_view != null) {
            views.add(local_view);
        }
        if (remote_view != null) {
            views.add(remote_view);
        }
        Collections.sort(views, new Comparator<View>(){

            @Override
            public int compare(View v1, View v2) {
                long id2;
                Address creator2;
                ViewId vid1 = v1.getViewId();
                ViewId vid2 = v2.getViewId();
                Address creator1 = vid1.getCreator();
                int rc = creator1.compareTo(creator2 = vid2.getCreator());
                if (rc != 0) {
                    return rc;
                }
                long id1 = vid1.getId();
                return id1 > (id2 = vid2.getId()) ? 1 : (id1 < id2 ? -1 : 0);
            }
        });
        ArrayList<Address> combined_members = new ArrayList<Address>();
        for (View view : views) {
            combined_members.addAll(view.getMembers());
        }
        RELAY rELAY = this;
        synchronized (rELAY) {
            new_view_id = this.global_view_id++;
        }
        Address address = view_creator = combined_members.isEmpty() ? this.local_addr : (Address)combined_members.get(0);
        if (merge) {
            return new MergeView(view_creator, new_view_id, combined_members, views);
        }
        return new View(view_creator, new_view_id, combined_members);
    }

    protected void createBridge() {
        try {
            if (this.log.isTraceEnabled()) {
                this.log.trace("I'm the coordinator, creating a channel (props=" + this.bridge_props + ", cluster_name=" + this.bridge_name + ")");
            }
            this.bridge = new JChannel(this.bridge_props);
            this.bridge.setDiscardOwnMessages(true);
            this.bridge.setReceiver(new Receiver());
            this.bridge.connect(this.bridge_name);
        }
        catch (Exception e) {
            this.log.error("failed creating bridge channel (props=" + this.bridge_props + ")", e);
        }
    }

    protected void sendOnLocalCluster(byte[] buf, int offset, int length) {
        try {
            Message msg = (Message)Util.streamableFromByteBuffer(Message.class, buf, offset, length);
            Address sender = msg.getSrc();
            Address dest = msg.getDest();
            if (!this.isLocal(dest)) {
                if (this.log.isWarnEnabled()) {
                    this.log.warn("[" + this.local_addr + "] dest=" + dest + " is not local (site=" + this.site + "); discarding it");
                }
                return;
            }
            msg.setSrc(this.local_addr);
            msg.putHeader(this.id, RelayHeader.createDisseminateHeader(sender));
            if (this.log.isTraceEnabled()) {
                this.log.trace("received msg from " + sender + ", passing down the stack with dest=" + msg.getDest() + " and src=" + msg.getSrc());
            }
            this.down_prot.down(new Event(1, msg));
        }
        catch (Exception e) {
            this.log.error("failed sending on local cluster", e);
        }
    }

    protected void sendViewOnLocalCluster(View remote_view, View global_view, boolean use_seperate_thread, List<Address> new_mbrs) {
        this.sendViewOnLocalCluster(ViewData.create(remote_view, global_view), use_seperate_thread, new_mbrs);
    }

    protected void sendViewOnLocalCluster(ViewData data, boolean use_seperate_thread, List<Address> new_mbrs) {
        try {
            final byte[] buffer = Util.streamableToByteBuffer(data);
            final ArrayList<Address> destinations = new ArrayList<Address>();
            destinations.add(null);
            if (new_mbrs != null) {
                destinations.addAll(new_mbrs);
            }
            if (use_seperate_thread) {
                this.timer.execute(new Runnable(){

                    @Override
                    public void run() {
                        RELAY.this.sendViewOnLocalCluster(destinations, buffer);
                    }
                });
            } else {
                this.sendViewOnLocalCluster(destinations, buffer);
            }
        }
        catch (Exception e) {
            this.log.error("failed sending view to local cluster", e);
        }
    }

    protected void sendViewOnLocalCluster(List<Address> destinations, byte[] buffer) {
        for (Address dest : destinations) {
            Message view_msg = new Message(dest, buffer).putHeader(this.id, RelayHeader.create(RelayHeader.Type.VIEW));
            this.down_prot.down(new Event(1, view_msg));
        }
    }

    protected boolean isLocal(Address dest) {
        if (dest instanceof PayloadUUID) {
            String tmp = ((PayloadUUID)dest).getPayload();
            return tmp != null && tmp.equals(this.site);
        }
        if (dest instanceof TopologyUUID) {
            String tmp = ((TopologyUUID)dest).getSiteId();
            return tmp != null && tmp.equals(this.site);
        }
        return true;
    }

    protected synchronized void startRemoteViewFetcher() {
        if (this.remote_view_fetcher_future == null || this.remote_view_fetcher_future.isDone()) {
            this.remote_view_fetcher_future = this.timer.scheduleWithFixedDelay(new RemoteViewFetcher(), 500L, 2000L, TimeUnit.MILLISECONDS);
        }
    }

    protected synchronized void stopRemoteViewFetcher() {
        if (this.remote_view_fetcher_future != null) {
            this.remote_view_fetcher_future.cancel(false);
            this.remote_view_fetcher_future = null;
        }
    }

    protected static class ViewData
    implements Streamable {
        protected View remote_view;
        protected View global_view;
        protected Map<Address, String> uuids;

        public ViewData() {
        }

        private ViewData(View remote_view, View global_view, Map<Address, String> uuids) {
            this.remote_view = remote_view;
            this.global_view = global_view;
            this.uuids = uuids;
        }

        public static ViewData create(View remote_view, View global_view) {
            Map<Address, String> tmp = UUID.getContents();
            View rv = remote_view != null ? remote_view.copy() : null;
            View gv = global_view != null ? global_view.copy() : null;
            return new ViewData(rv, gv, tmp);
        }

        @Override
        public void writeTo(DataOutput out) throws Exception {
            Util.writeView(this.remote_view, out);
            Util.writeView(this.global_view, out);
            out.writeInt(this.uuids.size());
            for (Map.Entry<Address, String> entry : this.uuids.entrySet()) {
                Util.writeAddress(entry.getKey(), out);
                out.writeUTF(entry.getValue());
            }
        }

        @Override
        public void readFrom(DataInput in) throws Exception {
            this.remote_view = Util.readView(in);
            this.global_view = Util.readView(in);
            int size = in.readInt();
            this.uuids = new HashMap<Address, String>();
            for (int i = 0; i < size; ++i) {
                Address addr = Util.readAddress(in);
                String name = in.readUTF();
                this.uuids.put(addr, name);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("global_view: " + this.global_view).append(", remote_view: ").append(this.remote_view);
            return sb.toString();
        }
    }

    public static class RelayHeader
    extends Header {
        protected Type type;
        protected Address original_sender;

        public RelayHeader() {
        }

        private RelayHeader(Type type) {
            this.type = type;
        }

        public static RelayHeader create(Type type) {
            return new RelayHeader(type);
        }

        public static RelayHeader createDisseminateHeader(Address original_sender) {
            RelayHeader retval = new RelayHeader(Type.DISSEMINATE);
            retval.original_sender = original_sender;
            return retval;
        }

        @Override
        public int size() {
            int retval = 1;
            switch (this.type) {
                case DISSEMINATE: {
                    retval += Util.size(this.original_sender);
                    break;
                }
            }
            return retval;
        }

        @Override
        public void writeTo(DataOutput out) throws Exception {
            out.writeByte(this.type.ordinal());
            switch (this.type) {
                case DISSEMINATE: {
                    Util.writeAddress(this.original_sender, out);
                    break;
                }
            }
        }

        @Override
        public void readFrom(DataInput in) throws Exception {
            this.type = Type.values()[in.readByte()];
            switch (this.type) {
                case DISSEMINATE: {
                    this.original_sender = Util.readAddress(in);
                    break;
                }
            }
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder(this.type.toString());
            switch (this.type) {
                case DISSEMINATE: {
                    sb.append(" (original sender=" + this.original_sender + ")");
                    break;
                }
            }
            return sb.toString();
        }

        public static enum Type {
            DISSEMINATE,
            FORWARD,
            VIEW,
            BROADCAST_VIEW;

        }
    }

    protected class RemoteViewFetcher
    implements Runnable {
        protected RemoteViewFetcher() {
        }

        @Override
        public void run() {
            if (RELAY.this.bridge == null || !RELAY.this.bridge.isConnected() || RELAY.this.remote_view != null) {
                return;
            }
            Message msg = new Message().putHeader(RELAY.this.id, RelayHeader.create(RelayHeader.Type.BROADCAST_VIEW));
            try {
                RELAY.this.bridge.send(msg);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected class Receiver
    extends ReceiverAdapter {
        protected Receiver() {
        }

        @Override
        public void receive(Message msg) {
            Address sender = msg.getSrc();
            if (RELAY.this.bridge.getAddress().equals(sender)) {
                return;
            }
            RelayHeader hdr = (RelayHeader)msg.getHeader(RELAY.this.id);
            switch (hdr.type) {
                case DISSEMINATE: {
                    break;
                }
                case FORWARD: {
                    RELAY.this.sendOnLocalCluster(msg.getRawBuffer(), msg.getOffset(), msg.getLength());
                    break;
                }
                case VIEW: {
                    try {
                        ViewData data = (ViewData)Util.streamableFromByteBuffer(ViewData.class, msg.getRawBuffer(), msg.getOffset(), msg.getLength());
                        if (data.remote_view != null) {
                            LinkedList<Address> mbrs = new LinkedList<Address>();
                            for (Address mbr : data.remote_view.getMembers()) {
                                mbrs.add(mbr);
                            }
                            data.remote_view = new View(data.remote_view.getViewId(), mbrs);
                        }
                        boolean merge = RELAY.this.remote_view == null;
                        RELAY.this.stopRemoteViewFetcher();
                        data.global_view = RELAY.this.generateGlobalView(RELAY.this.local_view, data.remote_view, merge);
                        RELAY.this.sendViewOnLocalCluster(data, false, null);
                    }
                    catch (Exception e) {
                        RELAY.this.log.error("failed unmarshalling view from remote cluster", e);
                    }
                    break;
                }
                case BROADCAST_VIEW: {
                    RELAY.this.sendViewToRemote(ViewData.create(RELAY.this.local_view, null), true);
                    break;
                }
                default: {
                    throw new IllegalArgumentException((Object)((Object)hdr.type) + " is not a valid type");
                }
            }
        }

        @Override
        public void viewAccepted(View view) {
            if (RELAY.this.bridge_view != null && RELAY.this.bridge_view.getViewId().equals(view.getViewId())) {
                return;
            }
            int prev_members = RELAY.this.bridge_view != null ? RELAY.this.bridge_view.size() : 0;
            RELAY.this.bridge_view = view;
            switch (view.size()) {
                case 1: {
                    if (prev_members <= 1 || !view.getMembers().iterator().next().equals(RELAY.this.bridge.getAddress())) break;
                    RELAY.this.remote_view = null;
                    View new_global_view = RELAY.this.generateGlobalView(RELAY.this.local_view, null);
                    RELAY.this.sendViewOnLocalCluster(null, new_global_view, false, null);
                    break;
                }
                case 2: {
                    RELAY.this.startRemoteViewFetcher();
                    break;
                }
            }
        }
    }
}

