/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.ArrayList;
import java.util.List;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.util.Util;

public class PingPong
extends ReceiverAdapter {
    JChannel ch;
    static final byte PING = 1;
    static final byte PONG = 2;
    static final byte[] PING_REQ = new byte[]{1};
    static final byte[] PONG_RSP = new byte[]{2};
    long start = 0L;
    final List<Address> members = new ArrayList<Address>();

    public void start(String props, String name, boolean unicast) throws Exception {
        this.ch = new JChannel(props);
        if (name != null) {
            this.ch.setName(name);
        }
        this.ch.setReceiver(this);
        this.ch.connect("ping");
        while (true) {
            Util.keyPress("enter to ping");
            Address dest = null;
            if (unicast) {
                dest = (Address)Util.pickRandomElement(this.members);
            }
            Message msg = new Message(dest, null, PING_REQ);
            msg.setFlag(Message.Flag.DONT_BUNDLE, Message.NO_FC);
            this.start = System.nanoTime();
            this.ch.send(msg);
        }
    }

    @Override
    public void viewAccepted(View new_view) {
        System.out.println("view: " + new_view);
        this.members.clear();
        this.members.addAll(new_view.getMembers());
    }

    @Override
    public void receive(Message msg) {
        byte type = msg.getRawBuffer()[0];
        switch (type) {
            case 1: {
                Message rsp = new Message(msg.getSrc(), null, PONG_RSP);
                rsp.setFlag(Message.Flag.DONT_BUNDLE, Message.NO_FC);
                try {
                    this.ch.send(rsp);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case 2: {
                long rtt = System.nanoTime() - this.start;
                double ms = (double)rtt / 1000.0 / 1000.0;
                System.out.println("RTT for " + msg.getSrc() + ": " + Util.format(ms) + " ms");
            }
        }
    }

    public static void main(String[] args) throws Exception {
        String props = "udp.xml";
        String name = null;
        boolean unicast = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-props")) {
                props = args[++i];
                continue;
            }
            if (args[i].equals("-name")) {
                name = args[++i];
                continue;
            }
            if (args[i].equals("-unicast")) {
                unicast = true;
                continue;
            }
            System.out.println("PingPong [-props <XML config>] [-name name] [-unicast]");
            return;
        }
        new PingPong().start(props, name, unicast);
    }
}

