/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.module.seq.jms.service;

import com.thetransactioncompany.jsonrpc2.util.NamedParamsRetriever;
import fr.profi.util.jsonrpc.IJSONRPC2Method;
import fr.profi.util.jsonrpc.JSONRPC2Method;
import fr.profi.util.jsonrpc.JSONRPC2MethodParameter;
import fr.profi.util.jsonrpc.JSONRPC2Utils;
import fr.proline.jms.service.api.AbstractRemoteProcessingService;
import fr.proline.jms.service.api.RemoteServiceIdentity;
import fr.proline.module.seq.service.RetrieveService;
import fr.proline.module.seq.util.ScalaUtil;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;
import scala.Some;
import scala.collection.JavaConversions;
import scala.collection.Seq;
import scala.collection.immutable.List;

public class RetrieveJMSService
extends AbstractRemoteProcessingService {
    private static final Logger LOG = LoggerFactory.getLogger(RetrieveJMSService.class);
    private static String serviceName = "RetrieveBioSeqForRSMs";
    private static String serviceDescription = "Retrieve BioSequence for all validated protein of specified Identification Summaries. This service will also calculate coverage and protein mass if necessary";
    private static String serviceNamespace = "proline/seq";
    private static String serviceVersion = "1.0";
    private static Boolean isDefaultVersion = true;

    public String serviceNamespace() {
        return serviceNamespace;
    }

    public String serviceLabel() {
        return serviceName;
    }

    public String serviceVersion() {
        return serviceVersion;
    }

    public boolean isDefaultVersion() {
        return isDefaultVersion;
    }

    public Option<String> serviceDescription() {
        return new Some((Object)serviceDescription);
    }

    public Object doProcess(NamedParamsRetriever paramsRetriever) throws Exception {
        if (paramsRetriever == null || paramsRetriever.size() <= 0) {
            throw new IllegalArgumentException(" No parameter specified");
        }
        Boolean force = paramsRetriever.hasParam("force_update") ? paramsRetriever.getBoolean("force_update") : false;
        Long projectId = paramsRetriever.getLong("project_id");
        java.util.List rsmsIdsStr = paramsRetriever.getList("result_summaries_ids");
        ArrayList<Long> rsmsIds = new ArrayList<Long>();
        rsmsIdsStr.forEach(idAsStr -> rsmsIds.add(new Long(idAsStr.toString())));
        RetrieveService.retrieveBioSequences(projectId, force, rsmsIds);
        return true;
    }

    public Seq<IJSONRPC2Method> methodDefinitions() {
        ArrayList<JSONRPC2MethodParameter> parameters = new ArrayList<JSONRPC2MethodParameter>();
        JSONRPC2MethodParameter PROJECT_ID_PARAM = JSONRPC2Utils.buildStringMethodParameter((String)"project_id", (String)"The id of the project to get bioSequence for", (boolean)false, ScalaUtil.none());
        parameters.add(PROJECT_ID_PARAM);
        JSONRPC2MethodParameter RSM_IDS_PARAM = JSONRPC2Utils.buildArrayLongMethodParameter((String)"result_summaries_ids", (String)"The list of the result summaries to retrieve be bioSequence", (boolean)false, ScalaUtil.none());
        parameters.add(RSM_IDS_PARAM);
        JSONRPC2MethodParameter FORCE_UPDATE_PARAM = JSONRPC2Utils.buildBooleanMethodParameter((String)"force_update", (String)"specify if biosequences are retrieve and properties are calculate even if they already exit", (boolean)true, (Option)new Some((Object)"false"));
        parameters.add(FORCE_UPDATE_PARAM);
        List params = JavaConversions.asScalaBuffer(parameters).toList();
        JSONRPC2Method meth = new JSONRPC2Method(RemoteServiceIdentity.PROCESS_METHOD_NAME(), serviceDescription, (Seq)params, JSONRPC2Utils.buildBooleanMethodReturn((String)"true: if operation was successful"), false);
        ArrayList<JSONRPC2Method> methods = new ArrayList<JSONRPC2Method>();
        methods.add(meth);
        return JavaConversions.asScalaBuffer(methods).toList();
    }
}

