/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.jms.util;

import com.thetransactioncompany.jsonrpc2.JSONRPC2Error;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Message;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Response;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import fr.profi.util.StringUtils;
import fr.profi.util.ThreadLogger;
import fr.proline.jms.ServiceEvent;
import fr.proline.jms.ServiceEvent$;
import fr.proline.jms.util.IServiceMonitoringNotifier;
import fr.proline.jms.util.JMSConstants$;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00153A!\u0001\u0002\u0001\u0017\t1R\t\u001f9je\u0016$W*Z:tC\u001e,7i\u001c8tk6,'O\u0003\u0002\u0004\t\u0005!Q\u000f^5m\u0015\t)a!A\u0002k[NT!a\u0002\u0005\u0002\u000fA\u0014x\u000e\\5oK*\t\u0011\"\u0001\u0002ge\u000e\u00011\u0003\u0002\u0001\r)]\u0001\"!\u0004\n\u000e\u00039Q!a\u0004\t\u0002\t1\fgn\u001a\u0006\u0002#\u0005!!.\u0019<b\u0013\t\u0019bB\u0001\u0004PE*,7\r\u001e\t\u0003\u001bUI!A\u0006\b\u0003\u0011I+hN\\1cY\u0016\u0004\"\u0001G\u0010\u000e\u0003eQ!AG\u000e\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005qi\u0012\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003y\t1aY8n\u0013\t\u0001\u0013DA\u0006MCjLHj\\4hS:<\u0007\u0002\u0003\u0012\u0001\u0005\u0003\u0005\u000b\u0011B\u0012\u0002\u000bE,X-^3\u0011\u0005\u0011BS\"A\u0013\u000b\u0005\u00151#\"A\u0014\u0002\u000b)\fg/\u0019=\n\u0005%*#!B)vKV,\u0007\u0002C\u0016\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0017\u0002\u0015\r|gN\\3di&|g\u000e\u0005\u0002%[%\u0011a&\n\u0002\u000b\u0007>tg.Z2uS>t\u0007\u0002\u0003\u0019\u0001\u0005\u0003\u0005\u000b\u0011B\u0019\u00023M,'O^5dK6{g.\u001b;pe&twMT8uS\u001aLWM\u001d\t\u0003eMj\u0011AA\u0005\u0003i\t\u0011!$S*feZL7-Z'p]&$xN]5oO:{G/\u001b4jKJDQA\u000e\u0001\u0005\u0002]\na\u0001P5oSRtD\u0003\u0002\u001d:um\u0002\"A\r\u0001\t\u000b\t*\u0004\u0019A\u0012\t\u000b-*\u0004\u0019\u0001\u0017\t\u000bA*\u0004\u0019A\u0019\t\u000bu\u0002A\u0011\u0001 \u0002\u0007I,h\u000eF\u0001@!\t\u00015)D\u0001B\u0015\u0005\u0011\u0015!B:dC2\f\u0017B\u0001#B\u0005\u0011)f.\u001b;")
public class ExpiredMessageConsumer
implements Runnable,
LazyLogging {
    private final Queue queue;
    private final Connection connection;
    private final IServiceMonitoringNotifier serviceMonitoringNotifier;
    private final Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        ExpiredMessageConsumer expiredMessageConsumer = this;
        synchronized (expiredMessageConsumer) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        Thread currentThread = Thread.currentThread();
        if (!(currentThread.getUncaughtExceptionHandler() instanceof ThreadLogger)) {
            currentThread.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new ThreadLogger(this.logger().underlying().getName()));
        }
        Session session = this.connection.createSession(false, 1);
        try {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            MessageConsumer consumer = session.createConsumer((Destination)this.queue);
            MessageProducer replyProducer = session.createProducer(null);
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(new StringBuilder().append((Object)"Entering ExpiredMessage Consumer receive loop [").append((Object)currentThread.getName()).append((Object)BoxesRunTime.boxToCharacter((char)']')).toString());
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            boolean goOn = true;
            while (goOn) {
                BoxedUnit boxedUnit3;
                None$ serviceDescrOp;
                BoxedUnit boxedUnit4;
                Message jmsMessage;
                block26: {
                    block27: {
                        try {
                            jmsMessage = consumer.receive();
                            if (jmsMessage != null) break block26;
                            goOn = false;
                            if (this.logger().underlying().isInfoEnabled()) {
                                this.logger().underlying().info("Consumer Connection is closed : exiting receive loop");
                                boxedUnit4 = BoxedUnit.UNIT;
                            }
                            break block27;
                        }
                        catch (Throwable throwable) {
                            if (this.logger().underlying().isErrorEnabled()) {
                                this.logger().underlying().error("Error running Consumer reception loop", throwable);
                                boxedUnit4 = BoxedUnit.UNIT;
                                continue;
                            }
                            boxedUnit4 = BoxedUnit.UNIT;
                        }
                        continue;
                    }
                    boxedUnit4 = BoxedUnit.UNIT;
                    continue;
                }
                String jmsMessageId = jmsMessage.getJMSMessageID();
                JSONRPC2Error err = new JSONRPC2Error(JMSConstants$.MODULE$.EXPIRED_MSG_ERROR_CODE(), "Message has expired.");
                JSONRPC2Response jsonResponse = new JSONRPC2Response(err, (Object)jmsMessageId);
                Destination replyDestination = jmsMessage.getJMSReplyTo();
                String serviceName = jmsMessage.getStringProperty(JMSConstants$.MODULE$.PROLINE_SERVICE_NAME_KEY());
                String serviceVersion = jmsMessage.getStringProperty(JMSConstants$.MODULE$.PROLINE_SERVICE_VERSION_KEY());
                None$ serviceVersionOp = StringUtils.isNotEmpty((String)serviceVersion) ? new Some((Object)serviceVersion) : None$.MODULE$;
                String serviceSource = jmsMessage.getStringProperty(JMSConstants$.MODULE$.PROLINE_SERVICE_SOURCE_KEY());
                None$ serviceSourceOp = StringUtils.isNotEmpty((String)serviceSource) ? new Some((Object)serviceSource) : None$.MODULE$;
                String serviceDescr = jmsMessage.getStringProperty(JMSConstants$.MODULE$.PROLINE_SERVICE_DESCR_KEY());
                Object object = serviceDescrOp = StringUtils.isNotEmpty((String)serviceDescr) ? new Some((Object)serviceDescr) : None$.MODULE$;
                if (replyDestination == null) {
                    if (this.logger().underlying().isWarnEnabled()) {
                        this.logger().underlying().warn("Request JMS Message has no JMSReplyTo Destination : Cannot send JSON Response to Client");
                        boxedUnit4 = BoxedUnit.UNIT;
                        continue;
                    }
                    boxedUnit4 = BoxedUnit.UNIT;
                    continue;
                }
                ServiceEvent serviceEvent = new ServiceEvent(jsonResponse.getID().toString(), jmsMessageId, serviceName, ServiceEvent$.MODULE$.EVENT_FAIL(), (Option<String>)serviceVersionOp, (Option<String>)serviceSourceOp, (Option<String>)serviceDescrOp);
                if (jmsMessage instanceof TextMessage) {
                    serviceEvent.setComplementaryInfo(((TextMessage)jmsMessage).getText());
                }
                this.serviceMonitoringNotifier.sendNotification((JSONRPC2Message)serviceEvent.toJSONRPCNotification(), null);
                TextMessage responseJMSMessage = session.createTextMessage();
                responseJMSMessage.setJMSCorrelationID(jmsMessageId);
                responseJMSMessage.setText(jsonResponse.toJSONString());
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(new StringBuilder().append((Object)"Sending JMS Response to Request JMS Message [").append((Object)jmsMessageId).append((Object)"] on Destination [").append((Object)replyDestination).append((Object)BoxesRunTime.boxToCharacter((char)']')).toString());
                    boxedUnit3 = BoxedUnit.UNIT;
                } else {
                    boxedUnit3 = BoxedUnit.UNIT;
                }
                replyProducer.send(replyDestination, (Message)responseJMSMessage);
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info(new StringBuilder().append((Object)"JMS Response to Request JMS Message [").append((Object)jmsMessageId).append((Object)"] sent").toString());
                    boxedUnit4 = BoxedUnit.UNIT;
                    continue;
                }
                boxedUnit4 = BoxedUnit.UNIT;
            }
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Exiting ServiceRunner loop");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        }
        catch (Throwable throwable) {
            if (session == null) throw throwable;
            try {
                BoxedUnit boxedUnit;
                session.close();
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("JMS Session closed");
                    boxedUnit = BoxedUnit.UNIT;
                    throw throwable;
                }
                boxedUnit = BoxedUnit.UNIT;
                throw throwable;
            }
            catch (JMSException jMSException) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("Error closing JMS Session", (Throwable)jMSException);
                    boxedUnit = BoxedUnit.UNIT;
                    throw throwable;
                }
                boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
        if (session == null) return;
        try {
            BoxedUnit boxedUnit;
            session.close();
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("JMS Session closed");
                boxedUnit = BoxedUnit.UNIT;
                return;
            }
            boxedUnit = BoxedUnit.UNIT;
            return;
        }
        catch (JMSException jMSException) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Error closing JMS Session", (Throwable)jMSException);
                boxedUnit = BoxedUnit.UNIT;
                return;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public ExpiredMessageConsumer(Queue queue, Connection connection, IServiceMonitoringNotifier serviceMonitoringNotifier) {
        this.queue = queue;
        this.connection = connection;
        this.serviceMonitoringNotifier = serviceMonitoringNotifier;
        LazyLogging.class.$init$((LazyLogging)this);
        Predef$.MODULE$.require(queue != null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Queue is null";
            }
        });
        Predef$.MODULE$.require(connection != null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Connection is null";
            }
        });
    }
}

