/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.algo.feature.extraction;

import fr.profi.ms.model.TheoreticalIsotopePattern;
import fr.profi.mzdb.algo.feature.extraction.AbstractSupervisedFtExtractor;
import fr.profi.mzdb.algo.feature.extraction.FeatureExtractorConfig;
import fr.profi.mzdb.algo.feature.extraction.OverlappingFeatureExtractorConfig;
import fr.profi.mzdb.algo.feature.extraction.PeakelDetectionConfig;
import fr.profi.mzdb.algo.feature.extraction.PredictedMzFtExtractor$;
import fr.profi.mzdb.algo.signal.detection.CwtPeakel;
import fr.profi.mzdb.algo.signal.detection.waveletImpl.WaveletPeakelFinderNeumann;
import fr.profi.mzdb.model.Feature;
import fr.profi.mzdb.model.IsotopicPattern;
import fr.profi.mzdb.model.IsotopicPatternLike;
import fr.profi.mzdb.model.Peak;
import fr.profi.mzdb.model.PeakListTree;
import fr.profi.mzdb.model.PutativeFeature;
import fr.profi.mzdb.model.SpectrumHeader;
import fr.profi.mzdb.util.ms.MsUtils;
import scala.Array$;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.LongMap;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001y4A!\u0001\u0002\u0001\u001f\t1\u0002K]3eS\u000e$X\rZ'{\rR,\u0005\u0010\u001e:bGR|'O\u0003\u0002\u0004\t\u0005QQ\r\u001f;sC\u000e$\u0018n\u001c8\u000b\u0005\u00151\u0011a\u00024fCR,(/\u001a\u0006\u0003\u000f!\tA!\u00197h_*\u0011\u0011BC\u0001\u0005[j$'M\u0003\u0002\f\u0019\u0005)\u0001O]8gS*\tQ\"\u0001\u0002ge\u000e\u00011C\u0001\u0001\u0011!\t\t\"#D\u0001\u0003\u0013\t\u0019\"AA\u000fBEN$(/Y2u'V\u0004XM\u001d<jg\u0016$g\t^#yiJ\f7\r^8s\u0011!)\u0002A!b\u0001\n\u00031\u0012AE:qK\u000e$(/^7IK\u0006$WM\u001d\"z\u0013\u0012,\u0012a\u0006\t\u00041}\tS\"A\r\u000b\u0005iY\u0012aB7vi\u0006\u0014G.\u001a\u0006\u00039u\t!bY8mY\u0016\u001cG/[8o\u0015\u0005q\u0012!B:dC2\f\u0017B\u0001\u0011\u001a\u0005\u001dauN\\4NCB\u0004\"AI\u0013\u000e\u0003\rR!\u0001\n\u0005\u0002\u000b5|G-\u001a7\n\u0005\u0019\u001a#AD*qK\u000e$(/^7IK\u0006$WM\u001d\u0005\tQ\u0001\u0011\t\u0011)A\u0005/\u0005\u00192\u000f]3diJ,X\u000eS3bI\u0016\u0014()_%eA!A!\u0006\u0001BC\u0002\u0013\u00051&\u0001\boM\nK8\u000b]3diJ,X.\u00133\u0016\u00031\u00022\u0001G\u0010.!\tqs&D\u0001\u001e\u0013\t\u0001TDA\u0003GY>\fG\u000f\u0003\u00053\u0001\t\u0005\t\u0015!\u0003-\u0003=qgMQ=Ta\u0016\u001cGO];n\u0013\u0012\u0004\u0003\u0002\u0003\u001b\u0001\u0005\u000b\u0007I\u0011A\u001b\u0002\u0019a$(/Y2u\u0007>tg-[4\u0016\u0003Y\u0002\"!E\u001c\n\u0005a\u0012!A\u0006$fCR,(/Z#yiJ\f7\r^8s\u0007>tg-[4\t\u0011i\u0002!\u0011!Q\u0001\nY\nQ\u0002\u001f;sC\u000e$8i\u001c8gS\u001e\u0004\u0003\u0002\u0003\u001f\u0001\u0005\u000b\u0007I\u0011A\u001f\u0002+A,\u0017m[3m\t\u0016$Xm\u0019;j_:\u001cuN\u001c4jOV\ta\b\u0005\u0002\u0012\u007f%\u0011\u0001I\u0001\u0002\u0016!\u0016\f7.\u001a7EKR,7\r^5p]\u000e{gNZ5h\u0011!\u0011\u0005A!A!\u0002\u0013q\u0014A\u00069fC.,G\u000eR3uK\u000e$\u0018n\u001c8D_:4\u0017n\u001a\u0011\t\u0011\u0011\u0003!Q1A\u0005\u0002\u0015\u000b1c\u001c<fe2\f\u0007\u000f\u0017;sC\u000e$8i\u001c8gS\u001e,\u0012A\u0012\t\u0003#\u001dK!\u0001\u0013\u0002\u0003C=3XM\u001d7baBLgn\u001a$fCR,(/Z#yiJ\f7\r^8s\u0007>tg-[4\t\u0011)\u0003!\u0011!Q\u0001\n\u0019\u000bAc\u001c<fe2\f\u0007\u000f\u0017;sC\u000e$8i\u001c8gS\u001e\u0004\u0003\"\u0002'\u0001\t\u0003i\u0015A\u0002\u001fj]&$h\b\u0006\u0004O\u001fB\u000b&k\u0015\t\u0003#\u0001AQ!F&A\u0002]AQAK&A\u00021BQ\u0001N&A\u0002YBq\u0001P&\u0011\u0002\u0003\u0007a\bC\u0003E\u0017\u0002\u0007a\tC\u0003V\u0001\u0011\u0005a+\u0001\bfqR\u0014\u0018m\u0019;GK\u0006$XO]3\u0015\u0007]k&\rE\u0002/1jK!!W\u000f\u0003\r=\u0003H/[8o!\t\u00113,\u0003\u0002]G\t9a)Z1ukJ,\u0007\"\u00020U\u0001\u0004y\u0016A\u00039vi\u0006$\u0018N^3GiB\u0011!\u0005Y\u0005\u0003C\u000e\u0012q\u0002U;uCRLg/\u001a$fCR,(/\u001a\u0005\u0006GR\u0003\r\u0001Z\u0001\ba.dGK]3f!\t\u0011S-\u0003\u0002gG\ta\u0001+Z1l\u0019&\u001cH\u000f\u0016:fK\u001e9\u0001NAA\u0001\u0012\u0003I\u0017A\u0006)sK\u0012L7\r^3e\u001bj4E/\u0012=ue\u0006\u001cGo\u001c:\u0011\u0005EQgaB\u0001\u0003\u0003\u0003E\ta[\n\u0003U2\u0004\"AL7\n\u00059l\"AB!osJ+g\rC\u0003MU\u0012\u0005\u0001\u000fF\u0001j\u0011\u001d\u0011(.%A\u0005\u0002M\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"T#\u0001;+\u0005y*8&\u0001<\u0011\u0005]dX\"\u0001=\u000b\u0005eT\u0018!C;oG\",7m[3e\u0015\tYX$\u0001\u0006b]:|G/\u0019;j_:L!! =\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public class PredictedMzFtExtractor
extends AbstractSupervisedFtExtractor {
    private final LongMap<SpectrumHeader> spectrumHeaderById;
    private final LongMap<Object> nfBySpectrumId;
    private final FeatureExtractorConfig xtractConfig;
    private final PeakelDetectionConfig peakelDetectionConfig;
    private final OverlappingFeatureExtractorConfig overlapXtractConfig;

    public static PeakelDetectionConfig $lessinit$greater$default$4() {
        return PredictedMzFtExtractor$.MODULE$.$lessinit$greater$default$4();
    }

    @Override
    public LongMap<SpectrumHeader> spectrumHeaderById() {
        return this.spectrumHeaderById;
    }

    @Override
    public LongMap<Object> nfBySpectrumId() {
        return this.nfBySpectrumId;
    }

    @Override
    public FeatureExtractorConfig xtractConfig() {
        return this.xtractConfig;
    }

    @Override
    public PeakelDetectionConfig peakelDetectionConfig() {
        return this.peakelDetectionConfig;
    }

    @Override
    public OverlappingFeatureExtractorConfig overlapXtractConfig() {
        return this.overlapXtractConfig;
    }

    @Override
    public Option<Feature> extractFeature(PutativeFeature putativeFt, PeakListTree pklTree) {
        TheoreticalIsotopePattern theoIP = putativeFt.theoreticalIP();
        double moz = putativeFt.getMz();
        int charge = putativeFt.getCharge();
        float mzTolPPM = this.xtractConfig().mzTolPPM();
        double mzTolDa = MsUtils.ppmToDa((double)moz, (double)mzTolPPM);
        ArrayBuffer xic = new ArrayBuffer();
        ArrayBuffer xicSpectrumIDs = new ArrayBuffer();
        Predef$.MODULE$.longArrayOps(pklTree.spectrumIds()).foreach((Function1)new Serializable(this, pklTree, moz, mzTolDa, xic, xicSpectrumIDs){
            public static final long serialVersionUID = 0L;
            private final PeakListTree pklTree$1;
            private final double moz$1;
            private final double mzTolDa$1;
            private final ArrayBuffer xic$1;
            private final ArrayBuffer xicSpectrumIDs$1;

            public final Object apply(long id) {
                BoxedUnit boxedUnit;
                Peak p = this.pklTree$1.getNearestPeak(id, this.moz$1, this.mzTolDa$1);
                if (p == null) {
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    this.xic$1.$plus$eq((Object)p);
                    boxedUnit = this.xicSpectrumIDs$1.$plus$eq((Object)BoxesRunTime.boxToLong((long)id));
                }
                return boxedUnit;
            }
            {
                this.pklTree$1 = pklTree$1;
                this.moz$1 = moz$1;
                this.mzTolDa$1 = mzTolDa$1;
                this.xic$1 = xic$1;
                this.xicSpectrumIDs$1 = xicSpectrumIDs$1;
            }
        });
        WaveletPeakelFinderNeumann peakelFinder = new WaveletPeakelFinderNeumann((Seq<Peak>)xic);
        CwtPeakel[] cwtPeakels = peakelFinder.findCwtPeakels();
        if (Predef$.MODULE$.refArrayOps((Object[])cwtPeakels).isEmpty()) {
            return Option$.MODULE$.empty();
        }
        CwtPeakel highestPeakel = (CwtPeakel)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])cwtPeakels).sortBy((Function1)new Serializable(this, putativeFt, xic){
            public static final long serialVersionUID = 0L;
            private final PutativeFeature putativeFt$1;
            private final ArrayBuffer xic$1;

            public final float apply(CwtPeakel x) {
                return package$.MODULE$.abs(((Peak)this.xic$1.apply(x.apexIndex())).getLcContext().getElutionTime() - this.putativeFt$1.getElutionTime());
            }
            {
                this.putativeFt$1 = putativeFt$1;
                this.xic$1 = xic$1;
            }
        }, (Ordering)Ordering.Float$.MODULE$)).head();
        Option[] isotopicPatterns = new Option[highestPeakel.maxIdx() - highestPeakel.minIdx() + 1];
        IntRef c = IntRef.create((int)0);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(highestPeakel.minIdx()), highestPeakel.maxIdx()).foreach$mVc$sp((Function1)new Serializable(this, pklTree, theoIP, mzTolPPM, xic, xicSpectrumIDs, isotopicPatterns, c){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PredictedMzFtExtractor $outer;
            private final PeakListTree pklTree$1;
            private final TheoreticalIsotopePattern theoIP$1;
            private final float mzTolPPM$1;
            private final ArrayBuffer xic$1;
            private final ArrayBuffer xicSpectrumIDs$1;
            private final Option[] isotopicPatterns$1;
            private final IntRef c$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                Option<IsotopicPattern> ipOpt;
                Peak peak = (Peak)this.xic$1.apply(i);
                long spectrumID = BoxesRunTime.unboxToLong((Object)this.xicSpectrumIDs$1.apply(i));
                this.isotopicPatterns$1[this.c$1.elem] = ipOpt = this.pklTree$1.extractIsotopicPattern((SpectrumHeader)this.$outer.spectrumHeaderById().apply(spectrumID), this.theoIP$1, this.mzTolPPM$1, this.pklTree$1.extractIsotopicPattern$default$4(), this.pklTree$1.extractIsotopicPattern$default$5());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.pklTree$1 = pklTree$1;
                this.theoIP$1 = theoIP$1;
                this.mzTolPPM$1 = mzTolPPM$1;
                this.xic$1 = xic$1;
                this.xicSpectrumIDs$1 = xicSpectrumIDs$1;
                this.isotopicPatterns$1 = isotopicPatterns$1;
                this.c$1 = c$1;
            }
        });
        IsotopicPattern[] definedIps = (IsotopicPattern[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])isotopicPatterns).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Option<IsotopicPattern> ip) {
                return ip != null && ip.isDefined();
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final IsotopicPattern apply(Option<IsotopicPattern> x$1) {
                return (IsotopicPattern)x$1.get();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(IsotopicPattern.class)));
        Feature f = new Feature(moz, charge, (Seq<IsotopicPatternLike>)Predef$.MODULE$.wrapRefArray((Object[])definedIps), true);
        this.overlappingFeaturesExtractor().extractOverlappingFeatures(f, theoIP, pklTree);
        return new Some((Object)f);
    }

    public PredictedMzFtExtractor(LongMap<SpectrumHeader> spectrumHeaderById, LongMap<Object> nfBySpectrumId, FeatureExtractorConfig xtractConfig, PeakelDetectionConfig peakelDetectionConfig, OverlappingFeatureExtractorConfig overlapXtractConfig) {
        this.spectrumHeaderById = spectrumHeaderById;
        this.nfBySpectrumId = nfBySpectrumId;
        this.xtractConfig = xtractConfig;
        this.peakelDetectionConfig = peakelDetectionConfig;
        this.overlapXtractConfig = overlapXtractConfig;
    }
}

