/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.algo.ms.calibration;

import fr.profi.mzdb.MzDbReader;
import fr.profi.mzdb.algo.ms.calibration.ClassedPeakScala;
import fr.profi.mzdb.model.Peak;
import fr.profi.mzdb.model.PeakList;
import fr.profi.mzdb.model.Spectrum;
import java.io.File;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConversions$;
import scala.collection.SeqLike;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

public final class CalibrationCurveWriter$ {
    public static final CalibrationCurveWriter$ MODULE$;

    static {
        new CalibrationCurveWriter$();
    }

    private Tuple2<TreeMap<Object, Object>, TreeMap<Object, Object>> compute(MzDbReader mzdb, double maxDeltaPpm, double intensityThresh, int skipBeginningSpectra) {
        ObjectRef ms1Iter = ObjectRef.create((Object)mzdb.getSpectrumIterator(1));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), skipBeginningSpectra).foreach((Function1)new Serializable(ms1Iter){
            public static final long serialVersionUID = 0L;
            private final ObjectRef ms1Iter$1;

            public final Spectrum apply(int i) {
                if (((Iterator)this.ms1Iter$1.elem).hasNext()) {
                    return (Spectrum)((Iterator)this.ms1Iter$1.elem).next();
                }
                throw new Throwable("reach last spectrum while trying to skip beginning spectra");
            }
            {
                this.ms1Iter$1 = ms1Iter$1;
            }
        });
        TreeMap<Long, Double> m445 = new TreeMap<Long, Double>();
        TreeMap<Long, Double> result2 = new TreeMap<Long, Double>();
        if (((Iterator)ms1Iter.elem).hasNext()) {
            Spectrum firstSpectrum = (Spectrum)((Iterator)ms1Iter.elem).next();
            while (((Iterator)ms1Iter.elem).hasNext()) {
                Spectrum secondSpectrum = (Spectrum)((Iterator)ms1Iter.elem).next();
                ClassedPeakScala[] mergedSpectrum = (ClassedPeakScala[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])firstSpectrum.toPeaks()).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final ClassedPeakScala apply(Peak x) {
                        return new ClassedPeakScala(x.getMz(), x.getIntensity(), 1);
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ClassedPeakScala.class)))).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])secondSpectrum.toPeaks()).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final ClassedPeakScala apply(Peak x) {
                        return new ClassedPeakScala(x.getMz(), x.getIntensity(), 2);
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ClassedPeakScala.class)))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ClassedPeakScala.class)));
                float thresh = BoxesRunTime.unboxToFloat((Object)((SeqLike)Predef$.MODULE$.floatArrayOps((float[])Predef$.MODULE$.refArrayOps((Object[])mergedSpectrum).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final float apply(ClassedPeakScala x$1) {
                        return x$1.getIntensity();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float()))).toSeq().sortWith((Function2)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(float x$2, float x$3) {
                        return x$2 < x$3;
                    }
                })).apply((int)(intensityThresh * (double)mergedSpectrum.length)));
                mergedSpectrum = (ClassedPeakScala[])Predef$.MODULE$.refArrayOps((Object[])mergedSpectrum).filter((Function1)new Serializable(thresh){
                    public static final long serialVersionUID = 0L;
                    private final float thresh$1;

                    public final boolean apply(ClassedPeakScala x$4) {
                        return x$4.getIntensity() > this.thresh$1;
                    }
                    {
                        this.thresh$1 = thresh$1;
                    }
                });
                ArrayBuffer deltaMass = new ArrayBuffer();
                for (int i = 0; i < mergedSpectrum.length - 2; ++i) {
                    if (mergedSpectrum[i].order() == mergedSpectrum[i + 1].order()) continue;
                    double mzFirst = 0.0;
                    double mzSecond = 0.0;
                    ClassedPeakScala pFirst = null;
                    ClassedPeakScala pSecond = null;
                    int gap = 1;
                    if (mergedSpectrum[i + 1].order() == 1) {
                        pFirst = mergedSpectrum[i + 1];
                        pSecond = mergedSpectrum[i];
                    } else {
                        pSecond = mergedSpectrum[i + 1];
                        pFirst = mergedSpectrum[i];
                    }
                    if (mergedSpectrum[i + 2].order() == mergedSpectrum[i].order()) {
                        boolean t = package$.MODULE$.abs(mergedSpectrum[i + 2].getMz() - mergedSpectrum[i + 1].getMz()) < package$.MODULE$.abs(mergedSpectrum[i].getMz() - mergedSpectrum[i + 1].getMz());
                        ClassedPeakScala goodPeak = null;
                        if (t) {
                            goodPeak = mergedSpectrum[i + 2];
                            ++gap;
                        } else {
                            goodPeak = mergedSpectrum[i];
                        }
                        if (goodPeak.order() == 1) {
                            pFirst = goodPeak;
                            pSecond = mergedSpectrum[i + 1];
                        } else {
                            pSecond = goodPeak;
                            pFirst = mergedSpectrum[i + 1];
                        }
                    }
                    mzFirst = pFirst.getMz();
                    mzSecond = pSecond.getMz();
                    double deltaMz = mzSecond - mzFirst;
                    double mean = (mzFirst + mzSecond) / 2.0;
                    double maxDeltaMz = mean * maxDeltaPpm / 1000000.0;
                    if (!(package$.MODULE$.abs(deltaMz) < maxDeltaMz)) continue;
                    deltaMass.$plus$eq((Object)BoxesRunTime.boxToDouble((double)this.daToPpm(mean, deltaMz)));
                    i += gap;
                }
                Peak peak445 = new PeakList(firstSpectrum).getNearestPeak(445.12, 445.12 * maxDeltaPpm / 1000000.0);
                Object object = peak445 == null ? BoxedUnit.UNIT : m445.put(BoxesRunTime.boxToLong((long)firstSpectrum.getHeader().getId()), BoxesRunTime.boxToDouble((double)peak445.getMz()));
                result2.put(BoxesRunTime.boxToLong((long)firstSpectrum.getHeader().getId()), BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)deltaMass.sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)deltaMass.length())));
            }
            ObjectRef output = ObjectRef.create(new TreeMap());
            DoubleRef sum = DoubleRef.create((double)0.0);
            JavaConversions$.MODULE$.asScalaSet(result2.entrySet()).foreach((Function1)new Serializable(output, sum){
                public static final long serialVersionUID = 0L;
                private final ObjectRef output$1;
                private final DoubleRef sum$1;

                public final double apply(Map.Entry<Object, Object> entry) {
                    this.sum$1.elem += BoxesRunTime.unboxToDouble((Object)entry.getValue());
                    return BoxesRunTime.unboxToDouble((Object)((TreeMap)this.output$1.elem).put(entry.getKey(), BoxesRunTime.boxToDouble((double)this.sum$1.elem)));
                }
                {
                    this.output$1 = output$1;
                    this.sum$1 = sum$1;
                }
            });
            return new Tuple2((Object)((TreeMap)output.elem), m445);
        }
        throw new Throwable("not enough spectra...");
    }

    private double compute$default$3() {
        return 0.9;
    }

    private int compute$default$4() {
        return 0;
    }

    public void writeCalibrationFile(String mzDbFile, double maxDeltaPpm) {
        MzDbReader mzdb = new MzDbReader(mzDbFile, false);
        Tuple2<TreeMap<Object, Object>, TreeMap<Object, Object>> result2 = this.compute(mzdb, maxDeltaPpm, this.compute$default$3(), this.compute$default$4());
        TreeMap o = (TreeMap)result2._1();
        ObjectRef m445 = ObjectRef.create((Object)((TreeMap)result2._2()));
        PrintWriter writer = new PrintWriter(new File(new StringBuilder().append((Object)mzDbFile).append((Object)"_calib.txt").toString()));
        JavaConversions$.MODULE$.asScalaSet(o.entrySet()).foreach((Function1)new Serializable(m445, writer){
            public static final long serialVersionUID = 0L;
            private final ObjectRef m445$1;
            private final PrintWriter writer$1;

            public final void apply(Map.Entry<Object, Object> entry) {
                this.writer$1.write(new StringBuilder().append(BoxesRunTime.unboxToLong((Object)entry.getKey())).append((Object)"\t").append(entry.getValue()).append((Object)"\t").append(((TreeMap)this.m445$1.elem).get(entry.getKey())).append((Object)"\n").toString());
            }
            {
                this.m445$1 = m445$1;
                this.writer$1 = writer$1;
            }
        });
    }

    public double daToPpm(double mz, double d) {
        return d * 1000000.0 / mz;
    }

    private CalibrationCurveWriter$() {
        MODULE$ = this;
    }
}

