/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.db.model;

import com.almworks.sqlite4java.SQLiteConnection;
import com.almworks.sqlite4java.SQLiteException;
import fr.profi.mzdb.db.model.params.IParamContainer;
import fr.profi.mzdb.db.model.params.ParamTree;
import fr.profi.mzdb.db.model.params.param.CVParam;
import fr.profi.mzdb.db.model.params.param.UserParam;
import fr.profi.mzdb.db.model.params.param.UserText;
import fr.profi.mzdb.io.reader.table.ParamTreeParser;
import fr.profi.mzdb.util.misc.AbstractInMemoryIdGen;
import fr.profi.mzdb.util.sqlite.SQLiteQuery;
import java.util.List;

public abstract class AbstractTableModel
extends AbstractInMemoryIdGen
implements IParamContainer {
    public static String TABLE_NAME;
    protected final long id;
    protected ParamTree paramTree = null;

    protected AbstractTableModel(long id, ParamTree paramTree) {
        this.id = id;
        this.paramTree = paramTree;
    }

    public long getId() {
        return this.id;
    }

    public boolean hasParamTree() {
        return this.paramTree != null;
    }

    public ParamTree getParamTree(SQLiteConnection mzDbConnection) throws SQLiteException {
        if (!this.hasParamTree()) {
            this.loadParamTree(mzDbConnection);
        }
        return this.paramTree;
    }

    public void setParamTree(ParamTree paramTree) {
        this.paramTree = paramTree;
    }

    protected void loadParamTree(SQLiteConnection mzDbConnection) throws SQLiteException {
        this.paramTree = ParamTreeParser.parseParamTree(this.getParamTreeAsString(mzDbConnection));
    }

    public String getParamTreeAsString(SQLiteConnection mzDbConnection) throws SQLiteException {
        String sqlString = "SELECT param_tree FROM " + TABLE_NAME;
        String paramTreeAsStr = new SQLiteQuery(mzDbConnection, sqlString).extractSingleString();
        return paramTreeAsStr;
    }

    @Override
    public List<CVParam> getCVParams() {
        return this.paramTree.getCVParams();
    }

    @Override
    public List<UserParam> getUserParams() {
        return this.paramTree.getUserParams();
    }

    @Override
    public UserParam getUserParam(String name) {
        return this.paramTree.getUserParam(name);
    }

    @Override
    public List<UserText> getUserTexts() {
        return this.paramTree.getUserTexts();
    }
}

