/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.util.sqlite;

import com.almworks.sqlite4java.SQLiteConnection;
import com.almworks.sqlite4java.SQLiteException;
import com.almworks.sqlite4java.SQLiteJob;
import com.almworks.sqlite4java.SQLiteQueue;
import fr.profi.mzdb.util.sqlite.ISQLiteConnectionFunction;
import fr.profi.mzdb.util.sqlite.SQLiteJobWrapper;
import java.util.Iterator;
import rx.Observable;
import rx.Subscriber;

public class SQLiteObservableJob<T>
extends Observable<T> {
    private final ISQLiteConnectionFunction<T> sqliteJobWrapper;

    public ISQLiteConnectionFunction<T> getSQLiteJobWrapper() {
        return this.sqliteJobWrapper;
    }

    public SQLiteObservableJob(SQLiteQueue queue, SQLiteJobWrapper<T> sqliteJobWrapper) {
        super(SQLiteObservableJob.onSubscribe(queue, sqliteJobWrapper));
        this.sqliteJobWrapper = sqliteJobWrapper;
    }

    private static <T> Observable.OnSubscribe<T> onSubscribe(SQLiteQueue queue, SQLiteJobWrapper<T> sqliteJobWrapper) {
        return subscriber -> {
            SQLiteJob<Object> sqliteJob = SQLiteObservableJob.buildSQLiteJob(subscriber, connection -> {
                Object result = null;
                result = sqliteJobWrapper.job(connection);
                subscriber.onNext(result);
                return result;
            });
            sqliteJobWrapper.setSQLiteJob(sqliteJob);
            queue.execute(sqliteJob);
        };
    }

    public static <R> SQLiteJob<R> buildSQLiteJob(final Subscriber<?> subscriber, final ISQLiteConnectionFunction<R> function) {
        return new SQLiteJob<R>(){

            protected R job(SQLiteConnection connection) throws SQLiteException {
                Object result = null;
                try {
                    result = function.apply(connection);
                }
                catch (Exception e) {
                    System.err.println("Error caught in SQLiteObservableJob");
                    e.printStackTrace();
                    subscriber.onError((Throwable)e);
                }
                return result;
            }

            protected void jobFinished(R result) {
                if (!subscriber.isUnsubscribed()) {
                    subscriber.onCompleted();
                }
            }

            protected void jobError(Throwable error) throws Throwable {
                if (!subscriber.isUnsubscribed()) {
                    subscriber.onError(error);
                }
            }
        };
    }

    public static <T> void observeIterator(Subscriber<? super T> subscriber, Iterator<T> iterator) {
        while (iterator.hasNext()) {
            subscriber.onNext(iterator.next());
        }
    }
}

