/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui;

import fr.proline.studio.msfiles.LocalFileSystemFile;
import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class LocalFileSystemModel
implements TreeModel {
    private DefaultMutableTreeNode m_root;
    private final HashSet<TreeModelListener> listeners;
    private static Comparator<File> FILE_COMPARATOR = new Comparator<File>(){

        @Override
        public int compare(File f1, File f2) {
            if (f1.isDirectory()) {
                if (!f2.isDirectory()) {
                    return -1;
                }
            } else if (f2.isDirectory()) {
                return 1;
            }
            return f1.getName().toLowerCase().compareTo(f2.getName().toLowerCase());
        }
    };

    public LocalFileSystemModel(String rootURL) {
        this.m_root = new DefaultMutableTreeNode(new LocalFileSystemFile(rootURL));
        this.listeners = new HashSet();
    }

    public void setRoot(String rootURL) {
        this.m_root = new DefaultMutableTreeNode(new LocalFileSystemFile(rootURL));
    }

    @Override
    public Object getRoot() {
        return this.m_root;
    }

    @Override
    public Object getChild(Object parent, int index) {
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)parent;
        File directory = (File)parentNode.getUserObject();
        String[] directoryMembers = this.getFilesName(directory);
        DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(new LocalFileSystemFile(directory, directoryMembers[index]));
        parentNode.add(childNode);
        return childNode;
    }

    @Override
    public int getChildCount(Object parent) {
        if (parent == null) {
            return 0;
        }
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)parent;
        File fileSystemMember = (File)parentNode.getUserObject();
        if (fileSystemMember.isDirectory()) {
            return this.getFilesCount(fileSystemMember);
        }
        return 0;
    }

    @Override
    public boolean isLeaf(Object node) {
        DefaultMutableTreeNode mutableNode = (DefaultMutableTreeNode)node;
        File fileNode = (File)mutableNode.getUserObject();
        return fileNode.isFile();
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)parent;
        DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)child;
        File directory = (File)parentNode.getUserObject();
        File directoryMember = (File)childNode.getUserObject();
        String[] directoryMemberNames = this.getFilesName(directory);
        int result = -1;
        for (int i = 0; i < directoryMemberNames.length; ++i) {
            if (!directoryMember.getName().equals(directoryMemberNames[i])) continue;
            result = i;
            break;
        }
        return result;
    }

    @Override
    public void addTreeModelListener(TreeModelListener listener) {
        if (listener != null && !this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        if (l != null) {
            this.listeners.remove(l);
        }
    }

    public void fireTreeNodesInserted(TreeModelEvent e) {
        for (TreeModelListener listener : this.listeners) {
            listener.treeNodesInserted(e);
        }
    }

    public void fireTreeNodesRemoved(TreeModelEvent e) {
        for (TreeModelListener listener : this.listeners) {
            listener.treeNodesRemoved(e);
        }
    }

    public void fireTreeNodesChanged(TreeModelEvent e) {
        for (TreeModelListener listener : this.listeners) {
            listener.treeNodesChanged(e);
        }
    }

    public void fireTreeStructureChanged(TreeModelEvent e) {
        for (TreeModelListener listener : this.listeners) {
            listener.treeStructureChanged(e);
        }
    }

    private int getFilesCount(File directory) {
        String[] list = directory.list();
        return list != null ? list.length : 0;
    }

    private File[] getFiles(File directory) {
        File[] files = directory.listFiles();
        Arrays.sort(files, FILE_COMPARATOR);
        return files;
    }

    private String[] getFilesName(File directory) {
        File[] files = this.getFiles(directory);
        int nbFiles = files.length;
        String[] fileNames = new String[nbFiles];
        for (int i = 0; i < nbFiles; ++i) {
            fileNames[i] = files[i].getName();
        }
        return fileNames;
    }
}

