/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui;

import fr.proline.studio.export.ExportButton;
import fr.proline.studio.gui.HourglassPanel;
import fr.proline.studio.rsmexplorer.gui.MSDiagOutput_AW;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StackedXYAreaRenderer2;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.xy.CategoryTableXYDataset;
import org.jfree.data.xy.TableXYDataset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MSDiag_StackedXYAreaChart
extends HourglassPanel {
    public static final String SERIES_NAME = "Chromatogram";
    protected static final Logger m_logger = LoggerFactory.getLogger((String)"ProlineStudio.ResultExplorer");
    private static final long serialVersionUID = 1L;
    private final CategoryTableXYDataset m_dataSet = new CategoryTableXYDataset();
    private final JFreeChart m_chart;
    private ChartPanel m_chromatogragmPanel;

    public MSDiag_StackedXYAreaChart() {
        NumberAxis rangeAxis = new NumberAxis("");
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        this.m_chart = ChartFactory.createStackedXYAreaChart((String)"", (String)"", (String)"", (TableXYDataset)this.m_dataSet, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        this.m_chart.setBackgroundPaint((Paint)Color.white);
        XYPlot plot = (XYPlot)this.m_chart.getPlot();
        StackedXYAreaRenderer2 renderer = (StackedXYAreaRenderer2)plot.getRenderer();
        renderer.setSeriesPaint(0, (Paint)new Color(254, 60, 60));
        renderer.setSeriesPaint(1, (Paint)new Color(176, 190, 255));
        renderer.setSeriesPaint(2, (Paint)new Color(132, 153, 255));
        renderer.setSeriesPaint(3, (Paint)new Color(91, 120, 255));
        renderer.setSeriesPaint(4, (Paint)new Color(64, 98, 255));
        renderer.setSeriesPaint(5, (Paint)new Color(32, 71, 255));
        renderer.setSeriesPaint(6, (Paint)new Color(1, 191, 220));
        renderer.setSeriesPaint(7, (Paint)new Color(126, 84, 214));
        TextTitle textTitle = this.m_chart.getTitle();
        textTitle.setFont(textTitle.getFont().deriveFont(0, 10.0f));
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.m_chromatogragmPanel = new ChartPanel(this.m_chart, true);
        this.m_chromatogragmPanel.setMinimumDrawWidth(0);
        this.m_chromatogragmPanel.setMinimumDrawHeight(0);
        this.m_chromatogragmPanel.setMaximumDrawWidth(Integer.MAX_VALUE);
        this.m_chromatogragmPanel.setMaximumDrawHeight(Integer.MAX_VALUE);
        this.m_chart.getPlot().setBackgroundPaint((Paint)Color.white);
        JToolBar toolbar = this.initToolbar();
        this.add(toolbar, "West");
        this.add((Component)this.m_chromatogragmPanel, "Center");
    }

    private JToolBar initToolbar() {
        JToolBar toolbar = new JToolBar(1);
        toolbar.setFloatable(false);
        ExportButton exportImageButton = new ExportButton("chart", (JPanel)this.m_chromatogragmPanel);
        toolbar.add((Component)exportImageButton);
        return toolbar;
    }

    public void setData(MSDiagOutput_AW msdo) {
        this.constructChromatogram(msdo);
    }

    private void constructChromatogram(MSDiagOutput_AW msdo) {
        this.m_dataSet.clear();
        if (msdo == null) {
            return;
        }
        String title = msdo.description;
        this.m_chart.setTitle(title);
        this.m_chart.getPlot().setBackgroundPaint((Paint)Color.white);
        int nbSeries = msdo.matrix[0].length;
        int nbCategories = msdo.matrix.length - 1;
        for (int serie = 1; serie < nbSeries; ++serie) {
            for (int cat = 0; cat < nbCategories; ++cat) {
                double x = Double.parseDouble(Integer.toString(serie));
                double y = (Double)msdo.matrix[cat][serie];
                String seriesName = msdo.column_names[serie];
                if (!(y > 0.0)) continue;
                this.m_dataSet.add(x, y, seriesName);
            }
        }
    }
}

