/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.admin;

import fr.proline.studio.gui.DefaultDialog;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class UserAccountDialog
extends DefaultDialog {
    private static UserAccountDialog m_singletonDialog = null;
    private static final String PASSWORD_HIDDEN = "******";
    private DialogMode m_mode;
    private JTextField m_loginTextField;
    private JTextField m_passwordTextField;
    private JRadioButton m_userRadioButton;
    private JRadioButton m_adminRadioButton;
    private boolean m_initialAdminUserGroup;

    public static UserAccountDialog getDialog(Window parent, DialogMode mode) {
        if (m_singletonDialog == null) {
            m_singletonDialog = new UserAccountDialog(parent);
        }
        m_singletonDialog.initMode(mode);
        return m_singletonDialog;
    }

    public UserAccountDialog(Window parent) {
        super(parent, Dialog.ModalityType.DOCUMENT_MODAL);
        this.initInternalPanel();
    }

    private void initMode(DialogMode mode) {
        this.m_mode = mode;
        switch (mode) {
            case CREATE_USER: {
                this.setTitle("Create User Account");
                this.m_loginTextField.setEnabled(true);
                this.m_initialAdminUserGroup = false;
                break;
            }
            case MODIFY_USER: {
                this.setTitle("Modify User Account");
                this.m_loginTextField.setEnabled(false);
                this.m_passwordTextField.setText(PASSWORD_HIDDEN);
            }
        }
        this.m_loginTextField.setText("");
        this.m_userRadioButton.setSelected(true);
    }

    private void initInternalPanel() {
        JPanel internalPanel = new JPanel();
        internalPanel.setLayout(new GridBagLayout());
        JLabel loginLabel = new JLabel("Login :");
        JLabel groupLabel = new JLabel("Group :");
        JLabel passwordLabel = new JLabel("Pasword :");
        this.m_loginTextField = new JTextField(30);
        ButtonGroup group = new ButtonGroup();
        this.m_userRadioButton = new JRadioButton("User");
        this.m_adminRadioButton = new JRadioButton("Admin");
        group.add(this.m_userRadioButton);
        group.add(this.m_adminRadioButton);
        this.m_passwordTextField = new JTextField(30);
        this.m_passwordTextField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (UserAccountDialog.this.m_passwordTextField.getText().compareTo(UserAccountDialog.PASSWORD_HIDDEN) == 0) {
                    UserAccountDialog.this.m_passwordTextField.setText("");
                }
            }
        });
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        internalPanel.add((Component)loginLabel, c);
        ++c.gridx;
        c.gridwidth = 2;
        internalPanel.add((Component)this.m_loginTextField, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        internalPanel.add((Component)groupLabel, c);
        ++c.gridx;
        internalPanel.add((Component)this.m_userRadioButton, c);
        ++c.gridx;
        internalPanel.add((Component)this.m_adminRadioButton, c);
        c.gridx = 0;
        ++c.gridy;
        internalPanel.add((Component)passwordLabel, c);
        ++c.gridx;
        c.gridwidth = 2;
        internalPanel.add((Component)this.m_passwordTextField, c);
        this.setInternalComponent(internalPanel);
    }

    public void setUserAccountInfo(String logging, boolean isAdmin) {
        this.m_loginTextField.setText(logging);
        if (isAdmin) {
            this.m_adminRadioButton.setSelected(true);
            this.m_initialAdminUserGroup = true;
        } else {
            this.m_userRadioButton.setSelected(true);
            this.m_initialAdminUserGroup = false;
        }
    }

    public String getLogin() {
        return this.m_loginTextField.getText().trim();
    }

    public boolean isAdmin() {
        return this.m_adminRadioButton.isSelected();
    }

    public boolean userGroupChanged() {
        return this.m_adminRadioButton.isSelected() ^ this.m_initialAdminUserGroup;
    }

    public boolean passwordChanged() {
        String password = this.m_passwordTextField.getText().trim();
        return !password.isEmpty() && this.m_passwordTextField.getText().compareTo(PASSWORD_HIDDEN) != 0;
    }

    public String getPassword() {
        return this.m_passwordTextField.getText();
    }

    private boolean checkParameters() {
        String login = this.getLogin();
        if (login.isEmpty() || login.length() < 3) {
            this.setStatus(true, "Login must contain at least 3 characters.");
            this.highlight(this.m_loginTextField);
            return false;
        }
        if (this.m_mode == DialogMode.CREATE_USER && this.getPassword().length() < 4) {
            this.setStatus(true, "Password must contain at least 4 characters");
            this.highlight(this.m_passwordTextField);
            return false;
        }
        return true;
    }

    protected boolean okCalled() {
        return this.checkParameters();
    }

    public static enum DialogMode {
        CREATE_USER,
        MODIFY_USER;

    }
}

