/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.calc.functions;

import fr.proline.studio.parameter.AbstractLinkedParameters;
import fr.proline.studio.parameter.AbstractParameter;
import fr.proline.studio.parameter.BooleanParameter;
import fr.proline.studio.parameter.DoubleParameter;
import fr.proline.studio.parameter.ObjectParameter;
import fr.proline.studio.parameter.ParameterList;
import fr.proline.studio.python.data.Table;
import fr.proline.studio.python.interpreter.ResultVariable;
import fr.proline.studio.rsmexplorer.gui.calc.GraphPanel;
import fr.proline.studio.rsmexplorer.gui.calc.functions.AbstractFunction;
import fr.proline.studio.rsmexplorer.gui.calc.functions.AbstractOnExperienceDesignFunction;
import javax.swing.JCheckBox;
import javax.swing.JTextField;
import org.python.core.PyObject;

public class MissingValuesImputationFunction
extends AbstractOnExperienceDesignFunction {
    private static final String MV_IMPUTATION_METHOD_KEY = "MV_IMPUTATION_METHOD";
    private static final String MV_IMPUTATION_METHOD_NAME = "Method";
    private static final String MV_IMPUTATION_METHOD_BPCA = "BPCA";
    private static final String MV_IMPUTATION_METHOD_KNN = "KNN";
    private static final String MV_IMPUTATION_METHOD_MLE = "MLE";
    private static final String MV_IMPUTATION_METHOD_QRILC = "QRILC";
    private static final String MV_PERCENTILE = "Percentile";
    private static final String PERCENTILE_VALUE_KEY = "PERCENTILE_PERCENTAGE";
    private static final String PERCENTILE_VALUE_NAME = "Percentage";
    private static final String SHOW_IMPUTATION_ROWS_KEY = "SHOW_IMPUTATION_ROWS";
    private static final String SHOW_IMPUTATION_ROWS_NAME = "Add Column with imputation squares";
    private static final String MISSING_VALUES_IMPUTATION_FUNCTION_PARAMETER_LIST_NAME = "mv imputation options";
    private ParameterList m_parameterList = null;
    private ObjectParameter m_methodParameter = null;
    private DoubleParameter m_percentileThresholdParameter = null;
    private BooleanParameter m_addSourceCol = null;
    private ResultVariable m_tableResultVariable = null;

    public MissingValuesImputationFunction(GraphPanel panel) {
        super(panel, AbstractFunction.FUNCTION_TYPE.MissingValuesImputationFunction, "Missing Values Imputation", "mvimputation", "mvimputation", null, null);
    }

    @Override
    public int getMinGroups() {
        return 2;
    }

    @Override
    public int getMaxGroups() {
        return 8;
    }

    @Override
    public AbstractFunction cloneFunction(GraphPanel p) {
        MissingValuesImputationFunction clone = new MissingValuesImputationFunction(p);
        clone.cloneInfo(this);
        return clone;
    }

    @Override
    public ParameterList getExtraParameterList() {
        this.m_parameterList = new ParameterList(MISSING_VALUES_IMPUTATION_FUNCTION_PARAMETER_LIST_NAME);
        Object[] mvImputationMethods = new String[]{MV_IMPUTATION_METHOD_BPCA, MV_IMPUTATION_METHOD_KNN, MV_IMPUTATION_METHOD_MLE, MV_IMPUTATION_METHOD_QRILC, MV_PERCENTILE};
        this.m_methodParameter = new ObjectParameter(MV_IMPUTATION_METHOD_KEY, MV_IMPUTATION_METHOD_NAME, null, mvImputationMethods, null, 0, null);
        this.m_percentileThresholdParameter = new DoubleParameter(PERCENTILE_VALUE_KEY, PERCENTILE_VALUE_NAME, JTextField.class, Double.valueOf(2.5), Double.valueOf(0.1), Double.valueOf(50.0));
        this.m_addSourceCol = new BooleanParameter(SHOW_IMPUTATION_ROWS_KEY, SHOW_IMPUTATION_ROWS_NAME, JCheckBox.class, Boolean.valueOf(true));
        AbstractLinkedParameters linkedParameters = new AbstractLinkedParameters(this.m_parameterList){

            public void valueChanged(String value, Object associatedValue) {
                boolean isPercentile = value.equalsIgnoreCase(MissingValuesImputationFunction.MV_PERCENTILE);
                this.showParameter((AbstractParameter)MissingValuesImputationFunction.this.m_percentileThresholdParameter, isPercentile);
                this.showParameter((AbstractParameter)MissingValuesImputationFunction.this.m_addSourceCol, isPercentile);
            }
        };
        this.m_parameterList.add((Object)this.m_methodParameter);
        this.m_parameterList.add((Object)this.m_percentileThresholdParameter);
        this.m_parameterList.add((Object)this.m_addSourceCol);
        this.m_parameterList.getPanel();
        this.m_methodParameter.addLinkedParameters(linkedParameters);
        return this.m_parameterList;
    }

    @Override
    public String getExtraValuesForFunctionCall() {
        String methodParameter = this.m_methodParameter.getStringValue();
        boolean isPercentile = methodParameter.equalsIgnoreCase(MV_PERCENTILE);
        if (isPercentile) {
            boolean displayColInfo = (Boolean)this.m_addSourceCol.getObjectValue();
            return ",\"" + methodParameter + "\"," + this.m_percentileThresholdParameter.getStringValue() + "," + (displayColInfo ? "1" : "0");
        }
        return ",\"" + methodParameter + "\"";
    }

    @Override
    public ResultVariable[] getExtraVariables(Table sourceTable) {
        this.m_tableResultVariable = new ResultVariable((PyObject)sourceTable);
        ResultVariable[] resultVariables = new ResultVariable[]{this.m_tableResultVariable};
        return resultVariables;
    }
}

