/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.dialog.xic;

import fr.proline.studio.rsmexplorer.gui.dialog.xic.AssociationWrapper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class XICDropZoneInfo
extends JPanel {
    private final JList m_droppedFilesList;
    private final DefaultListModel m_model;
    private final JLabel m_statusLabel;
    private int m_associatedCounter;

    public XICDropZoneInfo() {
        this.setLayout(new BorderLayout());
        this.m_model = new DefaultListModel();
        this.m_droppedFilesList = new JList(this.m_model);
        this.m_droppedFilesList.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value instanceof AssociationWrapper) {
                    AssociationWrapper wrapper = (AssociationWrapper)value;
                    this.setText(wrapper.getPath());
                    if (wrapper.getAssociationType() == AssociationWrapper.AssociationType.ASSOCIATED) {
                        this.setForeground(Color.GREEN);
                    } else {
                        this.setForeground(Color.RED);
                    }
                    if (isSelected) {
                        this.setBackground(this.getBackground().darker());
                    }
                }
                return c;
            }
        });
        JScrollPane listPane = new JScrollPane(this.m_droppedFilesList);
        this.add((Component)listPane, "Center");
        this.m_statusLabel = new JLabel();
        this.m_statusLabel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 10));
        this.add((Component)this.m_statusLabel, "South");
    }

    public void updateInfo(HashMap<String, AssociationWrapper> associations) {
        this.clearInfo();
        for (AssociationWrapper assocWrapper : associations.values()) {
            this.m_model.addElement(assocWrapper);
            if (assocWrapper.getAssociationType() != AssociationWrapper.AssociationType.ASSOCIATED) continue;
            ++this.m_associatedCounter;
        }
        this.m_statusLabel.setText(String.valueOf(this.m_model.size()) + " files dropped. " + this.m_associatedCounter + " files were associated.");
    }

    public void clearInfo() {
        this.m_model.removeAllElements();
        this.m_associatedCounter = 0;
        this.m_statusLabel.setText("0 files dropped.");
    }
}

