/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.tasklog;

import fr.proline.logparser.gui.TaskExecutionPanel;
import fr.proline.logparser.model.LogTask;
import fr.proline.logparser.model.Utility;
import fr.proline.studio.filter.ConvertValueInterface;
import fr.proline.studio.filter.DateFilter;
import fr.proline.studio.filter.DurationFilter;
import fr.proline.studio.filter.IntegerFilter;
import fr.proline.studio.filter.StringDiffFilter;
import fr.proline.studio.filter.ValueFilter;
import fr.proline.studio.table.AbstractDecoratedGlobalTableModel;
import java.awt.Color;
import java.awt.Component;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class ServerLogTaskTableModel
extends AbstractDecoratedGlobalTableModel<LogTask> {
    static final int COLTYPE_ORDER_ID = 0;
    static final int COLTYPE_MESSAGE_ID = 1;
    static final int COLTYPE_THREAD_NAME = 2;
    static final int COLTYPE_CALL_SERVICE = 3;
    static final int COLTYPE_META_INFO = 4;
    static final int COLTYPE_STATUS = 5;
    static final int COLTYPE_PROJECT_ID = 6;
    static final int COLTYPE_START_TIME = 7;
    static final int COLTYPE_STOP_TIME = 8;
    static final int COLTYPE_DURATION = 9;
    static final int COLTYPE_NB_TASK_PARALELLE = 10;
    private static final String[] m_columnNames = new String[]{"Task N\u00b0", "Message Id", "Thread Name", "Call Service", "Meta Info", "Status", "Project Id", "Start Time", "Stop Time", "Duration", "Parallel tasks Nb"};
    private static final String[] m_columnTooltips = m_columnNames;
    private final HashMap<Integer, TableCellRenderer> m_rendererMap = new HashMap();

    public int getRowCount() {
        return this.m_entities.size();
    }

    public int getColumnCount() {
        return m_columnNames.length;
    }

    public LogTask getTask(int row) {
        return (LogTask)this.m_entities.get(row);
    }

    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: 
            case 10: {
                return Integer.class;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                return String.class;
            }
            case 5: {
                return LogTask.STATUS.class;
            }
            case 7: 
            case 8: {
                return Date.class;
            }
            case 9: {
                return Long.class;
            }
        }
        return null;
    }

    public String getColumnName(int column) {
        return m_columnNames[column];
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex >= this.m_entities.size()) {
            return null;
        }
        LogTask taskInfo = (LogTask)this.m_entities.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return rowIndex;
            }
            case 6: {
                return taskInfo.getProjectId();
            }
            case 5: {
                return taskInfo.getStatus();
            }
            case 2: {
                return taskInfo.getThreadName();
            }
            case 1: {
                return taskInfo.getMessageId();
            }
            case 3: {
                return taskInfo.getCallService();
            }
            case 4: {
                return taskInfo.getDataSet();
            }
            case 7: {
                return taskInfo.getStartTime();
            }
            case 8: {
                return taskInfo.getStopTime();
            }
            case 9: {
                return taskInfo.getDuration();
            }
            case 10: {
                return taskInfo.getNbParallelTask();
            }
        }
        return null;
    }

    public TableCellRenderer getRenderer(int row, int col) {
        if (this.m_rendererMap.containsKey(col)) {
            return this.m_rendererMap.get(col);
        }
        DefaultTableCellRenderer renderer = null;
        switch (col) {
            case 10: {
                renderer = new TaskNbCellRenderer();
                break;
            }
            case 5: {
                renderer = new DefaultTableCellRenderer(){

                    @Override
                    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                        String toShow = ((LogTask.STATUS)value).getLabelTxt();
                        JLabel lb = (JLabel)super.getTableCellRendererComponent(table, toShow, isSelected, hasFocus, row, column);
                        return lb;
                    }
                };
                break;
            }
            case 7: {
                renderer = new DefaultTableCellRenderer(){

                    @Override
                    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                        String toShow = Utility.formatTime((Date)((Date)value));
                        JLabel lb = (JLabel)super.getTableCellRendererComponent(table, toShow, isSelected, hasFocus, row, column);
                        return lb;
                    }
                };
                break;
            }
            case 8: {
                renderer = new DefaultTableCellRenderer(){

                    @Override
                    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                        String toShow = Utility.formatTime((Date)((Date)value));
                        JLabel lb = (JLabel)super.getTableCellRendererComponent(table, toShow, isSelected, hasFocus, row, column);
                        return lb;
                    }
                };
                break;
            }
            case 9: {
                renderer = new DefaultTableCellRenderer(){

                    @Override
                    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                        String toShow = Utility.formatDurationInHour((long)((Long)value));
                        JLabel lb = (JLabel)super.getTableCellRendererComponent(table, toShow, isSelected, hasFocus, row, column);
                        return lb;
                    }
                };
                break;
            }
            default: {
                renderer = new DefaultTableCellRenderer();
            }
        }
        this.m_rendererMap.put(col, renderer);
        return renderer;
    }

    public Object getRowValue(Class c, int row) {
        if (c.equals(LogTask.class)) {
            return this.m_entities.get(row);
        }
        return null;
    }

    public int[] getKeysColumn() {
        return null;
    }

    public void addFilters(LinkedHashMap filtersMap) {
        filtersMap.put(0, new IntegerFilter(this.getColumnName(0), null, 0));
        filtersMap.put(1, new StringDiffFilter(this.getColumnName(1), null, 1));
        filtersMap.put(2, new StringDiffFilter(this.getColumnName(2), null, 2));
        filtersMap.put(3, new StringDiffFilter(this.getColumnName(3), null, 3));
        filtersMap.put(4, new StringDiffFilter(this.getColumnName(4), null, 4));
        ConvertValueInterface statusConverter = new ConvertValueInterface(){

            public Object convertValue(Object o) {
                if (o == null) {
                    return null;
                }
                return ((LogTask.STATUS)o).getIndex();
            }
        };
        ValueFilter statusFilter = new ValueFilter(this.getColumnName(5), (Object[])LogTask.STATUS.values(), null, ValueFilter.ValueFilterType.EQUAL, statusConverter, 5);
        filtersMap.put(5, statusFilter);
        filtersMap.put(6, new StringDiffFilter(this.getColumnName(6), null, 6));
        filtersMap.put(7, new DateFilter(this.getColumnName(7), null, 7));
        filtersMap.put(8, new DateFilter(this.getColumnName(8), null, 8));
        filtersMap.put(9, new DurationFilter(this.getColumnName(9), null, 9));
        filtersMap.put(10, new IntegerFilter(this.getColumnName(10), null, 10));
    }

    public String getToolTipForHeader(int col) {
        return m_columnNames[col];
    }

    public class TaskNbCellRenderer
    extends DefaultTableCellRenderer {
        private TaskExecutionPanel m_valuePanel;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (this.m_valuePanel == null) {
                this.m_valuePanel = new TaskExecutionPanel(1, -1);
            }
            LogTask task = ServerLogTaskTableModel.this.getTask(row);
            String toShow = (Integer)value == 0 ? "" : "+" + value;
            this.m_valuePanel.setData(task.getTimeStamp(), task.getNbOtherTaskMoment(), toShow);
            if (isSelected) {
                this.m_valuePanel.setBackground(UIManager.getDefaults().getColor("Table.selectionBackground"));
                this.m_valuePanel.setForeground(Color.WHITE);
            } else {
                this.m_valuePanel.setBackground(UIManager.getDefaults().getColor("Table.background"));
                this.m_valuePanel.setForeground(Color.BLACK);
            }
            return this.m_valuePanel;
        }
    }
}

