/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.xic;

import fr.proline.core.orm.lcms.ProcessedMap;
import fr.proline.studio.export.ExportButton;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.graphics.BasePlotPanel;
import fr.proline.studio.graphics.PlotPanel;
import fr.proline.studio.gui.HourglassPanel;
import fr.proline.studio.gui.SplittedPanelContainer;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.DataBoxPanelInterface;
import fr.proline.studio.pattern.xic.DataboxMapAlignment;
import fr.proline.studio.rsmexplorer.gui.xic.QuantChannelInfo;
import fr.proline.studio.rsmexplorer.gui.xic.alignment.IonsRTScatterPlot;
import fr.proline.studio.rsmexplorer.gui.xic.alignment.IonsRTTableModel;
import fr.proline.studio.utils.IconManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.border.TitledBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMapAlignmentPanel
extends HourglassPanel
implements DataBoxPanelInterface {
    protected static final Logger logger = LoggerFactory.getLogger((String)"ProlineStudio.ResultExplorer");
    protected static final String CLOUD_VIEW_BEST_FIT_TEXT = "Zoom to fit RT tolerance range";
    protected static final String CLOUD_VIEW_All_TEXT = "Zoom to fit all ions";
    protected static final String CLOUD_VIEW_NOT_ENABLED_TEXT = "Zoom disabled";
    protected static final int CLOUD_VIEW_ALL = 1;
    protected static final int CLOUD_VIEW_BEST_FIT = 0;
    protected static final String CLOUD_LOAD_TEXT = "Load matched peptide ions";
    protected static final String CLOUD_REMOVE_TEXT = "Remove peptide ions plot";
    protected static final String CLOUD_IS_LOADING = "Loading ions ...";
    protected static final NumberFormat format2 = new DecimalFormat("#0.0000");
    final double THRESHOLD = 1.0E-4;
    protected AbstractDataBox m_dataBox;
    protected QuantChannelInfo m_quantChannelInfo;
    protected Map<Integer, ProcessedMap> m_pMapByIndex;
    String m_typeAlignement;
    protected JLabel m_labelTitle;
    protected JTextField m_srcTimeValueTF;
    protected JTextField m_destValueTF;
    protected JComboBox m_sourceMapsCB;
    private JToggleButton m_loadIonsBtn;
    protected boolean m_isIonsCloudLoaded;
    protected JToggleButton m_zoomModeBtn;
    int m_zoomMode;
    protected JButton m_showHideCrossAssigned;
    protected BasePlotPanel m_alignmentGraphicPanel;
    protected IonsRTScatterPlot m_ionsScatterPlot;
    protected JSplitPane m_splitPane;
    protected BasePlotPanel m_alignmentGraphicPanel_2;
    protected IonsRTScatterPlot m_ionsScatterPlot2;
    protected PlotPanel m_plotPanel2;
    protected boolean m_isInitialized = false;

    public AbstractMapAlignmentPanel(AbstractDataBox dataBox, String typeAlignement) {
        this.m_dataBox = dataBox;
        this.m_typeAlignement = typeAlignement;
        this.m_isIonsCloudLoaded = false;
        JPanel mainPanel = this.initComponents();
        this.setLayout(new BorderLayout());
        this.add(mainPanel, "Center");
    }

    protected abstract String getTitleLabel();

    protected abstract JPanel createConvertPanel();

    protected abstract List<JButton> getMoreCloudButtons();

    public abstract void setData(QuantChannelInfo var1, List<ExtendedTableModelInterface> var2);

    protected abstract Double getCorrespondingData(Double var1, Long var2);

    protected abstract void setDataGraphic();

    protected JPanel initComponents() {
        JPanel mainPanel = new JPanel();
        JPanel headerPanel = this.initToolbarPanel();
        PlotPanel plotPanel1 = new PlotPanel();
        this.m_alignmentGraphicPanel = plotPanel1.getBasePlotPanel();
        mainPanel.setLayout(new BorderLayout());
        TitledBorder titleB = new TitledBorder(null, "LC-MS Map " + this.m_typeAlignement + "Alignments", 2, 0);
        mainPanel.setBorder(titleB);
        mainPanel.add((Component)headerPanel, "First");
        this.m_plotPanel2 = new PlotPanel();
        this.m_alignmentGraphicPanel_2 = this.m_plotPanel2.getBasePlotPanel();
        this.m_plotPanel2.setVisible(false);
        this.m_splitPane = new JSplitPane(1, (Component)plotPanel1, (Component)this.m_plotPanel2);
        this.m_splitPane.setResizeWeight(0.5);
        this.m_splitPane.setBorder(BorderFactory.createRaisedBevelBorder());
        mainPanel.add((Component)this.m_splitPane, "Center");
        return mainPanel;
    }

    private JPanel initToolbarPanel() {
        ExportButton exportImageButton = new ExportButton("Graphic", (JPanel)((Object)this));
        exportImageButton.setMargin(new Insets(2, 2, 2, 2));
        this.initLoadIonsButton();
        this.initZoomButton();
        this.m_labelTitle = new JLabel(this.getTitleLabel());
        this.m_srcTimeValueTF = new JTextField(10);
        this.m_srcTimeValueTF.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                AbstractMapAlignmentPanel.this.convertTime();
            }
        });
        this.m_srcTimeValueTF.addActionListener(e -> this.convertTime());
        this.m_srcTimeValueTF.setName("tfSourceTime");
        this.m_srcTimeValueTF.setToolTipText("Enter retention time (in minutes) ");
        this.m_sourceMapsCB = new JComboBox();
        this.m_sourceMapsCB.addActionListener(e -> {
            this.convertTime();
            this.setDataGraphic();
        });
        JPanel cloudOptionPane = new JPanel();
        cloudOptionPane.setLayout(new BoxLayout(cloudOptionPane, 2));
        this.m_showHideCrossAssigned = new JButton();
        this.m_showHideCrossAssigned.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.SHOW_CROSS_ASSIGNED));
        this.m_showHideCrossAssigned.setActionCommand("SHOW");
        this.m_showHideCrossAssigned.setMargin(new Insets(2, 2, 2, 2));
        this.m_showHideCrossAssigned.setToolTipText("Show/Hide cross assigned ions");
        this.m_showHideCrossAssigned.addActionListener(e -> {
            if (this.m_ionsScatterPlot != null || this.m_ionsScatterPlot2 != null) {
                if (e.getActionCommand().equals("HIDE")) {
                    if (this.m_ionsScatterPlot != null) {
                        this.m_ionsScatterPlot.showCrossAssignedIons(false);
                    }
                    if (this.m_ionsScatterPlot2 != null) {
                        this.m_ionsScatterPlot2.showCrossAssignedIons(false);
                    }
                    this.m_showHideCrossAssigned.setActionCommand("SHOW");
                    this.m_showHideCrossAssigned.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.SHOW_CROSS_ASSIGNED));
                } else {
                    if (this.m_ionsScatterPlot2 != null) {
                        this.m_ionsScatterPlot2.showCrossAssignedIons(true);
                    }
                    if (this.m_ionsScatterPlot != null) {
                        this.m_ionsScatterPlot.showCrossAssignedIons(true);
                    }
                    this.m_showHideCrossAssigned.setActionCommand("HIDE");
                    this.m_showHideCrossAssigned.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.HIDE_CROSS_ASSIGNED));
                }
                this.m_alignmentGraphicPanel.repaintUpdateDoubleBuffer();
                this.m_plotPanel2.repaint();
                if (this.m_alignmentGraphicPanel_2.isVisible()) {
                    this.m_alignmentGraphicPanel_2.repaintUpdateDoubleBuffer();
                }
            }
        });
        JSeparator separator = new JSeparator(1);
        cloudOptionPane.add((Component)exportImageButton);
        cloudOptionPane.add(this.m_loadIonsBtn);
        cloudOptionPane.add(this.m_zoomModeBtn);
        cloudOptionPane.add(this.m_showHideCrossAssigned);
        for (JButton bt : this.getMoreCloudButtons()) {
            cloudOptionPane.add(bt);
        }
        cloudOptionPane.add(Box.createRigidArea(new Dimension(10, 0)));
        this.setEnabledCloudButtons(false);
        cloudOptionPane.add(separator);
        JPanel beginPane = new JPanel(new FlowLayout());
        beginPane.add(cloudOptionPane);
        beginPane.add(this.createConvertPanel());
        JPanel pane = new JPanel();
        pane.setLayout(new BorderLayout());
        pane.add((Component)beginPane, "Before");
        pane.add((Component)this.m_labelTitle, "After");
        pane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
        return pane;
    }

    protected void setEnabledCloudButtons(boolean enable) {
        this.m_showHideCrossAssigned.setEnabled(enable);
        this.m_zoomModeBtn.setEnabled(enable);
    }

    private void initLoadIonsButton() {
        this.m_loadIonsBtn = new JToggleButton();
        this.m_loadIonsBtn.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.LOAD_ALIGNMENT_CLOUD));
        this.m_loadIonsBtn.setMargin(new Insets(2, 2, 2, 2));
        this.m_loadIonsBtn.setToolTipText(CLOUD_LOAD_TEXT);
        this.m_loadIonsBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!AbstractMapAlignmentPanel.this.m_isIonsCloudLoaded) {
                    AbstractMapAlignmentPanel.this.m_isIonsCloudLoaded = true;
                    AbstractMapAlignmentPanel.this.m_loadIonsBtn.setIcon(IconManager.getIconWithHourGlass((IconManager.IconType)IconManager.IconType.LOAD_ALIGNMENT_CLOUD));
                    AbstractMapAlignmentPanel.this.m_loadIonsBtn.setToolTipText(AbstractMapAlignmentPanel.CLOUD_IS_LOADING);
                    ((DataboxMapAlignment)AbstractMapAlignmentPanel.this.m_dataBox).loadCloud();
                } else if (AbstractMapAlignmentPanel.this.m_dataBox.isLoaded()) {
                    AbstractMapAlignmentPanel.this.m_isIonsCloudLoaded = false;
                    AbstractMapAlignmentPanel.this.m_loadIonsBtn.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.LOAD_ALIGNMENT_CLOUD));
                    AbstractMapAlignmentPanel.this.m_loadIonsBtn.setToolTipText(AbstractMapAlignmentPanel.CLOUD_LOAD_TEXT);
                    AbstractMapAlignmentPanel.this.setEnabledCloudButtons(false);
                    AbstractMapAlignmentPanel.this.setDataGraphic();
                }
            }
        });
    }

    protected void initZoomButton() {
        this.m_zoomModeBtn = new JToggleButton();
        this.m_zoomModeBtn.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.ZOOM_ALL));
        this.m_zoomModeBtn.setMargin(new Insets(2, 2, 2, 2));
        this.m_zoomModeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AbstractMapAlignmentPanel.this.m_zoomMode == 0) {
                    AbstractMapAlignmentPanel.this.m_zoomMode = 1;
                    AbstractMapAlignmentPanel.this.m_zoomModeBtn.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.ZOOM_FIT));
                    AbstractMapAlignmentPanel.this.m_zoomModeBtn.setToolTipText(AbstractMapAlignmentPanel.CLOUD_VIEW_BEST_FIT_TEXT);
                    AbstractMapAlignmentPanel.this.setDataGraphic();
                } else {
                    AbstractMapAlignmentPanel.this.m_zoomMode = 0;
                    AbstractMapAlignmentPanel.this.m_zoomModeBtn.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.ZOOM_ALL));
                    AbstractMapAlignmentPanel.this.m_zoomModeBtn.setToolTipText(AbstractMapAlignmentPanel.CLOUD_VIEW_All_TEXT);
                    AbstractMapAlignmentPanel.this.setDataGraphic();
                }
            }
        });
        this.m_zoomModeBtn.setToolTipText(CLOUD_VIEW_NOT_ENABLED_TEXT);
    }

    public void setAlignmentCloud() {
        this.m_loadIonsBtn.setToolTipText(CLOUD_REMOVE_TEXT);
        this.m_loadIonsBtn.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.REMOVE_ALIGNMENT_CLOUD));
        this.m_zoomModeBtn.setToolTipText(CLOUD_VIEW_All_TEXT);
        this.setEnabledCloudButtons(true);
        this.setDataGraphic();
    }

    @Override
    public void setDataBox(AbstractDataBox dataBox) {
        this.m_dataBox = dataBox;
    }

    @Override
    public AbstractDataBox getDataBox() {
        return this.m_dataBox;
    }

    @Override
    public void addSingleValue(Object v) {
    }

    public ActionListener getRemoveAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getRemoveAction(splittedPanel);
    }

    public ActionListener getAddAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getAddAction(splittedPanel);
    }

    public ActionListener getSaveAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getSaveAction(splittedPanel);
    }

    void convertTime() {
        try {
            Double time = Double.parseDouble(this.m_srcTimeValueTF.getText());
            Double calcMoz = this.getCorrespondingData(time, this.getSelectedMapId(this.m_sourceMapsCB));
            if (calcMoz.isNaN()) {
                this.m_destValueTF.setText("Not Found");
            } else {
                this.m_destValueTF.setText(format2.format(calcMoz));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    IonsRTTableModel getCloudData(long mapIdSrc) {
        if (this.m_dataBox.isLoaded()) {
            return ((DataboxMapAlignment)this.m_dataBox).getPeptideCloud(mapIdSrc);
        }
        return null;
    }

    protected Long getSelectedMapId(JComboBox cb) {
        if (cb == null) {
            return -1L;
        }
        int selId = cb.getSelectedIndex();
        if (this.m_pMapByIndex.containsKey(selId)) {
            return this.m_pMapByIndex.get(selId).getId();
        }
        return -1L;
    }
}

