/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import org.forester.archaeopteryx.Constants;
import org.forester.archaeopteryx.NodeEditPanel;
import org.forester.archaeopteryx.NodePanel;
import org.forester.archaeopteryx.TreePanel;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.util.ForesterUtil;

final class NodeFrame
extends JFrame {
    private static final long serialVersionUID = -6943510233968557246L;
    private final TreePanel _reepanel;
    private int _index = -1;

    NodeFrame(PhylogenyNode n, Phylogeny tree, TreePanel tp, int x) {
        super("Node " + (ForesterUtil.isEmpty(n.getName()) ? Long.valueOf(n.getId()) : n.getName()));
        this._reepanel = tp;
        this.setSize(Constants.NODE_FRAME_SIZE);
        this._index = x;
        Container contentPane = this.getContentPane();
        NodePanel nodepanel = new NodePanel(n);
        contentPane.add((Component)nodepanel, "Center");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                NodeFrame.this.remove();
                NodeFrame.this.dispose();
            }
        });
        this.setResizable(false);
        nodepanel.setVisible(true);
        this.setVisible(true);
    }

    NodeFrame(PhylogenyNode n, Phylogeny tree, TreePanel tp, int x, String dummy) {
        super("Editable Node " + (ForesterUtil.isEmpty(n.getName()) ? Long.valueOf(n.getId()) : n.getName()));
        this._reepanel = tp;
        this.setSize(Constants.NODE_FRAME_SIZE);
        this._index = x;
        Container contentPane = this.getContentPane();
        final NodeEditPanel nodepanel = new NodeEditPanel(n, tp);
        contentPane.add((Component)nodepanel, "Center");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                try {
                    nodepanel.writeAll();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                NodeFrame.this.remove();
                NodeFrame.this.dispose();
            }
        });
        this.setResizable(false);
        nodepanel.setVisible(true);
        this.setVisible(true);
    }

    TreePanel getTreePanel() {
        return this._reepanel;
    }

    void remove() {
        if (this._index > -1) {
            this._reepanel.removeEditNodeFrame(this._index);
        }
    }
}

