/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx.tools;

import java.io.File;
import org.forester.archaeopteryx.Configuration;

public final class InferenceManager {
    private static final String[] DEFAULT_PATHS = new String[]{"C:\\Program Files\\mafft-win\\", "C:\\Program Files\\", "C:\\Program Files (x86)\\", "/bin/", "/usr/local/bin/", "/usr/bin/"};
    private final File _path_to_local_mafft;
    private final File _path_to_local_fastme;
    private final File _path_to_local_raxml;

    public static InferenceManager createInstance(Configuration c) {
        return new InferenceManager(c.getPathToLocalMafft(), c.getPathToLocalFastme(), c.getPathToLocalRaxml());
    }

    public boolean canDoMsa() {
        return this.getPathToLocalMafft() != null;
    }

    public File getPathToLocalMafft() {
        return this._path_to_local_mafft;
    }

    public File getPathToLocalFastme() {
        return this._path_to_local_fastme;
    }

    public File getPathToLocalRaxml() {
        return this._path_to_local_raxml;
    }

    private static final File createLocalPath(File path, String name) {
        if (path != null && path.canExecute() && !path.isDirectory()) {
            return path;
        }
        File p1 = new File(name);
        if (p1.canExecute() && !p1.isDirectory()) {
            return p1;
        }
        for (String path_str : DEFAULT_PATHS) {
            try {
                File p2 = new File(path_str + name);
                if (p2.canExecute() && !p2.isDirectory()) {
                    return p2;
                }
                File p3 = new File(path_str + name + ".exe");
                if (p3.canExecute() && !p3.isDirectory()) {
                    return p3;
                }
                File p4 = new File(path_str + name + ".bat");
                if (!p4.canExecute() || p4.isDirectory()) continue;
                return p4;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private InferenceManager(File path_to_local_mafft, File path_to_local_fastme, File path_to_local_raxml) {
        this._path_to_local_mafft = InferenceManager.createLocalPath(path_to_local_mafft, "mafft");
        this._path_to_local_fastme = InferenceManager.createLocalPath(path_to_local_fastme, "fastme");
        this._path_to_local_raxml = InferenceManager.createLocalPath(path_to_local_raxml, "raxml");
    }
}

