/*
 * Decompiled with CFR 0.152.
 */
package org.forester.evoinference.distance;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.forester.evoinference.matrix.distance.BasicSymmetricalDistanceMatrix;

public final class Sset {
    public static final int FACTOR = 1000000;
    private static final boolean DEBUG = true;
    private final List<SortedMap<Integer, Set<Integer>>> _data = new ArrayList<SortedMap<Integer, Set<Integer>>>();

    public final void addPairing(double key, int value, int j) {
        Sset.addPairing((int)(1000000.0 * key), value, this.getS(j));
    }

    public final void addPairing(int key, int value, int j) {
        Sset.addPairing(key, value, this.getS(j));
    }

    public final SortedMap<Integer, Set<Integer>> getS(int j) {
        return this._data.get(j);
    }

    public final Set<Integer> getValues(int key, int j) {
        return (Set)this.getS(j).get(key);
    }

    public final void initialize(BasicSymmetricalDistanceMatrix d) {
        for (int j = 0; j < d.getSize(); ++j) {
            TreeMap<Integer, Set<Integer>> map = new TreeMap<Integer, Set<Integer>>();
            this._data.add(map);
            for (int i = 0; i < j; ++i) {
                Sset.addPairing((int)(1000000.0 * d.getValues()[i][j]), i, map);
            }
        }
    }

    public final void initialize(int size) {
        for (int j = 0; j < size; ++j) {
            TreeMap map = new TreeMap();
            this._data.add(map);
        }
    }

    public final void removePairing(double key, int value, int j) {
        this.removePairing((int)(key * 1000000.0), value, j);
    }

    public final void removePairing(int key, int value, int j) {
        SortedMap<Integer, Set<Integer>> m = this._data.get(j);
        Set x = (Set)m.get(key);
        if (x == null) {
            System.out.println();
            System.out.println("________________________________________________________________________________________");
            System.out.println(this.toString());
            throw new IllegalArgumentException("key " + key + " (->" + value + ") does not exist for row " + j);
        }
        if (x.size() == 1) {
            if (!x.contains(value)) {
                System.out.println();
                System.out.println("________________________________________________________________________________________");
                System.out.println(this.toString());
                throw new IllegalArgumentException("pairing " + key + "->" + value + " does not exist for row " + j);
            }
            m.remove(key);
        } else if (x.size() > 1) {
            if (!x.remove(value)) {
                throw new IllegalArgumentException("pairing " + key + "->" + value + " does not exist (could not be removed) for row " + j);
            }
        } else {
            throw new IllegalStateException();
        }
    }

    public final int size() {
        return this._data.size();
    }

    public final Set<Integer>[] toArray(int j) {
        return this._data.get(j).values().toArray(new Set[this._data.get(j).size()]);
    }

    public final String toString() {
        DecimalFormat df = new DecimalFormat("0.000000");
        StringBuilder sb = new StringBuilder();
        for (int j = 0; j < this.size(); ++j) {
            sb.append(j);
            sb.append(": ");
            for (Map.Entry<Integer, Set<Integer>> entry : this.getSentrySet(j)) {
                double key = entry.getKey().intValue();
                Set<Integer> values = entry.getValue();
                sb.append(df.format(key / 1000000.0) + "->");
                boolean first = true;
                for (int v : values) {
                    if (!first) {
                        sb.append(",");
                    }
                    first = false;
                    sb.append(v);
                }
                sb.append("  ");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    final Set<Map.Entry<Integer, Set<Integer>>> getSentrySet(int j) {
        return this.getS(j).entrySet();
    }

    private static final void addPairing(int key, int value, SortedMap<Integer, Set<Integer>> m) {
        if (!m.containsKey(key)) {
            HashSet<Integer> x = new HashSet<Integer>();
            x.add(value);
            m.put(key, x);
        } else {
            if (((Set)m.get(key)).contains(value)) {
                throw new IllegalArgumentException("pairing " + key + "->" + value + " already exists");
            }
            ((Set)m.get(key)).add(value);
        }
    }
}

