/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny.data;

import java.io.IOException;
import java.io.Writer;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.phylogeny.data.PhylogenyDataUtil;
import org.forester.util.ForesterUtil;

public final class Accession
implements PhylogenyData,
Comparable<Accession> {
    private final String _comment;
    private final String _source;
    private final String _source_value;
    private final String _value;

    public Accession(String value) {
        this._value = value;
        this._source = "";
        this._comment = "";
        this._source_value = value;
    }

    public Accession(String value, String source) {
        this._value = value;
        this._source = source;
        this._comment = "";
        this._source_value = source != null ? source + value : value;
    }

    public Accession(String value, Source source) {
        this._value = value;
        this._source = source.toString();
        this._comment = "";
        this._source_value = (Object)((Object)source) + value;
    }

    public Accession(String value, String source, String comment) {
        this._value = value;
        this._source = source;
        this._comment = comment;
        this._source_value = source != null ? source + value : value;
    }

    @Override
    public StringBuffer asSimpleText() {
        return new StringBuffer(this.getValue());
    }

    @Override
    public StringBuffer asText() {
        StringBuffer sb = new StringBuffer();
        if (!ForesterUtil.isEmpty(this.getSource())) {
            sb.append(this.getSource());
            sb.append(": ");
        }
        sb.append(this.getValue());
        if (!ForesterUtil.isEmpty(this.getComment())) {
            sb.append(" (");
            sb.append(this.getComment());
            sb.append(")");
        }
        return sb;
    }

    @Override
    public int compareTo(Accession o) {
        if (this.equals(o)) {
            return 0;
        }
        return this._source_value.compareTo(o._source_value);
    }

    @Override
    public PhylogenyData copy() {
        return new Accession(this.getValue(), this.getSource());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            throw new IllegalArgumentException("attempt to check [" + this.getClass() + "] equality to " + o + " [" + o.getClass() + "]");
        }
        return this.isEqual((Accession)o);
    }

    public String getComment() {
        return this._comment;
    }

    public String getSource() {
        return this._source;
    }

    public String getValue() {
        return this._value;
    }

    public int hashCode() {
        return this._source_value.hashCode();
    }

    @Override
    public boolean isEqual(PhylogenyData data) {
        if (this == data) {
            return true;
        }
        if (data == null || this.getValue() == null) {
            return false;
        }
        Accession a = (Accession)data;
        if (this.getSource() != null && a.getSource() != null) {
            return a.getValue().equals(this.getValue()) && a.getSource().equals(this.getSource());
        }
        return a.getValue().equals(this.getValue());
    }

    @Override
    public StringBuffer toNHX() {
        StringBuffer sb = new StringBuffer();
        sb.append(":");
        sb.append("AC=");
        sb.append(ForesterUtil.replaceIllegalNhxCharacters(this.getValue()));
        return sb;
    }

    @Override
    public void toPhyloXML(Writer writer, int level, String indentation) throws IOException {
        if (ForesterUtil.isEmpty(this.getSource())) {
            if (ForesterUtil.isEmpty(this.getComment())) {
                PhylogenyDataUtil.appendElement(writer, "accession", this.getValue(), "source", "unknown", indentation);
            } else {
                PhylogenyDataUtil.appendElement(writer, "accession", this.getValue(), "source", "unknown", "comment", this.getComment(), indentation);
            }
        } else if (ForesterUtil.isEmpty(this.getComment())) {
            PhylogenyDataUtil.appendElement(writer, "accession", this.getValue(), "source", this.getSource(), indentation);
        } else {
            PhylogenyDataUtil.appendElement(writer, "accession", this.getValue(), "source", this.getSource(), "comment", this.getComment(), indentation);
        }
    }

    public String toString() {
        return this.asText().toString();
    }

    public static enum Source {
        NCBI,
        REFSEQ,
        UNIPROT,
        GI,
        EMBL,
        ENSEMBL,
        UNKNOWN;


        public String toString() {
            switch (this) {
                case NCBI: {
                    return "ncbi";
                }
                case REFSEQ: {
                    return "refseq";
                }
                case UNIPROT: {
                    return "uniprot";
                }
                case GI: {
                    return "gi";
                }
                case EMBL: {
                    return "embl";
                }
                case ENSEMBL: {
                    return "ensembl";
                }
                case UNKNOWN: {
                    return "unknown";
                }
            }
            throw new IllegalArgumentException();
        }
    }
}

