/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny.data;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.phylogeny.data.PhylogenyDataUtil;
import org.forester.phylogeny.data.Point;
import org.forester.phylogeny.data.Polygon;
import org.forester.util.ForesterUtil;

public class Distribution
implements PhylogenyData {
    private final String _desc;
    private final List<Point> _points;
    private final List<Polygon> _polygons;

    public Distribution(String desc) {
        this._desc = desc;
        this._points = null;
        this._polygons = null;
    }

    public Distribution(String desc, List<Point> points) {
        this._desc = null;
        this._points = points;
        this._polygons = null;
    }

    public Distribution(String desc, List<Point> points, List<Polygon> polygons) {
        this._desc = desc;
        this._points = points;
        this._polygons = polygons;
    }

    public boolean isEmpty() {
        if (ForesterUtil.isEmpty(this._desc) && this.getPoints() != null && this.getPoints().size() == 1 && ForesterUtil.isEmpty(this._polygons) && Point.isSeemsEmpty(this.getPoints().get(0))) {
            return true;
        }
        return ForesterUtil.isEmpty(this._desc) && ForesterUtil.isEmpty(this._points) && ForesterUtil.isEmpty(this._polygons);
    }

    @Override
    public StringBuffer asSimpleText() {
        StringBuffer sb = new StringBuffer();
        if (this.isEmpty()) {
            return sb;
        }
        sb.append("Distribution: ");
        if (!ForesterUtil.isEmpty(this.getDesc())) {
            sb.append(ForesterUtil.LINE_SEPARATOR);
            sb.append(" Description: ");
            sb.append(this.getDesc());
        }
        int i = 0;
        if (this.getPoints() != null) {
            for (Point point : this.getPoints()) {
                if (point == null || Point.isSeemsEmpty(point)) continue;
                sb.append(ForesterUtil.LINE_SEPARATOR);
                sb.append(" Point " + i + ": ");
                sb.append(point.asSimpleText());
                ++i;
            }
        }
        i = 0;
        if (this.getPolygons() != null) {
            for (Polygon polygon : this.getPolygons()) {
                if (polygon == null) continue;
                sb.append(ForesterUtil.LINE_SEPARATOR);
                sb.append(" Polygon " + i + ":");
                sb.append(ForesterUtil.LINE_SEPARATOR);
                sb.append(polygon.asSimpleText());
                ++i;
            }
        }
        return sb;
    }

    @Override
    public StringBuffer asText() {
        return this.asSimpleText();
    }

    @Override
    public PhylogenyData copy() {
        ArrayList<Point> new_points = null;
        ArrayList<Polygon> new_polygons = null;
        if (this.getPoints() != null) {
            new_points = new ArrayList<Point>();
            for (Point point : this.getPoints()) {
                new_points.add((Point)point.copy());
            }
        }
        if (this.getPolygons() != null) {
            new_polygons = new ArrayList<Polygon>();
            for (Polygon polygon : this.getPolygons()) {
                new_polygons.add((Polygon)polygon.copy());
            }
        }
        return new Distribution(this.getDesc(), new_points, new_polygons);
    }

    public String getDesc() {
        return this._desc;
    }

    public List<Point> getPoints() {
        return this._points;
    }

    public List<Polygon> getPolygons() {
        return this._polygons;
    }

    @Override
    public boolean isEqual(PhylogenyData data) {
        throw new UnsupportedOperationException();
    }

    @Override
    public StringBuffer toNHX() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void toPhyloXML(Writer writer, int level, String indentation) throws IOException {
        if (this.isEmpty()) {
            return;
        }
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write(indentation);
        PhylogenyDataUtil.appendOpen(writer, "distribution");
        if (!ForesterUtil.isEmpty(this.getDesc())) {
            PhylogenyDataUtil.appendElement(writer, "desc", this.getDesc(), indentation);
        }
        String ind = indentation + "  ";
        if (this.getPoints() != null) {
            for (Point point : this.getPoints()) {
                if (point == null || Point.isSeemsEmpty(point)) continue;
                point.toPhyloXML(writer, level, ind);
            }
        }
        if (this.getPolygons() != null) {
            for (Polygon polygon : this.getPolygons()) {
                if (polygon == null) continue;
                polygon.toPhyloXML(writer, level, ind);
            }
        }
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write(indentation);
        PhylogenyDataUtil.appendClose(writer, "distribution");
    }

    public String toString() {
        return this.asSimpleText().toString();
    }
}

