/*
 * Decompiled with CFR 0.152.
 */
package org.forester.sdi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Event;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.sdi.GSDII;
import org.forester.sdi.GSDIsummaryResult;
import org.forester.sdi.NodesLinkingResult;
import org.forester.sdi.SDIException;
import org.forester.sdi.SDIutil;
import org.forester.util.ForesterUtil;

public final class GSDI
implements GSDII {
    private final boolean _most_parsimonious_duplication_model;
    private final int _speciation_or_duplication_events_sum;
    private final int _speciations_sum;
    private final int _duplications_sum;
    private final List<PhylogenyNode> _stripped_gene_tree_nodes;
    private final List<PhylogenyNode> _stripped_species_tree_nodes;
    private final Set<PhylogenyNode> _mapped_species_tree_nodes;
    private final SDIutil.TaxonomyComparisonBase _tax_comp_base;
    private final SortedSet<String> _scientific_names_mapped_to_reduced_specificity;

    public GSDI(Phylogeny gene_tree, Phylogeny species_tree, boolean most_parsimonious_duplication_model, boolean strip_gene_tree, boolean strip_species_tree) throws SDIException {
        this(gene_tree, species_tree, most_parsimonious_duplication_model, strip_gene_tree, strip_species_tree, true);
    }

    public GSDI(Phylogeny gene_tree, Phylogeny species_tree, boolean most_parsimonious_duplication_model, boolean strip_gene_tree, boolean strip_species_tree, boolean transfer_taxonomy) throws SDIException {
        this._most_parsimonious_duplication_model = most_parsimonious_duplication_model;
        if (gene_tree.getRoot().getNumberOfDescendants() == 3) {
            gene_tree.reRoot(gene_tree.getRoot().getChildNode(2));
        }
        NodesLinkingResult nodes_linking_result = GSDI.linkNodesOfG(gene_tree, species_tree, strip_gene_tree, strip_species_tree);
        this._stripped_gene_tree_nodes = nodes_linking_result.getStrippedGeneTreeNodes();
        this._stripped_species_tree_nodes = nodes_linking_result.getStrippedSpeciesTreeNodes();
        this._mapped_species_tree_nodes = nodes_linking_result.getMappedSpeciesTreeNodes();
        this._scientific_names_mapped_to_reduced_specificity = nodes_linking_result.getScientificNamesMappedToReducedSpecificity();
        this._tax_comp_base = nodes_linking_result.getTaxCompBase();
        PhylogenyMethods.preOrderReId(species_tree);
        GSDIsummaryResult gsdi_summary_result = GSDI.geneTreePostOrderTraversal(gene_tree, this._most_parsimonious_duplication_model, transfer_taxonomy);
        this._speciation_or_duplication_events_sum = gsdi_summary_result.getSpeciationOrDuplicationEventsSum();
        this._speciations_sum = gsdi_summary_result.getSpeciationsSum();
        this._duplications_sum = gsdi_summary_result.getDuplicationsSum();
    }

    public int getDuplicationsSum() {
        return this._duplications_sum;
    }

    @Override
    public Set<PhylogenyNode> getMappedExternalSpeciesTreeNodes() {
        return this._mapped_species_tree_nodes;
    }

    @Override
    public final SortedSet<String> getReMappedScientificNamesFromGeneTree() {
        return this._scientific_names_mapped_to_reduced_specificity;
    }

    public final int getSpeciationOrDuplicationEventsSum() {
        return this._speciation_or_duplication_events_sum;
    }

    @Override
    public final int getSpeciationsSum() {
        return this._speciations_sum;
    }

    @Override
    public List<PhylogenyNode> getStrippedExternalGeneTreeNodes() {
        return this._stripped_gene_tree_nodes;
    }

    @Override
    public List<PhylogenyNode> getStrippedSpeciesTreeNodes() {
        return this._stripped_species_tree_nodes;
    }

    @Override
    public SDIutil.TaxonomyComparisonBase getTaxCompBase() {
        return this._tax_comp_base;
    }

    public final String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Most parsimonious duplication model: " + this._most_parsimonious_duplication_model);
        sb.append(ForesterUtil.getLineSeparator());
        sb.append("Speciations sum                    : " + this.getSpeciationsSum());
        sb.append(ForesterUtil.getLineSeparator());
        sb.append("Duplications sum                   : " + this.getDuplicationsSum());
        sb.append(ForesterUtil.getLineSeparator());
        if (!this._most_parsimonious_duplication_model) {
            sb.append("Speciation or duplications sum     : " + this.getSpeciationOrDuplicationEventsSum());
            sb.append(ForesterUtil.getLineSeparator());
        }
        return sb.toString();
    }

    static final GSDIsummaryResult geneTreePostOrderTraversal(Phylogeny gene_tree, boolean most_parsimonious_duplication_model, boolean transfer_taxonomy) throws SDIException {
        GSDIsummaryResult res = new GSDIsummaryResult();
        PhylogenyNodeIterator it = gene_tree.iteratorPostorder();
        while (it.hasNext()) {
            PhylogenyNode g = it.next();
            if (g.isInternal()) {
                if (g.getNumberOfDescendants() != 2) {
                    throw new SDIException("gene tree contains internal node with " + g.getNumberOfDescendants() + " descendents");
                }
                PhylogenyNode s1 = g.getChildNode1().getLink();
                PhylogenyNode s2 = g.getChildNode2().getLink();
                while (s1 != s2) {
                    if (s1.getId() > s2.getId()) {
                        s1 = s1.getParent();
                        continue;
                    }
                    s2 = s2.getParent();
                }
                g.setLink(s1);
                GSDI.determineEvent(s1, g, most_parsimonious_duplication_model, res);
            }
            if (!transfer_taxonomy) continue;
            GSDI.transferTaxonomy(g);
        }
        return res;
    }

    static final GSDIsummaryResult geneTreePostOrderTraversal(Phylogeny gene_tree, boolean most_parsimonious_duplication_model, int min_duplications) throws SDIException {
        GSDIsummaryResult res = new GSDIsummaryResult();
        PhylogenyNodeIterator it = gene_tree.iteratorPostorder();
        while (it.hasNext()) {
            PhylogenyNode g = it.next();
            if (!g.isInternal()) continue;
            if (g.getNumberOfDescendants() != 2) {
                throw new SDIException("gene tree contains internal node with " + g.getNumberOfDescendants() + " descendents");
            }
            PhylogenyNode s1 = g.getChildNode1().getLink();
            PhylogenyNode s2 = g.getChildNode2().getLink();
            while (s1 != s2) {
                if (s1.getId() > s2.getId()) {
                    s1 = s1.getParent();
                    continue;
                }
                s2 = s2.getParent();
            }
            g.setLink(s1);
            GSDI.determineEvent(s1, g, most_parsimonious_duplication_model, res);
            if (res.getDuplicationsSum() <= min_duplications) continue;
            return null;
        }
        return res;
    }

    static final NodesLinkingResult linkNodesOfG(Phylogeny gene_tree, Phylogeny species_tree, boolean strip_gene_tree, boolean strip_species_tree) throws SDIException {
        SDIutil.TaxonomyComparisonBase tax_comp_base = SDIutil.determineTaxonomyComparisonBase(gene_tree);
        if (tax_comp_base == null) {
            throw new RuntimeException("failed to establish taxonomy linking base (taxonomy linking base is null)");
        }
        return GSDI.linkNodesOfG(gene_tree, species_tree, tax_comp_base, strip_gene_tree, strip_species_tree);
    }

    static final NodesLinkingResult linkNodesOfG(Phylogeny gene_tree, Phylogeny species_tree, SDIutil.TaxonomyComparisonBase tax_comp_base, boolean strip_gene_tree, boolean strip_species_tree) throws SDIException {
        String tax_str;
        if (tax_comp_base == null) {
            throw new IllegalArgumentException("taxonomy linking base is null");
        }
        HashMap<String, PhylogenyNode> species_to_node_map = new HashMap<String, PhylogenyNode>();
        ArrayList<PhylogenyNode> species_tree_ext_nodes = new ArrayList<PhylogenyNode>();
        NodesLinkingResult res = new NodesLinkingResult();
        res.setTaxCompBase(tax_comp_base);
        PhylogenyNodeIterator iter = species_tree.iteratorExternalForward();
        while (iter.hasNext()) {
            PhylogenyNode s = iter.next();
            species_tree_ext_nodes.add(s);
            if (!s.getNodeData().isHasTaxonomy() || ForesterUtil.isEmpty(tax_str = SDIutil.taxonomyToString(s, res.getTaxCompBase()))) continue;
            if (species_to_node_map.containsKey(tax_str)) {
                throw new SDIException("taxonomy \"" + tax_str + "\" is not unique in species tree (using " + (Object)((Object)res.getTaxCompBase()) + " for linking to gene tree)");
            }
            species_to_node_map.put(tax_str, s);
        }
        iter = gene_tree.iteratorExternalForward();
        while (iter.hasNext()) {
            PhylogenyNode g = iter.next();
            if (!g.getNodeData().isHasTaxonomy()) {
                if (strip_gene_tree) {
                    res.getStrippedGeneTreeNodes().add(g);
                    continue;
                }
                throw new SDIException("gene tree node \"" + g + "\" has no taxonomic data");
            }
            tax_str = SDIutil.taxonomyToString(g, res.getTaxCompBase());
            if (ForesterUtil.isEmpty(tax_str)) {
                if (strip_gene_tree) {
                    res.getStrippedGeneTreeNodes().add(g);
                    continue;
                }
                throw new SDIException("gene tree node \"" + g + "\" has no appropriate taxonomic data");
            }
            PhylogenyNode s = (PhylogenyNode)species_to_node_map.get(tax_str);
            if (res.getTaxCompBase() == SDIutil.TaxonomyComparisonBase.SCIENTIFIC_NAME && s == null && ForesterUtil.countChars(tax_str, ' ') > 1) {
                s = GSDI.tryMapByRemovingOverlySpecificData(species_to_node_map, tax_str, res.getScientificNamesMappedToReducedSpecificity());
            }
            if (s == null) {
                if (strip_gene_tree) {
                    res.getStrippedGeneTreeNodes().add(g);
                    continue;
                }
                throw new SDIException("taxonomy \"" + g.getNodeData().getTaxonomy() + "\" not present in species tree");
            }
            g.setLink(s);
            res.getMappedSpeciesTreeNodes().add(s);
        }
        if (strip_gene_tree) {
            GSDI.stripTree(gene_tree, res.getStrippedGeneTreeNodes());
            if (gene_tree.isEmpty() || gene_tree.getNumberOfExternalNodes() < 2) {
                throw new SDIException("species could not be mapped between gene tree and species tree (based on " + (Object)((Object)res.getTaxCompBase()) + ")");
            }
        }
        if (strip_species_tree) {
            GSDI.stripSpeciesTree(species_tree, species_tree_ext_nodes, res);
        }
        return res;
    }

    static final void transferTaxonomy(PhylogenyNode g) {
        if (g == null) {
            throw new IllegalArgumentException("gene tree node is null");
        }
        PhylogenyNode s = g.getLink();
        if (s == null) {
            throw new IllegalArgumentException("mapped species tree node is null");
        }
        if (s.getNodeData().isHasTaxonomy()) {
            g.getNodeData().setTaxonomy(s.getNodeData().getTaxonomy());
            if (g.isInternal()) {
                if (g.getChildNode1().isInternal() && g.getChildNode1().getNodeData().isHasTaxonomy() && g.getChildNode1().getNodeData().getTaxonomy() == s.getNodeData().getTaxonomy()) {
                    g.getChildNode1().getNodeData().setTaxonomy(null);
                }
                if (g.getChildNode2().isInternal() && g.getChildNode2().getNodeData().isHasTaxonomy() && g.getChildNode2().getNodeData().getTaxonomy() == s.getNodeData().getTaxonomy()) {
                    g.getChildNode2().getNodeData().setTaxonomy(null);
                }
            }
        } else if (ForesterUtil.isEmpty(g.getName()) && !ForesterUtil.isEmpty(s.getName())) {
            g.setName(s.getName());
            if (g.isInternal()) {
                if (g.getChildNode1().isInternal() && g.getChildNode1().getName() == s.getName()) {
                    g.getChildNode1().setName("");
                }
                if (g.getChildNode2().isInternal() && g.getChildNode2().getName() == s.getName()) {
                    g.getChildNode2().setName("");
                }
            }
        }
    }

    private static final void addScientificNamesMappedToReducedSpecificity(String s1, String s2, SortedSet<String> scientific_names_mapped_to_reduced_specificity) {
        scientific_names_mapped_to_reduced_specificity.add(s1 + " -> " + s2);
    }

    private static final void determineEvent(PhylogenyNode s, PhylogenyNode g, boolean most_parsimonious_duplication_model, GSDIsummaryResult res) {
        boolean oyako = false;
        if (g.getChildNode1().getLink() == s || g.getChildNode2().getLink() == s) {
            oyako = true;
        }
        if (g.getLink().getNumberOfDescendants() == 2) {
            if (oyako) {
                g.getNodeData().setEvent(Event.createSingleDuplicationEvent());
                res.increaseDuplicationsSum();
            } else {
                g.getNodeData().setEvent(Event.createSingleSpeciationEvent());
                res.increaseSpeciationsSum();
            }
        } else if (oyako) {
            HashSet<PhylogenyNode> set = new HashSet<PhylogenyNode>();
            for (PhylogenyNode n : g.getChildNode1().getAllExternalDescendants()) {
                n = n.getLink();
                while (n.getParent() != s && n.getParent() != null && !(n = n.getParent()).isRoot()) {
                }
                set.add(n);
            }
            boolean multiple = false;
            for (PhylogenyNode n : g.getChildNode2().getAllExternalDescendants()) {
                n = n.getLink();
                while (n.getParent() != s && n.getParent() != null && !(n = n.getParent()).isRoot()) {
                }
                if (!set.contains(n)) continue;
                multiple = true;
                break;
            }
            if (multiple) {
                g.getNodeData().setEvent(Event.createSingleDuplicationEvent());
                res.increaseDuplicationsSum();
            } else if (most_parsimonious_duplication_model) {
                g.getNodeData().setEvent(Event.createSingleSpeciationEvent());
                res.increaseSpeciationsSum();
            } else {
                g.getNodeData().setEvent(Event.createSingleSpeciationOrDuplicationEvent());
                res.increaseSpeciationOrDuplicationEventsSum();
            }
        } else {
            g.getNodeData().setEvent(Event.createSingleSpeciationEvent());
            res.increaseSpeciationsSum();
        }
    }

    private static final void stripSpeciesTree(Phylogeny species_tree, List<PhylogenyNode> species_tree_ext_nodes, NodesLinkingResult res) {
        for (PhylogenyNode s : species_tree_ext_nodes) {
            if (res.getMappedSpeciesTreeNodes().contains(s)) continue;
            species_tree.deleteSubtree(s, true);
            res.getStrippedSpeciesTreeNodes().add(s);
        }
        species_tree.clearHashIdToNodeMap();
        species_tree.externalNodesHaveChanged();
    }

    private static final void stripTree(Phylogeny phy, List<PhylogenyNode> strip_nodes) {
        for (PhylogenyNode g : strip_nodes) {
            phy.deleteSubtree(g, true);
        }
        phy.clearHashIdToNodeMap();
        phy.externalNodesHaveChanged();
    }

    private static final PhylogenyNode tryMapByRemovingOverlySpecificData(Map<String, PhylogenyNode> species_to_node_map, String tax_str, SortedSet<String> scientific_names_mapped_to_reduced_specificity) {
        String new_tax_str;
        PhylogenyNode s = GSDI.tryMapByRemovingOverlySpecificData(species_to_node_map, tax_str, " (", scientific_names_mapped_to_reduced_specificity);
        if (s == null && ForesterUtil.countChars(tax_str, ' ') == 2 && (s = species_to_node_map.get(new_tax_str = tax_str.substring(0, tax_str.lastIndexOf(32)).trim())) != null) {
            GSDI.addScientificNamesMappedToReducedSpecificity(tax_str, new_tax_str, scientific_names_mapped_to_reduced_specificity);
        }
        if (s == null) {
            String t;
            String[] stringArray = new String[]{" subspecies ", " strain ", " variety ", " varietas ", " subvariety ", " form ", " subform ", " cultivar ", " section ", " subsection "};
            int n = stringArray.length;
            for (int i = 0; i < n && (s = GSDI.tryMapByRemovingOverlySpecificData(species_to_node_map, tax_str, t = stringArray[i], scientific_names_mapped_to_reduced_specificity)) == null; ++i) {
            }
        }
        return s;
    }

    private static final PhylogenyNode tryMapByRemovingOverlySpecificData(Map<String, PhylogenyNode> species_to_node_map, String tax_str, String term, SortedSet<String> scientific_names_mapped_to_reduced_specificity) {
        int i = tax_str.indexOf(term);
        if (i > 4) {
            String new_tax_str = tax_str.substring(0, i).trim();
            PhylogenyNode s = species_to_node_map.get(new_tax_str);
            if (s != null) {
                GSDI.addScientificNamesMappedToReducedSpecificity(tax_str, new_tax_str, scientific_names_mapped_to_reduced_specificity);
            }
            return s;
        }
        return null;
    }
}

