/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.core.orm.msi;

import fr.proline.core.orm.msi.Peptide;
import fr.proline.core.orm.msi.PeptideInstancePeptideMatchMap;
import fr.proline.core.orm.msi.PeptideSetPeptideInstanceItem;
import fr.proline.core.orm.msi.ResultSummary;
import fr.proline.core.orm.msi.dto.DPeptideMatch;
import fr.proline.core.orm.msi.dto.DProteinSet;
import fr.proline.core.orm.util.JsonSerializer;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@NamedQueries(value={@NamedQuery(name="findPepInstByPepMatch", query="select pi from PeptideInstance pi, IN (pi.peptideInstancePeptideMatchMaps) pm where pm.id.peptideMatchId = :pmID "), @NamedQuery(name="findPepInstForPeptideId", query="select pi from PeptideInstance pi where pi.peptide.id = :pepID ")})
@Table(name="peptide_instance")
public class PeptideInstance
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private long id;
    @Column(name="best_peptide_match_id")
    private long bestPeptideMatchId;
    @Column(name="master_quant_component_id")
    private Long masterQuantComponentId;
    @Column(name="peptide_match_count")
    private int peptideMatchCount;
    @Column(name="protein_match_count")
    private int proteinMatchCount;
    @Column(name="protein_set_count")
    private int proteinSetCount;
    @Column(name="validated_protein_set_count")
    private int validatedProteinSetCount;
    @Column(name="total_leaves_match_count")
    private int totalLeavesMatchCount;
    @Column(name="elution_time")
    private Float elutionTime;
    @ManyToOne
    @JoinColumn(name="result_summary_id")
    private ResultSummary resultSummary;
    @ManyToOne
    @JoinColumn(name="peptide_id")
    private Peptide peptide;
    @Column(name="selection_level")
    private int selectionLevel;
    @Column(name="serialized_properties")
    private String serializedProperties;
    @Column(name="unmodified_peptide_id")
    private Long unmodifiedPeptideId;
    @OneToMany(mappedBy="peptideInstance")
    private Set<PeptideSetPeptideInstanceItem> peptideSetPeptideInstanceItems;
    @OneToMany(mappedBy="peptideInstance")
    private Set<PeptideInstancePeptideMatchMap> peptideInstancePeptideMatchMaps;
    @Transient
    private TransientData transientData = null;
    @Transient
    private Map<String, Object> properties;

    public long getId() {
        return this.id;
    }

    public void setId(long pId) {
        this.id = pId;
    }

    public long getBestPeptideMatchId() {
        return this.bestPeptideMatchId;
    }

    public void setBestPeptideMatchId(long pBestPeptideMatchId) {
        this.bestPeptideMatchId = pBestPeptideMatchId;
    }

    public Long getMasterQuantComponentId() {
        return this.masterQuantComponentId;
    }

    public void setMasterQuantComponentId(Long pMasterQuantComponentId) {
        this.masterQuantComponentId = pMasterQuantComponentId;
    }

    public Peptide getPeptide() {
        return this.peptide;
    }

    public void setPeptide(Peptide pPeptide) {
        this.peptide = pPeptide;
    }

    public int getPeptideMatchCount() {
        return this.peptideMatchCount;
    }

    public void setPeptideMatchCount(int pPeptideMatchCount) {
        this.peptideMatchCount = pPeptideMatchCount;
    }

    public int getProteinMatchCount() {
        return this.proteinMatchCount;
    }

    public void setProteinMatchCount(int pProteinMatchCount) {
        this.proteinMatchCount = pProteinMatchCount;
    }

    public int getProteinSetCount() {
        return this.proteinSetCount;
    }

    public void setProteinSetCount(int pProteinSetCount) {
        this.proteinSetCount = pProteinSetCount;
    }

    public int getTotalLeavesMatchCount() {
        return this.totalLeavesMatchCount;
    }

    public void setTotalLeavesMatchCount(int pTotalLeavesMatchCount) {
        this.totalLeavesMatchCount = pTotalLeavesMatchCount;
    }

    public ResultSummary getResultSummary() {
        return this.resultSummary;
    }

    public void setResultSummary(ResultSummary resultSummary) {
        this.resultSummary = resultSummary;
    }

    public int getSelectionLevel() {
        return this.selectionLevel;
    }

    public void setSelectionLevel(int pSelectionLevel) {
        this.selectionLevel = pSelectionLevel;
    }

    public Float getElutionTime() {
        return this.elutionTime;
    }

    public void setElutionTime(Float elutionTime) {
        this.elutionTime = elutionTime;
    }

    public String getSerializedProperties() {
        return this.serializedProperties;
    }

    public void setSerializedProperties(String serializedProperties) {
        this.serializedProperties = serializedProperties;
    }

    public Map<String, Object> getProperties() throws Exception {
        if (this.properties == null && this.serializedProperties != null) {
            this.properties = (Map)JsonSerializer.getMapper().readValue(this.getSerializedProperties(), Map.class);
        }
        return this.properties;
    }

    public void setProperties(Map<String, Object> serializedPropertiesMap) throws Exception {
        this.properties = serializedPropertiesMap;
        this.serializedProperties = JsonSerializer.getMapper().writeValueAsString(serializedPropertiesMap);
    }

    public Long getUnmodifiedPeptideId() {
        return this.unmodifiedPeptideId;
    }

    public void setUnmodifiedPeptideId(Long pUnmodifiedPeptideId) {
        this.unmodifiedPeptideId = pUnmodifiedPeptideId;
    }

    public int getValidatedProteinSetCount() {
        return this.validatedProteinSetCount;
    }

    public void setValidatedProteinSetCount(int pValidatedProteinSetCount) {
        this.validatedProteinSetCount = pValidatedProteinSetCount;
    }

    public Set<PeptideSetPeptideInstanceItem> getPeptideSetPeptideInstanceItems() {
        return this.peptideSetPeptideInstanceItems;
    }

    public void setPeptideSetPeptideInstanceItems(Set<PeptideSetPeptideInstanceItem> peptideSetPeptideInstanceItems) {
        this.peptideSetPeptideInstanceItems = peptideSetPeptideInstanceItems;
    }

    public Set<PeptideInstancePeptideMatchMap> getPeptideInstancePeptideMatchMaps() {
        return this.peptideInstancePeptideMatchMaps;
    }

    public void setPeptideInstancePeptideMatchMaps(Set<PeptideInstancePeptideMatchMap> peptideInstancePeptideMatchMaps) {
        this.peptideInstancePeptideMatchMaps = peptideInstancePeptideMatchMaps;
    }

    public TransientData getTransientData() {
        if (this.transientData == null) {
            this.transientData = new TransientData();
        }
        return this.transientData;
    }

    public static class TransientData
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private DPeptideMatch bestPeptideMatch = null;
        private DProteinSet[] proteinSetArray = null;
        private long[] peptideMatchesId;
        private DPeptideMatch[] peptideMatches;

        protected TransientData() {
        }

        public DProteinSet[] getProteinSetArray() {
            return this.proteinSetArray;
        }

        public void setProteinSetArray(DProteinSet[] proteinSetArray) {
            this.proteinSetArray = proteinSetArray;
        }

        public DPeptideMatch getBestPeptideMatch() {
            return this.bestPeptideMatch;
        }

        public void setBestPeptideMatch(DPeptideMatch bestPeptideMatch) {
            this.bestPeptideMatch = bestPeptideMatch;
        }

        public DPeptideMatch[] getPeptideMatches() {
            return this.peptideMatches;
        }

        public void setPeptideMatches(DPeptideMatch[] peptideMatches) {
            this.peptideMatches = peptideMatches;
        }

        public long[] getPeptideMatchesId() {
            return this.peptideMatchesId;
        }

        public void setPeptideMatchesId(long[] peptideMatchesId) {
            this.peptideMatchesId = peptideMatchesId;
        }
    }
}

