/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.python.model;

import fr.proline.studio.export.ExportFontData;
import fr.proline.studio.extendedtablemodel.ChildModelInterface;
import fr.proline.studio.extendedtablemodel.ExtraDataType;
import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.filter.Filter;
import fr.proline.studio.graphics.PlotInformation;
import fr.proline.studio.graphics.PlotType;
import fr.proline.studio.table.DecoratedTableModel;
import fr.proline.studio.table.LazyData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;

public class FilterColumnTableModel
extends DecoratedTableModel
implements ChildModelInterface {
    private GlobalTableModelInterface m_parentModel;
    private int[] m_columnsKept = null;
    private HashMap<Integer, Integer> m_reverseColumnsKept = new HashMap();
    public String m_name = null;

    public FilterColumnTableModel(GlobalTableModelInterface parentModel, int[] columnsKept) {
        this.m_parentModel = parentModel;
        this.m_columnsKept = columnsKept;
        for (int i = 0; i < this.m_columnsKept.length; ++i) {
            this.m_reverseColumnsKept.put(this.m_columnsKept[i], i);
        }
    }

    public int getRowCount() {
        return this.m_parentModel.getRowCount();
    }

    public int getColumnCount() {
        return this.m_columnsKept.length;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.m_parentModel.getValueAt(rowIndex, this.m_columnsKept[columnIndex]);
    }

    public Class getColumnClass(int columnIndex) {
        return this.m_parentModel.getColumnClass(this.m_columnsKept[columnIndex]);
    }

    public String getColumnName(int columnIndex) {
        return this.m_parentModel.getColumnName(this.m_columnsKept[columnIndex]);
    }

    public Long getTaskId() {
        return this.m_parentModel.getTaskId();
    }

    public LazyData getLazyData(int row, int col) {
        return this.m_parentModel.getLazyData(row, this.m_columnsKept[col]);
    }

    public void givePriorityTo(Long taskId, int row, int col) {
        this.m_parentModel.givePriorityTo(taskId, row, this.m_parentModel.getColumnCount());
    }

    public void sortingChanged(int col) {
        this.m_parentModel.sortingChanged(this.m_columnsKept[col]);
    }

    public int getSubTaskId(int col) {
        return this.m_parentModel.getSubTaskId(this.m_columnsKept[col]);
    }

    public String getToolTipForHeader(int col) {
        return this.m_parentModel.getToolTipForHeader(this.m_columnsKept[col]);
    }

    public String getTootlTipValue(int row, int col) {
        return this.m_parentModel.getTootlTipValue(row, this.m_columnsKept[col]);
    }

    public String getDataColumnIdentifier(int columnIndex) {
        return this.m_parentModel.getDataColumnIdentifier(this.m_columnsKept[columnIndex]);
    }

    public Class getDataColumnClass(int columnIndex) {
        return this.m_parentModel.getDataColumnClass(this.m_columnsKept[columnIndex]);
    }

    public Object getDataValueAt(int rowIndex, int columnIndex) {
        return this.m_parentModel.getDataValueAt(rowIndex, this.m_columnsKept[columnIndex]);
    }

    public int[] getKeysColumn() {
        int size = 0;
        int[] parentKeysColumn = this.m_parentModel.getKeysColumn();
        if (parentKeysColumn != null) {
            for (int i = 0; i < parentKeysColumn.length; ++i) {
                Integer inIndex = this.m_reverseColumnsKept.get(i);
                if (inIndex == null) continue;
                ++size;
            }
        }
        int[] keys = null;
        if (size > 0) {
            keys = new int[size];
            size = 0;
            for (int i = 0; i < parentKeysColumn.length; ++i) {
                Integer inIndex = this.m_reverseColumnsKept.get(i);
                if (inIndex == null) continue;
                keys[size] = inIndex;
                ++size;
            }
        }
        return keys;
    }

    public int getInfoColumn() {
        int iParent = this.m_parentModel.getInfoColumn();
        Integer inIndex = this.m_reverseColumnsKept.get(iParent);
        if (inIndex == null) {
            return -1;
        }
        return inIndex;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public String getName() {
        if (this.m_name != null) {
            return this.m_name;
        }
        return this.m_parentModel.getName();
    }

    public Map<String, Object> getExternalData() {
        return this.m_parentModel.getExternalData();
    }

    public PlotInformation getPlotInformation() {
        return this.m_parentModel.getPlotInformation();
    }

    public void addFilters(LinkedHashMap<Integer, Filter> filtersMap) {
        if (filtersMap.isEmpty()) {
            LinkedHashMap parentFiltersMap = new LinkedHashMap();
            this.m_parentModel.addFilters(parentFiltersMap);
            for (Integer i : parentFiltersMap.keySet()) {
                Integer key = this.m_reverseColumnsKept.get(i);
                Filter filter = (Filter)parentFiltersMap.get(i);
                filtersMap.put(key, filter);
            }
        }
    }

    public boolean isLoaded() {
        return this.m_parentModel.isLoaded();
    }

    public int getLoadingPercentage() {
        return this.m_parentModel.getLoadingPercentage();
    }

    public PlotType getBestPlotType() {
        return this.m_parentModel.getBestPlotType();
    }

    public int[] getBestColIndex(PlotType plotType) {
        int[] cols = this.m_parentModel.getBestColIndex(plotType);
        if (cols == null) {
            return null;
        }
        int nb = cols.length;
        int[] colsRes = new int[nb];
        for (int i = 0; i < nb; ++i) {
            Integer index = this.m_reverseColumnsKept.get(cols[i]);
            colsRes[i] = index == null ? -1 : index;
        }
        return colsRes;
    }

    public String getExportRowCell(int row, int col) {
        return this.m_parentModel.getExportRowCell(row, this.m_columnsKept[col]);
    }

    public ArrayList<ExportFontData> getExportFonts(int row, int col) {
        return this.m_parentModel.getExportFonts(row, this.m_columnsKept[col]);
    }

    public String getExportColumnName(int col) {
        return this.m_parentModel.getExportColumnName(this.m_columnsKept[col]);
    }

    public void setParentModel(GlobalTableModelInterface parentModel) {
        if (this.m_parentModel != null) {
            this.m_parentModel.removeTableModelListener((TableModelListener)((Object)this));
        }
        this.m_parentModel = parentModel;
        this.m_parentModel.addTableModelListener((TableModelListener)((Object)this));
    }

    public GlobalTableModelInterface getParentModel() {
        return this.m_parentModel;
    }

    public void tableChanged(TableModelEvent e) {
        this.fireTableDataChanged();
    }

    public TableCellRenderer getRenderer(int row, int col) {
        return this.m_parentModel.getRenderer(row, this.m_columnsKept[col]);
    }

    public GlobalTableModelInterface getFrozzenModel() {
        return this;
    }

    public ArrayList<ExtraDataType> getExtraDataTypes() {
        return this.m_parentModel.getExtraDataTypes();
    }

    public Object getValue(Class c) {
        return this.m_parentModel.getValue(c);
    }

    public Object getRowValue(Class c, int row) {
        return this.m_parentModel.getRowValue(c, row);
    }

    public Object getColValue(Class c, int col) {
        return this.m_parentModel.getColValue(c, this.m_columnsKept[col]);
    }
}

