/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dock.container;

import fr.proline.studio.dock.AbstractTopPanel;
import fr.proline.studio.dock.container.DockComponent;
import fr.proline.studio.dock.container.DockContainer;
import fr.proline.studio.dock.container.DockContainerMulti;
import fr.proline.studio.dock.container.DockContainerSplit;
import fr.proline.studio.dock.container.DockException;
import fr.proline.studio.dock.container.DockPosition;
import fr.proline.studio.dock.container.DockReplaceInterface;
import fr.proline.studio.dock.dragdrop.OverArea;
import fr.proline.studio.dock.gui.TabbedPaneLabel;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;

public class DockContainerTab
extends DockContainerMulti {
    private HashSet<DockContainer> m_dockContainerSet = new HashSet();

    public DockContainerTab() {
        JTabbedPane tabbedPane = new JTabbedPane();
        this.m_component = tabbedPane;
    }

    @Override
    public void toFront(DockContainer child) {
        JTabbedPane tabbedPane = (JTabbedPane)this.m_component;
        int index = tabbedPane.indexOfComponent(child.getComponent());
        if (index != -1) {
            tabbedPane.setSelectedIndex(index);
        }
    }

    @Override
    public void getTopPanels(HashSet<AbstractTopPanel> set) {
        for (DockContainer c : this.m_dockContainerSet) {
            c.getTopPanels(set);
        }
    }

    @Override
    public DockContainer search(String windowKey) {
        for (DockContainer c : this.m_dockContainerSet) {
            DockContainer containerSearched = c.search(windowKey);
            if (containerSearched == null) continue;
            return containerSearched;
        }
        return null;
    }

    @Override
    public DockContainer searchZoneArea(String zoneArea) {
        if (this.m_zoneArea != null && this.m_zoneArea.equals(zoneArea)) {
            return this;
        }
        for (DockContainer c : this.m_dockContainerSet) {
            DockContainer containerSearched = c.searchZoneArea(zoneArea);
            if (containerSearched == null) continue;
            return containerSearched;
        }
        return null;
    }

    @Override
    public void findAllDockComponents(ArrayList<DockComponent> components) {
        for (DockContainer c : this.m_dockContainerSet) {
            c.findAllDockComponents(components);
        }
    }

    public void add(DockContainer container, DockPosition dockPosition) throws DockException {
        if (!(container instanceof DockComponent)) {
            throw new DockException("Must add DockComponent to DockContainerTab");
        }
        DockComponent component = (DockComponent)container;
        DockReplaceInterface parent = (DockReplaceInterface)((Object)this.getParent());
        switch (dockPosition.getPosition()) {
            case -1: {
                this.add(component);
                break;
            }
            case -2: {
                DockContainerSplit dockContainerSplit = new DockContainerSplit();
                DockContainerTab containerTab = new DockContainerTab();
                containerTab.setZoneArea(this.getZoneArea());
                containerTab.add(component);
                dockContainerSplit.add(true, containerTab, this);
                parent.replace(this, dockContainerSplit);
                break;
            }
            case -3: {
                DockContainerSplit dockContainerSplit = new DockContainerSplit();
                DockContainerTab containerTab = new DockContainerTab();
                containerTab.setZoneArea(this.getZoneArea());
                containerTab.add(component);
                this.getComponent().getParent().remove(this.getComponent());
                dockContainerSplit.add(true, this, containerTab);
                parent.replace(this, dockContainerSplit);
                break;
            }
            case -4: {
                DockContainerSplit dockContainerSplit = new DockContainerSplit();
                DockContainerTab containerTab = new DockContainerTab();
                containerTab.setZoneArea(this.getZoneArea());
                containerTab.add(component);
                dockContainerSplit.add(false, containerTab, this);
                parent.replace(this, dockContainerSplit);
                break;
            }
            case -5: {
                DockContainerSplit dockContainerSplit = new DockContainerSplit();
                DockContainerTab containerTab = new DockContainerTab();
                containerTab.setZoneArea(this.getZoneArea());
                containerTab.add(component);
                this.getComponent().getParent().remove(this.getComponent());
                dockContainerSplit.add(false, this, containerTab);
                parent.replace(this, dockContainerSplit);
                break;
            }
            default: {
                this.add(component, dockPosition.getPosition());
            }
        }
        this.getRoot().check();
    }

    public void add(DockComponent container) {
        JTabbedPane tabbedPane = (JTabbedPane)this.m_component;
        tabbedPane.addTab(container.getTitle(), container.getComponent());
        int index = tabbedPane.indexOfComponent(container.getComponent());
        TabbedPaneLabel tpl = new TabbedPaneLabel(this, container);
        tabbedPane.setTabComponentAt(index, tpl);
        tabbedPane.setSelectedIndex(index);
        this.m_dockContainerSet.add(container);
        container.setParent(this);
        if (container.getComponent() instanceof AbstractTopPanel) {
            AbstractTopPanel topPanel = (AbstractTopPanel)container.getComponent();
            topPanel.componentAdded();
        }
    }

    public void add(DockComponent container, int destIndex) {
        JTabbedPane tabbedPane = (JTabbedPane)this.m_component;
        tabbedPane.insertTab(container.getTitle(), null, container.getComponent(), null, destIndex);
        TabbedPaneLabel tpl = new TabbedPaneLabel(this, container);
        tabbedPane.setTabComponentAt(destIndex, tpl);
        tabbedPane.setSelectedIndex(destIndex);
        this.m_dockContainerSet.add(container);
        container.setParent(this);
        if (container.getComponent() instanceof AbstractTopPanel) {
            AbstractTopPanel topPanel = (AbstractTopPanel)container.getComponent();
            topPanel.componentAdded();
        }
    }

    @Override
    public void remove(DockContainer container) {
        this.m_dockContainerSet.remove(container);
        JTabbedPane tabbedPane = (JTabbedPane)this.m_component;
        int index = tabbedPane.indexOfComponent(container.getComponent());
        if (container instanceof DockComponent) {
            ((DockComponent)container).removeDockComponentListener();
        }
        tabbedPane.remove(index);
        container.setParent(null);
        this.removeIfEmpty();
    }

    @Override
    public boolean isEmpty() {
        return this.m_dockContainerSet.isEmpty();
    }

    @Override
    public DockContainerTab searchTab(int idContainer) {
        if (idContainer == -1) {
            return this;
        }
        if (idContainer == this.getId()) {
            return this;
        }
        return null;
    }

    public void removeIfEmpty() {
        if (!this.m_dockContainerSet.isEmpty() || !this.m_canRemoveChildren) {
            return;
        }
        ((DockContainerMulti)this.getParent()).remove(this);
    }

    @Override
    public OverArea getOverArea(Point pointOnScreen) {
        Point localPoint = new Point(pointOnScreen);
        SwingUtilities.convertPointFromScreen(localPoint, this.m_component);
        Rectangle bounds = this.m_component.getBounds();
        bounds.x = 0;
        bounds.y = 0;
        if (!bounds.contains(localPoint)) {
            return null;
        }
        JTabbedPane tabbedPane = (JTabbedPane)this.m_component;
        int tabCount = tabbedPane.getTabCount();
        for (int i = 0; i < tabCount; ++i) {
            Component c = tabbedPane.getTabComponentAt(i);
            int MARGIN = 5;
            if (localPoint.x < c.getX() - 5 || localPoint.x > c.getX() + c.getWidth() + 5 || localPoint.y < c.getY() - 5 || localPoint.y > c.getY() + c.getWidth() + 5) continue;
            return new OverArea(this, new DockPosition(i));
        }
        if (localPoint.y < bounds.y + bounds.height / 3) {
            return new OverArea(this, new DockPosition(-4));
        }
        if (localPoint.y > bounds.y + bounds.height * 2 / 3) {
            return new OverArea(this, new DockPosition(-5));
        }
        if (localPoint.x > bounds.x + bounds.width * 2 / 3) {
            return new OverArea(this, new DockPosition(-3));
        }
        if (localPoint.x < bounds.x + bounds.width / 3) {
            return new OverArea(this, new DockPosition(-2));
        }
        return new OverArea(this, new DockPosition(-1));
    }

    @Override
    public void check() {
        for (DockContainer c : this.m_dockContainerSet) {
            if (c.getParent() != this) {
                System.err.println("Wrong Parent");
            }
            if (c.getComponent().getParent() != this.getComponent()) {
                System.err.println("Wrong Parent AWT");
            }
            c.check();
        }
    }
}

