/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.graphics;

import fr.proline.studio.graphics.ColorButton;
import fr.proline.studio.graphics.colorpicker.ColorDataInterface;
import fr.proline.studio.graphics.colorpicker.ColorPalettePanel;
import fr.proline.studio.utils.CyclicColorPalette;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JPanel;

public class ColorButtonAndPalettePanel
extends JPanel
implements ColorDataInterface {
    final int PALETTE_DELTA = 3;
    final int PALETTE_SQUARE_SIZE = 12;
    final int PALETTE_WIDTH = 9;
    private ColorButton m_colorButton = null;

    public ColorButtonAndPalettePanel(ColorButton colorButton) {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(0, 0, 0, 2);
        this.m_colorButton = colorButton;
        this.m_colorButton.addListener(this);
        c.gridx = 0;
        c.gridy = 0;
        this.add((Component)this.m_colorButton, c);
        ColorPalettePanel palettePanel = new ColorPalettePanel(this, CyclicColorPalette.getPalette(), 12, 3, 9);
        ++c.gridx;
        this.add((Component)palettePanel, c);
    }

    public ColorButtonAndPalettePanel() {
        this(new ColorButton());
        this.m_colorButton.initActionListener();
        this.m_colorButton.addListener(this);
    }

    public void setColor(Color c) {
        this.m_colorButton.setColor(c);
    }

    public Color getColor() {
        return this.m_colorButton.getColor();
    }

    @Override
    public void propagateColorChanged(int r, int g, int b) {
        this.m_colorButton.propagateColorChanged(r, g, b);
        this.repaint();
    }

    @Override
    public int getRed() {
        return this.m_colorButton.getRed();
    }

    @Override
    public int getGreen() {
        return this.m_colorButton.getGreen();
    }

    @Override
    public int getBlue() {
        return this.m_colorButton.getBlue();
    }

    @Override
    public void addListener(ColorDataInterface colorDataInterface) {
    }
}

