/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.graphics;

import fr.proline.studio.NbPreferences;
import fr.proline.studio.WindowManager;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.extendedtablemodel.ExtraDataForTableModelInterface;
import fr.proline.studio.extendedtablemodel.LogAdapterModel;
import fr.proline.studio.graphics.Axis;
import fr.proline.studio.graphics.BasePlotPanel;
import fr.proline.studio.graphics.ColorButtonAndPalettePanel;
import fr.proline.studio.graphics.ColorOrGradient;
import fr.proline.studio.graphics.ColorOrGradientChooserPanel;
import fr.proline.studio.graphics.CrossSelectionInterface;
import fr.proline.studio.graphics.GraphicDataGroup;
import fr.proline.studio.graphics.PlotType;
import fr.proline.studio.graphics.PlotXYAbstract;
import fr.proline.studio.graphics.ReferenceIdName;
import fr.proline.studio.graphics.XAxis;
import fr.proline.studio.graphics.YAxis;
import fr.proline.studio.graphics.core.PlotToolbarListenerInterface;
import fr.proline.studio.graphics.cursor.AbstractCursor;
import fr.proline.studio.graphics.cursor.CursorInfo;
import fr.proline.studio.graphics.cursor.CursorInfoList;
import fr.proline.studio.graphics.cursor.HorizontalCursor;
import fr.proline.studio.graphics.cursor.VerticalCursor;
import fr.proline.studio.graphics.marker.AbstractMarker;
import fr.proline.studio.graphics.marker.LabelMarker;
import fr.proline.studio.graphics.marker.coordinates.PercentageCoordinates;
import fr.proline.studio.graphics.measurement.WidthMeasurement;
import fr.proline.studio.parameter.AbstractLinkedParameters;
import fr.proline.studio.parameter.ColorOrGradientParameter;
import fr.proline.studio.parameter.ColorParameter;
import fr.proline.studio.parameter.DefaultParameterDialog;
import fr.proline.studio.parameter.DoubleParameter;
import fr.proline.studio.parameter.IntegerParameter;
import fr.proline.studio.parameter.ObjectParameter;
import fr.proline.studio.parameter.ParameterList;
import fr.proline.studio.parameter.StringParameter;
import fr.proline.studio.utils.CyclicColorPalette;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Path2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Random;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSlider;
import javax.swing.JTextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlotScatter
extends PlotXYAbstract
implements Axis.EnumXInterface,
Axis.EnumYInterface {
    protected static final Logger logger = LoggerFactory.getLogger((String)"ProlineStudio.Common");
    protected double m_xMin;
    protected double m_xMax;
    protected double m_yMin;
    protected double m_yMax;
    protected double[] m_dataX;
    protected double[] m_dataY;
    protected int[] m_jitterX;
    protected int[] m_jitterY;
    private String[] m_enumX;
    private String[] m_enumY;
    private double m_gradientParamValuesMin;
    private double m_gradientParamValuesMax;
    private double[] m_gradientParamValues;
    private int m_gradientParamCol = -1;
    private Color[] m_gradientColors;
    private float[] m_gradientFractions;
    protected boolean[] m_selected;
    private long[] m_ids;
    private HashMap<Long, Integer> m_idToIndex;
    public static final String PLOT_PARAMETER_LIST_KEY = "Plots";
    public static final int LOG_SUPPRESS_VALUES = 0;
    public static final int LOG_REPLACE_VALUES = 1;
    public static final int DEFAULT_LOG_ALGO = 0;
    public static final String LOG_ALGO_KEY = "Log_Algo";
    public static final String LOG_ALGO_NAME = "Log Axis Algorithm";
    public static final String LOG_ALGO_OPTION1 = "Suppress Negative and Null values";
    public static final String LOG_ALGO_OPTION2 = "Replace Negative and Null Values";
    public static final String DEFAULT_LOG_REPLACE_VALUE_KEY = "Replacement_Value";
    public static final String DEFAULT_LOG_REPLACE_VALUE_NAME = "Replacement Value";
    private static final int SELECT_SENSIBILITY = 8;
    private static final String PLOT_SCATTER_COLOR_KEY = "PLOT_SCATTER_COLOR";
    private static final String PLOT_SCATTER_X_JITTER_KEY = "PLOT_SCATTER_X_JITTER";
    private static final String PLOT_SCATTER_Y_JITTER_KEY = "PLOT_SCATTER_Y_JITTER";
    private final ColorOrGradientParameter m_colorParameter;
    private final IntegerParameter m_jitterXParameter;
    private final IntegerParameter m_jitterYParameter;
    private final ObjectParameter m_logAlgoParameter;
    private final DoubleParameter m_replaceValue;
    private ArrayList<ParameterList> m_parameterListArray = null;
    private final LinkedList<GraphicDataGroup> m_dataGroup = new LinkedList();
    private final HashMap<Long, GraphicDataGroup> m_idsToGraphicDataGroup = new HashMap();
    private final HashMap<GraphicDataGroup, LinkedHashSet<Long>> m_graphicDataGroupToId = new HashMap();
    private StringBuilder m_sb = null;

    public PlotScatter(BasePlotPanel plotPanel, ExtendedTableModelInterface compareDataInterface, CrossSelectionInterface crossSelectionInterface, int colX, int colY) {
        super(plotPanel, PlotType.SCATTER_PLOT, compareDataInterface, crossSelectionInterface);
        int[] cols = new int[]{colX, colY};
        ParameterList colorParameteList = new ParameterList("Colors");
        ColorOrGradient colorOrGradient = new ColorOrGradient();
        colorOrGradient.setColor(CyclicColorPalette.getColor(21, 128));
        float[] fractions = new float[]{0.0f, 1.0f};
        Color[] colors = new Color[]{Color.white, Color.red};
        LinearGradientPaint gradient = ColorOrGradientChooserPanel.getGradientForPanel(colors, fractions);
        colorOrGradient.setGradient(gradient);
        this.m_colorParameter = new ColorOrGradientParameter(PLOT_SCATTER_COLOR_KEY, "Scatter Plot Color", colorOrGradient, null);
        colorParameteList.add(this.m_colorParameter);
        ParameterList settingsParameterList = new ParameterList("Settings");
        this.m_jitterXParameter = new IntegerParameter(PLOT_SCATTER_X_JITTER_KEY, "X Jitter", JSlider.class, (Integer)0, (Integer)0, (Integer)20);
        this.m_jitterYParameter = new IntegerParameter(PLOT_SCATTER_Y_JITTER_KEY, "Y Jitter", JSlider.class, (Integer)0, (Integer)0, (Integer)20);
        settingsParameterList.add(this.m_jitterXParameter);
        settingsParameterList.add(this.m_jitterYParameter);
        ParameterList plotParameterList = new ParameterList(PLOT_PARAMETER_LIST_KEY);
        Object[] logOptions = new Object[]{LOG_ALGO_OPTION1, LOG_ALGO_OPTION2};
        JComboBox<Object> comboBox = new JComboBox<Object>(logOptions);
        Object[] objectTable = new Object[]{0, 1};
        this.m_logAlgoParameter = new ObjectParameter<Object>(LOG_ALGO_KEY, LOG_ALGO_NAME, comboBox, logOptions, objectTable, 0, null);
        plotParameterList.add(this.m_logAlgoParameter);
        this.m_replaceValue = new DoubleParameter(DEFAULT_LOG_REPLACE_VALUE_KEY, DEFAULT_LOG_REPLACE_VALUE_NAME, JTextField.class, new Double(1.0), new Double(1.0E-13), new Double(1.0E15));
        plotParameterList.add(this.m_replaceValue);
        plotParameterList.loadParameters(NbPreferences.root());
        AbstractLinkedParameters linkedParameters = new AbstractLinkedParameters(plotParameterList){

            @Override
            public void valueChanged(String value, Object associatedValue) {
                double valueDouble = Double.parseDouble(PlotScatter.this.m_replaceValue.getStringValue());
                int selection = Integer.parseInt(PlotScatter.this.m_logAlgoParameter.getStringValue());
                this.showParameter(PlotScatter.this.m_replaceValue, selection == 1, valueDouble);
                this.updateParameterListPanel();
            }
        };
        this.m_logAlgoParameter.addLinkedParameters(linkedParameters);
        this.update(cols, null);
        int selection = Integer.parseInt(this.m_logAlgoParameter.getStringValue());
        linkedParameters.valueChanged((String)logOptions[selection], objectTable[selection]);
        this.m_parameterListArray = new ArrayList(2);
        this.m_parameterListArray.add(colorParameteList);
        this.m_parameterListArray.add(settingsParameterList);
        this.m_parameterListArray.add(plotParameterList);
        this.addMeasurement(new WidthMeasurement(this));
        this.m_plotPanel.enableButton(PlotToolbarListenerInterface.BUTTONS.VIEW_ALL_MAP, true);
    }

    @Override
    public ArrayList<ParameterList> getParameters() {
        ArrayList<ReferenceIdName> m_potentialGradientParamArray = new ArrayList<ReferenceIdName>();
        HashSet<Class> acceptedValues = this.m_plotType.getAcceptedValuesAsParam();
        int nbCol = this.m_compareDataInterface.getColumnCount();
        for (int i = 0; i < nbCol; ++i) {
            Class c = this.m_compareDataInterface.getDataColumnClass(i);
            if (!acceptedValues.contains(c)) continue;
            ReferenceIdName ref = new ReferenceIdName(this.m_compareDataInterface.getDataColumnIdentifier(i), i);
            m_potentialGradientParamArray.add(ref);
        }
        this.m_colorParameter.setGradientParam(m_potentialGradientParamArray);
        return this.m_parameterListArray;
    }

    @Override
    public String getToolTipText(double x, double y) {
        boolean yAsEnum;
        boolean xAsEnum;
        int infoColumn;
        int indexFound = this.findPoint(x, y);
        if (indexFound == -1) {
            return null;
        }
        if (this.m_sb == null) {
            this.m_sb = new StringBuilder();
        }
        String infoValue = (infoColumn = this.m_compareDataInterface.getInfoColumn()) == this.m_cols[0] ? ((xAsEnum = this.m_plotPanel.getXAxis().isEnum()) ? this.getEnumValueX(indexFound, true) : this.m_compareDataInterface.getDataValueAt(indexFound, this.m_compareDataInterface.getInfoColumn()).toString()) : (infoColumn == this.m_cols[1] ? ((yAsEnum = this.m_plotPanel.getYAxis().isEnum()) ? this.getEnumValueY(indexFound, true, this.m_plotPanel.getYAxis()) : this.m_compareDataInterface.getDataValueAt(indexFound, this.m_compareDataInterface.getInfoColumn()).toString()) : this.m_compareDataInterface.getDataValueAt(indexFound, this.m_compareDataInterface.getInfoColumn()).toString());
        this.m_sb.append(infoValue);
        this.m_sb.append("<BR>");
        this.m_sb.append(this.m_plotPanel.getXAxis().getTitle());
        this.m_sb.append(" : ");
        xAsEnum = this.m_plotPanel.getXAxis().isEnum();
        if (xAsEnum) {
            this.m_sb.append(this.getEnumValueX(indexFound, true));
        } else {
            this.m_sb.append(this.m_plotPanel.getXAxis().getExternalDecimalFormat().format(this.m_dataX[indexFound]));
        }
        this.m_sb.append("<BR>");
        this.m_sb.append(this.m_plotPanel.getYAxis().getTitle());
        this.m_sb.append(" : ");
        boolean yAsEnum2 = this.m_plotPanel.getYAxis().isEnum();
        if (yAsEnum2) {
            this.m_sb.append(this.getEnumValueY(indexFound, true, this.m_plotPanel.getYAxis()));
        } else {
            this.m_sb.append(this.m_plotPanel.getYAxis().getExternalDecimalFormat().format(this.m_dataY[indexFound]));
        }
        String tooltip = this.m_sb.toString();
        this.m_sb.setLength(0);
        return tooltip;
    }

    @Override
    public boolean select(double x, double y, boolean append) {
        int indexFound = this.findPoint(x, y);
        int size = this.m_dataX.length;
        if (!append) {
            for (int i = 0; i < size; ++i) {
                this.m_selected[i] = false;
            }
        }
        if (indexFound != -1) {
            this.m_selected[indexFound] = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean select(Path2D.Double path, double minX, double maxX, double minY, double maxY, boolean append) {
        boolean aSelection = false;
        int size = this.m_dataX.length;
        for (int i = 0; i < size; ++i) {
            double dataX = this.m_dataX[i];
            double dataY = this.m_dataY[i];
            if (dataX < minX || dataX > maxX || dataY < minY || dataY > maxY) {
                if (append) continue;
                this.m_selected[i] = false;
                continue;
            }
            if (path.contains(dataX, dataY)) {
                this.m_selected[i] = true;
                aSelection = true;
                continue;
            }
            if (append) continue;
            this.m_selected[i] = false;
        }
        return aSelection;
    }

    @Override
    public ArrayList<Long> getSelectedIds() {
        ArrayList<Long> selection = new ArrayList<Long>();
        for (int i = 0; i < this.m_selected.length; ++i) {
            if (!this.m_selected[i]) continue;
            selection.add(this.m_ids[i]);
        }
        return selection;
    }

    @Override
    public void setSelectedIds(ArrayList<Long> selectedIds) {
        int i;
        for (i = 0; i < this.m_selected.length; ++i) {
            this.m_selected[i] = false;
        }
        for (i = 0; i < selectedIds.size(); ++i) {
            Integer index = this.m_idToIndex.get(selectedIds.get(i));
            if (index == null) continue;
            this.m_selected[index.intValue()] = true;
        }
    }

    protected int findPoint(double x, double y) {
        double rangeX = this.m_xMax - this.m_xMin;
        double rangeY = this.m_yMax - this.m_yMin;
        double distanceMin = Double.MAX_VALUE;
        int nearestDataIndex = -1;
        int size = this.m_dataX == null ? 0 : this.m_dataX.length;
        for (int i = size - 1; i >= 0; --i) {
            double squaredDistance;
            double normalizedDistanceY;
            double normalizedDistanceX;
            double dataX = this.m_dataX[i];
            double dataY = this.m_dataY[i];
            if (this.m_jitterX != null) {
                XAxis xAxis = this.m_plotPanel.getXAxis();
                int xWithJitter = xAxis.valueToPixel(dataX) + this.m_jitterX[i];
                dataX = xAxis.pixelToValue(xWithJitter);
            }
            if (this.m_jitterY != null) {
                YAxis yAxis = this.m_plotPanel.getYAxis();
                int yWithJitter = yAxis.valueToPixel(dataY) + this.m_jitterY[i];
                dataY = yAxis.pixelToValue(yWithJitter);
            }
            double d = normalizedDistanceX = rangeX <= 1.0E-9 ? 0.0 : (x - dataX) / rangeX;
            if (normalizedDistanceX < 0.0) {
                normalizedDistanceX = -normalizedDistanceX;
            }
            double d2 = normalizedDistanceY = rangeY <= 1.0E-9 ? 0.0 : (y - dataY) / rangeY;
            if (normalizedDistanceY < 0.0) {
                normalizedDistanceY = -normalizedDistanceY;
            }
            if (!(distanceMin > (squaredDistance = normalizedDistanceX * normalizedDistanceX + normalizedDistanceY * normalizedDistanceY))) continue;
            distanceMin = squaredDistance;
            nearestDataIndex = i;
        }
        if (nearestDataIndex != -1) {
            int jitterY;
            int jitterX;
            int n = jitterX = this.m_jitterX == null ? 0 : this.m_jitterX[nearestDataIndex];
            if (Math.abs(this.m_plotPanel.getXAxis().valueToPixel(x) - this.m_plotPanel.getXAxis().valueToPixel(this.m_dataX[nearestDataIndex]) - jitterX) > 8) {
                return -1;
            }
            int n2 = jitterY = this.m_jitterY == null ? 0 : this.m_jitterY[nearestDataIndex];
            if (Math.abs(this.m_plotPanel.getYAxis().valueToPixel(y) - this.m_plotPanel.getYAxis().valueToPixel(this.m_dataY[nearestDataIndex]) - jitterY) > 8) {
                return -1;
            }
        }
        return nearestDataIndex;
    }

    @Override
    public double getNearestXData(double x) {
        double distanceMin = Double.MAX_VALUE;
        int nearestDataIndex = -1;
        int size = this.m_dataX == null ? 0 : this.m_dataX.length;
        for (int i = size - 1; i >= 0; --i) {
            double dataX = this.m_dataX[i];
            double distanceX = x - dataX;
            if (distanceX < 0.0) {
                distanceX = -distanceX;
            }
            if (!(distanceMin > distanceX)) continue;
            distanceMin = distanceX;
            nearestDataIndex = i;
        }
        if (nearestDataIndex != -1) {
            return this.m_dataX[nearestDataIndex];
        }
        return x;
    }

    @Override
    public double getNearestYData(double y) {
        double distanceMin = Double.MAX_VALUE;
        int nearestDataIndex = -1;
        int size = this.m_dataY == null ? 0 : this.m_dataY.length;
        for (int i = size - 1; i >= 0; --i) {
            double dataY = this.m_dataY[i];
            double distanceY = y - dataY;
            if (distanceY < 0.0) {
                distanceY = -distanceY;
            }
            if (!(distanceMin > distanceY)) continue;
            distanceMin = distanceY;
            nearestDataIndex = i;
        }
        if (nearestDataIndex != -1) {
            return this.m_dataY[nearestDataIndex];
        }
        return y;
    }

    @Override
    public void parametersChanged() {
        boolean log;
        this.updateJitter();
        boolean logX = this.m_plotPanel.getXAxis().isLog();
        boolean logY = this.m_plotPanel.getYAxis().isLog();
        boolean bl = log = logX || logY;
        if (log) {
            this.update();
        }
    }

    private void updateJitter() {
        int i;
        int modulo;
        Random r;
        if (this.m_compareDataInterface == null) {
            return;
        }
        int size = this.m_compareDataInterface.getRowCount();
        if (size == 0) {
            return;
        }
        if (this.m_jitterXParameter == null || this.m_jitterYParameter == null || this.m_jitterXParameter.getObjectValue() == null || this.m_jitterYParameter.getObjectValue() == null) {
            this.m_jitterX = null;
            this.m_jitterY = null;
            return;
        }
        int jitterX = (Integer)this.m_jitterXParameter.getObjectValue();
        int jitterY = (Integer)this.m_jitterYParameter.getObjectValue();
        if (jitterX > 0) {
            this.m_jitterX = new int[size];
            r = new Random(System.currentTimeMillis());
            modulo = jitterX * 2 + 1;
            for (i = 0; i < size; ++i) {
                this.m_jitterX[i] = r.nextInt(modulo) - jitterX;
            }
        } else {
            this.m_jitterX = null;
        }
        if (jitterY > 0) {
            this.m_jitterY = new int[size];
            r = new Random(System.currentTimeMillis());
            modulo = jitterY * 2 + 1;
            for (i = 0; i < size; ++i) {
                this.m_jitterY[i] = r.nextInt(modulo) - jitterY;
            }
        } else {
            this.m_jitterY = null;
        }
    }

    @Override
    public final void update() {
        int i;
        double minY;
        double minX;
        Integer enumIndexCur;
        String stringValue;
        int enumIndex;
        boolean log;
        int size = this.m_compareDataInterface.getRowCount();
        if (size == 0) {
            return;
        }
        boolean logX = this.m_plotPanel.getXAxis().isLog();
        boolean logY = this.m_plotPanel.getYAxis().isLog();
        boolean bl = log = logX || logY;
        if (log) {
            boolean algoSupressValues;
            String algo = this.m_logAlgoParameter.getStringValue();
            boolean bl2 = algoSupressValues = algo == null || Integer.parseInt(algo) == 0;
            if (!(this.m_compareDataInterface instanceof LogAdapterModel)) {
                this.m_compareDataInterface = new LogAdapterModel(this.m_compareDataInterface);
            }
            if (algoSupressValues) {
                ((LogAdapterModel)this.m_compareDataInterface).update(LogAdapterModel.POLICY.REMOVE_INCORRECT_VALUES, logX ? this.m_cols[0] : -1, logY ? this.m_cols[1] : -1, null);
            } else {
                String value = this.m_replaceValue.getStringValue();
                double replaceValueD = value == null ? 1.0 : Double.parseDouble(value);
                ((LogAdapterModel)this.m_compareDataInterface).update(LogAdapterModel.POLICY.REPLACE_BY_VALUE, logX ? this.m_cols[0] : -1, logY ? this.m_cols[1] : -1, replaceValueD);
            }
        } else if (this.m_compareDataInterface instanceof LogAdapterModel) {
            this.m_compareDataInterface = ((LogAdapterModel)this.m_compareDataInterface).getInnerModel();
        }
        size = this.m_compareDataInterface.getRowCount();
        this.m_dataX = new double[size];
        this.m_dataY = new double[size];
        this.m_selected = new boolean[size];
        this.m_ids = new long[size];
        this.m_idToIndex = new HashMap(size);
        this.updateJitter();
        boolean xAsEnum = this.m_plotPanel.getXAxis().isEnum();
        boolean yAsEnum = this.m_plotPanel.getYAxis().isEnum();
        if (xAsEnum) {
            HashMap<String, Integer> stringToEnumMap = new HashMap<String, Integer>();
            HashMap<Integer, String> enumToStringMap = new HashMap<Integer, String>();
            enumIndex = 0;
            for (int i2 = 0; i2 < size; ++i2) {
                stringValue = this.m_compareDataInterface.getDataValueAt(i2, this.m_cols[0]).toString();
                enumIndexCur = (Integer)stringToEnumMap.get(stringValue);
                if (enumIndexCur == null) {
                    enumIndexCur = enumIndex;
                    stringToEnumMap.put(stringValue, enumIndexCur);
                    enumToStringMap.put(enumIndexCur, stringValue);
                    ++enumIndex;
                }
                this.m_dataX[i2] = enumIndexCur.intValue();
                this.m_selected[i2] = false;
                this.m_ids[i2] = this.m_compareDataInterface.row2UniqueId(i2);
                this.m_idToIndex.put(this.m_ids[i2], i2);
            }
            this.m_enumX = new String[enumToStringMap.size()];
            for (Integer enumI : enumToStringMap.keySet()) {
                this.m_enumX[enumI.intValue()] = (String)enumToStringMap.get(enumI);
            }
        } else {
            for (int i3 = 0; i3 < size; ++i3) {
                Object value = this.m_compareDataInterface.getDataValueAt(i3, this.m_cols[0]);
                this.m_dataX[i3] = value == null || !Number.class.isAssignableFrom(value.getClass()) ? Double.NaN : ((Number)value).doubleValue();
                this.m_selected[i3] = false;
                this.m_ids[i3] = this.m_compareDataInterface.row2UniqueId(i3);
                this.m_idToIndex.put(this.m_ids[i3], i3);
            }
        }
        if (yAsEnum) {
            HashMap<String, Integer> stringToEnumMap = new HashMap<String, Integer>();
            HashMap<Integer, String> enumToStringMap = new HashMap<Integer, String>();
            enumIndex = 0;
            for (int i4 = 0; i4 < size; ++i4) {
                stringValue = this.m_compareDataInterface.getDataValueAt(i4, this.m_cols[1]).toString();
                enumIndexCur = (Integer)stringToEnumMap.get(stringValue);
                if (enumIndexCur == null) {
                    enumIndexCur = enumIndex;
                    stringToEnumMap.put(stringValue, enumIndexCur);
                    enumToStringMap.put(enumIndexCur, stringValue);
                    ++enumIndex;
                }
                this.m_dataY[i4] = enumIndexCur.intValue();
            }
            this.m_enumY = new String[enumToStringMap.size()];
            for (Integer enumI : enumToStringMap.keySet()) {
                this.m_enumY[enumI.intValue()] = (String)enumToStringMap.get(enumI);
            }
        } else {
            for (int i5 = 0; i5 < size; ++i5) {
                Object value = this.m_compareDataInterface.getDataValueAt(i5, this.m_cols[1]);
                this.m_dataY[i5] = value == null || !Number.class.isAssignableFrom(value.getClass()) ? Double.NaN : ((Number)value).doubleValue();
            }
        }
        double maxX = minX = this.m_dataX[0];
        double maxY = minY = this.m_dataY[0];
        for (i = 1; (minX != minX || minY != minY) && i < size; ++i) {
            maxX = minX = this.m_dataX[i];
            maxY = minY = this.m_dataY[i];
        }
        while (i < size) {
            double x = this.m_dataX[i];
            if (x < minX) {
                minX = x;
            } else if (x > maxX) {
                maxX = x;
            }
            double y = this.m_dataY[i];
            if (y < minY) {
                minY = y;
            } else if (y > maxY) {
                maxY = y;
            }
            ++i;
        }
        this.m_xMin = minX;
        this.m_xMax = maxX;
        this.m_yMin = minY;
        this.m_yMax = maxY;
        if (!xAsEnum) {
            if (logX) {
                this.m_xMax *= 2.0;
                this.m_xMin /= 2.0;
            } else {
                double deltaX = this.m_xMax - this.m_xMin;
                if (deltaX <= 1.0E-9) {
                    this.m_xMin -= 1.0;
                    this.m_xMax += 1.0;
                } else {
                    this.m_xMin -= deltaX * 0.01;
                    this.m_xMax += deltaX * 0.01;
                }
            }
        }
        if (!yAsEnum) {
            if (logY) {
                this.m_yMax *= 2.0;
                this.m_yMin /= 2.0;
            } else {
                double deltaY = this.m_yMax - this.m_yMin;
                if (deltaY <= 1.0E-9) {
                    this.m_yMin -= 1.0;
                    this.m_yMax += 1.0;
                } else {
                    this.m_yMin -= deltaY * 0.01;
                    this.m_yMax += deltaY * 0.01;
                }
            }
        }
        this.m_plotPanel.updateAxis(this);
        this.m_plotPanel.setXAxisTitle(this.m_compareDataInterface.getDataColumnIdentifier(this.m_cols[0]));
        this.m_plotPanel.setYAxisTitle(this.m_compareDataInterface.getDataColumnIdentifier(this.m_cols[1]));
        this.removeAllCursors();
        if (this.m_compareDataInterface instanceof ExtraDataForTableModelInterface) {
            AbstractCursor cursor;
            CursorInfoList cursorInfoList = (CursorInfoList)this.m_compareDataInterface.getColValue(CursorInfoList.class, this.m_cols[0]);
            if (cursorInfoList != null) {
                for (CursorInfo info : cursorInfoList.getCursorInfoList()) {
                    cursor = new VerticalCursor(this.m_plotPanel, info.getValue());
                    info.applyParametersToCursor(cursor);
                    this.addCursor(cursor);
                }
            }
            if ((cursorInfoList = (CursorInfoList)this.m_compareDataInterface.getColValue(CursorInfoList.class, this.m_cols[1])) != null) {
                for (CursorInfo info : cursorInfoList.getCursorInfoList()) {
                    cursor = new HorizontalCursor(this.m_plotPanel, info.getValue());
                    info.applyParametersToCursor(cursor);
                    this.addCursor(cursor);
                }
            }
        }
        this.m_plotPanel.repaint();
    }

    private void setGradientValues() {
        double d;
        boolean useGradient;
        ColorOrGradient colorOrGradient = this.m_colorParameter.getColor();
        boolean bl = useGradient = !colorOrGradient.isColorSelected();
        if (!useGradient) {
            return;
        }
        this.m_gradientColors = colorOrGradient.getGradient().getColors();
        this.m_gradientFractions = colorOrGradient.getGradient().getFractions();
        int gradientParamCol = this.m_colorParameter.getSelectedReferenceIdName().getColumnIndex();
        if (gradientParamCol == this.m_gradientParamCol) {
            return;
        }
        this.m_gradientParamCol = gradientParamCol;
        int size = this.m_compareDataInterface.getRowCount();
        if (this.m_gradientParamValues == null || this.m_gradientParamValues.length != size) {
            this.m_gradientParamValues = new double[size];
        }
        if (size == 0) {
            return;
        }
        Object value = this.m_compareDataInterface.getDataValueAt(0, this.m_gradientParamCol);
        this.m_gradientParamValues[0] = d = value == null || !Number.class.isAssignableFrom(value.getClass()) ? Double.NaN : ((Number)value).doubleValue();
        this.m_gradientParamValuesMin = d;
        this.m_gradientParamValuesMax = d;
        for (int i = 1; i < size; ++i) {
            value = this.m_compareDataInterface.getDataValueAt(i, this.m_gradientParamCol);
            this.m_gradientParamValues[i] = d = value == null || !Number.class.isAssignableFrom(value.getClass()) ? Double.NaN : ((Number)value).doubleValue();
            if (d < this.m_gradientParamValuesMin) {
                this.m_gradientParamValuesMin = d;
                continue;
            }
            if (!(d > this.m_gradientParamValuesMax)) continue;
            this.m_gradientParamValuesMax = d;
        }
    }

    private Color getColorInGradient(double d) {
        double f = (d - this.m_gradientParamValuesMin) / (this.m_gradientParamValuesMax - this.m_gradientParamValuesMin);
        for (int i = 0; i < this.m_gradientFractions.length - 1; ++i) {
            float f1 = this.m_gradientFractions[i];
            float f2 = this.m_gradientFractions[i + 1];
            if (!(f >= (double)f1) || !(f <= (double)f2)) continue;
            Color c1 = this.m_gradientColors[i];
            Color c2 = this.m_gradientColors[i + 1];
            double fInInterval = (f - (double)f1) / (double)(f2 - f1);
            int r = (int)Math.round((double)(c2.getRed() - c1.getRed()) * fInInterval + (double)c1.getRed());
            int g = (int)Math.round((double)(c2.getGreen() - c1.getGreen()) * fInInterval + (double)c1.getGreen());
            int b = (int)Math.round((double)(c2.getBlue() - c1.getBlue()) * fInInterval + (double)c1.getBlue());
            int a = (int)Math.round((double)(c2.getAlpha() - c1.getAlpha()) * fInInterval + (double)c1.getAlpha());
            return new Color(r, g, b, a);
        }
        if (f <= (double)this.m_gradientFractions[0]) {
            return this.m_gradientColors[0];
        }
        return this.m_gradientColors[this.m_gradientFractions.length - 1];
    }

    @Override
    public double getXMin() {
        return this.m_xMin;
    }

    @Override
    public double getXMax() {
        return this.m_xMax;
    }

    @Override
    public double getYMin() {
        return this.m_yMin;
    }

    @Override
    public double getYMax() {
        return this.m_yMax;
    }

    @Override
    public void paint(Graphics2D g, XAxis xAxis, YAxis yAxis) {
        Color c;
        int y;
        int x;
        int i;
        int clipX = xAxis.valueToPixel(xAxis.getMinValue());
        int clipWidth = xAxis.valueToPixel(xAxis.getMaxValue()) - clipX;
        int clipY = yAxis.valueToPixel(yAxis.getMaxValue());
        int clipHeight = yAxis.valueToPixel(yAxis.getMinValue()) - clipY;
        g.setClip(clipX, clipY, clipWidth, clipHeight);
        boolean isLog = xAxis.isLog() || yAxis.isLog();
        ColorOrGradient colorOrGradient = this.m_colorParameter.getColor();
        boolean useGradient = !colorOrGradient.isColorSelected();
        Color plotColor = Color.black;
        if (!useGradient) {
            plotColor = colorOrGradient.getColor();
        } else {
            this.setGradientValues();
        }
        int size = this.m_dataX != null ? this.m_dataX.length : 0;
        for (i = 0; i < size; ++i) {
            if (this.m_selected[i]) continue;
            x = xAxis.valueToPixel(this.m_dataX[i]) + (this.m_jitterX != null ? this.m_jitterX[i] : 0);
            y = yAxis.valueToPixel(this.m_dataY[i]) + (this.m_jitterY != null ? this.m_jitterY[i] : 0);
            c = null;
            c = isLog && ((LogAdapterModel)this.m_compareDataInterface).isOnError(i) ? Color.red : this.selectColor(plotColor, useGradient, i);
            g.setColor(c);
            g.fillOval(x - 3, y - 3, 6, 6);
        }
        for (i = 0; i < size; ++i) {
            if (!this.m_selected[i]) continue;
            x = xAxis.valueToPixel(this.m_dataX[i]) + (this.m_jitterX != null ? this.m_jitterX[i] : 0);
            y = yAxis.valueToPixel(this.m_dataY[i]) + (this.m_jitterY != null ? this.m_jitterY[i] : 0);
            c = this.selectColor(plotColor, useGradient, i);
            g.setColor(c);
            g.fillOval(x - 3, y - 3, 6, 6);
            g.setColor(Color.black);
            g.drawOval(x - 3, y - 3, 6, 6);
        }
    }

    private Color selectColor(Color plotColor, boolean useGradient, int i) {
        GraphicDataGroup dataGroup;
        Color c = null;
        c = !this.m_idsToGraphicDataGroup.isEmpty() ? ((dataGroup = this.m_idsToGraphicDataGroup.get(this.m_ids[i])) != null ? dataGroup.getColor() : (useGradient ? this.getColorInGradient(this.m_gradientParamValues[i]) : plotColor)) : (useGradient ? this.getColorInGradient(this.m_gradientParamValues[i]) : plotColor);
        return c;
    }

    @Override
    public boolean getDoubleBufferingPolicy() {
        return this.m_dataX != null && this.m_dataX.length > 2000;
    }

    @Override
    public boolean needsXAxis() {
        return true;
    }

    @Override
    public boolean needsYAxis() {
        return true;
    }

    @Override
    public boolean canLogXAxis() {
        return true;
    }

    @Override
    public boolean canLogYAxis() {
        return true;
    }

    @Override
    public boolean isMouseOnPlot(double x, double y) {
        return this.findPoint(x, y) != -1;
    }

    @Override
    public boolean isMouseOnSelectedPlot(double x, double y) {
        int index = this.findPoint(x, y);
        if (index == -1) {
            return false;
        }
        return this.m_selected[index];
    }

    @Override
    public JPopupMenu getPopupMenu(final double x, final double y) {
        boolean isOverCursor;
        boolean onSelection = false;
        int index = this.findPoint(x, y);
        if (index != -1) {
            onSelection = this.m_selected[index];
        }
        long id = index == -1 ? -1L : this.m_ids[index];
        final GraphicDataGroup group = id == -1L ? null : this.m_idsToGraphicDataGroup.get(id);
        JMenuItem addGroupAction = new JMenuItem("Add Group");
        addGroupAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList<ParameterList> parameterListArray = new ArrayList<ParameterList>(1);
                ParameterList groupParameterList = new ParameterList("Define Group");
                parameterListArray.add(groupParameterList);
                StringParameter groupNameParameter = new StringParameter("GroupName", "Group Name", JTextField.class, "", (Integer)0, (Integer)32);
                groupParameterList.add(groupNameParameter);
                Color defaultColor = CyclicColorPalette.getColor(21, 128);
                ColorParameter colorParameter = new ColorParameter("GroupColorParameter", "Color", defaultColor, ColorButtonAndPalettePanel.class);
                groupParameterList.add(colorParameter);
                DefaultParameterDialog parameterDialog = new DefaultParameterDialog((Window)WindowManager.getDefault().getMainWindow(), "Plot Parameters", parameterListArray);
                parameterDialog.setLocationRelativeTo(PlotScatter.this.m_plotPanel);
                parameterDialog.setVisible(true);
                if (parameterDialog.getButtonClicked() == 0) {
                    String groupName = groupNameParameter.getStringValue();
                    Color c = colorParameter.getColor();
                    GraphicDataGroup dataGroup = new GraphicDataGroup(groupName, c);
                    PlotScatter.this.m_dataGroup.addFirst(dataGroup);
                    LinkedHashSet<Long> selectedIds = new LinkedHashSet<Long>();
                    for (int i = 0; i < PlotScatter.this.m_selected.length; ++i) {
                        if (!PlotScatter.this.m_selected[i]) continue;
                        long id = PlotScatter.this.m_ids[i];
                        GraphicDataGroup oldGroup = (GraphicDataGroup)PlotScatter.this.m_idsToGraphicDataGroup.get(id);
                        if (oldGroup != null) {
                            ((LinkedHashSet)PlotScatter.this.m_graphicDataGroupToId.get(oldGroup)).remove(id);
                        }
                        PlotScatter.this.m_idsToGraphicDataGroup.put(id, dataGroup);
                        selectedIds.add(id);
                    }
                    PlotScatter.this.m_graphicDataGroupToId.put(dataGroup, selectedIds);
                    String name = dataGroup.getName();
                    if (name != null && !name.isEmpty()) {
                        double percentageY = 1.0 - 0.1 * (double)PlotScatter.this.m_dataGroup.size();
                        if (percentageY < 0.1) {
                            percentageY = 0.1;
                        }
                        LabelMarker marker = new LabelMarker(PlotScatter.this.m_plotPanel, new PercentageCoordinates(0.9, percentageY), dataGroup.getName(), 2, 2, dataGroup.getColor());
                        dataGroup.setAssociatedMarker(marker);
                        PlotScatter.this.addMarker(marker);
                    }
                    PlotScatter.this.m_plotPanel.repaintUpdateDoubleBuffer();
                }
            }
        });
        addGroupAction.setEnabled(onSelection);
        JMenuItem selectGroupAction = new JMenuItem("Select Group");
        selectGroupAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int size = PlotScatter.this.m_selected.length;
                for (int i = 0; i < size; ++i) {
                    PlotScatter.this.m_selected[i] = false;
                }
                LinkedHashSet ids = (LinkedHashSet)PlotScatter.this.m_graphicDataGroupToId.get(group);
                for (Long id : ids) {
                    int index = (Integer)PlotScatter.this.m_idToIndex.get(id);
                    PlotScatter.this.m_selected[index] = true;
                }
                PlotScatter.this.m_plotPanel.repaintUpdateDoubleBuffer();
            }
        });
        selectGroupAction.setEnabled(group != null);
        JMenuItem deleteGroupAction = new JMenuItem("Delete Group");
        deleteGroupAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LinkedHashSet ids = (LinkedHashSet)PlotScatter.this.m_graphicDataGroupToId.get(group);
                for (Long id : ids) {
                    PlotScatter.this.m_idsToGraphicDataGroup.remove(id);
                }
                PlotScatter.this.m_graphicDataGroupToId.remove(group);
                PlotScatter.this.m_dataGroup.remove(group);
                AbstractMarker marker = group.getAssociatedMarker();
                if (marker != null) {
                    PlotScatter.this.removeMarker(marker);
                }
                PlotScatter.this.m_plotPanel.repaintUpdateDoubleBuffer();
            }
        });
        deleteGroupAction.setEnabled(group != null);
        final AbstractCursor cursor = this.getOverCursor(this.m_plotPanel.getXAxis().valueToPixel(x), this.m_plotPanel.getYAxis().valueToPixel(y));
        boolean bl = isOverCursor = cursor != null;
        if (isOverCursor) {
            this.selectCursor(cursor);
        }
        JMenuItem addVerticalCursorAction = new JMenuItem("Add Vertical Cursor");
        addVerticalCursorAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VerticalCursor c = new VerticalCursor(PlotScatter.this.m_plotPanel, x);
                PlotScatter.this.addCursor(c);
                PlotScatter.this.m_plotPanel.repaint();
            }
        });
        JMenuItem addHorizontalCursorAction = new JMenuItem("Add Horizontal Cursor");
        addHorizontalCursorAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HorizontalCursor c = new HorizontalCursor(PlotScatter.this.m_plotPanel, y);
                PlotScatter.this.addCursor(c);
                PlotScatter.this.m_plotPanel.repaint();
            }
        });
        addVerticalCursorAction.setEnabled(!isOverCursor);
        addHorizontalCursorAction.setEnabled(!isOverCursor);
        JMenuItem deleteCursorAction = new JMenuItem("Delete Cursor");
        deleteCursorAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlotScatter.this.removeCursor(cursor);
                PlotScatter.this.m_plotPanel.repaint();
            }
        });
        deleteCursorAction.setEnabled(isOverCursor);
        JCheckBoxMenuItem snapToDataMenuItem = null;
        if (isOverCursor) {
            snapToDataMenuItem = new JCheckBoxMenuItem("Snap to Data");
            snapToDataMenuItem.setSelected(cursor.isSnapToData());
            snapToDataMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    cursor.toggleSnapToData();
                }
            });
        }
        JPopupMenu menu = new JPopupMenu();
        menu.add(addGroupAction);
        menu.add(selectGroupAction);
        menu.add(deleteGroupAction);
        menu.addSeparator();
        menu.add(addVerticalCursorAction);
        menu.add(addHorizontalCursorAction);
        menu.add(deleteCursorAction);
        if (snapToDataMenuItem != null) {
            menu.add(snapToDataMenuItem);
        }
        return menu;
    }

    @Override
    public String getEnumValueX(int index, boolean fromData) {
        if (fromData) {
            if (index < 0 || index >= this.m_dataX.length) {
                return "";
            }
            return this.m_enumX[(int)Math.round(this.m_dataX[index])];
        }
        if (index < 0 || index >= this.m_enumX.length) {
            return "";
        }
        return this.m_enumX[index];
    }

    @Override
    public String getEnumValueY(int index, boolean fromData, Axis axis) {
        if (fromData) {
            if (index < 0 || index >= this.m_dataY.length) {
                return "";
            }
            return this.m_enumY[(int)Math.round(this.m_dataY[index])];
        }
        if (index < 0 || index >= this.m_enumY.length) {
            return "";
        }
        return this.m_enumY[index];
    }
}

