/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class StringChooserPanel
extends JPanel {
    private final ArrayList<JRadioButton> m_radioButtonList = new ArrayList();
    private String[] m_possibilities = null;
    private JTextField m_userTextField = null;
    private ActionListener m_actionListener = null;

    public StringChooserPanel(String[] possibilitiesName, String[] possibilities, int width, String defaultValue, boolean useUserTextField) {
        super(new GridBagLayout());
        this.m_possibilities = possibilities;
        ButtonGroup buttonGroup = new ButtonGroup();
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridwidth = 2;
        ActionListener radioButtonAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (StringChooserPanel.this.m_userTextField != null) {
                    StringChooserPanel.this.m_userTextField.setEnabled(false);
                }
                if (StringChooserPanel.this.m_actionListener != null) {
                    StringChooserPanel.this.m_actionListener.actionPerformed(null);
                }
            }
        };
        int nbChoices = possibilitiesName.length;
        for (int i = 0; i < nbChoices; ++i) {
            JRadioButton radioButton = new JRadioButton(possibilitiesName[i]);
            radioButton.addActionListener(radioButtonAction);
            c.gridx = i % width * 2;
            c.gridy = i / width;
            this.m_radioButtonList.add(radioButton);
            this.add((Component)radioButton, c);
            buttonGroup.add(radioButton);
        }
        if (useUserTextField) {
            final JRadioButton radioButton = new JRadioButton("Other");
            radioButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StringChooserPanel.this.m_userTextField.setEnabled(true);
                    StringChooserPanel.this.m_userTextField.requestFocus();
                    if (StringChooserPanel.this.m_actionListener != null) {
                        StringChooserPanel.this.m_actionListener.actionPerformed(null);
                    }
                }
            });
            c.gridx = nbChoices % width * 2;
            c.gridy = nbChoices / width;
            if (c.gridx > 0) {
                c.gridx = 0;
                ++c.gridy;
            }
            c.gridwidth = 1;
            this.add((Component)radioButton, c);
            this.m_radioButtonList.add(radioButton);
            buttonGroup.add(radioButton);
            MouseAdapter actionOnTextFieldClick = new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    radioButton.setSelected(true);
                    StringChooserPanel.this.m_userTextField.setEnabled(true);
                    StringChooserPanel.this.m_userTextField.requestFocusInWindow();
                    if (StringChooserPanel.this.m_actionListener != null) {
                        StringChooserPanel.this.m_actionListener.actionPerformed(null);
                    }
                }
            };
            this.m_userTextField = new JTextField();
            this.m_userTextField.addMouseListener(actionOnTextFieldClick);
            this.m_userTextField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.textChanged();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.textChanged();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.textChanged();
                }

                public void textChanged() {
                    if (StringChooserPanel.this.m_actionListener != null) {
                        StringChooserPanel.this.m_actionListener.actionPerformed(null);
                    }
                }
            });
            this.m_userTextField.setEnabled(false);
            ++c.gridx;
            c.weightx = 1.0;
            c.gridwidth = width * 2 - 1;
            this.add((Component)this.m_userTextField, c);
        }
        this.setText(defaultValue);
    }

    public String getText() {
        int nbChoices = this.m_radioButtonList.size();
        for (int i = 0; i < nbChoices; ++i) {
            if (!this.m_radioButtonList.get(i).isSelected()) continue;
            if (i == nbChoices - 1 && this.m_userTextField != null) {
                return this.m_userTextField.getText();
            }
            return this.m_possibilities[i];
        }
        return "";
    }

    public void setText(String t) {
        if (t == null) {
            t = "";
        }
        int nbChoices = this.m_possibilities.length;
        for (int i = 0; i < nbChoices; ++i) {
            String curText = this.m_possibilities[i];
            if (curText.compareTo(t) != 0) continue;
            this.m_radioButtonList.get(i).setSelected(true);
            return;
        }
        if (this.m_userTextField != null) {
            this.m_radioButtonList.get(this.m_radioButtonList.size() - 1).setSelected(true);
            this.m_userTextField.setText(t);
        }
    }

    public void setActionListener(ActionListener a) {
        this.m_actionListener = a;
    }
}

