/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.gui.expressionbuilder;

import fr.proline.studio.gui.expressionbuilder.ExpressionEntity;
import fr.proline.studio.gui.expressionbuilder.ExpressionEntityTree;
import fr.proline.studio.utils.IconManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.jdesktop.swingx.JXTextField;

public class ExpressionBuilderPanel
extends JPanel {
    private final ArrayList<ExpressionEntity> m_builtExpression = new ArrayList();
    private final ArrayList<ExpressionEntity> m_redoExpression = new ArrayList();
    private HashMap<Integer, JButton> m_shortCuts = new HashMap();
    private ExpressionEntity m_entityPlus;
    private ExpressionEntity m_entityMinus;
    private final JPanel m_functionsPanel;
    private final JPanel m_calcPanel;
    private GridBagConstraints m_numberPanelC;
    private final JPanel m_variablesListPanel;
    private ExpressionEntityTree m_functionTree;
    private ExpressionEntityTree m_variableTree;
    private JTextField m_expressionTextField;
    private JButton m_redoButton;
    private JButton m_undoButton;
    private JButton m_clearButton;
    private int m_nbButtonsHorizontal;

    public ExpressionBuilderPanel(int nbButtonsHorizontal) {
        this.setBorder(BorderFactory.createTitledBorder(" Expression Builder "));
        this.setLayout(new GridBagLayout());
        this.m_nbButtonsHorizontal = nbButtonsHorizontal;
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(2, 2, 2, 2);
        c.fill = 1;
        c.anchor = 18;
        JPanel expressionPanel = this.createExpressionPanel();
        this.m_functionsPanel = this.createFunctionPanel();
        this.m_variablesListPanel = this.createVariablesPanel();
        this.m_calcPanel = this.createNumberPanel();
        c.gridx = 0;
        c.gridwidth = 3;
        c.weightx = 1.0;
        this.add((Component)expressionPanel, c);
        ++c.gridy;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 1.0;
        this.add((Component)this.m_functionsPanel, c);
        ++c.gridx;
        this.add((Component)this.m_variablesListPanel, c);
        ++c.gridx;
        this.add((Component)this.m_calcPanel, c);
        this.setFocusable(true);
        this.requestFocusInWindow();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(new KeyEventDispatcher(){

            @Override
            public boolean dispatchKeyEvent(KeyEvent e) {
                if (e.getID() == 400) {
                    char keyChar = e.getKeyChar();
                    JButton button = (JButton)ExpressionBuilderPanel.this.m_shortCuts.get(keyChar);
                    if (button != null) {
                        button.doClick();
                    } else if (keyChar == '\b' && ExpressionBuilderPanel.this.m_undoButton.isEnabled()) {
                        ExpressionBuilderPanel.this.m_undoButton.doClick();
                    }
                }
                return false;
            }
        });
    }

    private JPanel createExpressionPanel() {
        JPanel expressionPanel = new JPanel(new FlowLayout());
        expressionPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(2, 2, 2, 2);
        c.fill = 1;
        c.anchor = 18;
        JLabel equalLabel = new JLabel("=");
        equalLabel.setIcon(IconManager.getIcon(IconManager.IconType.FUNCTION));
        this.m_expressionTextField = new JXTextField();
        this.m_expressionTextField.setEditable(false);
        this.m_undoButton = this.createUndoButton();
        this.m_redoButton = this.createRedoButton();
        this.m_clearButton = this.createClearButton();
        expressionPanel.add((Component)equalLabel, c);
        ++c.gridx;
        c.weightx = 1.0;
        expressionPanel.add((Component)this.m_expressionTextField, c);
        c.weightx = 0.0;
        ++c.gridx;
        expressionPanel.add((Component)this.m_undoButton, c);
        ++c.gridx;
        expressionPanel.add((Component)this.m_redoButton, c);
        ++c.gridx;
        expressionPanel.add((Component)this.m_clearButton, c);
        return expressionPanel;
    }

    private JButton createUndoButton() {
        JButton undoButton = new JButton(IconManager.getIcon(IconManager.IconType.UNDO));
        undoButton.setMargin(new Insets(1, 1, 1, 1));
        undoButton.setFocusPainted(false);
        undoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExpressionBuilderPanel.this.m_redoExpression.add(ExpressionBuilderPanel.this.m_builtExpression.remove(ExpressionBuilderPanel.this.m_builtExpression.size() - 1));
                ExpressionBuilderPanel.this.m_expressionTextField.setText(ExpressionBuilderPanel.this.getDisplayExpression());
                ExpressionBuilderPanel.this.updateEnableButtons();
            }
        });
        undoButton.setEnabled(false);
        return undoButton;
    }

    private JButton createRedoButton() {
        JButton redoButton = new JButton(IconManager.getIcon(IconManager.IconType.REDO));
        redoButton.setMargin(new Insets(1, 1, 1, 1));
        redoButton.setFocusPainted(false);
        redoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExpressionBuilderPanel.this.m_builtExpression.add(ExpressionBuilderPanel.this.m_redoExpression.remove(ExpressionBuilderPanel.this.m_redoExpression.size() - 1));
                ExpressionBuilderPanel.this.m_expressionTextField.setText(ExpressionBuilderPanel.this.getDisplayExpression());
                ExpressionBuilderPanel.this.updateEnableButtons();
            }
        });
        redoButton.setEnabled(false);
        return redoButton;
    }

    private JButton createClearButton() {
        JButton clearButton = new JButton(IconManager.getIcon(IconManager.IconType.ERASER));
        clearButton.setMargin(new Insets(1, 1, 1, 1));
        clearButton.setFocusPainted(false);
        clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                while (!ExpressionBuilderPanel.this.m_builtExpression.isEmpty()) {
                    ExpressionBuilderPanel.this.m_redoExpression.add(ExpressionBuilderPanel.this.m_builtExpression.remove(ExpressionBuilderPanel.this.m_builtExpression.size() - 1));
                }
                ExpressionBuilderPanel.this.m_expressionTextField.setText(ExpressionBuilderPanel.this.getDisplayExpression());
                ExpressionBuilderPanel.this.updateEnableButtons();
            }
        });
        clearButton.setEnabled(false);
        return clearButton;
    }

    private void updateEnableButtons() {
        this.m_redoButton.setEnabled(!this.m_redoExpression.isEmpty());
        this.m_undoButton.setEnabled(!this.m_builtExpression.isEmpty());
        this.m_clearButton.setEnabled(!this.m_builtExpression.isEmpty());
    }

    private JPanel createFunctionPanel() {
        JPanel functionsPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(2, 2, 2, 2);
        c.fill = 1;
        c.anchor = 18;
        this.m_functionTree = new ExpressionEntityTree(this, ExpressionEntityTree.TreeType.FUNCTIONS);
        JScrollPane scrollPane = new JScrollPane(this.m_functionTree);
        scrollPane.setPreferredSize(new Dimension(180, 220));
        functionsPanel.add((Component)scrollPane, c);
        return functionsPanel;
    }

    private JPanel createVariablesPanel() {
        JPanel variablesPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(2, 2, 2, 2);
        c.fill = 1;
        c.anchor = 18;
        this.m_variableTree = new ExpressionEntityTree(this, ExpressionEntityTree.TreeType.VARIABLES);
        JScrollPane scrollPane = new JScrollPane(this.m_variableTree);
        scrollPane.setPreferredSize(new Dimension(180, 220));
        variablesPanel.add((Component)scrollPane, c);
        return variablesPanel;
    }

    private JPanel createNumberPanel() {
        JPanel numberPanel = new JPanel(new GridBagLayout());
        this.m_numberPanelC = new GridBagConstraints();
        this.m_numberPanelC.gridx = 0;
        this.m_numberPanelC.gridy = 0;
        this.m_numberPanelC.insets = new Insets(2, 2, 2, 2);
        this.m_numberPanelC.fill = 1;
        this.m_numberPanelC.anchor = 18;
        this.m_numberPanelC.gridy = 100;
        this.m_numberPanelC.weighty = 1.0;
        numberPanel.add(Box.createVerticalGlue(), this.m_numberPanelC);
        this.m_numberPanelC.gridy = 0;
        this.m_numberPanelC.weighty = 0.0;
        return numberPanel;
    }

    public void addEntityToExpression(ExpressionEntity entity) {
        this.m_builtExpression.add(entity);
        this.m_redoExpression.clear();
        this.m_expressionTextField.setText(this.getDisplayExpression());
        this.updateEnableButtons();
    }

    public void addFunction(ExpressionEntity entity) {
        this.m_functionTree.addEntity(entity);
    }

    public void addVariable(ExpressionEntity entity) {
        this.m_variableTree.addEntity(entity);
    }

    public void addCalcButton(final ExpressionEntity entity) {
        String name;
        String code = entity.getCode();
        if (code.length() == 1) {
            char c = code.charAt(0);
            if (c == '+') {
                this.m_entityPlus = entity;
            } else if (c == '-') {
                this.m_entityMinus = entity;
            }
        }
        JButton calcButton = new JButton(entity.getName());
        calcButton.setFocusPainted(false);
        if (entity.getName().compareTo("\u00b1") == 0) {
            calcButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int index;
                    for (index = ExpressionBuilderPanel.this.m_builtExpression.size() - 1; index >= 0; --index) {
                        char c;
                        ExpressionEntity entityCur = (ExpressionEntity)ExpressionBuilderPanel.this.m_builtExpression.get(index);
                        String code = entityCur.getCode();
                        if (code.length() != 1 || (c = code.charAt(0)) >= '0' && c <= '9' || c == '.') continue;
                        if (c == '-') {
                            ExpressionBuilderPanel.this.m_builtExpression.set(index, ExpressionBuilderPanel.this.m_entityPlus);
                            break;
                        }
                        if (c == '+') {
                            ExpressionBuilderPanel.this.m_builtExpression.set(index, ExpressionBuilderPanel.this.m_entityMinus);
                            break;
                        }
                        ExpressionBuilderPanel.this.m_builtExpression.add(index + 1, ExpressionBuilderPanel.this.m_entityMinus);
                        break;
                    }
                    if (index < 0) {
                        ExpressionBuilderPanel.this.m_builtExpression.add(0, ExpressionBuilderPanel.this.m_entityMinus);
                    }
                    ExpressionBuilderPanel.this.m_expressionTextField.setText(ExpressionBuilderPanel.this.getDisplayExpression());
                    ExpressionBuilderPanel.this.updateEnableButtons();
                }
            });
        } else {
            calcButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExpressionBuilderPanel.this.m_builtExpression.add(entity);
                    ExpressionBuilderPanel.this.m_redoExpression.clear();
                    ExpressionBuilderPanel.this.m_expressionTextField.setText(ExpressionBuilderPanel.this.getDisplayExpression());
                    ExpressionBuilderPanel.this.updateEnableButtons();
                }
            });
        }
        this.m_calcPanel.add((Component)calcButton, this.m_numberPanelC);
        ++this.m_numberPanelC.gridx;
        if (this.m_numberPanelC.gridx >= this.m_nbButtonsHorizontal) {
            this.m_numberPanelC.gridx = 0;
            ++this.m_numberPanelC.gridy;
        }
        if ((name = entity.getName()).length() == 1) {
            char c = name.charAt(0);
            this.m_shortCuts.put(new Integer(c), calcButton);
        }
    }

    public String getCodeExpression() {
        StringBuilder sb = new StringBuilder();
        for (ExpressionEntity entity : this.m_builtExpression) {
            sb.append(entity.getCode());
        }
        return sb.toString();
    }

    public String getDisplayExpression() {
        StringBuilder sb = new StringBuilder();
        for (ExpressionEntity entity : this.m_builtExpression) {
            sb.append(entity.getNameDisplayed());
        }
        return sb.toString();
    }

    private static class EntityListRenderer
    extends DefaultListCellRenderer {
        private static EntityListRenderer m_singleton = null;

        public static EntityListRenderer getRenderer() {
            if (m_singleton == null) {
                m_singleton = new EntityListRenderer();
            }
            return m_singleton;
        }

        private EntityListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            return super.getListCellRendererComponent(list, ((ExpressionEntity)value).getName(), index, isSelected, cellHasFocus);
        }
    }
}

