/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.markerbar;

import fr.proline.studio.markerbar.AbstractBar;
import fr.proline.studio.markerbar.AbstractMarker;
import fr.proline.studio.markerbar.MarkerComponentInterface;
import fr.proline.studio.markerbar.MarkerContainerPanel;
import fr.proline.studio.markerbar.MarkerRendererInterface;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.TreeMap;

public class OverviewBar
extends AbstractBar
implements MouseListener {
    private static final long serialVersionUID = 1L;
    private static final Color m_almostWhiteColor = new Color(248, 248, 248);

    public OverviewBar(MarkerContainerPanel containerPanel) {
        super(containerPanel);
        this.addMouseListener(this);
    }

    @Override
    public void paint(Graphics g) {
        g.setColor(m_almostWhiteColor);
        g.fillRect(1, 1, this.getWidth() - 2, this.getHeight() - 2);
        g.setColor(Color.lightGray);
        g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        MarkerComponentInterface markerComponentInterface = this.m_containerPanel.getMarkerComponentInterface();
        double nbRows = markerComponentInterface.getRowCount();
        double heightD = this.getHeight();
        double h = heightD / nbRows;
        TreeMap<Integer, ArrayList<AbstractMarker>> markerMap = this.m_containerPanel.getMarkerArray();
        for (Integer row : markerMap.keySet()) {
            ArrayList<AbstractMarker> markersArrayList = markerMap.get(row);
            int size = markersArrayList.size();
            for (int i = 0; i < size; ++i) {
                AbstractMarker marker = markersArrayList.get(i);
                int graphicalRow = markerComponentInterface.convertRowIndexNonFilteredModelToView(row);
                if (graphicalRow == -1) continue;
                int y = (int)Math.round((double)graphicalRow * h);
                MarkerRendererInterface renderer = this.m_containerPanel.getRenderer(marker);
                renderer.paint(AbstractBar.BarType.OVERVIEW_BAR, g, 0, y, this.getWidth(), 4);
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        MarkerComponentInterface componentInterface = this.m_containerPanel.getMarkerComponentInterface();
        int nbRows = componentInterface.getRowCount();
        int y = e.getY();
        int rowClicked = (int)Math.round((double)y / (double)this.getHeight() * (double)nbRows);
        int rowWithMarker = this.m_containerPanel.findNearestRowWithMarker(rowClicked);
        double nbPixels = (double)Math.abs(rowWithMarker - rowClicked) / (double)nbRows * (double)this.getHeight();
        if (nbPixels <= 5.0) {
            componentInterface.scrollToVisible(rowWithMarker);
        } else {
            componentInterface.scrollToVisible(rowClicked);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

