/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.parameter;

import fr.proline.studio.graphics.ColorOrGradient;
import fr.proline.studio.graphics.ColorOrGradientChooserPanel;
import fr.proline.studio.graphics.ReferenceIdName;
import fr.proline.studio.parameter.AbstractParameter;
import fr.proline.studio.parameter.ParameterError;
import java.awt.Color;
import java.util.ArrayList;
import javax.swing.JComponent;

public class ColorOrGradientParameter
extends AbstractParameter {
    private ColorOrGradient m_defaultColor = null;
    private ArrayList<ReferenceIdName> m_gradientParam = null;
    private ColorOrGradient m_startValue;
    private boolean m_edited = false;

    public ColorOrGradientParameter(String key, String name, ColorOrGradient defaultColor, ArrayList<ReferenceIdName> gradientParam) {
        super(key, name, Color.class, ColorOrGradientChooserPanel.class);
        this.m_defaultColor = defaultColor;
        this.m_gradientParam = gradientParam;
    }

    public void setGradientParam(ArrayList<ReferenceIdName> gradientParam) {
        this.m_gradientParam = gradientParam;
    }

    @Override
    public JComponent getComponent(Object value) {
        this.m_startValue = (ColorOrGradient)value;
        if (this.m_startValue == null) {
            this.m_startValue = this.m_defaultColor;
        }
        if (this.m_parameterComponent != null && this.m_graphicalType.equals(ColorOrGradientChooserPanel.class)) {
            ((ColorOrGradientChooserPanel)this.m_parameterComponent).setColor(this.m_startValue);
            return this.m_parameterComponent;
        }
        if (this.m_graphicalType.equals(ColorOrGradientChooserPanel.class)) {
            ColorOrGradientChooserPanel colorGradientChooser = new ColorOrGradientChooserPanel(this.m_startValue, this.m_gradientParam);
            this.m_parameterComponent = colorGradientChooser;
            return colorGradientChooser;
        }
        return null;
    }

    @Override
    public void initDefault() {
        if (this.m_defaultColor == null) {
            return;
        }
        if (this.m_graphicalType.equals(ColorOrGradientChooserPanel.class)) {
            ColorOrGradientChooserPanel colorGradientChooser = (ColorOrGradientChooserPanel)this.m_parameterComponent;
            colorGradientChooser.setColor(this.m_defaultColor);
        }
    }

    @Override
    public ParameterError checkParameter() {
        return null;
    }

    @Override
    public String getStringValue() {
        return ((ColorOrGradient)this.getObjectValue()).toString();
    }

    @Override
    public Object getObjectValue() {
        if (this.m_graphicalType.equals(ColorOrGradientChooserPanel.class) && this.m_parameterComponent != null) {
            return ((ColorOrGradientChooserPanel)this.m_parameterComponent).getColor();
        }
        return null;
    }

    public ColorOrGradient getColor() {
        ColorOrGradient c = (ColorOrGradient)this.getObjectValue();
        if (c == null) {
            return this.m_defaultColor;
        }
        return c;
    }

    public ReferenceIdName getSelectedReferenceIdName() {
        if (this.m_graphicalType.equals(ColorOrGradientChooserPanel.class) && this.m_parameterComponent != null) {
            return ((ColorOrGradientChooserPanel)this.m_parameterComponent).getSelectedReferenceIdName();
        }
        return null;
    }

    @Override
    public void setValue(String v) {
        if (this.m_parameterComponent == null) {
            return;
        }
        if (this.m_graphicalType.equals(ColorOrGradientChooserPanel.class)) {
            ((ColorOrGradientChooserPanel)this.m_parameterComponent).setColor(ColorOrGradient.read(v));
        }
        if (v != null && ColorOrGradient.read(v) != null && this.m_startValue != null) {
            this.m_edited = ColorOrGradient.read(v) != this.m_startValue;
        }
    }

    @Override
    public boolean isEdited() {
        return this.m_edited;
    }
}

