/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.parameter;

import fr.proline.studio.parameter.AbstractParameter;
import fr.proline.studio.parameter.ParameterError;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class IntegerParameter
extends AbstractParameter {
    private Integer m_minValue;
    private Integer m_maxValue;
    private Integer m_defaultValue;
    private Integer m_startValue;
    private boolean m_edited;

    public IntegerParameter(String key, String name, Class graphicalType, Integer defaultValue, Integer minValue, Integer maxValue) {
        super(key, name, Integer.class, graphicalType);
        this.m_defaultValue = defaultValue;
        this.m_minValue = minValue;
        this.m_maxValue = maxValue;
    }

    public IntegerParameter(String key, String name, JComponent component, Integer defaultValue, Integer minValue, Integer maxValue) {
        super(key, name, Integer.class, component.getClass());
        this.m_defaultValue = defaultValue;
        this.m_minValue = minValue;
        this.m_maxValue = maxValue;
        this.m_parameterComponent = component;
    }

    @Override
    public JComponent getComponent(Object value) {
        this.m_startValue = null;
        if (value != null) {
            try {
                int valueParsed = Integer.parseInt(value.toString());
                this.m_startValue = new Integer(valueParsed);
            }
            catch (NumberFormatException valueParsed) {
                // empty catch block
            }
        }
        if (this.m_startValue == null) {
            this.m_startValue = this.m_defaultValue;
        }
        if (this.m_parameterComponent != null) {
            if (this.m_graphicalType.equals(JTextField.class)) {
                ((JTextField)this.m_parameterComponent).setText(this.m_startValue.toString());
                return this.m_parameterComponent;
            }
            if (this.m_graphicalType.equals(JSlider.class)) {
                ((JSlider)this.m_parameterComponent).setValue(this.m_startValue);
                return this.m_parameterComponent;
            }
            if (this.m_graphicalType.equals(JSpinner.class)) {
                ((JSpinner)this.m_parameterComponent).setValue(this.m_startValue);
                return this.m_parameterComponent;
            }
        }
        if (this.m_graphicalType.equals(JTextField.class)) {
            JTextField textField = new JTextField(30);
            if (this.m_startValue != null) {
                textField.setText(this.m_startValue.toString());
            }
            this.m_parameterComponent = textField;
            return textField;
        }
        if (this.m_graphicalType.equals(JSlider.class)) {
            JPanel sliderPanel = new JPanel(new FlowLayout());
            final JSlider slider = new JSlider(this.m_minValue, this.m_maxValue, this.m_startValue);
            slider.setPaintTicks(true);
            final JTextField textField = new JTextField(3);
            textField.setText(String.valueOf(this.m_startValue));
            slider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent evt) {
                    int v = slider.getValue();
                    textField.setText(String.valueOf(v));
                    if (IntegerParameter.this.m_externalActionListener != null) {
                        ActionEvent e = new ActionEvent(slider, -1, null);
                        IntegerParameter.this.m_externalActionListener.actionPerformed(e);
                    }
                }
            });
            textField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.modifySlider();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.modifySlider();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.modifySlider();
                }

                private void modifySlider() {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                int value = Integer.parseInt(textField.getText().trim());
                                slider.setValue(value);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                    });
                }
            });
            sliderPanel.add(slider);
            sliderPanel.add(textField);
            this.m_parameterComponent = slider;
            return sliderPanel;
        }
        if (this.m_graphicalType.equals(JSpinner.class)) {
            final JSpinner spinner = new JSpinner();
            SpinnerNumberModel model = new SpinnerNumberModel(this.m_startValue, this.m_minValue, this.m_maxValue, new Integer(1));
            spinner.setModel(model);
            spinner.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent evt) {
                    if (IntegerParameter.this.m_externalActionListener != null) {
                        ActionEvent e = new ActionEvent(spinner, -1, null);
                        IntegerParameter.this.m_externalActionListener.actionPerformed(e);
                    }
                }
            });
            this.m_parameterComponent = spinner;
            return spinner;
        }
        return null;
    }

    @Override
    public void initDefault() {
        if (this.m_defaultValue == null) {
            return;
        }
        if (this.m_graphicalType.equals(JTextField.class)) {
            JTextField textField = (JTextField)this.m_parameterComponent;
            textField.setText(this.m_defaultValue.toString());
        } else if (this.m_graphicalType.equals(JSlider.class)) {
            JSlider slider = (JSlider)this.m_parameterComponent;
            slider.setValue(this.m_defaultValue);
        } else if (this.m_graphicalType.equals(JSpinner.class)) {
            JSpinner spinner = (JSpinner)this.m_parameterComponent;
            spinner.setValue(this.m_defaultValue);
        }
    }

    public void setDefaultValue(Integer defaultValue) {
        this.m_defaultValue = defaultValue;
        this.initDefault();
    }

    @Override
    public ParameterError checkParameter() {
        if (!this.m_used && !this.m_compulsory) {
            return null;
        }
        Integer value = null;
        if (this.m_graphicalType.equals(JTextField.class)) {
            JTextField textField = (JTextField)this.m_parameterComponent;
            try {
                value = Integer.parseInt(textField.getText().trim());
            }
            catch (NumberFormatException nfe) {
                return new ParameterError(this.m_name + " is not a Integer", this.m_parameterComponent);
            }
        } else {
            if (this.m_graphicalType.equals(JSlider.class)) {
                return null;
            }
            if (this.m_graphicalType.equals(JSpinner.class)) {
                return null;
            }
        }
        if (this.m_minValue != null && value < this.m_minValue) {
            return new ParameterError(this.m_name + " must be greater than " + this.m_minValue.toString(), this.m_parameterComponent);
        }
        if (this.m_maxValue != null && value > this.m_maxValue) {
            return new ParameterError(this.m_name + " must be lesser than " + this.m_maxValue.toString(), this.m_parameterComponent);
        }
        return null;
    }

    @Override
    public void setValue(String v) {
        if (this.m_parameterComponent == null) {
            return;
        }
        if (v == null) {
            v = this.m_defaultValue.toString();
        }
        if (this.m_graphicalType.equals(JTextField.class)) {
            ((JTextField)this.m_parameterComponent).setText(v);
        } else if (this.m_graphicalType.equals(JSlider.class)) {
            ((JSlider)this.m_parameterComponent).setValue(Integer.valueOf(v));
        } else if (this.m_graphicalType.equals(JSpinner.class)) {
            ((JSpinner)this.m_parameterComponent).setValue(Integer.valueOf(v));
        }
        if (v != null && this.m_startValue != null) {
            this.m_edited = Integer.parseInt(v) != this.m_startValue;
        }
    }

    @Override
    public String getStringValue() {
        Object v = this.getObjectValue();
        return v != null ? v.toString() : null;
    }

    @Override
    public Object getObjectValue() {
        if (this.m_parameterComponent == null) {
            return null;
        }
        if (this.m_graphicalType.equals(JTextField.class)) {
            return Integer.parseInt(((JTextField)this.m_parameterComponent).getText().trim());
        }
        if (this.m_graphicalType.equals(JSlider.class)) {
            return ((JSlider)this.m_parameterComponent).getValue();
        }
        if (this.m_graphicalType.equals(JSpinner.class)) {
            return ((JSpinner)this.m_parameterComponent).getValue();
        }
        return "";
    }

    @Override
    public boolean isEdited() {
        return this.m_edited;
    }
}

