/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.table;

import fr.proline.studio.table.LazyData;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class TableColumn {
    private int position;
    private String name;
    private String tooltip;
    private Class type;
    private boolean isLazy = false;

    public TableColumn(int position, String name, String tooltip, Class type, boolean isLazy) {
        this(name, tooltip, type);
        this.position = position;
        this.isLazy = isLazy;
    }

    public TableColumn(String name, String tooltip, Class type) {
        this.name = name;
        this.tooltip = tooltip;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public int getPosition() {
        return this.position;
    }

    public Class getType() {
        if (this.isLazy) {
            return LazyData.class;
        }
        return this.type;
    }

    public static class Builder {
        List<TableColumn> columns = new ArrayList<TableColumn>();

        public Builder add(int position, String name, String tooltip, Class type, boolean isLazy) {
            this.columns.add(new TableColumn(position, name, tooltip, type, isLazy));
            return this;
        }

        public Builder add(int position, String name, String tooltip, Class type) {
            return this.add(position, name, tooltip, type, false);
        }

        public TableColumn[] build() {
            this.columns.sort(Comparator.comparing(TableColumn::getPosition));
            for (int k = 0; k < this.columns.size(); ++k) {
                assert (this.columns.get(k).getPosition() == k);
            }
            return this.columns.toArray(new TableColumn[0]);
        }
    }
}

