/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.tabs;

import fr.proline.studio.tabs.IWrappedPanel;
import fr.proline.studio.tabs.PanelAsGrid;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicTabbedPaneUI;

public class GridPanel
extends JPanel {
    private IWrappedPanel m_wrappedPanel;
    private JTabbedPane m_tabbedPane;
    private PanelAsGrid m_mainPanel;
    private boolean m_isSelected;
    public static final Color selectedColor = Color.white;
    public static final Color defaultColor = new Color(240, 240, 240);

    public GridPanel(PanelAsGrid mainPanel, IWrappedPanel wrappedPanel) {
        this.m_wrappedPanel = wrappedPanel;
        this.m_mainPanel = mainPanel;
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.m_tabbedPane = new JTabbedPane();
        this.m_tabbedPane.addTab(this.m_wrappedPanel.getTitle(), this.m_wrappedPanel.getComponent());
        this.m_tabbedPane.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent me) {
                GridPanel.this.m_mainPanel.changeSelectionPanel();
                GridPanel.this.setSelected(true);
            }

            @Override
            public void mousePressed(MouseEvent me) {
            }

            @Override
            public void mouseReleased(MouseEvent me) {
            }

            @Override
            public void mouseEntered(MouseEvent me) {
            }

            @Override
            public void mouseExited(MouseEvent me) {
            }
        });
        this.add((Component)this.m_tabbedPane, "Center");
        this.setSelected(false);
    }

    public boolean isSelected() {
        return this.m_isSelected;
    }

    public void setSelected(boolean isSelected) {
        this.m_isSelected = isSelected;
        if (this.m_isSelected) {
            this.setTabbedPaneBorderColor(selectedColor);
        } else {
            this.setTabbedPaneBorderColor(defaultColor);
        }
    }

    public void setTabbedPaneBorderColor(Color tabBorderColor) {
        UIManager.put("TabbedPane.selected", tabBorderColor);
        this.m_tabbedPane.setUI(new BasicTabbedPaneUI(){

            @Override
            protected void installDefaults() {
                super.installDefaults();
                this.highlight = UIManager.getColor("TabbedPane.light");
                this.lightHighlight = UIManager.getColor("TabbedPane.highlight");
                this.shadow = UIManager.getColor("TabbedPane.shadow");
                this.darkShadow = UIManager.getColor("TabbedPane.darkShadow");
                this.focus = UIManager.getColor("TabbedPane.focus");
            }
        });
    }

    public void setTabHeaderComponent(Component c) {
        this.m_tabbedPane.setTabComponentAt(0, c);
    }

    public int indexOfTabHeaderComponent(Component c) {
        return this.m_tabbedPane.indexOfTabComponent(c);
    }
}

