/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.brucker.timstof.model;

import fr.profi.brucker.timstof.converter.SpectrumGeneratingMethod;
import fr.profi.brucker.timstof.model.AbstractTimsFrame;
import fr.profi.brucker.timstof.model.Spectrum;
import fr.profi.mzdb.algo.signal.filtering.SavitzkyGolaySmoother;
import fr.profi.mzdb.algo.signal.filtering.SavitzkyGolaySmoothingConfig;
import fr.profi.mzdb.util.math.DerivativeAnalysis;
import it.unimi.dsi.fastutil.doubles.Double2FloatMap;
import it.unimi.dsi.fastutil.doubles.Double2FloatOpenHashMap;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleCollection;
import it.unimi.dsi.fastutil.doubles.DoubleComparators;
import it.unimi.dsi.fastutil.doubles.DoubleListIterator;
import it.unimi.dsi.fastutil.floats.Float2ObjectMap;
import it.unimi.dsi.fastutil.floats.Float2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.floats.FloatCollection;
import it.unimi.dsi.fastutil.floats.FloatComparators;
import it.unimi.dsi.fastutil.floats.FloatListIterator;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import scala.Tuple2;

public class TimsMSFrame
extends AbstractTimsFrame {
    private static Boolean SMOOTH_SUM = Boolean.valueOf(System.getProperty("smooth.sum", "FALSE"));
    private static Boolean SMOOTH_SUM_BOUNDED = Boolean.valueOf(System.getProperty("smooth.sum.bounded", "FALSE"));
    private Int2ObjectMap<Spectrum> m_spectrumByScan;
    private Float2ObjectMap<DoubleArrayList> m_allIntensity2Masses;
    private Double2FloatMap m_mass2retainedIntensityMap;
    static int nbrSp = 0;
    static long time0 = 0L;
    static long time01 = 0L;
    static long time02 = 0L;
    static long time03 = 0L;
    static long time04 = 0L;

    public TimsMSFrame(int id, int nbrScans, int nbrPeaks, int scanMode, int maxIntensity, int summedIntensity, double time) {
        super(id, nbrScans, nbrPeaks, scanMode, AbstractTimsFrame.MsMsType.MS, maxIntensity, summedIntensity, time);
    }

    @Override
    public void clearSpectraData() {
        super.clearSpectraData();
        if (this.m_singleSpectrum != null) {
            this.m_singleSpectrum = null;
        }
        if (this.m_spectrumByScan != null) {
            this.m_spectrumByScan.clear();
        }
        if (this.m_allIntensity2Masses != null) {
            this.m_allIntensity2Masses.clear();
        }
        if (this.m_mass2retainedIntensityMap != null) {
            this.m_mass2retainedIntensityMap.clear();
        }
    }

    @Override
    public void setMassIntensityByScan(Int2ObjectMap<Double2FloatMap> massIntByScan) {
        IntIterator scansIdIt = massIntByScan.keySet().iterator();
        int totalIndex = 0;
        while (scansIdIt.hasNext()) {
            int scId = scansIdIt.nextInt();
            Double2FloatMap massInt = (Double2FloatMap)massIntByScan.get(scId);
            if (this.m_spectrumByScan == null) {
                this.m_spectrumByScan = new Int2ObjectOpenHashMap();
            }
            if (this.m_allIntensity2Masses == null) {
                this.m_allIntensity2Masses = new Float2ObjectOpenHashMap();
            }
            if (this.m_mass2retainedIntensityMap == null) {
                this.m_mass2retainedIntensityMap = new Double2FloatOpenHashMap();
            }
            double[] scanMasses = new double[massInt.size()];
            float[] scanIntensities = new float[massInt.size()];
            ObjectIterator entries = massInt.double2FloatEntrySet().iterator();
            int index = 0;
            while (entries.hasNext()) {
                Double2FloatMap.Entry dataEntry = (Double2FloatMap.Entry)entries.next();
                double massVal = dataEntry.getDoubleKey();
                float intensityVal = dataEntry.getFloatValue();
                scanMasses[index] = massVal;
                scanIntensities[index++] = intensityVal;
                DoubleArrayList masses4Intensity = (DoubleArrayList)this.m_allIntensity2Masses.getOrDefault(intensityVal, (Object)new DoubleArrayList());
                masses4Intensity.add(massVal);
                this.m_allIntensity2Masses.put(intensityVal, (Object)masses4Intensity);
                float retainedIntensity = this.m_mass2retainedIntensityMap.getOrDefault(massVal, 0.0f);
                if (!SMOOTH_SUM.booleanValue()) {
                    if (!(retainedIntensity < intensityVal)) continue;
                    this.m_mass2retainedIntensityMap.put(massVal, intensityVal);
                    continue;
                }
                this.m_mass2retainedIntensityMap.put(massVal, retainedIntensity + intensityVal);
            }
            totalIndex += index;
            this.m_spectrumByScan.put(scId, (Object)new Spectrum("Frame_" + this.m_id + "-scan_" + scId, 1, (float)this.getTime(), scanMasses, scanIntensities));
        }
        this.m_spectrumDataSet = true;
    }

    public Spectrum getScanSpectrum(int scanId) {
        if (!this.m_spectrumDataSet || !this.m_spectrumByScan.containsKey(scanId)) {
            return null;
        }
        return (Spectrum)this.m_spectrumByScan.get(scanId);
    }

    @Override
    public ObjectList<Spectrum> getAllSpectra() {
        if (!this.m_spectrumDataSet) {
            return null;
        }
        return new ObjectArrayList(this.m_spectrumByScan.values());
    }

    @Override
    protected void createSingleSpectrum(SpectrumGeneratingMethod msCreateMethod) {
        switch (msCreateMethod) {
            case FULL: {
                this.createSingleSpFromAllSpectra();
                break;
            }
            case MERGED: {
                this.createMergedSingleSpFromAllInstensitiesMap();
                break;
            }
            case SMOOTH: {
                this.createSingleSpectrumFromMassInstensityMap();
            }
        }
    }

    @Override
    public int getSpectrumCount() {
        return 1;
    }

    private void createSingleSpectrumFromMassInstensityMap() {
        long start = System.currentTimeMillis();
        ++nbrSp;
        int nbrPeakMS = 0;
        double[] newSpMasses = new double[]{};
        float[] newSpIntensities = new float[]{};
        if (this.m_mass2retainedIntensityMap != null) {
            DoubleArrayList allMasses = new DoubleArrayList((DoubleCollection)this.m_mass2retainedIntensityMap.keySet());
            nbrPeakMS = allMasses.size();
            allMasses.sort(DoubleComparators.NATURAL_COMPARATOR);
            long s1 = System.currentTimeMillis();
            time0 = s1 - start;
            Tuple2[] allPeaks = new Tuple2[allMasses.size()];
            for (int index = 0; index < allMasses.size(); ++index) {
                double nextmass = allMasses.getDouble(index);
                float nextIntensity = this.m_mass2retainedIntensityMap.get(nextmass);
                allPeaks[index] = new Tuple2((Object)nextmass, (Object)nextIntensity);
            }
            long s2 = System.currentTimeMillis();
            time01 = s2 - s1;
            SavitzkyGolaySmoother smoother = new SavitzkyGolaySmoother(new SavitzkyGolaySmoothingConfig(3, 2, 1));
            Tuple2[] smoothedSpectrum = smoother.smoothTimeIntensityPairs(allPeaks);
            long s3 = System.currentTimeMillis();
            time02 = s3 - s2;
            int resultLength = smoothedSpectrum.length;
            double[] smoothedMasses = new double[resultLength];
            double[] smoothedIntensities = new double[resultLength];
            for (int k = 0; k < resultLength; ++k) {
                smoothedMasses[k] = (Double)smoothedSpectrum[k]._1;
                smoothedIntensities[k] = (Double)smoothedSpectrum[k]._2;
            }
            DerivativeAnalysis.ILocalDerivativeChange[] mm = DerivativeAnalysis.findMiniMaxi((double[])smoothedIntensities);
            long s4 = System.currentTimeMillis();
            time03 = s4 - s3;
            int realLenght = 0;
            newSpMasses = new double[mm.length];
            newSpIntensities = new float[mm.length];
            for (int k = 0; k < mm.length; ++k) {
                if (!mm[k].isMaximum()) continue;
                double mass = smoothedMasses[mm[k].index()];
                double intensity = (Double)allPeaks[mm[k].index()]._2;
                if (SMOOTH_SUM.booleanValue()) {
                    int mmNextIndex;
                    int shift;
                    int mmPrevIndex;
                    int n = mmPrevIndex = k > 0 && SMOOTH_SUM_BOUNDED != false ? mm[k - 1].index() : 0;
                    for (shift = mm[k].index() - 1; shift > 0 && shift >= mmPrevIndex && Math.abs(smoothedMasses[shift] - mass) / mass * 1000000.0 < 10.0; --shift) {
                        intensity += ((Double)allPeaks[shift]._2).doubleValue();
                    }
                    int n2 = mmNextIndex = k < mm.length - 1 && SMOOTH_SUM_BOUNDED != false ? mm[k + 1].index() : allPeaks.length - 1;
                    for (shift = mm[k].index() + 1; shift < allPeaks.length && shift <= mmNextIndex && Math.abs(smoothedMasses[shift] - mass) / mass * 1000000.0 < 10.0; ++shift) {
                        intensity += ((Double)allPeaks[shift]._2).doubleValue();
                    }
                }
                newSpMasses[realLenght] = mass;
                newSpIntensities[realLenght] = (float)intensity;
                ++realLenght;
            }
            newSpMasses = Arrays.copyOfRange(newSpMasses, 0, realLenght);
            newSpIntensities = Arrays.copyOfRange(newSpIntensities, 0, realLenght);
            long s5 = System.currentTimeMillis();
            time04 = s5 - s4;
        }
        if (newSpMasses.length == 0) {
            LOG.debug("SingleSpectrum >>> Frame_" + this.m_id + " has\t" + nbrPeakMS + "\tpeaks, reduced to\t" + newSpMasses.length);
        }
        this.m_singleSpectrum = new Spectrum("Frame_" + this.m_id, 1, (float)this.m_time, newSpMasses, newSpIntensities);
        if (nbrSp % 100 == 0) {
            LOG.debug(" SMOOTH SingleSpectrum>> Frame Single READ Duration: {} reduced to {} ", (Object)nbrPeakMS, (Object)newSpMasses.length);
            LOG.debug(" SingleSpectrum>> Frame  Sort Masses: " + time0);
            LOG.debug(" SingleSpectrum>> Frame  Create Tuple: " + time01);
            LOG.debug(" SingleSpectrum>> Frame  Smooth: " + time02);
            LOG.debug(" SingleSpectrum>> Frame  Create [] and Get MinMax: " + time03);
            LOG.debug(" SingleSpectrum>> Frame  Create final []: " + time04);
            time0 = 0L;
            time01 = 0L;
            time02 = 0L;
            time03 = 0L;
            time04 = 0L;
        }
    }

    private void createMergedSingleSpFromAllInstensitiesMap() {
        long start = System.currentTimeMillis();
        ++nbrSp;
        Double2FloatOpenHashMap retainedMasses2Intensity = new Double2FloatOpenHashMap();
        int nbrPeakMS = 0;
        if (this.m_allIntensity2Masses != null) {
            FloatArrayList allIntensities = new FloatArrayList((FloatCollection)this.m_allIntensity2Masses.keySet());
            allIntensities.sort(FloatComparators.OPPOSITE_COMPARATOR);
            ArrayList<Double> keyMasses = new ArrayList<Double>();
            long s1 = System.currentTimeMillis();
            time0 += s1 - start;
            FloatListIterator floatListIterator = allIntensities.iterator();
            while (floatListIterator.hasNext()) {
                float nextIntensity = ((Float)floatListIterator.next()).floatValue();
                DoubleArrayList allMasses = (DoubleArrayList)this.m_allIntensity2Masses.get(nextIntensity);
                DoubleListIterator doubleListIterator = allMasses.iterator();
                while (doubleListIterator.hasNext()) {
                    double nextMass = (Double)doubleListIterator.next();
                    start = System.currentTimeMillis();
                    ++nbrPeakMS;
                    if (keyMasses.isEmpty()) {
                        keyMasses.add(nextMass);
                        retainedMasses2Intensity.put(nextMass, nextIntensity);
                        continue;
                    }
                    int index = Collections.binarySearch(keyMasses, nextMass);
                    long s2 = System.currentTimeMillis();
                    time01 += s2 - start;
                    if (index >= 0) continue;
                    int idxToInsert = index ^= 0xFFFFFFFF;
                    double min = Double.MAX_VALUE;
                    for (int k = Math.max(0, index - 1); k <= Math.min(keyMasses.size() - 1, index + 1); ++k) {
                        if (!(Math.abs((Double)keyMasses.get(k) - nextMass) < min)) continue;
                        min = Math.abs((Double)keyMasses.get(k) - nextMass);
                        index = k;
                    }
                    long s3 = System.currentTimeMillis();
                    time02 += s3 - s2;
                    double nearestMass = (Double)keyMasses.get(index);
                    double asPpm = Math.abs(nearestMass - nextMass) / nextMass * 1000000.0;
                    if (!(asPpm > 10.0)) continue;
                    keyMasses.add(idxToInsert, nextMass);
                    retainedMasses2Intensity.put(nextMass, nextIntensity);
                    long s4 = System.currentTimeMillis();
                    time03 += s4 - s3;
                }
            }
        }
        this.m_singleSpectrum = new Spectrum("Frame_" + this.m_id, 1, (float)this.m_time, (Double2FloatMap)retainedMasses2Intensity);
        if (nbrSp % 1000 == 0) {
            LOG.debug(" MERGED SingleSpectrum>> Frame Single READ Duration: {} reduced to {} ", (Object)nbrPeakMS, (Object)retainedMasses2Intensity.size());
            LOG.debug(" SingleSpectrum>> Frame Single READ Duration: ");
            LOG.debug(" SingleSpectrum>> Frame  Sort intensities: " + time0);
            LOG.debug(" SingleSpectrum>> Frame  Binary search: " + time01);
            LOG.debug(" SingleSpectrum>> Frame  Find nearest: " + time02);
            LOG.debug(" SingleSpectrum>> Frame  inset new mass: " + time03);
            time0 = 0L;
            time01 = 0L;
            time02 = 0L;
            time03 = 0L;
        }
    }
}

