/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.mzdb;

import fr.profi.mzdb.model.Peakel;
import fr.proline.mzscope.model.IPeakel;
import fr.proline.mzscope.model.IRawFile;
import fr.proline.mzscope.mzdb.MzdbFeatureWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MzdbPeakelWrapper
implements IPeakel {
    private static final Logger logger = LoggerFactory.getLogger(MzdbFeatureWrapper.class);
    private final Peakel peakel;
    private IRawFile rawFile;
    private final int msLevel;
    private double parentMz;

    public MzdbPeakelWrapper(Peakel mzdbPeakel, IRawFile rawfile) {
        this(mzdbPeakel, rawfile, 1);
    }

    public MzdbPeakelWrapper(Peakel mzdbPeakel, IRawFile rawfile, double parentMz) {
        this(mzdbPeakel, rawfile, 2);
        this.parentMz = parentMz;
    }

    public MzdbPeakelWrapper(Peakel mzdbPeakel, IRawFile rawfile, int msLevel) {
        this.peakel = mzdbPeakel;
        this.rawFile = rawfile;
        this.msLevel = msLevel;
    }

    @Override
    public float getArea() {
        return this.peakel.getArea();
    }

    @Override
    public int getScanCount() {
        return this.peakel.getSpectrumIds().length;
    }

    @Override
    public double getMz() {
        return this.peakel.getMz();
    }

    @Override
    public float getElutionTime() {
        return this.peakel.getElutionTime();
    }

    @Override
    public float getDuration() {
        return this.peakel.calcDuration();
    }

    @Override
    public float getApexIntensity() {
        return this.peakel.getApexIntensity();
    }

    @Override
    public float getFirstElutionTime() {
        return this.peakel.getFirstElutionTime();
    }

    @Override
    public float getLastElutionTime() {
        return this.peakel.getLastElutionTime();
    }

    @Override
    public IRawFile getRawFile() {
        return this.rawFile;
    }

    @Override
    public void setRawFile(IRawFile rawfile) {
        this.rawFile = rawfile;
    }

    @Override
    public int getMsLevel() {
        return this.msLevel;
    }

    @Override
    public Peakel getPeakel() {
        return this.peakel;
    }

    @Override
    public double getParentMz() {
        return this.parentMz;
    }
}

