/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.processing;

import fr.profi.mzdb.algo.signal.filtering.SavitzkyGolaySmoother;
import fr.profi.mzdb.algo.signal.filtering.SavitzkyGolaySmoothingConfig;
import fr.profi.mzdb.model.Peakel;
import fr.profi.mzdb.model.SpectrumHeader;
import fr.profi.mzdb.peakeldb.PeakelDbHelper;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.IntStream;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.math3.stat.correlation.PearsonsCorrelation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpectrumUtils {
    private static final Logger logger = LoggerFactory.getLogger(SpectrumUtils.class);
    public static final double MIN_CORRELATION_SCORE = 0.5;

    public static SpectrumHeader[] sortMs2SpectrumHeaders(SpectrumHeader[] spectrums) {
        SpectrumHeader[] ms2SpectrumHeaders = null;
        if (spectrums != null) {
            int nbSc = spectrums.length;
            ms2SpectrumHeaders = new SpectrumHeader[nbSc];
            List<SpectrumHeader> list = Arrays.asList(spectrums);
            Collections.sort(list, new Comparator<SpectrumHeader>(){

                @Override
                public int compare(SpectrumHeader sc1, SpectrumHeader sc2) {
                    if (sc1.getPrecursorMz() <= sc2.getPrecursorMz()) {
                        return -1;
                    }
                    return 1;
                }
            });
            ms2SpectrumHeaders = list.toArray(new SpectrumHeader[nbSc]);
        }
        return ms2SpectrumHeaders;
    }

    public static int getNearestPeakIndex(double[] peaksMz, double value) {
        int idx = Arrays.binarySearch(peaksMz, value);
        idx = idx < 0 ? ~idx : idx;
        double min = Double.MAX_VALUE;
        for (int k = Math.max(0, idx - 1); k <= Math.min(peaksMz.length - 1, idx + 1); ++k) {
            if (!(Math.abs(peaksMz[k] - value) < min)) continue;
            min = Math.abs(peaksMz[k] - value);
            idx = k;
        }
        return idx;
    }

    public static int getPeakIndex(double[] peaksMz, double value, double ppmTol) {
        int idx = Arrays.binarySearch(peaksMz, value);
        idx = idx < 0 ? ~idx : idx;
        double min = Double.MAX_VALUE;
        int resultIdx = -1;
        for (int k = Math.max(0, idx - 1); k <= Math.min(peaksMz.length - 1, idx + 1); ++k) {
            if (!(1000000.0 * Math.abs(peaksMz[k] - value) / value < ppmTol) || !(Math.abs(peaksMz[k] - value) < min)) continue;
            min = Math.abs(peaksMz[k] - value);
            resultIdx = k;
        }
        return resultIdx;
    }

    public static boolean isInRange(double m1, double m2, double ppmTol) {
        return 1000000.0 * Math.abs(m1 - m2) / m2 < ppmTol;
    }

    public static int findPeakIndex(Peakel[] peakels, Pair<Double, Integer>[] peakelIndexesByMz, double moz, Peakel referencePeakel, float mzTolPPM) {
        double min = Double.MAX_VALUE;
        int resultIdx = -1;
        Comparator<Pair<Double, Integer>> c = new Comparator<Pair<Double, Integer>>(){

            @Override
            public int compare(Pair<Double, Integer> o1, Pair<Double, Integer> o2) {
                return Double.compare((Double)o1.getLeft(), (Double)o2.getLeft());
            }
        };
        int lowerIdx = Arrays.binarySearch(peakelIndexesByMz, new ImmutablePair((Object)(moz - moz * (double)mzTolPPM / 1000000.0), (Object)0), c);
        lowerIdx = lowerIdx < 0 ? Math.max(0, ~lowerIdx - 1) : Math.max(0, lowerIdx - 1);
        int upperIdx = Arrays.binarySearch(peakelIndexesByMz, new ImmutablePair((Object)(moz + moz * (double)mzTolPPM / 1000000.0), (Object)0), c);
        upperIdx = upperIdx < 0 ? Math.min(peakelIndexesByMz.length - 1, ~upperIdx) : Math.min(peakelIndexesByMz.length - 1, upperIdx + 1);
        for (int i = lowerIdx; i <= upperIdx; ++i) {
            int k = (Integer)peakelIndexesByMz[i].getRight();
            if (!(1000000.0 * Math.abs(peakels[k].getMz() - moz) / moz < (double)mzTolPPM) || !((double)(Math.abs(peakels[k].getElutionTime() - referencePeakel.getElutionTime()) / referencePeakel.calcDuration()) < 0.25) || !(Math.abs(peakels[k].getMz() - moz) < min)) continue;
            min = Math.abs(peakels[k].getMz() - moz);
            resultIdx = k;
        }
        return resultIdx;
    }

    public static int findCorrelatingPeakelIndex(Peakel[] peakels, Pair<Double, Integer>[] peakelIndexesByMz, double moz, Peakel referencePeakel, float mzTolPPM) {
        double maxCorr = Double.MIN_VALUE;
        int resultIdx = -1;
        Comparator<Pair<Double, Integer>> c = new Comparator<Pair<Double, Integer>>(){

            @Override
            public int compare(Pair<Double, Integer> o1, Pair<Double, Integer> o2) {
                return Double.compare((Double)o1.getLeft(), (Double)o2.getLeft());
            }
        };
        int lowerIdx = Arrays.binarySearch(peakelIndexesByMz, new ImmutablePair((Object)(moz - moz * (double)mzTolPPM / 1000000.0), (Object)0), c);
        lowerIdx = lowerIdx < 0 ? Math.max(0, ~lowerIdx - 1) : Math.max(0, lowerIdx - 1);
        int upperIdx = Arrays.binarySearch(peakelIndexesByMz, new ImmutablePair((Object)(moz + moz * (double)mzTolPPM / 1000000.0), (Object)0), c);
        upperIdx = upperIdx < 0 ? Math.min(peakelIndexesByMz.length - 1, ~upperIdx) : Math.min(peakelIndexesByMz.length - 1, upperIdx + 1);
        for (int i = lowerIdx; i <= upperIdx; ++i) {
            double corr;
            int k = (Integer)peakelIndexesByMz[i].getRight();
            if (!(1000000.0 * Math.abs(peakels[k].getMz() - moz) / moz < (double)mzTolPPM) || !(peakels[k].getElutionTime() >= referencePeakel.getFirstElutionTime()) || !(peakels[k].getElutionTime() <= referencePeakel.getLastElutionTime()) || !((corr = SpectrumUtils.correlation(referencePeakel, peakels[k])) > 0.5) || !(corr > maxCorr)) continue;
            maxCorr = corr;
            resultIdx = k;
        }
        return resultIdx;
    }

    public static double correlation(Peakel p1, Peakel p2) {
        int nbrPoints = Math.min(p1.peaksCount() / 4, 9);
        SavitzkyGolaySmoother smoother = new SavitzkyGolaySmoother(new SavitzkyGolaySmoothingConfig(nbrPoints, 2, 1));
        Peakel sp1 = nbrPoints > 0 ? smoother.smoothPeakel(p1) : p1;
        nbrPoints = Math.min(p2.peaksCount() / 4, 9);
        smoother = new SavitzkyGolaySmoother(new SavitzkyGolaySmoothingConfig(nbrPoints, 2, 1));
        Peakel sp2 = nbrPoints > 0 ? smoother.smoothPeakel(p2) : p2;
        return SpectrumUtils.correlation(sp1.getElutionTimes(), sp1.getIntensityValues(), sp2.getElutionTimes(), sp2.getIntensityValues());
    }

    public static double correlationOMP(Peakel p1, Peakel p2, boolean smooth) {
        if (smooth) {
            int nbrPoints = Math.min(p1.peaksCount() / 4, 9);
            SavitzkyGolaySmoother smoother = new SavitzkyGolaySmoother(new SavitzkyGolaySmoothingConfig(nbrPoints, 2, 1));
            Peakel sp1 = smoother.smoothPeakel(p1);
            nbrPoints = Math.min(p2.peaksCount() / 4, 9);
            smoother = new SavitzkyGolaySmoother(new SavitzkyGolaySmoothingConfig(nbrPoints, 2, 1));
            Peakel sp2 = smoother.smoothPeakel(p2);
            return PeakelDbHelper.computeCorrelation((Peakel)sp1, (Peakel)sp2);
        }
        return PeakelDbHelper.computeCorrelation((Peakel)p1, (Peakel)p2);
    }

    public static double correlation(float[] x1, float[] y1, float[] x2, float[] y2) {
        Pair<double[], double[]> values = SpectrumUtils.zipValues(x1, y1, x2, y2);
        PearsonsCorrelation pearson = new PearsonsCorrelation();
        double corr = pearson.correlation((double[])values.getLeft(), (double[])values.getRight());
        return corr;
    }

    public static double correlation(double[] x1, double[] y1, double[] x2, double[] y2) {
        Pair<double[], double[]> values = SpectrumUtils.zipValues(x1, y1, x2, y2);
        PearsonsCorrelation pearson = new PearsonsCorrelation();
        double corr = pearson.correlation((double[])values.getLeft(), (double[])values.getRight());
        return corr;
    }

    public static Pair<double[], double[]> zipValues(double[] x1, double[] y1, double[] x2, double[] y2) {
        int offset1 = 0;
        int offset2 = 0;
        double[] c = Arrays.copyOf(x1, x1.length + x2.length);
        System.arraycopy(x2, 0, c, x1.length, x2.length);
        double[] time = Arrays.stream(c).sorted().distinct().toArray();
        double[] a1 = new double[time.length];
        double[] a2 = new double[time.length];
        for (int k = 0; k < time.length; ++k) {
            a1[k] = 0.0;
            a2[k] = 0.0;
            while (offset1 < x1.length && time[k] == x1[offset1]) {
                a1[k] = y1[offset1];
                ++offset1;
            }
            while (offset2 < x2.length && time[k] == x2[offset2]) {
                a2[k] = y2[offset2];
                ++offset2;
            }
        }
        return new ImmutablePair((Object)a1, (Object)a2);
    }

    public static Pair<double[], double[]> zipValues(float[] x1, float[] y1, float[] x2, float[] y2) {
        int offset1 = 0;
        int offset2 = 0;
        float[] c = Arrays.copyOf(x1, x1.length + x2.length);
        System.arraycopy(x2, 0, c, x1.length, x2.length);
        double[] time = IntStream.range(0, c.length).mapToDouble(i -> c[i]).sorted().distinct().toArray();
        double[] a1 = new double[time.length];
        double[] a2 = new double[time.length];
        for (int k = 0; k < time.length; ++k) {
            a1[k] = 0.0;
            a2[k] = 0.0;
            while (offset1 < x1.length && time[k] == (double)x1[offset1]) {
                a1[k] = y1[offset1];
                ++offset1;
            }
            while (offset2 < x2.length && time[k] == (double)x2[offset2]) {
                a2[k] = y2[offset2];
                ++offset2;
            }
        }
        return new ImmutablePair((Object)a1, (Object)a2);
    }
}

