/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.algo.feature.extraction;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import fr.profi.ms.algo.IsotopePatternInterpolator$;
import fr.profi.ms.model.TheoreticalIsotopePattern;
import fr.profi.mzdb.algo.feature.extraction.AbstractSupervisedFtExtractor;
import fr.profi.mzdb.algo.feature.extraction.DetectionAlgorithm$;
import fr.profi.mzdb.algo.feature.extraction.FeatureExtractorConfig;
import fr.profi.mzdb.algo.feature.extraction.OverlappingFeatureExtractorConfig;
import fr.profi.mzdb.algo.feature.extraction.OverlappingFeaturesExtractor$;
import fr.profi.mzdb.algo.feature.extraction.OverlappingFeaturesExtractor$$anonfun$_extractOverlappingFeatures$1$;
import fr.profi.mzdb.algo.feature.extraction.OverlappingStatus;
import fr.profi.mzdb.algo.feature.extraction.PeakelDetectionConfig;
import fr.profi.mzdb.algo.feature.scoring.FeatureScorer$;
import fr.profi.mzdb.model.Feature;
import fr.profi.mzdb.model.FeatureOverlapProperties;
import fr.profi.mzdb.model.FeatureOverlapProperties$;
import fr.profi.mzdb.model.OverlappingFeature;
import fr.profi.mzdb.model.PeakListTree;
import fr.profi.mzdb.model.Peakel;
import fr.profi.mzdb.model.PutativeFeature;
import fr.profi.mzdb.model.SpectrumHeader;
import java.util.concurrent.atomic.AtomicLong;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.LongMap;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.control.Breaks$;

@ScalaSignature(bytes="\u0006\u0001\u0005}t!B\u0001\u0003\u0011\u0003y\u0011\u0001H(wKJd\u0017\r\u001d9j]\u001e4U-\u0019;ve\u0016\u001cX\t\u001f;sC\u000e$xN\u001d\u0006\u0003\u0007\u0011\t!\"\u001a=ue\u0006\u001cG/[8o\u0015\t)a!A\u0004gK\u0006$XO]3\u000b\u0005\u001dA\u0011\u0001B1mO>T!!\u0003\u0006\u0002\t5THM\u0019\u0006\u0003\u00171\tQ\u0001\u001d:pM&T\u0011!D\u0001\u0003MJ\u001c\u0001\u0001\u0005\u0002\u0011#5\t!AB\u0003\u0013\u0005!\u00051C\u0001\u000fPm\u0016\u0014H.\u00199qS:<g)Z1ukJ,7/\u0012=ue\u0006\u001cGo\u001c:\u0014\u0005E!\u0002CA\u000b\u0019\u001b\u00051\"\"A\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005e1\"AB!osJ+g\rC\u0003\u001c#\u0011\u0005A$\u0001\u0004=S:LGO\u0010\u000b\u0002\u001f!9a$\u0005a\u0001\n\u0003y\u0012\u0001\u00048p]6{gn\\\"pk:$X#\u0001\u0011\u0011\u0005\u0005RS\"\u0001\u0012\u000b\u0005\r\"\u0013AB1u_6L7M\u0003\u0002&M\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005\u001dB\u0013\u0001B;uS2T\u0011!K\u0001\u0005U\u00064\u0018-\u0003\u0002,E\tQ\u0011\t^8nS\u000eduN\\4\t\u000f5\n\u0002\u0019!C\u0001]\u0005\u0001bn\u001c8N_:|7i\\;oi~#S-\u001d\u000b\u0003_I\u0002\"!\u0006\u0019\n\u0005E2\"\u0001B+oSRDqa\r\u0017\u0002\u0002\u0003\u0007\u0001%A\u0002yIEBa!N\t!B\u0013\u0001\u0013!\u00048p]6{gn\\\"pk:$\b\u0005C\u00048#E\u0005I\u0011\u0001\u001d\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133+\u0005I$F\u0001\u001eF!\rY\u0004IQ\u0007\u0002y)\u0011QHP\u0001\b[V$\u0018M\u00197f\u0015\tyd#\u0001\u0006d_2dWm\u0019;j_:L!!\u0011\u001f\u0003\u000f1{gnZ'baB\u0011QcQ\u0005\u0003\tZ\u0011QA\u00127pCR\\\u0013A\u0012\t\u0003\u000f2k\u0011\u0001\u0013\u0006\u0003\u0013*\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005-3\u0012AC1o]>$\u0018\r^5p]&\u0011Q\n\u0013\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,g\u0001\u0002\n\u0003\u0001=\u001b2A\u0014\u000bQ!\t\t\u0006,D\u0001S\u0015\t\u0019F+\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u0002V-\u0006AA/\u001f9fg\u00064WMC\u0001X\u0003\r\u0019w.\\\u0005\u00033J\u00131\u0002T1{s2{wmZ5oO\"A1L\u0014BC\u0002\u0013\u0005A,\u0001\nta\u0016\u001cGO];n\u0011\u0016\fG-\u001a:Cs&#W#A/\u0011\u0007m\u0002e\f\u0005\u0002`E6\t\u0001M\u0003\u0002b\u0011\u0005)Qn\u001c3fY&\u00111\r\u0019\u0002\u000f'B,7\r\u001e:v[\"+\u0017\rZ3s\u0011!)gJ!A!\u0002\u0013i\u0016aE:qK\u000e$(/^7IK\u0006$WM\u001d\"z\u0013\u0012\u0004\u0003\u0002C4O\u0005\u000b\u0007I\u0011\u00015\u0002\u001d94')_*qK\u000e$(/^7JIV\t!\b\u0003\u0005k\u001d\n\u0005\t\u0015!\u0003;\u0003=qgMQ=Ta\u0016\u001cGO];n\u0013\u0012\u0004\u0003\u0002\u00037O\u0005\u000b\u0007I\u0011A7\u0002\u0017\u0019$X\t\u001f;sC\u000e$xN]\u000b\u0002]B\u0011\u0001c\\\u0005\u0003a\n\u0011Q$\u00112tiJ\f7\r^*va\u0016\u0014h/[:fI\u001a#X\t\u001f;sC\u000e$xN\u001d\u0005\te:\u0013\t\u0011)A\u0005]\u0006aa\r^#yiJ\f7\r^8sA!)1D\u0014C\u0001iR!QO^<y!\t\u0001b\nC\u0003\\g\u0002\u0007Q\fC\u0004hgB\u0005\t\u0019\u0001\u001e\t\u000b1\u001c\b\u0019\u00018\t\u000fit%\u0019!C\u0001w\u0006a\u0001\u0010\u001e:bGR\u001cuN\u001c4jOV\tA\u0010\u0005\u0002\u0011{&\u0011aP\u0001\u0002\u0017\r\u0016\fG/\u001e:f\u000bb$(/Y2u_J\u001cuN\u001c4jO\"9\u0011\u0011\u0001(!\u0002\u0013a\u0018!\u0004=ue\u0006\u001cGoQ8oM&<\u0007\u0005C\u0005\u0002\u00069\u0013\r\u0011\"\u0001\u0002\b\u0005\u0019rN^3sY\u0006\u0004\b\f\u001e:bGR\u001cuN\u001c4jOV\u0011\u0011\u0011\u0002\t\u0004!\u0005-\u0011bAA\u0007\u0005\t\tsJ^3sY\u0006\u0004\b/\u001b8h\r\u0016\fG/\u001e:f\u000bb$(/Y2u_J\u001cuN\u001c4jO\"A\u0011\u0011\u0003(!\u0002\u0013\tI!\u0001\u000bpm\u0016\u0014H.\u00199YiJ\f7\r^\"p]\u001aLw\r\t\u0005\b\u0003+qE\u0011AA\f\u0003i)\u0007\u0010\u001e:bGR|e/\u001a:mCB\u0004\u0018N\\4GK\u0006$XO]3t)!\tI\"a\b\u0002*\u0005m\u0002c\u0001\t\u0002\u001c%\u0019\u0011Q\u0004\u0002\u0003#=3XM\u001d7baBLgnZ*uCR,8\u000f\u0003\u0005\u0002\"\u0005M\u0001\u0019AA\u0012\u0003\t1G\u000fE\u0002`\u0003KI1!a\na\u0005\u001d1U-\u0019;ve\u0016D\u0001\"a\u000b\u0002\u0014\u0001\u0007\u0011QF\u0001\u0007i\",w.\u0013)\u0011\t\u0005=\u0012qG\u0007\u0003\u0003cQ1!YA\u001a\u0015\r\t)DC\u0001\u0003[NLA!!\u000f\u00022\tIB\u000b[3pe\u0016$\u0018nY1m\u0013N|Go\u001c9f!\u0006$H/\u001a:o\u0011!\ti$a\u0005A\u0002\u0005}\u0012a\u00029lYR\u0013X-\u001a\t\u0004?\u0006\u0005\u0013bAA\"A\na\u0001+Z1l\u0019&\u001cH\u000f\u0016:fK\"9\u0011q\t(\u0005\n\u0005%\u0013aG0fqR\u0014\u0018m\u0019;Pm\u0016\u0014H.\u00199qS:<g)Z1ukJ,7\u000f\u0006\u0005\u0002L\u0005E\u00131KA/!\u0015)\u0012QJA\u0012\u0013\r\tyE\u0006\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\t\u0003C\t)\u00051\u0001\u0002$!A\u0011QKA#\u0001\u0004\t9&A\u0002gij\u00032!FA-\u0013\r\tYF\u0006\u0002\u0004\u0013:$\b\u0002CA\u001f\u0003\u000b\u0002\r!a\u0010\t\u000f\u0005\u0005d\n\"\u0003\u0002d\u0005Qr,\u001a<bYV\fG/Z(wKJd\u0017\r\u001d9j]\u001e\u001cF/\u0019;vgR1\u0011\u0011DA3\u0003OB\u0001\"!\t\u0002`\u0001\u0007\u00111\u0005\u0005\t\u0003S\ny\u00061\u0001\u0002L\u0005YqN\u001e7GK\u0006$XO]3t\u0011\u001d\tiG\u0014C\u0005\u0003_\nadX:fY\u0016\u001cGOQ3ti>3XM\u001d7baBLgn\u001a$fCR,(/Z:\u0015\r\u0005E\u0014\u0011PA>!\u0015)\u0012QJA:!\ry\u0016QO\u0005\u0004\u0003o\u0002'AE(wKJd\u0017\r\u001d9j]\u001e4U-\u0019;ve\u0016D\u0001\"!\t\u0002l\u0001\u0007\u00111\u0005\u0005\t\u0003{\nY\u00071\u0001\u0002L\u00051qN\u001e7GiN\u0004")
public class OverlappingFeaturesExtractor
implements LazyLogging {
    private final LongMap<SpectrumHeader> spectrumHeaderById;
    private final LongMap<Object> nfBySpectrumId;
    private final AbstractSupervisedFtExtractor ftExtractor;
    private final FeatureExtractorConfig xtractConfig;
    private final OverlappingFeatureExtractorConfig overlapXtractConfig;
    private final Logger logger;
    private volatile boolean bitmap$0;

    public static LongMap<Object> $lessinit$greater$default$2() {
        return OverlappingFeaturesExtractor$.MODULE$.$lessinit$greater$default$2();
    }

    public static void nonMonoCount_$eq(AtomicLong atomicLong) {
        OverlappingFeaturesExtractor$.MODULE$.nonMonoCount_$eq(atomicLong);
    }

    public static AtomicLong nonMonoCount() {
        return OverlappingFeaturesExtractor$.MODULE$.nonMonoCount();
    }

    private Logger logger$lzycompute() {
        OverlappingFeaturesExtractor overlappingFeaturesExtractor = this;
        synchronized (overlappingFeaturesExtractor) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public LongMap<SpectrumHeader> spectrumHeaderById() {
        return this.spectrumHeaderById;
    }

    public LongMap<Object> nfBySpectrumId() {
        return this.nfBySpectrumId;
    }

    public AbstractSupervisedFtExtractor ftExtractor() {
        return this.ftExtractor;
    }

    public FeatureExtractorConfig xtractConfig() {
        return this.xtractConfig;
    }

    public OverlappingFeatureExtractorConfig overlapXtractConfig() {
        return this.overlapXtractConfig;
    }

    public OverlappingStatus extractOverlappingFeatures(Feature ft, TheoreticalIsotopePattern theoIP, PeakListTree pklTree) {
        Predef$.MODULE$.require(!Predef$.MODULE$.refArrayOps((Object[])ft.indexedPeakels()).isEmpty(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "can not extract overlapping features of an empty feature. Returning Error";
            }
        });
        Feature[] ovlFeatures = this._extractOverlappingFeatures(ft, ft.charge(), pklTree);
        return this._evaluateOverlappingStatus(ft, ovlFeatures);
    }

    private Feature[] _extractOverlappingFeatures(Feature ft, int ftZ, PeakListTree pklTree) {
        int minZ = 2;
        int maxZ = 3;
        int maxIpShift = this.overlapXtractConfig().extractAllOvlFts() ? this.overlapXtractConfig().maxIpShift() : 1;
        float mzTolPPM = this.xtractConfig().mzTolPPM();
        Predef$.MODULE$.require(maxZ > 0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "maximum charge must be strictly positive";
            }
        });
        Predef$.MODULE$.require(maxIpShift > 0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "maximum IP shift must be strictly positive";
            }
        });
        Peakel firstFtPeakel = ft.getFirstPeakel();
        double firstFtMz = firstFtPeakel.getMz();
        long maxSpectrumId = firstFtPeakel.getApexSpectrumId();
        Predef$.MODULE$.require(maxSpectrumId != 0L);
        ArrayBuffer ovlFts = new ArrayBuffer();
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(minZ), maxZ).foreach$mVc$sp((Function1)new Serializable(this, pklTree, maxIpShift, firstFtMz, maxSpectrumId, ovlFts){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OverlappingFeaturesExtractor $outer;
            public final PeakListTree pklTree$1;
            public final int maxIpShift$1;
            public final double firstFtMz$1;
            public final long maxSpectrumId$1;
            public final ArrayBuffer ovlFts$1;

            public final void apply(int z) {
                this.apply$mcVI$sp(z);
            }

            public void apply$mcVI$sp(int z) {
                Breaks$.MODULE$.breakable((Function0)new Serializable(this, z){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$_extractOverlappingFeatures$1 $outer;
                    public final int z$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(-this.$outer.maxIpShift$1), 0).foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$_extractOverlappingFeatures$1$$anonfun$apply$mcVI$sp$1 $outer;

                            public final Object apply(int ipShift) {
                                BoxedUnit boxedUnit;
                                if (ipShift != 0) {
                                    double mzToExtract = this.$outer.fr$profi$mzdb$algo$feature$extraction$OverlappingFeaturesExtractor$$anonfun$$anonfun$$$outer().firstFtMz$1 + ((double)ipShift + (double)ipShift * 0.0027) / (double)this.$outer.z$1;
                                    PutativeFeature putativeFt = new PutativeFeature(-1, mzToExtract, this.$outer.z$1, this.$outer.fr$profi$mzdb$algo$feature$extraction$OverlappingFeaturesExtractor$$anonfun$$anonfun$$$outer().maxSpectrumId$1, 1);
                                    PeakelDetectionConfig ftXtractAlgoConfig = this.$outer.fr$profi$mzdb$algo$feature$extraction$OverlappingFeaturesExtractor$$anonfun$$anonfun$$$outer().fr$profi$mzdb$algo$feature$extraction$OverlappingFeaturesExtractor$$anonfun$$$outer().ftExtractor().peakelDetectionConfig().copy(DetectionAlgorithm$.MODULE$.BASIC(), true, this.$outer.fr$profi$mzdb$algo$feature$extraction$OverlappingFeaturesExtractor$$anonfun$$anonfun$$$outer().fr$profi$mzdb$algo$feature$extraction$OverlappingFeaturesExtractor$$anonfun$$$outer().ftExtractor().peakelDetectionConfig().copy$default$3());
                                    PutativeFeature x$2 = putativeFt;
                                    PeakListTree x$3 = this.$outer.fr$profi$mzdb$algo$feature$extraction$OverlappingFeaturesExtractor$$anonfun$$anonfun$$$outer().pklTree$1;
                                    PeakelDetectionConfig x$4 = ftXtractAlgoConfig;
                                    FeatureExtractorConfig x$5 = this.$outer.fr$profi$mzdb$algo$feature$extraction$OverlappingFeaturesExtractor$$anonfun$$anonfun$$$outer().fr$profi$mzdb$algo$feature$extraction$OverlappingFeaturesExtractor$$anonfun$$$outer().ftExtractor().searchAndExtractFeature$default$3();
                                    Option<Feature> featureAsOpt = this.$outer.fr$profi$mzdb$algo$feature$extraction$OverlappingFeaturesExtractor$$anonfun$$anonfun$$$outer().fr$profi$mzdb$algo$feature$extraction$OverlappingFeaturesExtractor$$anonfun$$$outer().ftExtractor().searchAndExtractFeature(x$2, x$3, x$5, x$4);
                                    if (featureAsOpt.isDefined()) {
                                        Feature ovlFt = (Feature)featureAsOpt.get();
                                        boxedUnit = this.$outer.fr$profi$mzdb$algo$feature$extraction$OverlappingFeaturesExtractor$$anonfun$$anonfun$$$outer().ovlFts$1.$plus$eq((Object)ovlFt);
                                    } else {
                                        boxedUnit = BoxedUnit.UNIT;
                                    }
                                } else {
                                    boxedUnit = BoxedUnit.UNIT;
                                }
                                return boxedUnit;
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                    }

                    public /* synthetic */ $anonfun$_extractOverlappingFeatures$1 fr$profi$mzdb$algo$feature$extraction$OverlappingFeaturesExtractor$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.z$1 = z$1;
                    }
                });
            }

            public /* synthetic */ OverlappingFeaturesExtractor fr$profi$mzdb$algo$feature$extraction$OverlappingFeaturesExtractor$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.pklTree$1 = pklTree$1;
                this.maxIpShift$1 = maxIpShift$1;
                this.firstFtMz$1 = firstFtMz$1;
                this.maxSpectrumId$1 = maxSpectrumId$1;
                this.ovlFts$1 = ovlFts$1;
            }
        });
        return (Feature[])ovlFts.toArray(ClassTag$.MODULE$.apply(Feature.class));
    }

    private OverlappingStatus _evaluateOverlappingStatus(Feature ft, Feature[] ovlFeatures) {
        FeatureOverlapProperties featureOverlapProperties;
        if (Predef$.MODULE$.refArrayOps((Object[])ovlFeatures).isEmpty()) {
            return new OverlappingStatus(false, false, null, null);
        }
        boolean overlapEvidence = true;
        OverlappingFeature[] bestOvlFts = this._selectBestOverlappingFeatures(ft, ovlFeatures);
        if (ft.overlapProperties() == null) {
            ft.overlapProperties_$eq(new FeatureOverlapProperties(FeatureOverlapProperties$.MODULE$.apply$default$1(), FeatureOverlapProperties$.MODULE$.apply$default$2(), FeatureOverlapProperties$.MODULE$.apply$default$3(), FeatureOverlapProperties$.MODULE$.apply$default$4()));
            featureOverlapProperties = ft.overlapProperties();
        } else {
            featureOverlapProperties = ft.overlapProperties();
        }
        FeatureOverlapProperties ftOverlapProperties = featureOverlapProperties;
        ftOverlapProperties.overlappingFeatures_$eq(bestOvlFts);
        if (!Predef$.MODULE$.refArrayOps((Object[])bestOvlFts).isEmpty()) {
            OverlappingFeature[] sortedOvlFts = (OverlappingFeature[])Predef$.MODULE$.refArrayOps((Object[])bestOvlFts).sortBy((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final float apply(OverlappingFeature ovlFt) {
                    return ovlFt.feature().getPeakel(package$.MODULE$.max(ovlFt.overlappingPeakelIndex() - 1, 0)).area();
                }
            }, (Ordering)Ordering.Float$.MODULE$);
            ftOverlapProperties.bestOverlappingFeature_$eq((OverlappingFeature)Predef$.MODULE$.refArrayOps((Object[])sortedOvlFts).last());
        }
        return new OverlappingStatus(true, !Predef$.MODULE$.refArrayOps((Object[])bestOvlFts).isEmpty(), ovlFeatures, bestOvlFts);
    }

    private OverlappingFeature[] _selectBestOverlappingFeatures(Feature ft, Feature[] ovlFts) {
        ArrayBuffer bestOvlFeatures = new ArrayBuffer();
        Peakel monoFtPeakel = ft.getFirstPeakel();
        double currFtMonoMz = monoFtPeakel.getMz();
        float minCorr = this.overlapXtractConfig().minPeakelCorrToMono();
        float minApexDistance = this.overlapXtractConfig().minApexDistance();
        float minAveragineRatio = this.overlapXtractConfig().minAveragineRatio();
        Predef$.MODULE$.refArrayOps((Object[])ovlFts).foreach((Function1)new Serializable(this, ft, bestOvlFeatures, monoFtPeakel, currFtMonoMz, minCorr, minApexDistance, minAveragineRatio){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OverlappingFeaturesExtractor $outer;
            private final Feature ft$1;
            private final ArrayBuffer bestOvlFeatures$1;
            private final Peakel monoFtPeakel$1;
            public final double currFtMonoMz$1;
            private final float minCorr$1;
            private final float minApexDistance$1;
            private final float minAveragineRatio$1;

            public final Object apply(Feature ovlFt) {
                Tuple2 prevOvlFtPeakelWithIdx = (Tuple2)Predef$.MODULE$.refArrayOps((Object[])ovlFt.indexedPeakels()).minBy((Function1)new Serializable(this, ovlFt){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$_selectBestOverlappingFeatures$1 $outer;
                    private final Feature ovlFt$1;

                    public final double apply(Tuple2<Peakel, Object> pWithIdx) {
                        return package$.MODULE$.abs(((Peakel)pWithIdx._1()).getMz() + 1.0027 / (double)this.ovlFt$1.getCharge() - this.$outer.currFtMonoMz$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.ovlFt$1 = ovlFt$1;
                    }
                }, (Ordering)Ordering.Double$.MODULE$);
                Tuple2 tuple2 = prevOvlFtPeakelWithIdx;
                if (tuple2 != null) {
                    BoxedUnit boxedUnit;
                    float quotient;
                    Tuple2 tuple22;
                    Peakel prevOvlFtPeakel = (Peakel)tuple2._1();
                    int prevOvlFtPeakelIdx = tuple2._2$mcI$sp();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)prevOvlFtPeakel, (Object)BoxesRunTime.boxToInteger((int)prevOvlFtPeakelIdx));
                    Peakel prevOvlFtPeakel2 = (Peakel)tuple23._1();
                    int prevOvlFtPeakelIdx2 = tuple23._2$mcI$sp();
                    int monoisotopicIndex = 0;
                    int apexDistanceInCycle = package$.MODULE$.abs(((SpectrumHeader)this.$outer.spectrumHeaderById().apply(prevOvlFtPeakel2.getApexSpectrumId())).getCycle() - ((SpectrumHeader)this.$outer.spectrumHeaderById().apply(this.monoFtPeakel$1.getApexSpectrumId())).getCycle());
                    float correlation = (float)FeatureScorer$.MODULE$.calcPeakelCorrelation(prevOvlFtPeakel2, this.monoFtPeakel$1);
                    TheoreticalIsotopePattern theoIP = IsotopePatternInterpolator$.MODULE$.getTheoreticalPattern(ovlFt.mz(), ovlFt.charge());
                    float[] abundances = theoIP.abundances();
                    float theoriticalQuotient = abundances[monoisotopicIndex] / abundances[monoisotopicIndex + 1];
                    float observedQuotient = prevOvlFtPeakel2.area() / this.monoFtPeakel$1.area();
                    float f = quotient = observedQuotient > theoriticalQuotient ? observedQuotient / theoriticalQuotient : theoriticalQuotient / observedQuotient;
                    if ((float)apexDistanceInCycle <= this.minApexDistance$1 && (double)correlation != Double.NaN && correlation > this.minCorr$1 && quotient < this.minAveragineRatio$1 && (double)quotient > 0.75) {
                        BoxedUnit boxedUnit2;
                        this.ft$1.hasMonoPeakel_$eq(false);
                        if (this.$outer.logger().underlying().isTraceEnabled()) {
                            this.$outer.logger().underlying().trace(" apexDist {}, correlation: {}, average ratio: {}", new Object[]{BoxesRunTime.boxToInteger((int)apexDistanceInCycle), BoxesRunTime.boxToFloat((float)correlation), BoxesRunTime.boxToFloat((float)quotient)});
                            boxedUnit2 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit2 = BoxedUnit.UNIT;
                        }
                        OverlappingFeaturesExtractor$.MODULE$.nonMonoCount().incrementAndGet();
                        boxedUnit = this.bestOvlFeatures$1.$plus$eq((Object)new OverlappingFeature(ovlFt, 0, prevOvlFtPeakelIdx2, apexDistanceInCycle, correlation, quotient));
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    return boxedUnit;
                }
                throw new MatchError((Object)tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.ft$1 = ft$1;
                this.bestOvlFeatures$1 = bestOvlFeatures$1;
                this.monoFtPeakel$1 = monoFtPeakel$1;
                this.currFtMonoMz$1 = currFtMonoMz$1;
                this.minCorr$1 = minCorr$1;
                this.minApexDistance$1 = minApexDistance$1;
                this.minAveragineRatio$1 = minAveragineRatio$1;
            }
        });
        return (OverlappingFeature[])bestOvlFeatures.toArray(ClassTag$.MODULE$.apply(OverlappingFeature.class));
    }

    public OverlappingFeaturesExtractor(LongMap<SpectrumHeader> spectrumHeaderById, LongMap<Object> nfBySpectrumId, AbstractSupervisedFtExtractor ftExtractor) {
        this.spectrumHeaderById = spectrumHeaderById;
        this.nfBySpectrumId = nfBySpectrumId;
        this.ftExtractor = ftExtractor;
        LazyLogging.class.$init$((LazyLogging)this);
        this.xtractConfig = ftExtractor.xtractConfig();
        this.overlapXtractConfig = ftExtractor.overlapXtractConfig();
    }
}

