/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.model;

import fr.profi.mzdb.model.ILcContext;
import fr.profi.mzdb.model.Peak;
import fr.profi.mzdb.model.PeakList$;
import fr.profi.mzdb.model.Spectrum;
import fr.profi.mzdb.model.SpectrumData;
import fr.profi.mzdb.model.SpectrumHeader;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\t}u!B\u0001\u0003\u0011\u0003Y\u0011\u0001\u0003)fC.d\u0015n\u001d;\u000b\u0005\r!\u0011!B7pI\u0016d'BA\u0003\u0007\u0003\u0011i'\u0010\u001a2\u000b\u0005\u001dA\u0011!\u00029s_\u001aL'\"A\u0005\u0002\u0005\u0019\u00148\u0001\u0001\t\u0003\u00195i\u0011A\u0001\u0004\u0006\u001d\tA\ta\u0004\u0002\t!\u0016\f7\u000eT5tiN\u0019Q\u0002\u0005\f\u0011\u0005E!R\"\u0001\n\u000b\u0003M\tQa]2bY\u0006L!!\u0006\n\u0003\r\u0005s\u0017PU3g!\t\tr#\u0003\u0002\u0019%\ta1+\u001a:jC2L'0\u00192mK\")!$\u0004C\u00017\u00051A(\u001b8jiz\"\u0012a\u0003\u0005\u0006;5!\tAH\u0001\u0019g>\u0014H\u000fU3bWN\u0014\u0015\u0010R3tG&sG/\u001a8tSRLHCA\u0010#!\t\t\u0002%\u0003\u0002\"%\t!QK\\5u\u0011\u0015\u0019C\u00041\u0001%\u0003\u0015\u0001X-Y6t!\r\tReJ\u0005\u0003MI\u0011Q!\u0011:sCf\u0004\"\u0001\u0004\u0015\n\u0005%\u0012!\u0001\u0002)fC.DQaK\u0007\u0005\u00021\n\u0001c]8siB+\u0017m[:Cs\u0006\u001b8-\u0014>\u0015\u0005}i\u0003\"B\u0012+\u0001\u0004!\u0003\"B\u0018\u000e\t\u0003\u0001\u0014AH:peR\u0004V-Y6t\u0007>|'\u000fZ:Cs\u0012+7oY%oi\u0016t7/\u001b;z)\r\td\u0007\u000f\t\u0004#\u0015\u0012\u0004cA\t&gA\u0011\u0011\u0003N\u0005\u0003kI\u00111!\u00138u\u0011\u00159d\u00061\u00012\u0003-\u0001X-Y6t\u0007>|'\u000fZ:\t\u000ber\u0003\u0019\u0001\u001e\u0002\u001b%tG/\u001a8tSRLH*[:u!\r\tRe\u000f\t\u0003#qJ!!\u0010\n\u0003\u000b\u0019cw.\u0019;\t\u000b}jA\u0011\u0003!\u0002\u001fM|'\u000f\u001e)fC.\u001c8i\\8sIN$2!M!C\u0011\u00159d\b1\u00012\u0011\u0015\u0019e\b1\u0001E\u00035\u0001X-Y6t\u001fJ$WM]5oOB\u0019Q)\u0014)\u000f\u0005\u0019[eBA$K\u001b\u0005A%BA%\u000b\u0003\u0019a$o\\8u}%\t1#\u0003\u0002M%\u00059\u0001/Y2lC\u001e,\u0017B\u0001(P\u0005!y%\u000fZ3sS:<'B\u0001'\u0013!\t\tf+D\u0001S\u0015\t\u0019F+\u0001\u0003mC:<'\"A+\u0002\t)\fg/Y\u0005\u0003/J\u0013q!\u00138uK\u001e,'\u000fC\u0004Z\u001b\u0005\u0005I\u0011\u0011.\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0013m\u0013iG!\u001d\u0003v\te\u0004C\u0001\u0007]\r\u0011q!\u0001Q/\u0014\tq\u0003bL\u0006\t\u0003#}K!\u0001\u0019\n\u0003\u000fA\u0013x\u000eZ;di\"A!\r\u0018BK\u0002\u0013\u00051-\u0001\u0005ta\u0016\u001cGO];n+\u0005!\u0007C\u0001\u0007f\u0013\t1'A\u0001\u0005Ta\u0016\u001cGO];n\u0011!AGL!E!\u0002\u0013!\u0017!C:qK\u000e$(/^7!Q\t9'\u000e\u0005\u0002l]6\tAN\u0003\u0002n%\u0005)!-Z1og&\u0011q\u000e\u001c\u0002\r\u0005\u0016\fg\u000e\u0015:pa\u0016\u0014H/\u001f\u0005\u0006cr#\tA]\u0001\fO\u0016$8\u000b]3diJ,X\u000eF\u0001e\u0011!!HL!f\u0001\n\u0003)\u0018A\u00039fC.\u001c8i\\;oiV\t1\u0007\u0003\u0005x9\nE\t\u0015!\u00034\u0003-\u0001X-Y6t\u0007>,h\u000e\u001e\u0011)\u0005YT\u0007\"\u0002>]\t\u0003Y\u0018!D4fiB+\u0017m[:D_VtG\u000fF\u00014\u0011!iHL!f\u0001\n\u0003q\u0018!B7j]6SX#A@\u0011\u0007E\t\t!C\u0002\u0002\u0004I\u0011a\u0001R8vE2,\u0007\"CA\u00049\nE\t\u0015!\u0003\u0000\u0003\u0019i\u0017N\\'{A!\u001a\u0011Q\u00016\t\u000f\u00055A\f\"\u0001\u0002\u0010\u0005Aq-\u001a;NS:l%\u0010F\u0001\u0000\u0011%\t\u0019\u0002\u0018BK\u0002\u0013\u0005a0A\u0003nCbl%\u0010C\u0005\u0002\u0018q\u0013\t\u0012)A\u0005\u007f\u00061Q.\u0019=Nu\u0002B3!!\u0006k\u0011\u001d\ti\u0002\u0018C\u0001\u0003\u001f\t\u0001bZ3u\u001b\u0006DXJ\u001f\u0005\u00075q#\t\"!\t\u0015\u0013m\u000b\u0019#!\n\u0002(\u0005%\u0002B\u00022\u0002 \u0001\u0007A\r\u0003\u0004u\u0003?\u0001\ra\r\u0005\u0007{\u0006}\u0001\u0019A@\t\u000f\u0005M\u0011q\u0004a\u0001\u007f\"A\u0011Q\u0006/C\u0002\u0013%a0\u0001\nN5~Ke\nR#Y?B\u0013ViQ%T\u0013>s\u0005bBA\u00199\u0002\u0006Ia`\u0001\u0014\u001bj{\u0016J\u0014#F1~\u0003&+R\"J'&{e\n\t\u0005\b\u0003kaF\u0011CA\u001c\u0003-\u0019\u0017\r\\2Nu&sG-\u001a=\u0015\t\u0005e\u0012q\b\t\u0004#\u0005m\u0012bAA\u001f%\t!Aj\u001c8h\u0011\u001d\t\t%a\rA\u0002}\f!!\u001c>\t\riaF\u0011AA#)\rY\u0016q\t\u0005\u0007E\u0006\r\u0003\u0019\u00013\t\u0011\u0005-CL1A\u0005\ny\f\u0001\"\u001c>XS:$wn\u001e\u0005\b\u0003\u001fb\u0006\u0015!\u0003\u0000\u0003%i'pV5oI><\b\u0005C\u0005\u0002Tq\u0013\r\u0011\"\u0003\u0002V\u0005q1\u000f]3diJ,X\u000eS3bI\u0016\u0014XCAA,!\ra\u0011\u0011L\u0005\u0004\u00037\u0012!AD*qK\u000e$(/^7IK\u0006$WM\u001d\u0005\t\u0003?b\u0006\u0015!\u0003\u0002X\u0005y1\u000f]3diJ,X\u000eS3bI\u0016\u0014\b\u0005C\u0005\u0002dq\u0013\r\u0011\"\u0003\u0002f\u0005a1\u000f]3diJ,X\u000eR1uCV\u0011\u0011q\r\t\u0004\u0019\u0005%\u0014bAA6\u0005\ta1\u000b]3diJ,X\u000eR1uC\"A\u0011q\u000e/!\u0002\u0013\t9'A\u0007ta\u0016\u001cGO];n\t\u0006$\u0018\r\t\u0005\n\u0003gb&\u0019!C\u0005\u0003k\na!\u001c>MSN$XCAA<!\r\tRe \u0005\t\u0003wb\u0006\u0015!\u0003\u0002x\u00059QN\u001f'jgR\u0004\u0003\u0002C\u001d]\u0005\u0004%I!a \u0016\u0003iBq!a!]A\u0003%!(\u0001\bj]R,gn]5us2K7\u000f\u001e\u0011\t\u0013\u0005\u001dEL1A\u0005\n\u0005}\u0014\u0001\u00047fMRDu\u000f[7MSN$\bbBAF9\u0002\u0006IAO\u0001\u000eY\u00164G\u000fS<i[2K7\u000f\u001e\u0011\t\u0013\u0005=EL1A\u0005\n\u0005}\u0014!\u0004:jO\"$\bj\u001e5n\u0019&\u001cH\u000fC\u0004\u0002\u0014r\u0003\u000b\u0011\u0002\u001e\u0002\u001dILw\r\u001b;Io\"lG*[:uA!9\u0011q\u0013/\u0005\u0002\u0005e\u0015!E4fiN\u0003Xm\u0019;sk6DU-\u00193feR\u0011\u0011q\u000b\u0005\b\u0003;cF\u0011AAP\u0003=9W\r^*qK\u000e$(/^7ECR\fGCAA4\u0011\u001d\t\u0019\u000b\u0018C\u0001\u0003K\u000b\u0011bZ3u\u001bjd\u0015n\u001d;\u0015\u0005\u0005]\u0004bBAU9\u0012\u0005\u00111V\u0001\u0011O\u0016$\u0018J\u001c;f]NLG/\u001f'jgR$\u0012A\u000f\u0005\b\u0003_cF\u0011AAV\u0003=9W\r\u001e'fMRDu\u000f[7MSN$\bbBAZ9\u0012\u0005\u00111V\u0001\u0011O\u0016$(+[4ii\";\b.\u001c'jgRDq!a.]\t\u0003\tI,A\u0005ck&dG\rU3bWR\u0019q%a/\t\u000f\u0005u\u0016Q\u0017a\u0001g\u00059\u0001/Z1l\u0013\u0012D\bbBAa9\u0012\u0005\u00111Y\u0001\nO\u0016$\b+Z1l\u0003R$2aJAc\u0011\u001d\ti,a0A\u0002MBq!!3]\t\u0003\tY-\u0001\bhKRtU-\u0019:fgR\u0004V-Y6\u0015\u000b\u001d\ni-!5\t\u000f\u0005=\u0017q\u0019a\u0001\u007f\u0006YQN\u001f+p\u000bb$(/Y2u\u0011\u001d\t\u0019.a2A\u0002}\fq!\u001c>U_2$\u0015\rC\u0004\u0002Xr#\t!!7\u0002#\u001d,GOT3be\u0016\u001cH\u000fU3bW&#\u0007\u0010F\u00034\u00037\fi\u000eC\u0004\u0002P\u0006U\u0007\u0019A@\t\u000f\u0005M\u0017Q\u001ba\u0001\u007f\"I\u0011\u0011\u001d/\u0002\u0002\u0013\u0005\u00111]\u0001\u0005G>\u0004\u0018\u0010F\u0005\\\u0003K\f9/!;\u0002l\"A!-a8\u0011\u0002\u0003\u0007A\r\u0003\u0005u\u0003?\u0004\n\u00111\u00014\u0011!i\u0018q\u001cI\u0001\u0002\u0004y\b\"CA\n\u0003?\u0004\n\u00111\u0001\u0000\u0011%\ty\u000fXI\u0001\n\u0003\t\t0\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005M(f\u00013\u0002v.\u0012\u0011q\u001f\t\u0005\u0003s\u0014\u0019!\u0004\u0002\u0002|*!\u0011Q`A\u0000\u0003%)hn\u00195fG.,GMC\u0002\u0003\u0002I\t!\"\u00198o_R\fG/[8o\u0013\u0011\u0011)!a?\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u0003\nq\u000b\n\u0011\"\u0001\u0003\f\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TC\u0001B\u0007U\r\u0019\u0014Q\u001f\u0005\n\u0005#a\u0016\u0013!C\u0001\u0005'\tabY8qs\u0012\"WMZ1vYR$3'\u0006\u0002\u0003\u0016)\u001aq0!>\t\u0013\teA,%A\u0005\u0002\tM\u0011AD2paf$C-\u001a4bk2$H\u0005\u000e\u0005\n\u0005;a\u0016\u0011!C!\u0005?\tQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXC\u0001B\u0011!\r\t&1E\u0005\u0004\u0005K\u0011&AB*ue&tw\r\u0003\u0005\u0003*q\u000b\t\u0011\"\u0001v\u00031\u0001(o\u001c3vGR\f%/\u001b;z\u0011%\u0011i\u0003XA\u0001\n\u0003\u0011y#\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\tE\"q\u0007\t\u0004#\tM\u0012b\u0001B\u001b%\t\u0019\u0011I\\=\t\u0013\te\"1FA\u0001\u0002\u0004\u0019\u0014a\u0001=%c!I!Q\b/\u0002\u0002\u0013\u0005#qH\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!\u0011\t\t\u0007\u0005\u0007\u0012IE!\r\u000e\u0005\t\u0015#b\u0001B$%\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\t-#Q\t\u0002\t\u0013R,'/\u0019;pe\"I!q\n/\u0002\u0002\u0013\u0005!\u0011K\u0001\tG\u0006tW)];bYR!!1\u000bB-!\r\t\"QK\u0005\u0004\u0005/\u0012\"a\u0002\"p_2,\u0017M\u001c\u0005\u000b\u0005s\u0011i%!AA\u0002\tE\u0002\u0002\u0003B/9\u0006\u0005I\u0011I>\u0002\u0011!\f7\u000f[\"pI\u0016D\u0011B!\u0019]\u0003\u0003%\tEa\u0019\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"A!\t\t\u0013\t\u001dD,!A\u0005B\t%\u0014AB3rk\u0006d7\u000f\u0006\u0003\u0003T\t-\u0004B\u0003B\u001d\u0005K\n\t\u00111\u0001\u00032!)!\r\u0017a\u0001I\"\u001a!Q\u000e6\t\u000bQD\u0006\u0019A\u001a)\u0007\tE$\u000eC\u0003~1\u0002\u0007q\u0010K\u0002\u0003v)Da!a\u0005Y\u0001\u0004y\bf\u0001B=U\"I!qP\u0007\u0002\u0002\u0013\u0005%\u0011Q\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011\u0019Ia$\u0011\u000bE\u0011)I!#\n\u0007\t\u001d%C\u0001\u0004PaRLwN\u001c\t\b#\t-EmM@\u0000\u0013\r\u0011iI\u0005\u0002\u0007)V\u0004H.\u001a\u001b\t\u0013\tE%QPA\u0001\u0002\u0004Y\u0016a\u0001=%a!I!QS\u0007\u0002\u0002\u0013%!qS\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0003\u001aB\u0019\u0011Ka'\n\u0007\tu%K\u0001\u0004PE*,7\r\u001e")
public class PeakList
implements Product,
Serializable {
    private final Spectrum spectrum;
    private final int peaksCount;
    private final double minMz;
    private final double maxMz;
    private final double MZ_INDEX_PRECISION;
    private final double mzWindow;
    private final SpectrumHeader spectrumHeader;
    private final SpectrumData spectrumData;
    private final double[] mzList;
    private final float[] intensityList;
    private final float[] leftHwhmList;
    private final float[] rightHwhmList;

    public static Option<Tuple4<Spectrum, Object, Object, Object>> unapply(PeakList peakList) {
        return PeakList$.MODULE$.unapply(peakList);
    }

    public static PeakList apply(Spectrum spectrum, int n, double d, double d2) {
        return PeakList$.MODULE$.apply(spectrum, n, d, d2);
    }

    public static int[][] sortPeaksCoordsByDescIntensity(int[][] nArray, float[] fArray) {
        return PeakList$.MODULE$.sortPeaksCoordsByDescIntensity(nArray, fArray);
    }

    public static void sortPeaksByAscMz(Peak[] peakArray) {
        PeakList$.MODULE$.sortPeaksByAscMz(peakArray);
    }

    public static void sortPeaksByDescIntensity(Peak[] peakArray) {
        PeakList$.MODULE$.sortPeaksByDescIntensity(peakArray);
    }

    public Spectrum spectrum() {
        return this.spectrum;
    }

    public int peaksCount() {
        return this.peaksCount;
    }

    public double minMz() {
        return this.minMz;
    }

    public double maxMz() {
        return this.maxMz;
    }

    private double MZ_INDEX_PRECISION() {
        return this.MZ_INDEX_PRECISION;
    }

    public long calcMzIndex(double mz) {
        return (long)(mz / this.MZ_INDEX_PRECISION());
    }

    private double mzWindow() {
        return this.mzWindow;
    }

    private SpectrumHeader spectrumHeader() {
        return this.spectrumHeader;
    }

    private SpectrumData spectrumData() {
        return this.spectrumData;
    }

    private double[] mzList() {
        return this.mzList;
    }

    private float[] intensityList() {
        return this.intensityList;
    }

    private float[] leftHwhmList() {
        return this.leftHwhmList;
    }

    private float[] rightHwhmList() {
        return this.rightHwhmList;
    }

    public SpectrumHeader getSpectrumHeader() {
        return this.spectrumHeader();
    }

    public SpectrumData getSpectrumData() {
        return this.spectrumData();
    }

    public double[] getMzList() {
        return this.mzList();
    }

    public float[] getIntensityList() {
        return this.intensityList();
    }

    public float[] getLeftHwhmList() {
        return this.leftHwhmList();
    }

    public float[] getRightHwhmList() {
        return this.rightHwhmList();
    }

    public Peak buildPeak(int peakIdx) {
        if (peakIdx == -1) {
            return null;
        }
        return new Peak(this.mzList()[peakIdx], this.intensityList()[peakIdx], this.leftHwhmList() == null ? 0.0f : this.leftHwhmList()[peakIdx], this.rightHwhmList() == null ? 0.0f : this.rightHwhmList()[peakIdx], (ILcContext)this.spectrumHeader());
    }

    public Peak getPeakAt(int peakIdx) {
        return this.buildPeak(peakIdx);
    }

    public Peak getNearestPeak(double mzToExtract, double mzTolDa) {
        int nearestPeakIdx = this.getNearestPeakIdx(mzToExtract, mzTolDa);
        if (nearestPeakIdx == -1) {
            return null;
        }
        return this.buildPeak(nearestPeakIdx);
    }

    public int getNearestPeakIdx(double mzToExtract, double mzTolDa) {
        if (this.peaksCount() == 0) {
            return -1;
        }
        double searchedMinMz = mzToExtract - mzTolDa;
        double searchedMaxMz = mzToExtract + mzTolDa;
        if (searchedMinMz > this.maxMz() || searchedMaxMz < this.minMz()) {
            return -1;
        }
        int nPeaks = this.peaksCount();
        int expectedNearestIdx = mzToExtract < this.minMz() ? 0 : (mzToExtract > this.maxMz() ? nPeaks - 1 : (int)((double)(nPeaks - 1) * (mzToExtract - this.minMz()) / this.mzWindow()));
        Predef$.MODULE$.assert(expectedNearestIdx >= 0 && expectedNearestIdx < nPeaks, (Function0)new Serializable(this, nPeaks, expectedNearestIdx){
            public static final long serialVersionUID = 0L;
            private final int nPeaks$1;
            private final int expectedNearestIdx$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"invalid expectedNearestIdx=", " while peaks count is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.expectedNearestIdx$1), BoxesRunTime.boxToInteger((int)this.nPeaks$1)}));
            }
            {
                this.nPeaks$1 = nPeaks$1;
                this.expectedNearestIdx$1 = expectedNearestIdx$1;
            }
        });
        double mzAtExpectedNearestIdx = this.mzList()[expectedNearestIdx];
        int idxOffset = mzAtExpectedNearestIdx < mzToExtract ? 1 : -1;
        double lowestDeltaMz = mzTolDa;
        double prevDeltaMz = this.mzWindow();
        int nearestMzIdx = -1;
        boolean outOfRange = false;
        for (int mzIdx = expectedNearestIdx; mzIdx >= 0 && mzIdx < nPeaks && !outOfRange; mzIdx += idxOffset) {
            double absDeltaMz;
            double mz = this.mzList()[mzIdx];
            double deltaMz = mz - mzToExtract;
            double d = absDeltaMz = deltaMz <= 0.0 ? 0.0 - deltaMz : deltaMz;
            if (absDeltaMz < lowestDeltaMz) {
                lowestDeltaMz = absDeltaMz;
                nearestMzIdx = mzIdx;
            } else if (absDeltaMz > prevDeltaMz) {
                outOfRange = true;
            }
            prevDeltaMz = absDeltaMz;
        }
        return nearestMzIdx;
    }

    public Spectrum getSpectrum() {
        return this.spectrum();
    }

    public int getPeaksCount() {
        return this.peaksCount();
    }

    public double getMinMz() {
        return this.minMz();
    }

    public double getMaxMz() {
        return this.maxMz();
    }

    public PeakList copy(Spectrum spectrum, int peaksCount, double minMz, double maxMz) {
        return new PeakList(spectrum, peaksCount, minMz, maxMz);
    }

    public Spectrum copy$default$1() {
        return this.spectrum();
    }

    public int copy$default$2() {
        return this.peaksCount();
    }

    public double copy$default$3() {
        return this.minMz();
    }

    public double copy$default$4() {
        return this.maxMz();
    }

    public String productPrefix() {
        return "PeakList";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 3: {
                object = BoxesRunTime.boxToDouble((double)this.maxMz());
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToDouble((double)this.minMz());
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToInteger((int)this.peaksCount());
                break;
            }
            case 0: {
                object = this.spectrum();
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof PeakList;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.spectrum()));
        n = Statics.mix((int)n, (int)this.peaksCount());
        n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.minMz()));
        n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.maxMz()));
        return Statics.finalizeHash((int)n, (int)4);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof PeakList)) return false;
        boolean bl = true;
        if (!bl) return false;
        PeakList peakList = (PeakList)x$1;
        Spectrum spectrum = this.spectrum();
        Spectrum spectrum2 = peakList.spectrum();
        if (spectrum == null) {
            if (spectrum2 != null) {
                return false;
            }
        } else if (!spectrum.equals(spectrum2)) return false;
        if (this.peaksCount() != peakList.peaksCount()) return false;
        if (this.minMz() != peakList.minMz()) return false;
        if (this.maxMz() != peakList.maxMz()) return false;
        if (!peakList.canEqual(this)) return false;
        return true;
    }

    public PeakList(Spectrum spectrum, int peaksCount, double minMz, double maxMz) {
        this.spectrum = spectrum;
        this.peaksCount = peaksCount;
        this.minMz = minMz;
        this.maxMz = maxMz;
        Product.class.$init$((Product)this);
        this.MZ_INDEX_PRECISION = 0.1;
        this.mzWindow = maxMz - minMz;
        this.spectrumHeader = spectrum.getHeader();
        this.spectrumData = spectrum.getData();
        this.mzList = this.spectrumData().getMzList();
        this.intensityList = this.spectrumData().getIntensityList();
        this.leftHwhmList = this.spectrumData().getLeftHwhmList();
        this.rightHwhmList = this.spectrumData().getRightHwhmList();
    }

    public PeakList(Spectrum spectrum) {
        this(spectrum, spectrum.getData().getPeaksCount(), spectrum.getData().getMinMz(), spectrum.getData().getMaxMz());
    }
}

