/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.peakeldb.io;

import com.almworks.sqlite4java.SQLiteConnection;
import com.almworks.sqlite4java.SQLiteStatement;
import fr.profi.mzdb.model.Peakel;
import fr.profi.mzdb.model.PeakelDataMatrix;
import fr.profi.mzdb.model.PeakelDataMatrix$;
import fr.profi.mzdb.model.SpectrumHeader;
import fr.profi.mzdb.peakeldb.io.PeakelDbWriter$;
import fr.profi.util.collection.package;
import fr.profi.util.collection.package$;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.LongMap;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class PeakelDbWriter$ {
    public static final PeakelDbWriter$ MODULE$;

    static {
        new PeakelDbWriter$();
    }

    /*
     * WARNING - void declaration
     */
    public SQLiteConnection initPeakelStore(File fileLocation) {
        void var2_2;
        SQLiteConnection connection = new SQLiteConnection(fileLocation);
        connection.open(true);
        connection.exec("PRAGMA synchronous=OFF;");
        connection.exec("PRAGMA journal_mode=OFF;");
        connection.exec("PRAGMA temp_store=2;");
        connection.exec("PRAGMA cache_size=100000;");
        String ddlQuery = "\r\nCREATE TABLE peakeldb_file (\r\n                id INTEGER NOT NULL,\r\n                name VARCHAR NOT NULL,\r\n                description VARCHAR,\r\n                raw_file_name VARCHAR NOT NULL,\r\n                is_dia_experiment BOOLEAN NOT NULL,\r\n                creation_timestamp TIMESTAMP NOT NULL,\r\n                modification_timestamp TIMESTAMP NOT NULL,\r\n                serialized_properties CLOB,\r\n                CONSTRAINT peakeldb_file_pk PRIMARY KEY (id)\r\n);\r\n\r\nCREATE TABLE lcms_map (\r\n                id INTEGER NOT NULL,\r\n                ms_level INTEGER NOT NULL,\r\n                peakel_count INTEGER NOT NULL,\r\n                serialized_properties CLOB,\r\n                peakeldb_file_id INTEGER NOT NULL,\r\n                CONSTRAINT lcms_map_pk PRIMARY KEY (id),\r\n                CONSTRAINT peakeldb_file_lcms_map_fk FOREIGN KEY (peakeldb_file_id) REFERENCES peakeldb_file (id)\r\n);\r\n\r\nCREATE TABLE lcms_map_relation (\r\n                parent_lcms_map_id INTEGER NOT NULL,\r\n                child_lcms_map_id INTEGER NOT NULL,\r\n                min_parent_mz REAL NOT NULL,\r\n                max_parent_mz REAL NOT NULL,\r\n                CONSTRAINT lcms_map_relation_pk PRIMARY KEY (parent_lcms_map_id, child_lcms_map_id)\r\n                CONSTRAINT lcms_map_lcms_map_relation_fk1 FOREIGN KEY (parent_lcms_map_id) REFERENCES lcms_map (id)\r\n                CONSTRAINT lcms_map_lcms_map_relation_fk2 FOREIGN KEY (child_lcms_map_id) REFERENCES lcms_map (id)\t\t\r\n);\r\n\r\nCREATE TABLE peakel (\r\n                id INTEGER NOT NULL,\r\n                moz DOUBLE NOT NULL,\r\n                elution_time REAL NOT NULL,\r\n                duration REAL NOT NULL,\r\n                gap_count INTEGER NOT NULL,\r\n                apex_intensity REAL NOT NULL,\r\n                area REAL NOT NULL,\r\n                amplitude REAL NOT NULL,\r\n                intensity_cv REAL NOT NULL,\r\n                left_hwhm_mean REAL,\r\n                left_hwhm_cv REAL,\r\n                right_hwhm_mean REAL,\r\n                right_hwhm_cv REAL,\r\n                is_interfering BOOLEAN NOT NULL,\r\n                peak_count INTEGER NOT NULL,\r\n                peaks BLOB NOT NULL,\r\n                serialized_properties CLOB,\r\n                first_spectrum_id INTEGER NOT NULL,\r\n                apex_spectrum_id INTEGER NOT NULL,\r\n                last_spectrum_id INTEGER NOT NULL,\r\n                map_id INTEGER NOT NULL,\r\n                CONSTRAINT peakel_pk PRIMARY KEY (id)\r\n                CONSTRAINT lcms_map_peakel_fk FOREIGN KEY (map_id) REFERENCES lcms_map (id)\r\n);\r\n\r\nCREATE INDEX peakel_map_idx ON peakel ( map_id );\r\n\r\nCREATE TABLE peakel_rtree (\r\n                id INTEGER NOT NULL,\r\n                min_lcms_map_id INTEGER NOT NULL,\r\n                max_lcms_map_id INTEGER NOT NULL,\r\n                min_mz REAL NOT NULL,\r\n                max_mz REAL NOT NULL,\r\n                min_time REAL NOT NULL,\r\n                max_time REAL NOT NULL,\r\n                CONSTRAINT peakel_rtree_pk PRIMARY KEY (id)\r\n                CONSTRAINT peakel_peakel_rtree_fk FOREIGN KEY (id) REFERENCES peakel (id)\r\n);\r\n\r\n";
        connection.exec(ddlQuery);
        connection.exec("BEGIN TRANSACTION;");
        SQLiteStatement peakelDbFileStmt = connection.prepare(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"INSERT INTO peakeldb_file VALUES (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])Array$.MODULE$.fill(8, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "?";
            }
        }, ClassTag$.MODULE$.apply(String.class))).mkString(",")})));
        peakelDbFileStmt.bind(1, 1);
        peakelDbFileStmt.bind(2, "no name");
        peakelDbFileStmt.bindNull(3);
        peakelDbFileStmt.bind(4, "no name");
        peakelDbFileStmt.bind(5, 1);
        peakelDbFileStmt.bind(6, new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        peakelDbFileStmt.bind(7, new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        peakelDbFileStmt.bindNull(8);
        peakelDbFileStmt.step();
        SQLiteStatement lcmsMapStmt = connection.prepare(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"INSERT INTO lcms_map VALUES (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])Array$.MODULE$.fill(5, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "?";
            }
        }, ClassTag$.MODULE$.apply(String.class))).mkString(",")})));
        lcmsMapStmt.bind(1, 1);
        lcmsMapStmt.bind(2, 1);
        lcmsMapStmt.bind(3, 0);
        lcmsMapStmt.bindNull(4);
        lcmsMapStmt.bind(5, 1);
        lcmsMapStmt.step();
        connection.exec("COMMIT TRANSACTION;");
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public void storePeakelsInPeakelDB(SQLiteConnection sqliteConn, Peakel[] peakels, SpectrumHeader[] ms1SpecHeaders) {
        LongMap initialIdByMzDbSpecId = package.LongMapBuilderFromTraversableOnce$.MODULE$.toLongMapWith$extension(package$.MODULE$.array2longMapBuilder((Object)ms1SpecHeaders), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(SpectrumHeader sh) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)sh.getId())), (Object)BoxesRunTime.boxToInteger((int)sh.getInitialId()));
            }
        });
        LongMap cycleByMzDbSpecId = package.LongMapBuilderFromTraversableOnce$.MODULE$.toLongMapWith$extension(package$.MODULE$.array2longMapBuilder((Object)ms1SpecHeaders), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(SpectrumHeader sh) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)sh.getId())), (Object)BoxesRunTime.boxToInteger((int)sh.getCycle()));
            }
        });
        sqliteConn.exec("BEGIN TRANSACTION;");
        SQLiteStatement peakelStmt = sqliteConn.prepare(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"INSERT INTO peakel VALUES (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])Array$.MODULE$.fill(21, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "?";
            }
        }, ClassTag$.MODULE$.apply(String.class))).mkString(",")})));
        SQLiteStatement peakelIndexStmt = sqliteConn.prepare(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"INSERT INTO peakel_rtree VALUES (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])Array$.MODULE$.fill(7, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "?";
            }
        }, ClassTag$.MODULE$.apply(String.class))).mkString(",")})));
        try {
            Predef$.MODULE$.refArrayOps((Object[])peakels).foreach((Function1)new Serializable(initialIdByMzDbSpecId, cycleByMzDbSpecId, peakelStmt, peakelIndexStmt){
                public static final long serialVersionUID = 0L;
                public final LongMap initialIdByMzDbSpecId$1;
                private final LongMap cycleByMzDbSpecId$1;
                private final SQLiteStatement peakelStmt$1;
                private final SQLiteStatement peakelIndexStmt$1;

                public final SQLiteStatement apply(Peakel peakel) {
                    int[] scanInitialIds = (int[])Predef$.MODULE$.longArrayOps(peakel.getSpectrumIds()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.storePeakelsInPeakelDB.1 $outer;

                        public final int apply(long x$1) {
                            return this.apply$mcIJ$sp(x$1);
                        }

                        public int apply$mcIJ$sp(long x$1) {
                            return BoxesRunTime.unboxToInt((Object)this.$outer.initialIdByMzDbSpecId$1.apply(x$1));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
                    PeakelDataMatrix peakelMessage = peakel.toPeakelDataMatrix();
                    byte[] peakelMessageAsBytes = PeakelDataMatrix$.MODULE$.pack(peakelMessage);
                    double peakelMz = peakel.getMz();
                    float peakelTime = peakel.getApexElutionTime();
                    int fieldNumber = 1;
                    this.peakelStmt$1.bind(fieldNumber, peakel.id());
                    this.peakelStmt$1.bind(++fieldNumber, peakelMz);
                    this.peakelStmt$1.bind(++fieldNumber, (double)peakelTime);
                    this.peakelStmt$1.bind(++fieldNumber, (double)peakel.calcDuration());
                    this.peakelStmt$1.bind(++fieldNumber, peakel.calcGapCount((LongMap<Object>)this.cycleByMzDbSpecId$1));
                    this.peakelStmt$1.bind(++fieldNumber, (double)peakel.getApexIntensity());
                    this.peakelStmt$1.bind(++fieldNumber, (double)peakel.area());
                    this.peakelStmt$1.bind(++fieldNumber, (double)peakel.calcAmplitude());
                    this.peakelStmt$1.bind(++fieldNumber, (double)peakel.calcIntensityCv());
                    this.peakelStmt$1.bind(++fieldNumber, (double)peakel.leftHwhmMean());
                    this.peakelStmt$1.bind(++fieldNumber, (double)peakel.leftHwhmCv());
                    this.peakelStmt$1.bind(++fieldNumber, (double)peakel.rightHwhmMean());
                    this.peakelStmt$1.bind(++fieldNumber, (double)peakel.rightHwhmCv());
                    this.peakelStmt$1.bind(++fieldNumber, 0);
                    this.peakelStmt$1.bind(++fieldNumber, peakel.spectrumIds().length);
                    this.peakelStmt$1.bind(++fieldNumber, peakelMessageAsBytes);
                    this.peakelStmt$1.bindNull(++fieldNumber);
                    this.peakelStmt$1.bind(++fieldNumber, BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.intArrayOps(scanInitialIds).head()));
                    this.peakelStmt$1.bind(++fieldNumber, peakel.getApexSpectrumId());
                    this.peakelStmt$1.bind(++fieldNumber, BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.intArrayOps(scanInitialIds).last()));
                    this.peakelStmt$1.bind(++fieldNumber, 1);
                    this.peakelStmt$1.step();
                    this.peakelStmt$1.reset();
                    fieldNumber = 1;
                    this.peakelIndexStmt$1.bind(fieldNumber, peakel.id());
                    this.peakelIndexStmt$1.bind(++fieldNumber, 1);
                    this.peakelIndexStmt$1.bind(++fieldNumber, 1);
                    this.peakelIndexStmt$1.bind(++fieldNumber, peakelMz);
                    this.peakelIndexStmt$1.bind(++fieldNumber, peakelMz);
                    this.peakelIndexStmt$1.bind(++fieldNumber, (double)peakelTime);
                    this.peakelIndexStmt$1.bind(++fieldNumber, (double)peakelTime);
                    this.peakelIndexStmt$1.step();
                    return this.peakelIndexStmt$1.reset();
                }
                {
                    this.initialIdByMzDbSpecId$1 = initialIdByMzDbSpecId$1;
                    this.cycleByMzDbSpecId$1 = cycleByMzDbSpecId$1;
                    this.peakelStmt$1 = peakelStmt$1;
                    this.peakelIndexStmt$1 = peakelIndexStmt$1;
                }
            });
        }
        catch (Throwable throwable) {
            void var7_7;
            void var6_6;
            var6_6.dispose();
            var7_7.dispose();
            throw throwable;
        }
        peakelStmt.dispose();
        peakelIndexStmt.dispose();
        sqliteConn.exec("COMMIT TRANSACTION;");
    }

    private PeakelDbWriter$() {
        MODULE$ = this;
    }
}

