/*
 * Decompiled with CFR 0.152.
 */
package com.thierry.filtering;

import com.thierry.filtering.report.HTMLReportBuilder;
import com.thierry.filtering.report.TableReportGenerator;
import com.thierry.filtering.report.TextReportBuilder;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.awt.datatransfer.DataTransferer;

public class TableSelection
implements Transferable,
ClipboardOwner {
    private static ArrayList<DataFlavor> htmlFlavors = new ArrayList();
    private static ArrayList<DataFlavor> textFlavors = new ArrayList();
    private static ArrayList<DataFlavor> stringFlavors = new ArrayList();
    private static ArrayList<DataFlavor> supporterFlavors = new ArrayList();
    protected static final Logger logger;
    private JTable m_table;
    private String m_textReport;
    private String m_htmlReport;

    public static void installCopyAction(final JTable table) {
        KeyStroke copy = KeyStroke.getKeyStroke(67, 2, false);
        AbstractAction copyAction = new AbstractAction("Copy"){

            @Override
            public void actionPerformed(ActionEvent e) {
                logger.debug("Table selection change");
                TableSelection transfer = new TableSelection(table);
                logger.debug("Clipboard transfertHandler will change after ");
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(transfer, transfer);
                logger.debug("Clipboard transfertHandler changed ");
            }
        };
        table.registerKeyboardAction(copyAction, "Copy", copy, 0);
    }

    private static boolean isHTMLDataFlavor(DataFlavor flavor) {
        return htmlFlavors.contains(flavor);
    }

    private static boolean isTextDataFlavor(DataFlavor flavor) {
        return textFlavors.contains(flavor);
    }

    private static boolean isStringDataFlavor(DataFlavor flavor) {
        return stringFlavors.contains(flavor);
    }

    public TableSelection(JTable table) {
        this.m_table = table;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return supporterFlavors.toArray(new DataFlavor[supporterFlavors.size()]);
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return supporterFlavors.contains(flavor);
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
        String transferedData = null;
        if (TableSelection.isHTMLDataFlavor(flavor)) {
            transferedData = this.getHTMLStringSelection();
        }
        if (TableSelection.isTextDataFlavor(flavor)) {
            transferedData = this.getTextStringSelection();
        }
        if (TableSelection.isStringDataFlavor(flavor)) {
            transferedData = this.getTextStringSelection();
        }
        if (transferedData != null) {
            return this.getTransferData(flavor, transferedData);
        }
        throw new UnsupportedFlavorException(flavor);
    }

    private String getHTMLStringSelection() {
        logger.debug("HTMLReport requested");
        if (this.m_htmlReport == null) {
            this.m_htmlReport = new TableReportGenerator(this.m_table).getSelection(new HTMLReportBuilder());
        }
        return this.m_htmlReport;
    }

    private Object getTransferData(DataFlavor flavor, String transfered) throws UnsupportedFlavorException {
        if (String.class.equals(flavor.getRepresentationClass())) {
            return transfered;
        }
        if (Reader.class.equals(flavor.getRepresentationClass())) {
            return new StringReader(transfered);
        }
        if (InputStream.class.equals(flavor.getRepresentationClass())) {
            return new ByteArrayInputStream(transfered.getBytes());
        }
        throw new UnsupportedFlavorException(flavor);
    }

    private String getTextStringSelection() {
        logger.debug("Text Report Requested ... ");
        if (this.m_textReport == null) {
            this.m_textReport = new TableReportGenerator(this.m_table).getSelection(new TextReportBuilder());
        }
        return this.m_textReport;
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    static {
        String encoding = null;
        DataTransferer transferer = DataTransferer.getInstance();
        if (transferer != null) {
            encoding = transferer.getDefaultUnicodeEncoding();
        }
        htmlFlavors.add(new DataFlavor("text/html;charset=" + encoding + ";class=java.lang.String", "HTML Text"));
        htmlFlavors.add(new DataFlavor("text/html;charset=" + encoding + ";class=java.io.Reader", "HTML Text"));
        htmlFlavors.add(new DataFlavor("text/html;charset=" + encoding + ";class=java.io.InputStream", "HTML Text"));
        textFlavors.add(new DataFlavor("text/plain;charset=" + encoding + ";class=java.lang.String", "Plain Text"));
        textFlavors.add(new DataFlavor("text/plain;charset=" + encoding + ";class=java.io.Reader", "Plain Text"));
        textFlavors.add(new DataFlavor("text/plain;charset=" + encoding + ";class=java.io.InputStream", "Plain Text"));
        stringFlavors.add(new DataFlavor("application/x-java-jvm-local-objectref;class=java.lang.String", "String Flavor"));
        stringFlavors.add(DataFlavor.stringFlavor);
        supporterFlavors.addAll(htmlFlavors);
        supporterFlavors.addAll(textFlavors);
        supporterFlavors.addAll(stringFlavors);
        logger = LoggerFactory.getLogger((String)"ProlineStudio.Commons");
    }
}

