/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio;

import fr.proline.studio.settings.FilePreferences;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.prefs.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NbPreferences {
    protected static final Logger logger = LoggerFactory.getLogger((String)"ProlineStudio.Commons");
    private static FilePreferences m_preferences;

    public static Preferences root() {
        if (m_preferences == null) {
            NbPreferences.initPreferences(null);
        }
        return m_preferences;
    }

    public static void initPreferences(String path) {
        path = path == null ? NbPreferences.getUserHome() + File.separator + "Preferences.properties" : path + File.separator + "Preferences.properties";
        m_preferences = new FilePreferences(new File(path), null, "");
    }

    private static String getUserHome() {
        String userHome = null;
        String OS = System.getProperty("os.name").toLowerCase();
        if (OS.contains("win")) {
            userHome = System.getenv("AppData");
        } else {
            userHome = System.getProperty("user.home");
            if (OS.contains("mac")) {
                userHome = userHome + "/Library/Application Support";
            }
        }
        if (userHome != null) {
            userHome = userHome + File.separator + ".prolinestudio" + File.separator + "dev" + File.separator + "config";
            Path path = Paths.get(userHome, new String[0]);
            try {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (IOException ie) {
                logger.warn("Impossible to create user directory: " + userHome);
            }
        }
        if (userHome == null) {
            userHome = "./";
        }
        return userHome;
    }
}

