/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.export;

import fr.proline.studio.WindowManager;
import fr.proline.studio.export.ExportDialog;
import fr.proline.studio.gui.DefaultDialog;
import fr.proline.studio.progress.ProgressBarDialog;
import fr.proline.studio.progress.ProgressInterface;
import fr.proline.studio.utils.IconManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.jdesktop.swingx.JXTable;

public class ExportButton
extends JButton
implements ActionListener {
    private final String m_exportName;
    private JXTable m_table = null;
    private JPanel m_panel = null;
    private ProgressInterface m_progressInterface = null;

    public ExportButton(ProgressInterface progressInterface, String exportName, JXTable table) {
        this.setProgressInterface(progressInterface);
        this.m_exportName = exportName;
        this.m_table = table;
        this.setIcon(IconManager.getIcon(IconManager.IconType.EXPORT));
        this.setToolTipText("Export Data...");
        this.setFocusPainted(false);
        this.addActionListener(this);
    }

    public final void setProgressInterface(ProgressInterface progressInterface) {
        this.m_progressInterface = progressInterface;
    }

    public ExportButton(String exportName, JPanel panel) {
        this.m_exportName = exportName;
        this.m_panel = panel;
        this.setIcon(IconManager.getIcon(IconManager.IconType.EXPORT_IMAGE));
        this.setToolTipText("Export Image...");
        this.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DefaultDialog dialog;
        if (this.m_progressInterface != null && !this.m_progressInterface.isLoaded()) {
            dialog = ProgressBarDialog.getDialog(WindowManager.getDefault().getMainWindow(), this.m_progressInterface, "Data loading", "Export is not available while data is loading. Please Wait.");
            dialog.setLocation(this.getLocationOnScreen().x + this.getWidth() + 5, this.getLocationOnScreen().y + this.getHeight() + 5);
            ((ProgressBarDialog)dialog).setVisible(true);
            if (!((ProgressBarDialog)dialog).isWaitingFinished()) {
                return;
            }
        }
        dialog = this.m_table != null ? ExportDialog.getDialog((Window)WindowManager.getDefault().getMainWindow(), this.m_table, this.m_exportName) : ExportDialog.getDialog((Window)WindowManager.getDefault().getMainWindow(), this.m_panel, this.m_exportName);
        dialog.setLocation(this.getLocationOnScreen().x + this.getWidth() + 5, this.getLocationOnScreen().y + this.getHeight() + 5);
        ((ExportDialog)dialog).setVisible(true);
    }
}

