/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.export;

import fr.proline.studio.export.ExportFontData;
import fr.proline.studio.export.ExportModelInterface;
import fr.proline.studio.export.ExporterInterface;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.gui.DefaultDialog;
import java.util.ArrayList;
import javax.swing.JTable;
import javax.swing.table.TableModel;

public class ExportManager {
    private final JTable m_table;
    private ExportManager m_exportManager = null;
    private Exception m_exportException = null;

    public ExportManager(JTable table) {
        this.m_table = table;
        this.m_exportManager = this;
    }

    public ExportWorker getTask(ExporterInterface exporter, String name, String filePath, boolean decorated) {
        int nbCol = this.m_table.getColumnCount();
        int[] colsInModel = new int[nbCol];
        for (int i = 0; i < nbCol; ++i) {
            int colInModel;
            colsInModel[i] = colInModel = this.m_table.convertColumnIndexToModel(i);
        }
        int nbRow = this.m_table.getRowCount();
        int[] rowsInModel = new int[nbRow];
        for (int i = 0; i < nbRow; ++i) {
            int rowInModel;
            rowsInModel[i] = rowInModel = this.m_table.convertRowIndexToModel(i);
        }
        TableModel model = this.m_table.getModel();
        return new ExportWorker(exporter, name, filePath, decorated, model, colsInModel, rowsInModel);
    }

    public void setException(Exception e) {
        this.m_exportException = e;
    }

    public Exception getException() {
        return this.m_exportException;
    }

    public class ExportWorker
    extends DefaultDialog.ProgressTask {
        private final ExporterInterface m_exporter;
        private final String m_name;
        private final String m_filePath;
        private final boolean m_decorated;
        private final TableModel m_model;
        private final int[] m_colsInModel;
        private final int[] m_rowsInModel;

        public ExportWorker(ExporterInterface exporter, String name, String filePath, boolean decorated, TableModel model, int[] colsInModel, int[] rowsInModel) {
            this.m_exporter = exporter;
            this.m_name = name;
            this.m_filePath = filePath;
            this.m_decorated = decorated;
            this.m_model = model;
            this.m_colsInModel = colsInModel;
            this.m_rowsInModel = rowsInModel;
        }

        protected Object doInBackground() throws Exception {
            try {
                String colName;
                int j;
                this.m_exporter.start(this.m_filePath);
                this.m_exporter.startSheet(this.m_name);
                this.m_exporter.setDecorated(this.m_decorated);
                ExportModelInterface exportInterface = this.m_model instanceof ExportModelInterface ? (ExportModelInterface)((Object)this.m_model) : null;
                int nbCol = this.m_colsInModel.length;
                int nbRow = this.m_rowsInModel.length;
                if (exportInterface != null) {
                    this.m_exporter.startRow();
                    for (j = 0; j < nbCol; ++j) {
                        colName = exportInterface.getExportColumnName(this.m_colsInModel[j]);
                        this.m_exporter.addCell(colName, null);
                    }
                } else {
                    this.m_exporter.startRow();
                    for (j = 0; j < nbCol; ++j) {
                        colName = this.m_model.getColumnName(this.m_colsInModel[j]);
                        this.m_exporter.addCell(colName, null);
                    }
                }
                int lastPercentage = 0;
                for (int j2 = 0; j2 < nbRow; ++j2) {
                    int percentage;
                    Object o;
                    String text;
                    int col;
                    int i;
                    int row = this.m_rowsInModel[j2];
                    if (exportInterface != null) {
                        this.m_exporter.startRow();
                        for (i = 0; i < nbCol; ++i) {
                            col = this.m_colsInModel[i];
                            text = exportInterface.getExportRowCell(row, col);
                            ArrayList<ExportFontData> stringFonts = null;
                            if (text == null) {
                                Object o2 = ((ExtendedTableModelInterface)((Object)this.m_model)).getDataValueAt(row, col);
                                if (o2 != null) {
                                    text = o2.toString();
                                }
                            } else {
                                stringFonts = exportInterface.getExportFonts(row, col);
                            }
                            this.m_exporter.addCell(text, stringFonts);
                        }
                    } else if (this.m_model instanceof ExtendedTableModelInterface) {
                        this.m_exporter.startRow();
                        for (i = 0; i < nbCol; ++i) {
                            col = this.m_colsInModel[i];
                            text = null;
                            o = ((ExtendedTableModelInterface)((Object)this.m_model)).getDataValueAt(row, col);
                            if (o != null) {
                                text = o.toString();
                            }
                            this.m_exporter.addCell(text, null);
                        }
                    } else {
                        this.m_exporter.startRow();
                        for (i = 0; i < nbCol; ++i) {
                            col = this.m_colsInModel[i];
                            text = null;
                            o = this.m_model.getValueAt(row, col);
                            if (o != null) {
                                text = o.toString();
                            }
                            this.m_exporter.addCell(text, null);
                        }
                    }
                    if ((percentage = (int)Math.round((double)(j2 + 1) / (double)nbRow * 100.0)) <= lastPercentage) continue;
                    this.setProgress(percentage);
                    lastPercentage = percentage;
                }
            }
            catch (Exception e) {
                ExportManager.this.m_exportManager.setException(e);
            }
            this.setProgress(this.getMaxValue());
            this.m_exporter.end();
            return null;
        }

        @Override
        public int getMinValue() {
            return 0;
        }

        @Override
        public int getMaxValue() {
            return 100;
        }
    }
}

