/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.extendedtablemodel;

import au.com.bytecode.opencsv.CSVReader;
import fr.proline.studio.export.ExportFontData;
import fr.proline.studio.export.ExportModelUtilities;
import fr.proline.studio.extendedtablemodel.ExtraDataType;
import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.filter.DoubleFilter;
import fr.proline.studio.filter.Filter;
import fr.proline.studio.filter.LongFilter;
import fr.proline.studio.filter.StringDiffFilter;
import fr.proline.studio.graphics.PlotInformation;
import fr.proline.studio.graphics.PlotType;
import fr.proline.studio.table.DecoratedTableModel;
import fr.proline.studio.table.LazyData;
import fr.proline.studio.table.TableDefaultRendererManager;
import fr.proline.studio.table.renderer.DefaultLeftAlignRenderer;
import fr.proline.studio.table.renderer.DefaultRightAlignRenderer;
import fr.proline.studio.table.renderer.DoubleRenderer;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.table.TableCellRenderer;

public class ImportedDataTableModel
extends DecoratedTableModel
implements GlobalTableModelInterface {
    private String[] m_columnNames = new String[]{"No Data"};
    private Class[] m_columTypes = new Class[]{String.class};
    private Object[][] m_data = null;
    private String m_modelName = null;

    public ImportedDataTableModel() {
        this.m_data = new Object[1][1];
        this.m_data[0][0] = "";
    }

    public ImportedDataTableModel(String[] columnNames, Class[] columTypes, Object[][] data) {
        this.setData(columnNames, columTypes, data);
    }

    public final void setData(String[] columnNames, Class[] columTypes, Object[][] data) {
        this.m_columnNames = columnNames;
        this.m_columTypes = columTypes;
        this.m_data = data;
        this.fireTableStructureChanged();
    }

    @Override
    public int getRowCount() {
        if (this.m_data == null) {
            return 0;
        }
        return this.m_data.length;
    }

    @Override
    public int getColumnCount() {
        if (this.m_columnNames == null) {
            return 0;
        }
        return this.m_columnNames.length;
    }

    public Class getColumnClass(int column) {
        return this.m_columTypes[column];
    }

    @Override
    public String getColumnName(int column) {
        return this.m_columnNames[column];
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.m_data[rowIndex][columnIndex];
    }

    @Override
    public String getToolTipForHeader(int col) {
        return null;
    }

    @Override
    public String getTootlTipValue(int row, int col) {
        return null;
    }

    @Override
    public TableCellRenderer getRenderer(int row, int col) {
        if (this.m_columTypes[col] == String.class) {
            return new DefaultLeftAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class));
        }
        if (this.m_columTypes[col] == Long.class) {
            return TableDefaultRendererManager.getDefaultRenderer(Long.class);
        }
        if (this.m_columTypes[col] == Double.class) {
            return new DoubleRenderer(new DefaultRightAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class)), 4, true, true);
        }
        return null;
    }

    @Override
    public GlobalTableModelInterface getFrozzenModel() {
        return this;
    }

    @Override
    public Long getTaskId() {
        return -1L;
    }

    @Override
    public LazyData getLazyData(int row, int col) {
        return null;
    }

    @Override
    public void givePriorityTo(Long taskId, int row, int col) {
    }

    @Override
    public void sortingChanged(int col) {
    }

    @Override
    public int getSubTaskId(int col) {
        return -1;
    }

    @Override
    public String getDataColumnIdentifier(int columnIndex) {
        return this.m_columnNames[columnIndex];
    }

    @Override
    public Class getDataColumnClass(int columnIndex) {
        return this.m_columTypes[columnIndex];
    }

    @Override
    public Object getDataValueAt(int rowIndex, int columnIndex) {
        return this.getValueAt(rowIndex, columnIndex);
    }

    @Override
    public int[] getKeysColumn() {
        return null;
    }

    @Override
    public void setName(String name) {
        this.m_modelName = name;
    }

    @Override
    public String getName() {
        return this.m_modelName;
    }

    @Override
    public Map<String, Object> getExternalData() {
        return null;
    }

    @Override
    public PlotInformation getPlotInformation() {
        return null;
    }

    @Override
    public void addFilters(LinkedHashMap<Integer, Filter> filtersMap) {
        int nbCols = this.getColumnCount();
        for (int i = 0; i < nbCols; ++i) {
            Class c = this.getColumnClass(i);
            if (c.equals(Double.class)) {
                filtersMap.put(i, new DoubleFilter(this.getColumnName(i), null, i));
                continue;
            }
            if (c.equals(Long.class)) {
                filtersMap.put(i, new LongFilter(this.getColumnName(i), null, i));
                continue;
            }
            if (!c.equals(String.class)) continue;
            filtersMap.put(i, new StringDiffFilter(this.getColumnName(i), null, i));
        }
    }

    @Override
    public boolean isLoaded() {
        return true;
    }

    @Override
    public int getLoadingPercentage() {
        return 100;
    }

    @Override
    public PlotType getBestPlotType() {
        return PlotType.SCATTER_PLOT;
    }

    @Override
    public int[] getBestColIndex(PlotType plotType) {
        return null;
    }

    @Override
    public String getExportRowCell(int row, int col) {
        return ExportModelUtilities.getExportRowCell(this, row, col);
    }

    @Override
    public ArrayList<ExportFontData> getExportFonts(int row, int col) {
        return null;
    }

    @Override
    public String getExportColumnName(int col) {
        return this.m_columnNames[col];
    }

    @Override
    public int getInfoColumn() {
        return 0;
    }

    @Override
    public ArrayList<ExtraDataType> getExtraDataTypes() {
        return null;
    }

    @Override
    public Object getValue(Class c) {
        return this.getSingleValue(c);
    }

    @Override
    public Object getRowValue(Class c, int row) {
        return null;
    }

    @Override
    public Object getColValue(Class c, int col) {
        return null;
    }

    public static Exception loadFile(ImportedDataTableModel model, String filePath, char separator, boolean header, boolean testFile) {
        File f = new File(filePath);
        if (!f.exists()) {
            model.setData(null, null, null);
        }
        try {
            String[] dataLine;
            CSVReader reader = new CSVReader((Reader)new FileReader(filePath), separator);
            String[] headerLine = null;
            int nbColumns = 0;
            int line = 1;
            if (header) {
                headerLine = reader.readNext();
                if (headerLine == null) {
                    model.setData(null, null, null);
                    throw new IOException("No Data found in File");
                }
                nbColumns = headerLine.length;
                line = 2;
            }
            if (headerLine == null) {
                headerLine = new String[nbColumns];
                for (int i = 0; i < nbColumns; ++i) {
                    headerLine[i] = String.valueOf(i + 1);
                }
            }
            ArrayList<String[]> allDataLines = new ArrayList<String[]>();
            while ((dataLine = reader.readNext()) != null) {
                int nbColumsCur = dataLine.length;
                if (nbColumsCur != 0 && nbColumns == 0) {
                    nbColumns = nbColumsCur;
                }
                if (nbColumns != nbColumsCur) {
                    model.setData(null, null, null);
                    return new IOException("Number of columns differ in file at line " + line);
                }
                allDataLines.add(dataLine);
                if (!testFile || ++line < 7) continue;
                break;
            }
            int nbRows = allDataLines.size();
            Class[] columTypes = new Class[nbColumns];
            for (int col = 0; col < nbColumns; ++col) {
                boolean canBeLong = true;
                boolean canBeDouble = true;
                for (int row = 0; row < nbRows; ++row) {
                    String data = ((String[])allDataLines.get(row))[col];
                    if (canBeLong) {
                        try {
                            Long.parseLong(data);
                        }
                        catch (NumberFormatException nfe) {
                            canBeLong = false;
                        }
                    }
                    if (canBeLong || !canBeDouble) continue;
                    try {
                        Double.parseDouble(data);
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        canBeDouble = false;
                        break;
                    }
                }
                columTypes[col] = canBeLong ? Long.class : (canBeDouble ? Double.class : String.class);
            }
            Object[][] data = new Object[nbRows][nbColumns];
            for (int row = 0; row < nbRows; ++row) {
                for (int col = 0; col < nbColumns; ++col) {
                    String value = ((String[])allDataLines.get(row))[col];
                    data[row][col] = columTypes[col].equals(Long.class) ? Long.valueOf(Long.parseLong(value)) : (columTypes[col].equals(Double.class) ? Double.valueOf(Double.parseDouble(value)) : value);
                }
            }
            model.setData(headerLine, columTypes, data);
            model.setName(f.getName().substring(0, f.getName().lastIndexOf(46)));
        }
        catch (Exception e) {
            model.setData(null, null, null);
            return e;
        }
        return null;
    }
}

