/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.graphics;

import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.graphics.Axis;
import fr.proline.studio.graphics.BasePlotPanel;
import fr.proline.studio.graphics.ColorOrGradient;
import fr.proline.studio.graphics.ColorOrGradientChooserPanel;
import fr.proline.studio.graphics.CrossSelectionInterface;
import fr.proline.studio.graphics.MoveableInterface;
import fr.proline.studio.graphics.PlotMultiDataAbstract;
import fr.proline.studio.graphics.PlotType;
import fr.proline.studio.graphics.XAxis;
import fr.proline.studio.graphics.YAxis;
import fr.proline.studio.graphics.core.PlotToolbarListenerInterface;
import fr.proline.studio.graphics.parallelcoordinates.ParallelCoordinatesAxis;
import fr.proline.studio.parameter.ColorOrGradientParameter;
import fr.proline.studio.parameter.ColorParameter;
import fr.proline.studio.parameter.IntegerParameter;
import fr.proline.studio.parameter.ParameterList;
import fr.proline.studio.utils.CyclicColorPalette;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Path2D;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSpinner;

public class PlotParallelCoordinates
extends PlotMultiDataAbstract {
    private static final Color COLOR_VALUES_NOT_SELECTED = new Color(230, 230, 230);
    private static final Color[] GRADIENT_COLORS_VALUES_SELECTED = new Color[]{new Color(132, 90, 133), new Color(255, 200, 255)};
    private static final int PAD_AXIS_X = 30;
    private ArrayList<ParallelCoordinatesAxis> m_axisList = new ArrayList();
    private ArrayList<ParameterList> m_parameterListArray = null;
    private final ColorOrGradientParameter m_colorSelectedParameter;
    private final ColorParameter m_colorParameter;
    private final IntegerParameter m_thicknessParameter;
    private Color[] m_gradientColors;
    private float[] m_gradientFractions;
    private int m_mainSelectedAxisIndex = 0;
    private boolean[] m_selectionArray = null;
    private long[] m_ids;
    private boolean[] m_SpecificSelection = null;
    private int m_previousWidth = 0;
    private int m_previousHeight = 0;
    private static final Color ERROR_COLOR = new Color(192, 0, 0, 128);
    private static final Color ERROR_COLOR_NOT_SELECTED = new Color(128, 0, 0, 128);

    public PlotParallelCoordinates(BasePlotPanel plotPanel, ExtendedTableModelInterface compareDataInterface, CrossSelectionInterface crossSelectionInterface, int[] cols) {
        super(plotPanel, PlotType.PARALLEL_COORDINATES_PLOT, compareDataInterface, crossSelectionInterface);
        this.update(cols, null);
        ParameterList colorParameteList = new ParameterList("Colors");
        ColorOrGradient colorOrGradient = new ColorOrGradient();
        colorOrGradient.setColor(CyclicColorPalette.getColor(21, 128));
        float[] fractions = new float[]{0.0f, 1.0f};
        LinearGradientPaint gradient = ColorOrGradientChooserPanel.getGradientForPanel(GRADIENT_COLORS_VALUES_SELECTED, fractions);
        colorOrGradient.setGradient(gradient);
        colorOrGradient.setGradientSelected();
        this.m_colorSelectedParameter = new ColorOrGradientParameter("PLOT_COORD_PARALLEL_COLOR_KEY", "Color for selected values", colorOrGradient, null);
        colorParameteList.add(this.m_colorSelectedParameter);
        this.m_colorParameter = new ColorParameter("UNSELECTED_COLOR_KEY", "Color for unselected values", COLOR_VALUES_NOT_SELECTED);
        colorParameteList.add(this.m_colorParameter);
        this.m_thicknessParameter = new IntegerParameter("THICKNESS_BORDER_VENNDIAGRAM", "Border Thickness", JSpinner.class, (Integer)1, (Integer)1, (Integer)5);
        colorParameteList.add(this.m_thicknessParameter);
        this.m_parameterListArray = new ArrayList(1);
        this.m_parameterListArray.add(colorParameteList);
        this.m_plotPanel.enableButton(PlotToolbarListenerInterface.BUTTONS.GRID, false);
        this.m_plotPanel.enableButton(PlotToolbarListenerInterface.BUTTONS.VIEW_ALL_MAP, false);
    }

    @Override
    public boolean needsXAxis() {
        return false;
    }

    @Override
    public boolean needsYAxis() {
        return false;
    }

    @Override
    public boolean canLogXAxis() {
        return false;
    }

    @Override
    public boolean canLogYAxis() {
        return true;
    }

    @Override
    public double getNearestXData(double x) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double getNearestYData(double y) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double getXMin() {
        return 0.0;
    }

    @Override
    public double getXMax() {
        if (this.m_plotPanel == null) {
            return 0.0;
        }
        return this.m_plotPanel.getWidth();
    }

    @Override
    public double getYMin() {
        return 0.0;
    }

    @Override
    public double getYMax() {
        if (this.m_plotPanel == null) {
            return 0.0;
        }
        return this.m_plotPanel.getHeight();
    }

    @Override
    public void parametersChanged() {
    }

    @Override
    public void paint(Graphics2D g, XAxis xAxis, YAxis yAxis) {
        if (this.m_axisList.isEmpty()) {
            return;
        }
        int width = this.m_plotPanel.getWidth();
        int height = this.m_plotPanel.getHeight();
        if (width != this.m_previousWidth || height != this.m_previousHeight) {
            this.m_plotPanel.updateAxis();
            xAxis.setSize(0, height, width, 0);
            yAxis.setSize(0, 0, 0, height);
            this.m_previousWidth = width;
            this.m_previousHeight = height;
        }
        int nbAxis = this.m_axisList.size();
        int deltaAxis = this.getAxisDelta(width, nbAxis);
        int i = 0;
        for (ParallelCoordinatesAxis axis : this.m_axisList) {
            axis.setPosition(30 + i * deltaAxis, height);
            ++i;
        }
        ColorOrGradient colorOrGradient = this.m_colorSelectedParameter.getColor();
        boolean useGradient = !colorOrGradient.isColorSelected();
        Color plotColor = Color.black;
        if (!useGradient) {
            plotColor = colorOrGradient.getColor();
        } else {
            this.setGradientValues();
        }
        this.drawLines(g, plotColor, useGradient, false);
        Stroke previousStroke = g.getStroke();
        Integer thickness = (Integer)this.m_thicknessParameter.getObjectValue();
        if (thickness == null) {
            thickness = 1;
        }
        g.setStroke(new BasicStroke(thickness.intValue()));
        this.drawLines(g, plotColor, useGradient, true);
        g.setStroke(previousStroke);
    }

    @Override
    public void paintOver(Graphics2D g) {
        int width = this.m_plotPanel.getWidth();
        for (ParallelCoordinatesAxis axis : this.m_axisList) {
            if (axis.isSelected()) continue;
            axis.paint(g, width);
        }
        for (ParallelCoordinatesAxis axis : this.m_axisList) {
            if (!axis.isSelected()) continue;
            axis.paint(g, width);
        }
    }

    private int getAxisDelta(int width, int nbAxis) {
        if (nbAxis > 1) {
            return (width - 10 - 60) / (nbAxis - 1);
        }
        return 0;
    }

    private void drawLines(Graphics2D g, Color plotColor, boolean useGradient, boolean paintSelection) {
        ParallelCoordinatesAxis selectedAxis = this.m_axisList.get(this.m_mainSelectedAxisIndex);
        ParallelCoordinatesAxis firstAxis = this.m_axisList.get(0);
        int nbRows = this.m_compareDataInterface.getRowCount();
        for (int index = 0; index < nbRows; ++index) {
            int rowIndex = selectedAxis.getRowIndexFromIndex(index);
            if (this.m_SpecificSelection != null ? this.m_SpecificSelection[rowIndex] ^ paintSelection : this.m_selectionArray[rowIndex] ^ paintSelection) continue;
            int y1 = firstAxis.getPositionByRowIndex(rowIndex);
            int x1 = firstAxis.getX();
            boolean error1 = firstAxis.isOnError(rowIndex);
            Color normalColor = paintSelection ? this.selectColor(plotColor, useGradient, rowIndex, false) : this.m_colorParameter.getColor();
            Color errorColor = paintSelection ? this.selectColor(plotColor, useGradient, rowIndex, true) : ERROR_COLOR_NOT_SELECTED;
            for (int j = 1; j < this.m_axisList.size(); ++j) {
                ParallelCoordinatesAxis secondAxis = this.m_axisList.get(j);
                int y2 = secondAxis.getPositionByRowIndex(rowIndex);
                int x2 = secondAxis.getX();
                boolean error2 = secondAxis.isOnError(rowIndex);
                if (!error1 && !error2) {
                    g.setColor(normalColor);
                } else {
                    g.setColor(errorColor);
                }
                g.drawLine(x1, y1, x2, y2);
                x1 = x2;
                y1 = y2;
                error1 = error2;
            }
        }
    }

    private void prepareSelectionHashSet() {
        if (this.m_axisList.isEmpty()) {
            return;
        }
        this.m_SpecificSelection = null;
        int nbRows = this.m_compareDataInterface.getRowCount();
        ParallelCoordinatesAxis selectedAxis = this.m_axisList.get(this.m_mainSelectedAxisIndex);
        for (int index = 0; index < nbRows; ++index) {
            boolean selected = true;
            int rowIndex = selectedAxis.getRowIndexFromIndex(index);
            for (ParallelCoordinatesAxis axis : this.m_axisList) {
                if (axis.isRowIndexSelected(rowIndex)) continue;
                selected = false;
                break;
            }
            this.m_selectionArray[rowIndex] = selected;
        }
    }

    private void setGradientValues() {
        boolean useGradient;
        ColorOrGradient colorOrGradient = this.m_colorSelectedParameter.getColor();
        boolean bl = useGradient = !colorOrGradient.isColorSelected();
        if (!useGradient) {
            return;
        }
        this.m_gradientColors = colorOrGradient.getGradient().getColors();
        this.m_gradientFractions = colorOrGradient.getGradient().getFractions();
    }

    private Color selectColor(Color plotColor, boolean useGradient, int rowIndex, boolean error) {
        Color c;
        if (useGradient) {
            ParallelCoordinatesAxis selectedAxis = this.m_axisList.get(this.m_mainSelectedAxisIndex);
            int height = selectedAxis.getHeight();
            int heightInAxis = selectedAxis.getRelativePositionByRowIndex(rowIndex);
            c = this.getColorInGradient(heightInAxis, height, error);
        } else {
            c = plotColor;
        }
        return c;
    }

    private Color getColorInGradient(int heightInAxis, int height, boolean error) {
        double f = (double)heightInAxis / (double)height;
        for (int i = 0; i < this.m_gradientFractions.length - 1; ++i) {
            float f1 = this.m_gradientFractions[i];
            float f2 = this.m_gradientFractions[i + 1];
            if (!(f >= (double)f1) || !(f <= (double)f2)) continue;
            Color c1 = this.m_gradientColors[i];
            Color c2 = i == 0 && error ? ERROR_COLOR : this.m_gradientColors[i + 1];
            double fInInterval = (f - (double)f1) / (double)(f2 - f1);
            int r = (int)Math.round((double)(c2.getRed() - c1.getRed()) * fInInterval + (double)c1.getRed());
            int g = (int)Math.round((double)(c2.getGreen() - c1.getGreen()) * fInInterval + (double)c1.getGreen());
            int b = (int)Math.round((double)(c2.getBlue() - c1.getBlue()) * fInInterval + (double)c1.getBlue());
            int a = (int)Math.round((double)(c2.getAlpha() - c1.getAlpha()) * fInInterval + (double)c1.getAlpha());
            return new Color(r, g, b, a);
        }
        if (f <= (double)this.m_gradientFractions[0]) {
            return this.m_gradientColors[0];
        }
        return error ? ERROR_COLOR : this.m_gradientColors[this.m_gradientFractions.length - 1];
    }

    @Override
    public String getToolTipText(double x, double y) {
        return null;
    }

    @Override
    public void update() {
        int nbRows = this.m_compareDataInterface.getRowCount();
        this.m_selectionArray = new boolean[nbRows];
        this.m_SpecificSelection = null;
        this.m_ids = new long[nbRows];
        Arrays.fill(this.m_selectionArray, Boolean.TRUE);
        this.m_axisList.clear();
        for (int i = 0; i < nbRows; ++i) {
            this.m_ids[i] = this.m_compareDataInterface.row2UniqueId(i);
        }
        this.m_mainSelectedAxisIndex = 0;
        int nbCols = this.m_cols.length;
        for (int i = 0; i < nbCols; ++i) {
            int colId = this.m_cols[i];
            ParallelCoordinatesAxis axis = new ParallelCoordinatesAxis(i, this.m_compareDataInterface, colId, this);
            if (i == 0) {
                axis.displaySelected(true);
            }
            this.m_axisList.add(axis);
        }
        this.prepareSelectionHashSet();
        this.m_plotPanel.forceUpdateDoubleBuffer();
        this.m_plotPanel.repaint();
    }

    @Override
    public boolean select(double x, double y, boolean append) {
        if (this.m_mainSelectedAxisIndex == -1) {
            return false;
        }
        ParallelCoordinatesAxis selectedAxis = this.m_axisList.get(this.m_mainSelectedAxisIndex);
        this.m_mainSelectedAxisIndex = -1;
        this.selectAxis(selectedAxis, false);
        return false;
    }

    @Override
    public boolean select(Path2D.Double path, double minX, double maxX, double minY, double maxY, boolean append) {
        return false;
    }

    @Override
    public ArrayList<Long> getSelectedIds() {
        ParallelCoordinatesAxis selectedAxis = this.m_axisList.get(this.m_mainSelectedAxisIndex);
        int nbRows = this.m_compareDataInterface.getRowCount();
        ArrayList<Long> selection = new ArrayList<Long>();
        for (int index = 0; index < nbRows; ++index) {
            int rowIndex = selectedAxis.getRowIndexFromIndex(index);
            if (this.m_SpecificSelection != null) {
                if (!this.m_SpecificSelection[rowIndex]) continue;
                selection.add(this.m_ids[rowIndex]);
                continue;
            }
            if (!this.m_selectionArray[rowIndex]) continue;
            selection.add(this.m_ids[rowIndex]);
        }
        return selection;
    }

    @Override
    public void setSelectedIds(ArrayList<Long> selection) {
        int nbRows = this.m_compareDataInterface.getRowCount();
        this.m_SpecificSelection = new boolean[nbRows];
        Arrays.fill(this.m_SpecificSelection, Boolean.FALSE);
        for (Long l : selection) {
            this.m_SpecificSelection[l.intValue()] = true;
        }
    }

    @Override
    public ArrayList<ParameterList> getParameters() {
        return this.m_parameterListArray;
    }

    @Override
    public boolean isMouseOnPlot(double x, double y) {
        return true;
    }

    @Override
    public boolean isMouseOnSelectedPlot(double x, double y) {
        return false;
    }

    @Override
    public String getEnumValueX(int index, boolean fromData) {
        return null;
    }

    @Override
    public String getEnumValueY(int index, boolean fromData, Axis axis) {
        return null;
    }

    @Override
    public MoveableInterface getOverMovable(int x, int y) {
        MoveableInterface movable = super.getOverMovable(x, y);
        if (movable != null) {
            return movable;
        }
        for (ParallelCoordinatesAxis axis : this.m_axisList) {
            movable = axis.getOverMovable(x, y);
            if (movable == null) continue;
            return movable;
        }
        return null;
    }

    @Override
    public JPopupMenu getPopupMenu(double x, double y) {
        MoveableInterface over = this.getOverMovable((int)Math.round(x), (int)Math.round(y));
        if (over == null || !(over instanceof ParallelCoordinatesAxis) || !((ParallelCoordinatesAxis)over).isSelected()) {
            return null;
        }
        int countLog = 0;
        int nbNumberAxisSelected = 0;
        boolean stringAxisSelected = false;
        boolean canLog = true;
        for (ParallelCoordinatesAxis axis : this.m_axisList) {
            if (!axis.isSelected()) continue;
            if (axis.isNumeric()) {
                ++nbNumberAxisSelected;
                if (axis.isLog()) {
                    ++countLog;
                }
                if (axis.canLog()) continue;
                canLog = false;
                continue;
            }
            stringAxisSelected = true;
        }
        JMenuItem logAction = new JMenuItem("Log10");
        logAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (ParallelCoordinatesAxis axis : PlotParallelCoordinates.this.m_axisList) {
                    if (!axis.isSelected() || !axis.isNumeric()) continue;
                    axis.log();
                }
                ParallelCoordinatesAxis mainAxis = (ParallelCoordinatesAxis)PlotParallelCoordinates.this.m_axisList.get(PlotParallelCoordinates.this.m_mainSelectedAxisIndex);
                PlotParallelCoordinates.this.m_mainSelectedAxisIndex = -1;
                PlotParallelCoordinates.this.selectAxis(mainAxis, false);
                PlotParallelCoordinates.this.m_plotPanel.repaintUpdateDoubleBuffer();
            }
        });
        logAction.setEnabled(nbNumberAxisSelected >= 1 && !stringAxisSelected && canLog);
        JMenuItem normalizeAction = new JMenuItem("Normalize");
        normalizeAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                double rangeMin = Double.POSITIVE_INFINITY;
                double rangeMax = Double.NEGATIVE_INFINITY;
                boolean hasNaN = false;
                for (ParallelCoordinatesAxis axis : PlotParallelCoordinates.this.m_axisList) {
                    double max;
                    if (!axis.isSelected()) continue;
                    hasNaN |= axis.hasNaN();
                    double min = axis.getRealMinValue();
                    if (min < rangeMin) {
                        rangeMin = min;
                    }
                    if (!((max = axis.getRealMaxValue()) > rangeMax)) continue;
                    rangeMax = max;
                }
                for (ParallelCoordinatesAxis axis : PlotParallelCoordinates.this.m_axisList) {
                    if (!axis.isSelected()) continue;
                    axis.setRange(rangeMin, rangeMax, hasNaN);
                }
                ParallelCoordinatesAxis mainAxis = (ParallelCoordinatesAxis)PlotParallelCoordinates.this.m_axisList.get(PlotParallelCoordinates.this.m_mainSelectedAxisIndex);
                PlotParallelCoordinates.this.m_mainSelectedAxisIndex = -1;
                PlotParallelCoordinates.this.selectAxis(mainAxis, false);
                PlotParallelCoordinates.this.m_plotPanel.repaintUpdateDoubleBuffer();
            }
        });
        normalizeAction.setEnabled(nbNumberAxisSelected > 1 && !stringAxisSelected && (countLog == nbNumberAxisSelected || countLog == 0));
        JPopupMenu menu = new JPopupMenu();
        menu.add(logAction);
        menu.add(normalizeAction);
        return menu;
    }

    @Override
    public void doubleClicked(int x, int y) {
        for (ParallelCoordinatesAxis axis : this.m_axisList) {
            MoveableInterface movable = axis.getOverMovable(x, y);
            if (movable == null) continue;
            axis.doubleClicked();
        }
    }

    public void selectAxis(ParallelCoordinatesAxis axis, boolean isCtrlOrShiftDown) {
        int id = axis.getId();
        if (this.m_mainSelectedAxisIndex != id) {
            this.m_mainSelectedAxisIndex = id;
            this.m_SpecificSelection = null;
            if (!isCtrlOrShiftDown) {
                for (ParallelCoordinatesAxis axisCur : this.m_axisList) {
                    axisCur.displaySelected(false);
                }
            }
            axis.displaySelected(true);
            this.m_plotPanel.repaint();
        }
    }

    public void axisMoved(ParallelCoordinatesAxis axis, int deltaX) {
        ParallelCoordinatesAxis mainAxis = this.m_axisList.get(this.m_mainSelectedAxisIndex);
        int nbAxis = this.m_axisList.size();
        int width = this.m_plotPanel.getWidth();
        int deltaAxis = this.getAxisDelta(width, nbAxis);
        if (Math.abs(deltaX) < deltaAxis) {
            this.m_plotPanel.repaintUpdateDoubleBuffer();
            return;
        }
        int axisPosition = axis.getX() + deltaX;
        ArrayList<ParallelCoordinatesAxis> m_axisListNew = new ArrayList<ParallelCoordinatesAxis>();
        boolean axisAdded = false;
        ParallelCoordinatesAxis previousAxis = null;
        for (ParallelCoordinatesAxis nextAxis : this.m_axisList) {
            if (nextAxis.equals(axis)) {
                previousAxis = nextAxis;
                continue;
            }
            if (previousAxis == null) {
                if (axisPosition < nextAxis.getX()) {
                    m_axisListNew.add(axis);
                    axisAdded = true;
                }
            } else if (previousAxis.getX() < axisPosition && axisPosition < nextAxis.getX()) {
                m_axisListNew.add(axis);
                axisAdded = true;
            }
            m_axisListNew.add(nextAxis);
            previousAxis = nextAxis;
        }
        if (!axisAdded) {
            m_axisListNew.add(axis);
        }
        this.m_axisList = m_axisListNew;
        this.m_mainSelectedAxisIndex = 0;
        for (ParallelCoordinatesAxis axisCur : this.m_axisList) {
            axisCur.setId(this.m_mainSelectedAxisIndex);
            if (axisCur.equals(mainAxis)) break;
            ++this.m_mainSelectedAxisIndex;
        }
        this.m_plotPanel.repaintUpdateDoubleBuffer();
    }

    public void axisChanged() {
        this.prepareSelectionHashSet();
        this.m_plotPanel.repaintUpdateDoubleBuffer();
    }

    public void axisIsMoving() {
        this.m_plotPanel.repaintUpdateDoubleBuffer();
    }
}

