/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.gui;

import fr.proline.studio.gui.DefaultDialogListener;
import fr.proline.studio.gui.HelpHeaderPanel;
import fr.proline.studio.utils.HelpUtils;
import fr.proline.studio.utils.IconManager;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import org.slf4j.LoggerFactory;

public class DefaultDialog
extends JDialog {
    public static final int BUTTON_OK = 0;
    public static final int BUTTON_CANCEL = 1;
    public static final int BUTTON_DEFAULT = 2;
    public static final int BUTTON_LOAD = 3;
    public static final int BUTTON_SAVE = 4;
    public static final int BUTTON_HELP = 5;
    public static final int BUTTON_BACK = 6;
    private static final int BUTTONS_NUMBER = 7;
    private JPanel m_internalPanel;
    private ImagePanel m_imageInfoPanel;
    private JButton[] m_buttons;
    private JPanel m_statusPanel;
    private JLabel m_statusLabel;
    private BusyGlassPane m_busyGlassPane = null;
    private HighlightGlassPane m_highlightGlassPane = null;
    private DefaultDialog m_dialog;
    private boolean m_firstDisplay = true;
    protected int m_buttonClicked = 1;
    private String m_documentationSuffix = null;
    private DefaultDialogListener m_defaultDialogListener;
    private JPanel m_helpPanel;
    private Timer statusStimer = null;

    public DefaultDialog() {
        this(null, Dialog.ModalityType.MODELESS);
    }

    public DefaultDialog(Window parent) {
        this(parent, Dialog.ModalityType.APPLICATION_MODAL);
    }

    public DefaultDialog(Window parent, Dialog.ModalityType modalityType) {
        super(parent, modalityType);
        this.init();
    }

    public DefaultDialog(Dialog owner) {
        super(owner, true);
        this.init();
    }

    public void addDefaultDialogListener(DefaultDialogListener defaultDialogListener) {
        this.m_defaultDialogListener = defaultDialogListener;
    }

    public DefaultDialogListener getDefaultDialogListener() {
        return this.m_defaultDialogListener;
    }

    private void init() {
        this.m_buttons = new JButton[7];
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                DefaultDialog.this.cancelButtonActionPerformed();
            }
        });
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        AbstractAction actionListener = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DefaultDialog.this.cancelButtonActionPerformed();
            }
        };
        InputMap inputMap = this.getRootPane().getInputMap(2);
        inputMap.put(stroke, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", actionListener);
        stroke = KeyStroke.getKeyStroke(10, 0);
        actionListener = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DefaultDialog.this.doClick(0);
            }
        };
        inputMap.put(stroke, "ENTER");
        this.getRootPane().getActionMap().put("ENTER", actionListener);
        this.initComponents();
    }

    public void setDocumentationSuffix(String documentationSuffix) {
        this.m_documentationSuffix = documentationSuffix;
    }

    public void setImageInfo(JPanel sourcePanel, int x, int y, int width, int height) {
        this.m_imageInfoPanel.setVisible(true);
        this.m_imageInfoPanel.setImageInfo(sourcePanel, x, y, width, height);
    }

    public void hideInfoPanel() {
        this.m_imageInfoPanel.setVisible(false);
        this.revalidate();
    }

    @Override
    public void setVisible(boolean v) {
        this.pack();
        if (v) {
            this.m_buttonClicked = 1;
        }
        this.m_dialog = this;
        super.setVisible(v);
    }

    @Override
    public void pack() {
        if (this.m_firstDisplay) {
            super.pack();
            this.m_firstDisplay = false;
        }
    }

    public void repack() {
        super.pack();
    }

    public int getButtonClicked() {
        return this.m_buttonClicked;
    }

    public void setHelpHeaderText(String htmlSupportedTxt) {
        this.setHelpHeader(IconManager.getIcon(IconManager.IconType.INFORMATION), null, htmlSupportedTxt);
    }

    public void setHelpHeaderTextWithIcon(Icon icon, String htmlSupportedTxt) {
        this.setHelpHeader(icon, null, htmlSupportedTxt);
    }

    public void setHelpHeader(String title, String htmlSupportedTxt) {
        this.m_helpPanel.removeAll();
        this.m_helpPanel.add((Component)new HelpHeaderPanel(title, htmlSupportedTxt), "Center");
    }

    public void setHelpHeader(Icon icon, String title, String htmlSupportedTxt) {
        this.m_helpPanel.removeAll();
        this.m_helpPanel.add((Component)new HelpHeaderPanel(icon, title, htmlSupportedTxt), "Center");
        this.repaint();
    }

    public void setHelpHeader(String htmlSupportedTxt, int width, int height) {
        this.m_helpPanel.removeAll();
        JTextPane wizardPane = new JTextPane();
        this.m_helpPanel.setBorder(BorderFactory.createEtchedBorder(1));
        wizardPane.setEditable(false);
        wizardPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        wizardPane.setContentType("text/html");
        String fontFamily = this.getFont().getFamily();
        int fontSize = this.getFont().getSize();
        String content = "<html> \n   <head>\n      <style type=\"text/css\">  \n         #help{\n         color: Gray; \n         font-family: " + fontFamily + ";         font-size: " + fontSize + ";         padding-top: 1px;\n         padding-bottom: 1px;\n         } \n      </style> \n   </head> \n   <body>\n<div id=\"help\">" + htmlSupportedTxt + "</div>   </body> \n</html>";
        wizardPane.setText(content);
        wizardPane.setPreferredSize(new Dimension(width, height));
        this.m_helpPanel.add(wizardPane);
        this.repaint();
    }

    public void setHelpHeaderSize(int width, int height) {
        this.m_helpPanel.setPreferredSize(new Dimension(width, height));
    }

    protected void setInternalComponent(Component component) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 1;
        c.anchor = 18;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.m_internalPanel.add(component, c);
    }

    protected void replaceInternalComponent(Component component) {
        this.m_internalPanel.removeAll();
        this.setInternalComponent(component);
    }

    public void setButtonVisible(int buttonId, boolean visible) {
        this.m_buttons[buttonId].setVisible(visible);
    }

    public void setButtonEnabled(int buttonId, boolean enabled) {
        this.m_buttons[buttonId].setEnabled(enabled);
    }

    public void setButtonName(int buttonId, String name) {
        this.m_buttons[buttonId].setText(name);
    }

    protected void setButtonIcon(int buttonId, Icon icon) {
        this.m_buttons[buttonId].setIcon(icon);
    }

    protected void doClick(int buttonId) {
        this.m_buttons[buttonId].doClick();
    }

    protected void setStatusVisible(boolean visible) {
        this.m_statusPanel.setVisible(visible);
    }

    public void setStatus(boolean error, String text) {
        if (error) {
            this.m_statusLabel.setIcon(IconManager.getIcon(IconManager.IconType.EXCLAMATION));
            if (this.statusStimer == null) {
                int DELAY_TO_ERASE_STATUS = 7000;
                this.statusStimer = new Timer(7000, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DefaultDialog.this.m_statusLabel.setIcon(IconManager.getIcon(IconManager.IconType.EMPTY));
                        DefaultDialog.this.m_statusLabel.setText("");
                    }
                });
                this.statusStimer.setRepeats(false);
            }
            if (!this.statusStimer.isRunning()) {
                this.statusStimer.start();
            } else {
                this.statusStimer.restart();
            }
        } else {
            this.m_statusLabel.setIcon(IconManager.getIcon(IconManager.IconType.EMPTY));
        }
        this.m_statusLabel.setText(text);
    }

    protected boolean cancelCalled() {
        if (this.m_defaultDialogListener != null) {
            this.m_defaultDialogListener.cancelPerformed(this);
        }
        return true;
    }

    protected boolean okCalled() {
        if (this.m_defaultDialogListener != null) {
            this.m_defaultDialogListener.okPerformed(this);
        }
        return true;
    }

    protected boolean defaultCalled() {
        if (this.m_defaultDialogListener != null) {
            this.m_defaultDialogListener.defaultPerformed(this);
        }
        return false;
    }

    protected boolean backCalled() {
        if (this.m_defaultDialogListener != null) {
            this.m_defaultDialogListener.backPerformed(this);
        }
        return false;
    }

    protected boolean saveCalled() {
        if (this.m_defaultDialogListener != null) {
            this.m_defaultDialogListener.savePerformed(this);
        }
        return false;
    }

    protected boolean loadCalled() {
        if (this.m_defaultDialogListener != null) {
            this.m_defaultDialogListener.loadPerformed(this);
        }
        return false;
    }

    private void initComponents() {
        this.setResizable(false);
        this.setDefaultCloseOperation(2);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 1;
        c.anchor = 18;
        c.weightx = 1.0;
        this.m_imageInfoPanel = new ImagePanel();
        this.m_imageInfoPanel.setVisible(false);
        this.add((Component)this.m_imageInfoPanel, c);
        ++c.gridy;
        c.weighty = 1.0;
        JPanel mainPanel = new JPanel(new BorderLayout());
        this.m_helpPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)this.m_helpPanel, "North");
        this.m_internalPanel = new JPanel();
        this.m_internalPanel.setLayout(new GridBagLayout());
        mainPanel.add((Component)this.m_internalPanel, "Center");
        this.add((Component)mainPanel, c);
        JPanel buttonPanel = this.createButtonPanel();
        ++c.gridy;
        c.weighty = 0.0;
        this.add((Component)buttonPanel, c);
        this.m_statusPanel = this.createStatusPanel();
        ++c.gridy;
        c.weightx = 1.0;
        this.add((Component)this.m_statusPanel, c);
    }

    private JPanel createButtonPanel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 1;
        c.anchor = 18;
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.m_buttons[0] = new JButton(IconManager.getIcon(IconManager.IconType.OK));
        this.m_buttons[1] = new JButton(IconManager.getIcon(IconManager.IconType.CANCEL));
        this.m_buttons[2] = new JButton(IconManager.getIcon(IconManager.IconType.DEFAULT));
        this.m_buttons[6] = new JButton(IconManager.getIcon(IconManager.IconType.BACK));
        this.m_buttons[3] = new JButton(IconManager.getIcon(IconManager.IconType.LOAD_SETTINGS));
        this.m_buttons[4] = new JButton(IconManager.getIcon(IconManager.IconType.SAVE_SETTINGS));
        this.m_buttons[5] = new JButton(IconManager.getIcon(IconManager.IconType.QUESTION));
        Insets margin = this.m_buttons[5].getMargin();
        margin.left = 3;
        margin.right = 3;
        this.m_buttons[5].setMargin(margin);
        buttonPanel.add((Component)this.m_buttons[4], c);
        ++c.gridx;
        buttonPanel.add((Component)this.m_buttons[3], c);
        ++c.gridx;
        buttonPanel.add((Component)this.m_buttons[2], c);
        ++c.gridx;
        c.weightx = 1.0;
        buttonPanel.add(Box.createHorizontalGlue(), c);
        ++c.gridx;
        c.weightx = 0.0;
        buttonPanel.add((Component)this.m_buttons[6], c);
        ++c.gridx;
        buttonPanel.add((Component)this.m_buttons[0], c);
        ++c.gridx;
        buttonPanel.add((Component)this.m_buttons[1], c);
        ++c.gridx;
        buttonPanel.add((Component)this.m_buttons[5], c);
        this.m_buttons[4].setText("Save");
        this.setButtonVisible(4, false);
        this.m_buttons[4].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DefaultDialog.this.saveButtonActionPerformed();
            }
        });
        this.m_buttons[3].setText("Load");
        this.setButtonVisible(3, false);
        this.m_buttons[3].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DefaultDialog.this.loadButtonActionPerformed();
            }
        });
        this.m_buttons[0].setText("OK");
        this.m_buttons[0].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DefaultDialog.this.okButtonActionPerformed();
            }
        });
        this.m_buttons[1].setText("Cancel");
        this.m_buttons[1].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DefaultDialog.this.cancelButtonActionPerformed();
            }
        });
        this.m_buttons[2].setText("Default");
        this.setButtonVisible(2, false);
        this.m_buttons[2].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DefaultDialog.this.defaultButtonActionPerformed();
            }
        });
        this.m_buttons[6].setText("Back");
        this.setButtonVisible(6, false);
        this.m_buttons[6].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DefaultDialog.this.backButtonActionPerformed();
            }
        });
        this.m_buttons[5].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DefaultDialog.this.helpButtonActionPerformed();
            }
        });
        return buttonPanel;
    }

    private void saveButtonActionPerformed() {
        if (this.saveCalled()) {
            this.m_buttonClicked = 4;
        }
    }

    private void loadButtonActionPerformed() {
        if (this.loadCalled()) {
            this.m_buttonClicked = 3;
        }
    }

    private void cancelButtonActionPerformed() {
        if (this.cancelCalled()) {
            this.m_buttonClicked = 1;
            this.setVisible(false);
        }
    }

    private void okButtonActionPerformed() {
        if (this.okCalled()) {
            this.m_buttonClicked = 0;
            this.setVisible(false);
        }
    }

    private void defaultButtonActionPerformed() {
        if (this.defaultCalled()) {
            this.m_buttonClicked = 2;
            this.setVisible(false);
        }
    }

    private void backButtonActionPerformed() {
        if (this.backCalled()) {
            this.m_buttonClicked = 6;
        }
    }

    private void helpButtonActionPerformed() {
        if (this.m_documentationSuffix == null) {
            LoggerFactory.getLogger((String)"ProlineStudio.Commons").error(this.getClass().getSimpleName() + " failed");
            return;
        }
        if (Desktop.isDesktopSupported()) {
            try {
                Desktop.getDesktop().browse(HelpUtils.createRedirectTempFile(this.m_documentationSuffix));
            }
            catch (Exception ex) {
                LoggerFactory.getLogger((String)"ProlineStudio.Commons").error(this.getClass().getSimpleName() + " failed", (Throwable)ex);
            }
        }
    }

    private JPanel createStatusPanel() {
        JPanel statusPanel = new JPanel();
        statusPanel.setLayout(new GridBagLayout());
        statusPanel.setBorder(BorderFactory.createLoweredSoftBevelBorder());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(1, 1, 1, 1);
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 1;
        c.anchor = 18;
        c.weightx = 1.0;
        c.weighty = 0.0;
        this.m_statusLabel = new JLabel(" ");
        this.m_statusLabel.setIcon(IconManager.getIcon(IconManager.IconType.EMPTY));
        statusPanel.add((Component)this.m_statusLabel, c);
        return statusPanel;
    }

    @Override
    public void setLocation(int x, int y) {
        this.pack();
        int width = this.getWidth();
        int height = this.getHeight() + 30;
        Rectangle screenBounds = this.getScreenBounds(x, y);
        if (screenBounds == null) {
            if (x < 0) {
                x = 0;
            }
            if (y < 0) {
                y = 0;
            }
            screenBounds = this.getScreenBounds(x, y);
        }
        if (x + width > screenBounds.x + screenBounds.width) {
            x = screenBounds.x + screenBounds.width - width;
        }
        if (y + height > screenBounds.y + screenBounds.height) {
            y = screenBounds.y + screenBounds.height - height;
        }
        if (x < screenBounds.x) {
            x = screenBounds.x;
        }
        if (y < screenBounds.y) {
            y = screenBounds.y;
        }
        super.setLocation(x, y);
    }

    public void centerToWindow(Window w) {
        this.pack();
        int width = this.getWidth();
        int height = this.getHeight();
        int frameX = w.getX();
        int frameY = w.getY();
        int frameWidth = w.getWidth();
        int frameHeight = w.getHeight();
        int x = frameX + (frameWidth - width) / 2;
        int y = frameY + (frameHeight - height) / 2;
        this.setLocation(x, y);
    }

    public void centerToScreen() {
        this.pack();
        Rectangle screenBounds = this.getScreenBounds(this.getX(), this.getY());
        int width = this.getWidth();
        int height = this.getHeight();
        int x = (screenBounds.width - width) / 2 + screenBounds.x;
        int y = (screenBounds.height - height) / 2 + screenBounds.y;
        super.setLocation(x, y);
    }

    private Rectangle getScreenBounds(int x, int y) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gd = ge.getScreenDevices();
        for (int i = 0; i < gd.length; ++i) {
            GraphicsConfiguration gc = gd[i].getDefaultConfiguration();
            Rectangle r = gc.getBounds();
            if (!r.contains(x, y)) continue;
            return r;
        }
        return null;
    }

    public void setBusy(boolean busy) {
        if (this.m_busyGlassPane == null) {
            this.m_busyGlassPane = new BusyGlassPane();
        }
        this.setGlassPane(this.m_busyGlassPane);
        if (busy) {
            this.m_busyGlassPane.setVisible(true);
        } else {
            this.m_busyGlassPane.setVisible(false);
        }
    }

    public void startTask(ProgressTask task) {
        this.setBusy(true);
        this.m_busyGlassPane.setProgressBar(task);
    }

    public void highlight(Component c) {
        this.highlight(c, null);
    }

    public void highlight(Component c, Rectangle zone) {
        if (this.m_highlightGlassPane == null) {
            this.m_highlightGlassPane = new HighlightGlassPane();
        }
        this.m_highlightGlassPane.setComponent(c, zone);
        this.setGlassPane(this.m_highlightGlassPane);
        this.m_highlightGlassPane.highlight();
    }

    private class ImagePanel
    extends JPanel {
        private BufferedImage m_bi = null;
        private final Dimension m_dimension = new Dimension(0, 0);

        @Override
        public Dimension getPreferredSize() {
            return this.m_dimension;
        }

        @Override
        public void paint(Graphics g) {
            if (this.m_bi == null) {
                return;
            }
            g.setColor(Color.white);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            int xImage = (this.getWidth() - this.m_bi.getWidth()) / 2;
            int yImage = 1;
            g.drawImage(this.m_bi, xImage, yImage, null);
            g.setColor(Color.darkGray);
            g.drawRect(xImage - 1, yImage - 1, this.m_bi.getWidth() + 1, this.m_bi.getHeight() + 1);
        }

        public void setImageInfo(JPanel sourcePanel, int x, int y, int width, int height) {
            this.m_bi = new BufferedImage(width, height, 2);
            this.m_dimension.width = width + 2;
            this.m_dimension.height = height + 2;
            Graphics g = this.m_bi.getGraphics();
            g.translate(-x, -y);
            sourcePanel.paint(g);
        }
    }

    public static abstract class ProgressTask
    extends SwingWorker {
        public abstract int getMinValue();

        public abstract int getMaxValue();
    }

    private class HighlightGlassPane
    extends JComponent {
        private final int ANIMATION_DELAY = 400;
        private final int DISPLAY_DELAY = 1300;
        private long m_timeStart = 0L;
        private Component m_comp;
        private int m_x;
        private int m_y;
        private int m_width;
        private int m_height;
        private static final int PAD = 10;
        private Timer animationTimer = null;

        @Override
        protected void paintComponent(Graphics g) {
            Point p = SwingUtilities.convertPoint(this.m_comp, 0, 0, this);
            g.setColor(new Color(240, 0, 0));
            ((Graphics2D)g).setStroke(new BasicStroke(2.0f));
            long timeCur = System.currentTimeMillis();
            int START_ANGLE = 30;
            int DELTA_ANGLE = 380;
            int deltaAngle = timeCur - this.m_timeStart <= 400L ? 30 + (int)(350.0 * ((double)(timeCur - this.m_timeStart) / 400.0)) : 380;
            for (int angle = 30; angle <= deltaAngle + 30; angle += 3) {
                int delta = (int)((double)(angle - 30) / 380.0 * 10.0);
                g.drawArc(p.x + this.m_x - delta, p.y + this.m_y - delta, this.m_width + delta * 2, this.m_height + delta * 2, angle, 3);
            }
        }

        private void setComponent(Component c) {
            this.m_comp = c;
            this.m_x = -10;
            this.m_y = -10;
            this.m_width = c.getWidth() + 20;
            this.m_height = c.getHeight() + 20;
        }

        public void setComponent(Component c, Rectangle r) {
            if (r == null) {
                this.setComponent(c);
                return;
            }
            this.m_comp = c;
            this.m_x = -10 + r.x;
            this.m_y = -10 + r.y;
            this.m_width = r.width + 20;
            this.m_height = r.height + 20;
        }

        public void highlight() {
            DefaultDialog.this.m_highlightGlassPane.setVisible(true);
            this.m_timeStart = System.currentTimeMillis();
            ActionListener timerAction = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    long timeCur = System.currentTimeMillis();
                    if (timeCur - HighlightGlassPane.this.m_timeStart > 1700L) {
                        DefaultDialog.this.m_highlightGlassPane.setVisible(false);
                        HighlightGlassPane.this.animationTimer.setRepeats(false);
                    } else {
                        HighlightGlassPane.this.repaint();
                    }
                }
            };
            this.animationTimer = new Timer(20, timerAction);
            this.animationTimer.setRepeats(true);
            this.animationTimer.start();
        }

        @Override
        protected void processMouseEvent(MouseEvent e) {
            if (e.getID() == 500) {
                DefaultDialog.this.m_statusLabel.setIcon(IconManager.getIcon(IconManager.IconType.EMPTY));
                DefaultDialog.this.m_statusLabel.setText("");
            }
            super.processMouseEvent(e);
        }
    }

    private class BusyGlassPane
    extends JComponent
    implements PropertyChangeListener {
        private boolean m_firstProgressDisplay = true;
        private JPanel m_progressPanel;
        private JProgressBar m_progressBar;

        public BusyGlassPane() {
            this.setLayout(null);
            MouseAdapter mouseAdapter = new MouseAdapter(){};
            this.addMouseListener(mouseAdapter);
            this.addMouseMotionListener(mouseAdapter);
            this.setCursor(Cursor.getPredefinedCursor(3));
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.m_progressBar != null) {
                if (this.m_firstProgressDisplay) {
                    this.m_progressPanel.setBounds(30, this.getHeight() / 2 - 16, this.getWidth() - 60, 32);
                    this.m_progressBar.setBounds(6, 6, this.m_progressPanel.getWidth() - 12, this.m_progressPanel.getHeight() - 12);
                    this.m_firstProgressDisplay = false;
                }
                Color ppColor = new Color(140, 140, 140, 70);
                g.setColor(ppColor);
                g.fillRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            }
        }

        protected void setProgressBar(ProgressTask task) {
            this.removeAll();
            this.m_firstProgressDisplay = true;
            this.m_progressPanel = new JPanel(null){

                @Override
                public void paint(Graphics g) {
                    super.paint(g);
                    g.setColor(Color.darkGray);
                    g.drawRect(1, 1, this.getWidth() - 3, this.getHeight() - 3);
                }
            };
            this.m_progressPanel.setOpaque(true);
            this.m_progressPanel.setBackground(Color.white);
            this.m_progressBar = new JProgressBar(task.getMinValue(), task.getMaxValue());
            this.m_progressBar.setIndeterminate(true);
            this.m_progressBar.setStringPainted(false);
            this.m_progressPanel.add(this.m_progressBar);
            this.add(this.m_progressPanel);
            task.addPropertyChangeListener(this);
            task.execute();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("progress".equals(evt.getPropertyName())) {
                int progress = (Integer)evt.getNewValue();
                if (progress > 0 && this.m_progressBar.isIndeterminate()) {
                    this.m_progressBar.setIndeterminate(false);
                    this.m_progressBar.setStringPainted(true);
                }
                this.m_progressBar.setValue(progress);
                if (progress >= this.m_progressBar.getMaximum()) {
                    DefaultDialog.this.setBusy(false);
                    DefaultDialog.this.m_dialog.setVisible(false);
                }
            }
        }
    }
}

