/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.parameter;

import fr.proline.studio.parameter.AbstractLinkedParameters;
import fr.proline.studio.parameter.AbstractParameter;
import fr.proline.studio.parameter.ParameterError;
import fr.proline.studio.utils.IconManager;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.filechooser.FileSystemView;

public class FileParameter
extends AbstractParameter {
    private ArrayList<AbstractLinkedParameters> m_linkedParametersList = null;
    private final FileSystemView m_fsv;
    private String m_defaultValue;
    private String m_startValue;
    private final String[] m_fileFilterName;
    private final String[] m_fileFilterExtension;
    private boolean m_edited = false;
    private int m_selectionMode = 2;
    private boolean m_allFiles = true;
    private File m_defaultDirectory = null;
    private JPanel m_panel = null;

    public FileParameter(FileSystemView fsv, String key, String name, Class graphicalType, String defaultValue, String[] fileFilterName, String[] fileFilterExtension) {
        super(key, name, String.class, graphicalType);
        this.m_fsv = fsv;
        this.m_defaultValue = defaultValue;
        this.m_fileFilterName = fileFilterName;
        this.m_fileFilterExtension = fileFilterExtension;
    }

    @Override
    public JComponent getComponent(Object value) {
        this.m_startValue = null;
        if (value != null) {
            this.m_startValue = value.toString();
        }
        if (this.m_startValue == null) {
            String string = this.m_startValue = this.m_defaultValue != null ? this.m_defaultValue : "";
        }
        if (this.m_parameterComponent == null && this.m_graphicalType.equals(JTextField.class)) {
            this.m_panel = new JPanel(new FlowLayout());
            final JTextField textField = new JTextField(30);
            textField.setText(this.m_startValue);
            textField.addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent ke) {
                    if (!textField.getText().equalsIgnoreCase(FileParameter.this.m_startValue)) {
                        FileParameter.this.m_edited = true;
                    } else {
                        FileParameter.this.m_edited = false;
                    }
                }

                @Override
                public void keyPressed(KeyEvent ke) {
                }

                @Override
                public void keyReleased(KeyEvent ke) {
                }
            });
            this.m_parameterComponent = textField;
            final JButton addFileButton = new JButton(IconManager.getIcon(IconManager.IconType.OPEN_FILE));
            addFileButton.setMargin(new Insets(2, 2, 2, 2));
            addFileButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int result;
                    JFileChooser fchooser = FileParameter.this.m_fsv != null ? new JFileChooser(FileParameter.this.m_fsv) : new JFileChooser();
                    fchooser.setMultiSelectionEnabled(false);
                    if (FileParameter.this.m_defaultDirectory != null) {
                        fchooser.setCurrentDirectory(FileParameter.this.m_defaultDirectory);
                    }
                    fchooser.setFileSelectionMode(FileParameter.this.m_selectionMode);
                    fchooser.setAcceptAllFileFilterUsed(FileParameter.this.m_allFiles);
                    if (FileParameter.this.m_fileFilterName != null) {
                        for (int i = 0; i < FileParameter.this.m_fileFilterName.length; ++i) {
                            FileNameExtensionFilter filter = new FileNameExtensionFilter(FileParameter.this.m_fileFilterName[i], FileParameter.this.m_fileFilterExtension[i]);
                            fchooser.addChoosableFileFilter(filter);
                        }
                    }
                    if ((result = fchooser.showOpenDialog(addFileButton)) == 0) {
                        File file = fchooser.getSelectedFile();
                        textField.setText(file.getPath());
                        if (!textField.getText().equalsIgnoreCase(FileParameter.this.m_startValue)) {
                            FileParameter.this.m_edited = true;
                        } else {
                            FileParameter.this.m_edited = false;
                        }
                    }
                }
            });
            this.m_panel.add(textField);
            this.m_panel.add(addFileButton);
            this.m_parameterComponent = textField;
            return this.m_panel;
        }
        return this.m_panel;
    }

    @Override
    public void initDefault() {
        if (this.m_defaultValue == null) {
            return;
        }
        if (this.m_graphicalType.equals(JTextField.class)) {
            JTextField textField = (JTextField)this.m_parameterComponent;
            textField.setText(this.m_defaultValue.toString());
        }
    }

    @Override
    public ParameterError checkParameter() {
        JTextField textField;
        String path;
        if (this.m_graphicalType.equals(JTextField.class) && (path = (textField = (JTextField)this.m_parameterComponent).getText().trim()).isEmpty()) {
            return new ParameterError(path + " file is missing", this.m_parameterComponent);
        }
        return null;
    }

    @Override
    public void setValue(String v) {
        if (this.m_graphicalType.equals(JTextField.class) && this.m_parameterComponent != null) {
            ((JTextField)this.m_parameterComponent).setText(v);
        }
    }

    @Override
    public String getStringValue() {
        return this.getObjectValue().toString();
    }

    @Override
    public Object getObjectValue() {
        if (this.m_graphicalType.equals(JTextField.class) && this.m_parameterComponent != null) {
            return ((JTextField)this.m_parameterComponent).getText().trim();
        }
        return "";
    }

    @Override
    public void clean() {
        if (this.m_graphicalType.equals(JTextField.class)) {
            JTextField textField = (JTextField)this.m_parameterComponent;
            textField.setText("");
        }
    }

    public void setSelectionMode(int selectionMode) {
        this.m_selectionMode = selectionMode;
    }

    public void setAllFiles(boolean allFiles) {
        this.m_allFiles = allFiles;
    }

    public void setDefaultDirectory(File defaultDirectory) {
        this.m_defaultDirectory = defaultDirectory;
    }

    public void addLinkedParameters(final AbstractLinkedParameters linkedParameters) {
        this.getComponent(null);
        if (this.m_linkedParametersList == null) {
            this.m_linkedParametersList = new ArrayList(1);
        }
        this.m_linkedParametersList.add(linkedParameters);
        if (this.m_parameterComponent instanceof JTextField) {
            ((JTextField)this.m_parameterComponent).getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.textChanged();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.textChanged();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.textChanged();
                }

                public void textChanged() {
                    linkedParameters.valueChanged(FileParameter.this.getStringValue(), FileParameter.this.getObjectValue());
                }
            });
        }
    }

    @Override
    public boolean isEdited() {
        return this.m_edited;
    }
}

